<?php
/** Adminer - Compact database management
* @link https://www.adminer.org/
* @author Jakub Vrana, https://www.vrana.cz/
* @copyright 2007 Jakub Vrana
* @license https://www.apache.org/licenses/LICENSE-2.0 Apache License, Version 2.0
* @license https://www.gnu.org/licenses/gpl-2.0.html GNU General Public License, version 2 (one or other)
* @version 5.1.1
*/namespace
Adminer;const
VERSION="5.1.1";error_reporting(24575);set_error_handler(function($zc,$Ac){return!!preg_match('~^Undefined (array key|offset|index)~',$Ac);},E_WARNING|E_NOTICE);$Vc=!preg_match('~^(unsafe_raw)?$~',ini_get("filter.default"));if($Vc||ini_get("filter.default_flags")){foreach(array('_GET','_POST','_COOKIE','_SERVER')as$X){$Ti=filter_input_array(constant("INPUT$X"),FILTER_UNSAFE_RAW);if($Ti)$$X=$Ti;}}if(function_exists("mb_internal_encoding"))mb_internal_encoding("8bit");function
connection($h=null){return($h?:Db::$de);}function
adminer(){return
Adminer::$de;}function
driver(){return
Driver::$de;}function
connect(array$Db){$J=Driver::connect($Db[0],$Db[1],$Db[2]);return(is_object($J)?$J:null);}function
idf_unescape($v){if(!preg_match('~^[`\'"[]~',$v))return$v;$we=substr($v,-1);return
str_replace($we.$we,$we,substr($v,1,-1));}function
q($Q){return
connection()->quote($Q);}function
escape_string($X){return
substr(q($X),1,-1);}function
idx($xa,$y,$l=null){return($xa&&array_key_exists($y,$xa)?$xa[$y]:$l);}function
number($X){return
preg_replace('~[^0-9]+~','',$X);}function
number_type(){return'((?<!o)int(?!er)|numeric|real|float|double|decimal|money)';}function
remove_slashes(array$Dg,$Vc=false){if(function_exists("get_magic_quotes_gpc")&&get_magic_quotes_gpc()){while(list($y,$X)=each($Dg)){foreach($X
as$oe=>$W){unset($Dg[$y][$oe]);if(is_array($W)){$Dg[$y][stripslashes($oe)]=$W;$Dg[]=&$Dg[$y][stripslashes($oe)];}else$Dg[$y][stripslashes($oe)]=($Vc?$W:stripslashes($W));}}}}function
bracket_escape($v,$Ea=false){static$Ci=array(':'=>':1',']'=>':2','['=>':3','"'=>':4');return
strtr($v,($Ea?array_flip($Ci):$Ci));}function
min_version($kj,$Ie="",$h=null){$h=connection($h);$xh=$h->server_info;if($Ie&&preg_match('~([\d.]+)-MariaDB~',$xh,$B)){$xh=$B[1];$kj=$Ie;}return$kj&&version_compare($xh,$kj)>=0;}function
charset(Db$g){return(min_version("5.5.3",0,$g)?"utf8mb4":"utf8");}function
ini_bool($Yd){$X=ini_get($Yd);return(preg_match('~^(on|true|yes)$~i',$X)||(int)$X);}function
sid(){static$J;if($J===null)$J=(SID&&!($_COOKIE&&ini_bool("session.use_cookies")));return$J;}function
set_password($jj,$N,$V,$F){$_SESSION["pwds"][$jj][$N][$V]=($_COOKIE["adminer_key"]&&is_string($F)?array(encrypt_string($F,$_COOKIE["adminer_key"])):$F);}function
get_password(){$J=get_session("pwds");if(is_array($J))$J=($_COOKIE["adminer_key"]?decrypt_string($J[0],$_COOKIE["adminer_key"]):false);return$J;}function
get_val($H,$n=0,$sb=null){$sb=connection($sb);$I=$sb->query($H);if(!is_object($I))return
false;$K=$I->fetch_row();return($K?$K[$n]:false);}function
get_vals($H,$d=0){$J=array();$I=connection()->query($H);if(is_object($I)){while($K=$I->fetch_row())$J[]=$K[$d];}return$J;}function
get_key_vals($H,$h=null,$_h=true){$h=connection($h);$J=array();$I=$h->query($H);if(is_object($I)){while($K=$I->fetch_row()){if($_h)$J[$K[0]]=$K[1];else$J[]=$K[0];}}return$J;}function
get_rows($H,$h=null,$m="<p class='error'>"){$sb=connection($h);$J=array();$I=$sb->query($H);if(is_object($I)){while($K=$I->fetch_assoc())$J[]=$K;}elseif(!$I&&!$h&&$m&&(defined('Adminer\PAGE_HEADER')||$m=="-- "))echo$m.error()."\n";return$J;}function
unique_array($K,array$x){foreach($x
as$w){if(preg_match("~PRIMARY|UNIQUE~",$w["type"])){$J=array();foreach($w["columns"]as$y){if(!isset($K[$y]))continue
2;$J[$y]=$K[$y];}return$J;}}}function
escape_key($y){if(preg_match('(^([\w(]+)('.str_replace("_",".*",preg_quote(idf_escape("_"))).')([ \w)]+)$)',$y,$B))return$B[1].idf_escape(idf_unescape($B[2])).$B[3];return
idf_escape($y);}function
where(array$Z,array$o=array()){$J=array();foreach((array)$Z["where"]as$y=>$X){$y=bracket_escape($y,true);$d=escape_key($y);$n=idx($o,$y,array());$Tc=$n["type"];$J[]=$d.(JUSH=="sql"&&$Tc=="json"?" = CAST(".q($X)." AS JSON)":(JUSH=="sql"&&is_numeric($X)&&preg_match('~\.~',$X)?" LIKE ".q($X):(JUSH=="mssql"&&strpos($Tc,"datetime")===false?" LIKE ".q(preg_replace('~[_%[]~','[\0]',$X)):" = ".unconvert_field($n,q($X)))));if(JUSH=="sql"&&preg_match('~char|text~',$Tc)&&preg_match("~[^ -@]~",$X))$J[]="$d = ".q($X)." COLLATE ".charset(connection())."_bin";}foreach((array)$Z["null"]as$y)$J[]=escape_key($y)." IS NULL";return
implode(" AND ",$J);}function
where_check($X,array$o=array()){parse_str($X,$Xa);remove_slashes(array(&$Xa));return
where($Xa,$o);}function
where_link($t,$d,$Y,$Ff="="){return"&where%5B$t%5D%5Bcol%5D=".urlencode($d)."&where%5B$t%5D%5Bop%5D=".urlencode(($Y!==null?$Ff:"IS NULL"))."&where%5B$t%5D%5Bval%5D=".urlencode($Y);}function
convert_fields(array$e,array$o,array$M=array()){$J="";foreach($e
as$y=>$X){if($M&&!in_array(idf_escape($y),$M))continue;$ya=convert_field($o[$y]);if($ya)$J
.=", $ya AS ".idf_escape($y);}return$J;}function
cookie($C,$Y,$Ce=2592000){header("Set-Cookie: $C=".urlencode($Y).($Ce?"; expires=".gmdate("D, d M Y H:i:s",time()+$Ce)." GMT":"")."; path=".preg_replace('~\?.*~','',$_SERVER["REQUEST_URI"]).(HTTPS?"; secure":"")."; HttpOnly; SameSite=lax",false);}function
get_settings($Ab){parse_str($_COOKIE[$Ab],$Ah);return$Ah;}function
get_setting($y,$Ab="adminer_settings"){$Ah=get_settings($Ab);return$Ah[$y];}function
save_settings(array$Ah,$Ab="adminer_settings"){cookie($Ab,http_build_query($Ah+get_settings($Ab)));}function
restart_session(){if(!ini_bool("session.use_cookies")&&(!function_exists('session_status')||session_status()==1))session_start();}function
stop_session($dd=false){$bj=ini_bool("session.use_cookies");if(!$bj||$dd){session_write_close();if($bj&&@ini_set("session.use_cookies",'0')===false)session_start();}}function&get_session($y){return$_SESSION[$y][DRIVER][SERVER][$_GET["username"]];}function
set_session($y,$X){$_SESSION[$y][DRIVER][SERVER][$_GET["username"]]=$X;}function
auth_url($jj,$N,$V,$k=null){$Xi=remove_from_uri(implode("|",array_keys(SqlDriver::$cc))."|username|ext|".($k!==null?"db|":"").($jj=='mssql'||$jj=='pgsql'?"":"ns|").session_name());preg_match('~([^?]*)\??(.*)~',$Xi,$B);return"$B[1]?".(sid()?SID."&":"").($jj!="server"||$N!=""?urlencode($jj)."=".urlencode($N)."&":"").($_GET["ext"]?"ext=".urlencode($_GET["ext"])."&":"")."username=".urlencode($V).($k!=""?"&db=".urlencode($k):"").($B[2]?"&$B[2]":"");}function
is_ajax(){return($_SERVER["HTTP_X_REQUESTED_WITH"]=="XMLHttpRequest");}function
redirect($Ee,$Ve=null){if($Ve!==null){restart_session();$_SESSION["messages"][preg_replace('~^[^?]*~','',($Ee!==null?$Ee:$_SERVER["REQUEST_URI"]))][]=$Ve;}if($Ee!==null){if($Ee=="")$Ee=".";header("Location: $Ee");exit;}}function
query_redirect($H,$Ee,$Ve,$Mg=true,$Fc=true,$Oc=false,$qi=""){if($Fc){$Ph=microtime(true);$Oc=!connection()->query($H);$qi=format_time($Ph);}$Jh=($H?adminer()->messageQuery($H,$qi,$Oc):"");if($Oc){adminer()->error
.=error().$Jh.script("messagesPrint();")."<br>";return
false;}if($Mg)redirect($Ee,$Ve.$Jh);return
true;}class
Queries{static$Hg=array();static$Ph=0;}function
queries($H){if(!Queries::$Ph)Queries::$Ph=microtime(true);Queries::$Hg[]=(preg_match('~;$~',$H)?"DELIMITER ;;\n$H;\nDELIMITER ":$H).";";return
connection()->query($H);}function
apply_queries($H,array$T,$Bc='Adminer\table'){foreach($T
as$R){if(!queries("$H ".$Bc($R)))return
false;}return
true;}function
queries_redirect($Ee,$Ve,$Mg){$Hg=implode("\n",Queries::$Hg);$qi=format_time(Queries::$Ph);return
query_redirect($Hg,$Ee,$Ve,$Mg,false,!$Mg,$qi);}function
format_time($Ph){return
lang(0,max(0,microtime(true)-$Ph));}function
relative_uri(){return
str_replace(":","%3a",preg_replace('~^[^?]*/([^?]*)~','\1',$_SERVER["REQUEST_URI"]));}function
remove_from_uri($cg=""){return
substr(preg_replace("~(?<=[?&])($cg".(SID?"":"|".session_name()).")=[^&]*&~",'',relative_uri()."&"),0,-1);}function
get_file($y,$Pb=false,$Tb=""){$Uc=$_FILES[$y];if(!$Uc)return
null;foreach($Uc
as$y=>$X)$Uc[$y]=(array)$X;$J='';foreach($Uc["error"]as$y=>$m){if($m)return$m;$C=$Uc["name"][$y];$yi=$Uc["tmp_name"][$y];$xb=file_get_contents($Pb&&preg_match('~\.gz$~',$C)?"compress.zlib://$yi":$yi);if($Pb){$Ph=substr($xb,0,3);if(function_exists("iconv")&&preg_match("~^\xFE\xFF|^\xFF\xFE~",$Ph))$xb=iconv("utf-16","utf-8",$xb);elseif($Ph=="\xEF\xBB\xBF")$xb=substr($xb,3);}$J
.=$xb;if($Tb)$J
.=(preg_match("($Tb\\s*\$)",$xb)?"":$Tb)."\n\n";}return$J;}function
upload_error($m){$Qe=($m==UPLOAD_ERR_INI_SIZE?ini_get("upload_max_filesize"):0);return($m?lang(1).($Qe?" ".lang(2,$Qe):""):lang(3));}function
repeat_pattern($mg,$z){return
str_repeat("$mg{0,65535}",$z/65535)."$mg{0,".($z%65535)."}";}function
is_utf8($X){return(preg_match('~~u',$X)&&!preg_match('~[\0-\x8\xB\xC\xE-\x1F]~',$X));}function
format_number($X){return
strtr(number_format($X,0,".",lang(4)),preg_split('~~u',lang(5),-1,PREG_SPLIT_NO_EMPTY));}function
friendly_url($X){return
preg_replace('~\W~i','-',$X);}function
table_status1($R,$Pc=false){$J=table_status($R,$Pc);return($J?reset($J):array("Name"=>$R));}function
column_foreign_keys($R){$J=array();foreach(adminer()->foreignKeys($R)as$q){foreach($q["source"]as$X)$J[$X][]=$q;}return$J;}function
fields_from_edit(){$J=array();foreach((array)$_POST["field_keys"]as$y=>$X){if($X!=""){$X=bracket_escape($X);$_POST["function"][$X]=$_POST["field_funs"][$y];$_POST["fields"][$X]=$_POST["field_vals"][$y];}}foreach((array)$_POST["fields"]as$y=>$X){$C=bracket_escape($y,true);$J[$C]=array("field"=>$C,"privileges"=>array("insert"=>1,"update"=>1,"where"=>1,"order"=>1),"null"=>1,"auto_increment"=>($y==driver()->primary),);}return$J;}function
dump_headers($Ld,$ff=false){$J=adminer()->dumpHeaders($Ld,$ff);$Yf=$_POST["output"];if($Yf!="text")header("Content-Disposition: attachment; filename=".adminer()->dumpFilename($Ld).".$J".($Yf!="file"&&preg_match('~^[0-9a-z]+$~',$Yf)?".$Yf":""));session_write_close();if(!ob_get_level())ob_start(null,4096);ob_flush();flush();return$J;}function
dump_csv(array$K){foreach($K
as$y=>$X){if(preg_match('~["\n,;\t]|^0|\.\d*0$~',$X)||$X==="")$K[$y]='"'.str_replace('"','""',$X).'"';}echo
implode(($_POST["format"]=="csv"?",":($_POST["format"]=="tsv"?"\t":";")),$K)."\r\n";}function
apply_sql_function($s,$d){return($s?($s=="unixepoch"?"DATETIME($d, '$s')":($s=="count distinct"?"COUNT(DISTINCT ":strtoupper("$s("))."$d)"):$d);}function
get_temp_dir(){$J=ini_get("upload_tmp_dir");if(!$J){if(function_exists('sys_get_temp_dir'))$J=sys_get_temp_dir();else{$p=@tempnam("","");if(!$p)return'';$J=dirname($p);unlink($p);}}return$J;}function
file_open_lock($p){if(is_link($p))return;$r=@fopen($p,"c+");if(!$r)return;chmod($p,0660);if(!flock($r,LOCK_EX)){fclose($r);return;}return$r;}function
file_write_unlock($r,$Jb){rewind($r);fwrite($r,$Jb);ftruncate($r,strlen($Jb));file_unlock($r);}function
file_unlock($r){flock($r,LOCK_UN);fclose($r);}function
first(array$xa){return
reset($xa);}function
password_file($i){$p=get_temp_dir()."/adminer.key";if(!$i&&!file_exists($p))return'';$r=file_open_lock($p);if(!$r)return'';$J=stream_get_contents($r);if(!$J){$J=rand_string();file_write_unlock($r,$J);}else
file_unlock($r);return$J;}function
rand_string(){return
md5(uniqid(strval(mt_rand()),true));}function
select_value($X,$A,array$n,$pi){if(is_array($X)){$J="";foreach($X
as$oe=>$W)$J
.="<tr>".($X!=array_values($X)?"<th>".h($oe):"")."<td>".select_value($W,$A,$n,$pi);return"<table>$J</table>";}if(!$A)$A=adminer()->selectLink($X,$n);if($A===null){if(is_mail($X))$A="mailto:$X";if(is_url($X))$A=$X;}$J=adminer()->editVal($X,$n);if($J!==null){if(!is_utf8($J))$J="\0";elseif($pi!=""&&is_shortable($n))$J=shorten_utf8($J,max(0,+$pi));else$J=h($J);}return
adminer()->selectVal($J,$A,$n,$X);}function
is_mail($pc){$za='[-a-z0-9!#$%&\'*+/=?^_`{|}~]';$bc='[a-z0-9]([-a-z0-9]{0,61}[a-z0-9])';$mg="$za+(\\.$za+)*@($bc?\\.)+$bc";return
is_string($pc)&&preg_match("(^$mg(,\\s*$mg)*\$)i",$pc);}function
is_url($Q){$bc='[a-z0-9]([-a-z0-9]{0,61}[a-z0-9])';return
preg_match("~^(https?)://($bc?\\.)+$bc(:\\d+)?(/.*)?(\\?.*)?(#.*)?\$~i",$Q);}function
is_shortable(array$n){return
preg_match('~char|text|json|lob|geometry|point|linestring|polygon|string|bytea~',$n["type"]);}function
count_rows($R,array$Z,$ie,array$rd){$H=" FROM ".table($R).($Z?" WHERE ".implode(" AND ",$Z):"");return($ie&&(JUSH=="sql"||count($rd)==1)?"SELECT COUNT(DISTINCT ".implode(", ",$rd).")$H":"SELECT COUNT(*)".($ie?" FROM (SELECT 1$H GROUP BY ".implode(", ",$rd).") x":$H));}function
slow_query($H){$k=adminer()->database();$ri=adminer()->queryTimeout();$Eh=driver()->slowQuery($H,$ri);$h=null;if(!$Eh&&support("kill")){$h=connect(adminer()->credentials());if($h&&($k==""||$h->select_db($k))){$re=get_val(connection_id(),0,$h);echo
script("const timeout = setTimeout(() => { ajax('".js_escape(ME)."script=kill', function () {}, 'kill=$re&token=".get_token()."'); }, 1000 * $ri);");}}ob_flush();flush();$J=@get_key_vals(($Eh?:$H),$h,false);if($h){echo
script("clearTimeout(timeout);");ob_flush();flush();}return$J;}function
get_token(){$Kg=rand(1,1e6);return($Kg^$_SESSION["token"]).":$Kg";}function
verify_token(){list($zi,$Kg)=explode(":",$_POST["token"]);return($Kg^$_SESSION["token"])==$zi;}function
lzw_decompress($Ka){$Xb=256;$La=8;$gb=array();$Xg=0;$Yg=0;for($t=0;$t<strlen($Ka);$t++){$Xg=($Xg<<8)+ord($Ka[$t]);$Yg+=8;if($Yg>=$La){$Yg-=$La;$gb[]=$Xg>>$Yg;$Xg&=(1<<$Yg)-1;$Xb++;if($Xb>>$La)$La++;}}$Wb=range("\0","\xFF");$J="";$tj="";foreach($gb
as$t=>$fb){$oc=$Wb[$fb];if(!isset($oc))$oc=$tj.$tj[0];$J
.=$oc;if($t)$Wb[]=$tj.$oc[0];$tj=$oc;}return$J;}function
script($Gh,$Bi="\n"){return"<script".nonce().">$Gh</script>$Bi";}function
script_src($Yi){return"<script src='".h($Yi)."'".nonce()."></script>\n";}function
nonce(){return' nonce="'.get_nonce().'"';}function
input_hidden($C,$Y=""){return"<input type='hidden' name='".h($C)."' value='".h($Y)."'>\n";}function
input_token(){return
input_hidden("token",get_token());}function
target_blank(){return' target="_blank" rel="noreferrer noopener"';}function
h($Q){return
str_replace("\0","&#0;",htmlspecialchars($Q,ENT_QUOTES,'utf-8'));}function
nl_br($Q){return
str_replace("\n","<br>",$Q);}function
checkbox($C,$Y,$ab,$te="",$Ef="",$eb="",$ue=""){$J="<input type='checkbox' name='$C' value='".h($Y)."'".($ab?" checked":"").($ue?" aria-labelledby='$ue'":"").">".($Ef?script("qsl('input').onclick = function () { $Ef };",""):"");return($te!=""||$eb?"<label".($eb?" class='$eb'":"").">$J".h($te)."</label>":$J);}function
optionlist($Jf,$ph=null,$cj=false){$J="";foreach($Jf
as$oe=>$W){$Kf=array($oe=>$W);if(is_array($W)){$J
.='<optgroup label="'.h($oe).'">';$Kf=$W;}foreach($Kf
as$y=>$X)$J
.='<option'.($cj||is_string($y)?' value="'.h($y).'"':'').($ph!==null&&($cj||is_string($y)?(string)$y:$X)===$ph?' selected':'').'>'.h($X);if(is_array($W))$J
.='</optgroup>';}return$J;}function
html_select($C,array$Jf,$Y="",$Df="",$ue=""){return"<select name='".h($C)."'".($ue?" aria-labelledby='$ue'":"").">".optionlist($Jf,$Y)."</select>".($Df?script("qsl('select').onchange = function () { $Df };",""):"");}function
html_radios($C,array$Jf,$Y=""){$J="";foreach($Jf
as$y=>$X)$J
.="<label><input type='radio' name='".h($C)."' value='".h($y)."'".($y==$Y?" checked":"").">".h($X)."</label>";return$J;}function
confirm($Ve="",$qh="qsl('input')"){return
script("$qh.onclick = () => confirm('".($Ve?js_escape($Ve):lang(6))."');","");}function
print_fieldset($u,$Ae,$nj=false){echo"<fieldset><legend>","<a href='#fieldset-$u'>$Ae</a>",script("qsl('a').onclick = partial(toggle, 'fieldset-$u');",""),"</legend>","<div id='fieldset-$u'".($nj?"":" class='hidden'").">\n";}function
bold($Na,$eb=""){return($Na?" class='active $eb'":($eb?" class='$eb'":""));}function
js_escape($Q){return
addcslashes($Q,"\r\n'\\/");}function
pagination($E,$Gb){return" ".($E==$Gb?$E+1:'<a href="'.h(remove_from_uri("page").($E?"&page=$E".($_GET["next"]?"&next=".urlencode($_GET["next"]):""):"")).'">'.($E+1)."</a>");}function
hidden_fields(array$Dg,array$Od=array(),$xg=''){$J=false;foreach($Dg
as$y=>$X){if(!in_array($y,$Od)){if(is_array($X))hidden_fields($X,array(),$y);else{$J=true;echo
input_hidden(($xg?$xg."[$y]":$y),$X);}}}return$J;}function
hidden_fields_get(){echo(sid()?input_hidden(session_name(),session_id()):''),(SERVER!==null?input_hidden(DRIVER,SERVER):""),input_hidden("username",$_GET["username"]);}function
enum_input($U,$_a,array$n,$Y,$sc=null){preg_match_all("~'((?:[^']|'')*)'~",$n["length"],$Le);$J=($sc!==null?"<label><input type='$U'$_a value='$sc'".((is_array($Y)?in_array($sc,$Y):$Y===$sc)?" checked":"")."><i>".lang(7)."</i></label>":"");foreach($Le[1]as$t=>$X){$X=stripcslashes(str_replace("''","'",$X));$ab=(is_array($Y)?in_array($X,$Y):$Y===$X);$J
.=" <label><input type='$U'$_a value='".h($X)."'".($ab?' checked':'').'>'.h(adminer()->editVal($X,$n)).'</label>';}return$J;}function
input(array$n,$Y,$s,$Da=false){$C=h(bracket_escape($n["field"]));echo"<td class='function'>";if(is_array($Y)&&!$s){$Y=json_encode($Y,128|64|256);$s="json";}$Wg=(JUSH=="mssql"&&$n["auto_increment"]);if($Wg&&!$_POST["save"])$s=null;$md=(isset($_GET["select"])||$Wg?array("orig"=>lang(8)):array())+adminer()->editFunctions($n);$Yb=stripos($n["default"],"GENERATED ALWAYS AS ")===0?" disabled=''":"";$_a=" name='fields[$C]'$Yb".($Da?" autofocus":"");$yc=driver()->enumLength($n);if($yc){$n["type"]="enum";$n["length"]=$yc;}echo
driver()->unconvertFunction($n)." ";$R=$_GET["edit"]?:$_GET["select"];if($n["type"]=="enum")echo
h($md[""])."<td>".adminer()->editInput($R,$n,$_a,$Y);else{$zd=(in_array($s,$md)||isset($md[$s]));echo(count($md)>1?"<select name='function[$C]'$Yb>".optionlist($md,$s===null||$zd?$s:"")."</select>".on_help("event.target.value.replace(/^SQL\$/, '')",1).script("qsl('select').onchange = functionChange;",""):h(reset($md))).'<td>';$ae=adminer()->editInput($R,$n,$_a,$Y);if($ae!="")echo$ae;elseif(preg_match('~bool~',$n["type"]))echo"<input type='hidden'$_a value='0'>"."<input type='checkbox'".(preg_match('~^(1|t|true|y|yes|on)$~i',$Y)?" checked='checked'":"")."$_a value='1'>";elseif($n["type"]=="set"){preg_match_all("~'((?:[^']|'')*)'~",$n["length"],$Le);foreach($Le[1]as$t=>$X){$X=stripcslashes(str_replace("''","'",$X));$ab=in_array($X,explode(",",$Y),true);echo" <label><input type='checkbox' name='fields[$C][$t]' value='".h($X)."'".($ab?' checked':'').">".h(adminer()->editVal($X,$n)).'</label>';}}elseif(preg_match('~blob|bytea|raw|file~',$n["type"])&&ini_bool("file_uploads"))echo"<input type='file' name='fields-$C'>";elseif($s=="json"||preg_match('~^jsonb?$~',$n["type"]))echo"<textarea$_a cols='50' rows='12' class='jush-js'>".h($Y).'</textarea>';elseif(($ni=preg_match('~text|lob|memo~i',$n["type"]))||preg_match("~\n~",$Y)){if($ni&&JUSH!="sqlite")$_a
.=" cols='50' rows='12'";else{$L=min(12,substr_count($Y,"\n")+1);$_a
.=" cols='30' rows='$L'";}echo"<textarea$_a>".h($Y).'</textarea>';}else{$Ni=driver()->types();$Se=(!preg_match('~int~',$n["type"])&&preg_match('~^(\d+)(,(\d+))?$~',$n["length"],$B)?((preg_match("~binary~",$n["type"])?2:1)*$B[1]+($B[3]?1:0)+($B[2]&&!$n["unsigned"]?1:0)):($Ni[$n["type"]]?$Ni[$n["type"]]+($n["unsigned"]?0:1):0));if(JUSH=='sql'&&min_version(5.6)&&preg_match('~time~',$n["type"]))$Se+=7;echo"<input".((!$zd||$s==="")&&preg_match('~(?<!o)int(?!er)~',$n["type"])&&!preg_match('~\[\]~',$n["full_type"])?" type='number'":"")." value='".h($Y)."'".($Se?" data-maxlength='$Se'":"").(preg_match('~char|binary~',$n["type"])&&$Se>20?" size='".($Se>99?60:40)."'":"")."$_a>";}echo
adminer()->editHint($R,$n,$Y);$Wc=0;foreach($md
as$y=>$X){if($y===""||!$X)break;$Wc++;}if($Wc&&count($md)>1)echo
script("qsl('td').oninput = partial(skipOriginal, $Wc);");}}function
process_input(array$n){if(stripos($n["default"],"GENERATED ALWAYS AS ")===0)return;$v=bracket_escape($n["field"]);$s=idx($_POST["function"],$v);$Y=$_POST["fields"][$v];if($n["type"]=="enum"||driver()->enumLength($n)){if($Y==-1)return
false;if($Y=="")return"NULL";}if($n["auto_increment"]&&$Y=="")return
null;if($s=="orig")return(preg_match('~^CURRENT_TIMESTAMP~i',$n["on_update"])?idf_escape($n["field"]):false);if($s=="NULL")return"NULL";if($n["type"]=="set")$Y=implode(",",(array)$Y);if($s=="json"){$s="";$Y=json_decode($Y,true);if(!is_array($Y))return
false;return$Y;}if(preg_match('~blob|bytea|raw|file~',$n["type"])&&ini_bool("file_uploads")){$Uc=get_file("fields-$v");if(!is_string($Uc))return
false;return
driver()->quoteBinary($Uc);}return
adminer()->processInput($n,$Y,$s);}function
search_tables(){$_GET["where"][0]["val"]=$_POST["query"];$sh="<ul>\n";foreach(table_status('',true)as$R=>$S){$C=adminer()->tableName($S);if(isset($S["Engine"])&&$C!=""&&(!$_POST["tables"]||in_array($R,$_POST["tables"]))){$I=connection()->query("SELECT".limit("1 FROM ".table($R)," WHERE ".implode(" AND ",adminer()->selectSearchProcess(fields($R),array())),1));if(!$I||$I->fetch_row()){$_g="<a href='".h(ME."select=".urlencode($R)."&where[0][op]=".urlencode($_GET["where"][0]["op"])."&where[0][val]=".urlencode($_GET["where"][0]["val"]))."'>$C</a>";echo"$sh<li>".($I?$_g:"<p class='error'>$_g: ".error())."\n";$sh="";}}}echo($sh?"<p class='message'>".lang(9):"</ul>")."\n";}function
on_help($mb,$Ch=0){return
script("mixin(qsl('select, input'), {onmouseover: function (event) { helpMouseover.call(this, event, $mb, $Ch) }, onmouseout: helpMouseout});","");}function
edit_form($R,array$o,$K,$Wi,$m=''){$bi=adminer()->tableName(table_status1($R,true));page_header(($Wi?lang(10):lang(11)),$m,array("select"=>array($R,$bi)),$bi);adminer()->editRowPrint($R,$o,$K,$Wi);if($K===false){echo"<p class='error'>".lang(12)."\n";return;}echo"<form action='' method='post' enctype='multipart/form-data' id='form'>\n";if(!$o)echo"<p class='error'>".lang(13)."\n";else{echo"<table class='layout'>".script("qsl('table').onkeydown = editingKeydown;");$Da=!$_POST;foreach($o
as$C=>$n){echo"<tr><th>".adminer()->fieldName($n);$l=idx($_GET["set"],bracket_escape($C));if($l===null){$l=$n["default"];if($n["type"]=="bit"&&preg_match("~^b'([01]*)'\$~",$l,$Tg))$l=$Tg[1];if(JUSH=="sql"&&preg_match('~binary~',$n["type"]))$l=bin2hex($l);}$Y=($K!==null?($K[$C]!=""&&JUSH=="sql"&&preg_match("~enum|set~",$n["type"])&&is_array($K[$C])?implode(",",$K[$C]):(is_bool($K[$C])?+$K[$C]:$K[$C])):(!$Wi&&$n["auto_increment"]?"":(isset($_GET["select"])?false:$l)));if(!$_POST["save"]&&is_string($Y))$Y=adminer()->editVal($Y,$n);$s=($_POST["save"]?idx($_POST["function"],$C,""):($Wi&&preg_match('~^CURRENT_TIMESTAMP~i',$n["on_update"])?"now":($Y===false?null:($Y!==null?'':'NULL'))));if(!$_POST&&!$Wi&&$Y==$n["default"]&&preg_match('~^[\w.]+\(~',$Y))$s="SQL";if(preg_match("~time~",$n["type"])&&preg_match('~^CURRENT_TIMESTAMP~i',$Y)){$Y="";$s="now";}if($n["type"]=="uuid"&&$Y=="uuid()"){$Y="";$s="uuid";}if($Da!==false)$Da=($n["auto_increment"]||$s=="now"||$s=="uuid"?null:true);input($n,$Y,$s,$Da);if($Da)$Da=false;echo"\n";}if(!support("table")&&!fields($R))echo"<tr>"."<th><input name='field_keys[]'>".script("qsl('input').oninput = fieldChange;")."<td class='function'>".html_select("field_funs[]",adminer()->editFunctions(array("null"=>isset($_GET["select"]))))."<td><input name='field_vals[]'>"."\n";echo"</table>\n";}echo"<p>\n";if($o){echo"<input type='submit' value='".lang(14)."'>\n";if(!isset($_GET["select"]))echo"<input type='submit' name='insert' value='".($Wi?lang(15):lang(16))."' title='Ctrl+Shift+Enter'>\n",($Wi?script("qsl('input').onclick = function () { return !ajaxForm(this.form, '".lang(17)."…', this); };"):"");}echo($Wi?"<input type='submit' name='delete' value='".lang(18)."'>".confirm()."\n":"");if(isset($_GET["select"]))hidden_fields(array("check"=>(array)$_POST["check"],"clone"=>$_POST["clone"],"all"=>$_POST["all"]));echo
input_hidden("referer",(isset($_POST["referer"])?$_POST["referer"]:$_SERVER["HTTP_REFERER"])),input_hidden("save",1),input_token(),"</form>\n";}function
shorten_utf8($Q,$z=80,$Vh=""){if(!preg_match("(^(".repeat_pattern("[\t\r\n -\x{10FFFF}]",$z).")($)?)u",$Q,$B))preg_match("(^(".repeat_pattern("[\t\r\n -~]",$z).")($)?)",$Q,$B);return
h($B[1]).$Vh.(isset($B[2])?"":"<i>…</i>");}function
icon($Kd,$C,$Jd,$ti){return"<button type='submit' name='$C' title='".h($ti)."' class='icon icon-$Kd'><span>$Jd</span></button>";}if(isset($_GET["file"])){if(substr(VERSION,-4)!='-dev'){if($_SERVER["HTTP_IF_MODIFIED_SINCE"]){header("HTTP/1.1 304 Not Modified");exit;}header("Expires: ".gmdate("D, d M Y H:i:s",time()+365*24*60*60)." GMT");header("Last-Modified: ".gmdate("D, d M Y H:i:s")." GMT");header("Cache-Control: immutable");}if($_GET["file"]=="favicon.ico"){header("Content-Type: image/x-icon");echo
lzw_decompress("\0\0\0` \0\0\n @\0C\"\0`EQ?tvM'Jdd\\b0\0\"fӈs5AXPaJ08#RTz`#.cXȀ?-\0Im?.M\0ȯ(̉/(%\0");}elseif($_GET["file"]=="default.css"){header("Content-Type: text/css; charset=utf-8");echo
lzw_decompress("h:Mhgб\"Cd<fa:;NBqR;1Lf9u7\$)\$L;3A`%E!e9&r4MAv2\r&:iΖs0\"3Má-;LC@i:cs,(aG#ãeɐ9kSѺu>ddcñ:6ZcArf[YN/d9I87f\"V3Y)ƣ-4UoD:xjHb{&єt1֋Uv8# ȵ!pp2\0c%\r7<8s	;H΀26o3P%s>JKJ@dB\0Z\0ct0X*D!	B1\r5# @i*Nq,N2ÔWij^0>zD4Q8sd~!ȯ\$(s9td:,(=+R,:6S:Grl쀟Hh9,0\0?P!\$2UO՚4v#AiW<Ձȹ\"rhm-`(p@@pe]L\\iLOr:aj-u`S/={:ɭvҶ5ЛT,\\x3cR+WfSc%cG=RCJ2,Cc0/@1\rz\rSXM*nW,H\ryeg.853Z(8Rׯ5HH3zrjX t6C%Y)ͻo8.V,&Ie1#f\\.<'?|ƓoGC6OmDTݬXW{mW[4\rT#-\$Xb\n_3kMM	hA&0W]RP:{Lqj`- [no*ЛPoQ '`X[[a2DdPoAuk`\$Y0%0q:ƅ\0h@!;eւj0FP:vCi7lC\rHyRMoC\0yl\$\$/.038Ls~a:NF ;#}2Hq55	}H#Il#/d.<6:r8'Fp^\0\$bkZP.ȇA\$̰wfI2pgUA\$R%G@]4&2zm2\$R)9Hu!!ւG\0bZ/4MZ>P)s8C(s+O@tKQnY7E\n41*`MTNyR*:tfd[^͸&cS`\r1(NaPiFARTb%P*Ehq:@hˡz2dL_s`k[tޔ4ǆ<+3DxI]wֽ,\"{9ڏs:UDP\"R\"\$!YHA2T|ރj}s7xpb:5ZԗkؖKsxqh(\"Ւo0ـH]u9B'EW%&A1A:hlMVJ	IPKg9/TʆJm0*࣍\re\0Ji8\$Nv=XP8-`@.<!0ӝ<Sz2INbiQymB({M8 Hb\\i3@3ϐ@ט7\$Q	-%QnOLЂ 2X(`eL\nPRn|vR<gbOKB^mkǛ˻?h/	#dkbq\rr:M9Oɘ7܂D|#+/oS\rRUcbtm`p-:S1kց7u3aYv/GPsqO6XATʯ!elm=E6oH8:=Lc3/&g@9b;d/p\"OjS8_\$w7oW.)zOMA{1DJdRRZjh!oMN)mYl۳%fmEzí/٢Rvy@b!1+;|tڊhƝgk\0 a.:xr((MsD֖ZI| 8ʜ2x)S'uXaκ~{v66TsAKs\\(b\reUuTi |jJJX7V;N]C[WC\n7s݆E9ֲbv_yM6H~jJEg\0F{N1\01>4/om\0,L^\rP4˪,R,@lX\n@`\r	\r  	j 	@@\n 	 	\0j@P@	0@	 	\$N	 V\0``\n\0\n \n@%\n\0`\r	\r\0Rv	\0`	z}\0\\O6M288>2PC@FpQPYaPi\nsp{p	p	\nP	0oP\n \0kbl\0^@\0`@\"\n10&'@Zhú07*S5W_0goyЁ	1UБ	P	Сqk `001\r^\"Y	`\n 5 \0	 p\n\n` q(!CA18SAGpuQQ[a\n  0 qn\rRp	 @b\r`\r`\r	d	,\n``\n`dQ?&Q'k&Rqu1\n\n\0Ђ2R\n	\0*0`\n`\n@fd\0` \n@	Dø`p O\$B\\'(/&K'2w@	 	33)2s ; \0h@\n@ f%1,ʃ\$G*}fF(@\r@\rx\$J.rAHA+U'BaBX^L@0-ըhhBiCFFGD\neR4@CfF`mwG AU4\0IgITUAKxTFv\$YTDCt0MLr1CN}7k42ld\n@o*T)dqD@p 4ԷFWEIzKQ39Mh~*L!FEG+n⎖)R[CGHI ڟM JƮȏNN,̏@)RnfJOcM*6\r-Yl5pikEt FT]4U猁NgL4u|UFPu\n*'*yMD<sU5d5xW^`L&d5cj\n5{ z&@E,@fe\"@gf%`gJ7n& ~@he`*f hCH4\n.FF,|W7\n\$#`h~W|\n \$HhC\"\nd-fVmjfg\"hB!wf6p,+pqs4;VL`%W8;\0\r#`ڒwFwSeCuN\"uZ2T|q`vw v7[uvpmvxÓwÿy7x4wqyx0<͗gL/chJMrwt*zt\0z~yWgxt#zɣ}h\0w=+{h|Wwiܤ!h+Էzx)}MwXE@и[/Icx7݅Ewxi/ANE=7tHlG!oX @Ew8NWBXWnx8vjVł#E|k|pb}8`Ïw8ICŌXًzy	B=	oxkj6j;%yKny]Y'\"\0ZMnbnɳ	YōlCXsbwWwtaQl9l7fUjixx97u|1Y~=8wx 󠘿xj'ڡK#Z5C1zeY#\0ˣ-yy|&-8_ZAWhBv7}R1Z#p´6imy\$\ryimk=AWەtnWv#L^#Xyzuw}_w;W:zO:;:\r:Pˢ'Z;z#!NUei7w%~@߳3}EzZ,f9wVŴL-467iM6f3롲E	׆DR");}elseif($_GET["file"]=="dark.css"){header("Content-Type: text/css; charset=utf-8");echo
lzw_decompress("h:Mhgh0LЁd91	o6Pnf0qs4HE\$J%Rak\rc)Xa3:\r5q1'E2C(hcX31d1f#	g9Φ\$\$b5Úʹ^ZF30x_!#3n82JΆ,:59ʾrͪUam>5k}F#1â4L&AWnLhkrf7>f5t9w\$#:1l2̧Mncc9>z̸4J<NkT:AP`)Ћӂ >\rCN=8|8\\+[cx#H<\"wơtL8LLJ0\r03c|} #ID+at \rsIP9r:9;rSu6OF2[,#i\0Ql3Smî 9Sh2c3R1`1.qmRkt{N\$rO6c@D\nSh0UjD7O6I<ʢPz<B,4\r/P\rMO^fHanJAf=bC^28h׊Cu\0ss4&/a.9cd~3㸚QeQqGci<UeJ?9=,BP5߾X`0L۩N*l!&©2a_p>Kds@8B3ß\nC<1[9c>Tl^0L Uڷ;47d1d94~ɇ!iotnH8wYHlk\$<1(h3nh ;8oa812:z\"AiZ\nVpQq^J|Pa&Apȉ(2@p\\P<7HM\n-09!p-c;8]KSo?G C2N!0a-+6&~U+b\$k 98^Aj3rC\\1PdD, A8~#y%`");}elseif($_GET["file"]=="functions.js"){header("Content-Type: text/javascript; charset=utf-8");echo
lzw_decompress("':̢i11	4Q6a&:OAIe:NFD|!Cym2\"r<̱/C#:DbqSeJ˦Cܺ\n\nǱS\rZH\$RAܞS+XKvtdg:6EvXŞjmҩej2MB&ʮLC3Q0L-x\nDyNaPn:s͐(cL/(5{Qy4g-i4ڃf(bUko7&ä*ACb`.\r\nCh<\r)`إ`7CʒZX<Q1X@0dp9EQfF\r!(h)\np'#ČH(i*r&<#7K~# A:N6l,\rJP3!@2>CrhN](a0M326UE2'!<#3R<XCH7#n+a\$!2P0.wdr:YE!]<j@\\pl_\rZғTͩZs3\"~9jP)QYbݕDYc`zcѨ'#tBOh*2<ŒOfg-Z#8a^+r2b\\~0Wnp!#`Z612@ky9\rB3pޅ6<!pG9no6s#F3bA69Z#6%?s\"|؂)bJc\rNsih8ݟ:;HތuI5@1APaH^\$Hv@ÛL~b9'S?P-0C\nRm4ȓ:Ը24h(k\njI6\"EY#Wr\rG8@tXԓBS\nc0kC I\rʰ<u`A!)2C\0= P1ӢK!!pIs,6di1+k<^	\n20Fԉ_\$)f\0C8E^/3W!א)u*&\$2Y\n]EkDV\$JxTse!RY R`=Lޫ\nl_.!V!\r\nHk\$א`{1	|i<jRrPTG|w4b\r4d,E6<h[Nq@Oi>'ѩ\r;]#}0ASIJdA/Q⸵@t\rUG_G<<y-Iz򄤝\"PB\0q`vAa̡JRʮ)JB.TLyCpp\0(7cYYaM1em4crS)opC!ISb0m(dEH߳X/PyX85\$+֖gdyϝJ lEur,dCX}em]2̽(-zZ;I\\) ,\n>)\rVS\njx*w`ⴷSFid,ZJFM}Њ \\ZP`zZE]dɟOcmԁ] %\"w4\n\$zVSQD:6GwMS0B-s)Zcǁ2δA;nWz/AZhG~cc%[D&lFR77|I3g0Lac0RJ2%F S L^ trtʩ;.喚Ł>[aN^(!g@1Nz<bݖO,CuDtj޹I;)݀\nncȂW<s	\0hNP9{ueut뵕3=gJWQ0w9p-	'5\nOe)M)_kz\0V;jl\nxPf-`C.@&]#\0ڶpy͖ƛtd b}	G1mru*_xD3qBsQus%\n5sut{syN4,J{4@\0P^=l`e~F١h3o\"qR<iUT[QUM6T. 0'pe\\5pCe	ٕ\"*M	D?h2zU@7C4aiE!f\$B<9o*\$lH\$ @P\rNYn<\$	Q=F&*@]\0 W'd z\$jP[\$0#&_`+B)wv%	LcJRSi`Ů	FW	\nBP\n\r\0}	瑩0Z/`j\$: 8ieφxa GnsgOU%VU@Nϐd+(oJ@XzM'F٣WhVI^٢1>@\" QR!\\`[.0fbF;Fpp/t`(VbȲ(Hlԯ1vH1T3q1Ѫf\nT\$Nq+`ލvǜ\rVmr'ϸg%\"Lm((CLz\"hXm=\\H\n0U f&M\$g\$U`a\rP>`#gh`R4H'GK;\"MۨThBEn\"b>\r#\0N:#_	QQ1{	f:BR&)JBr+K.\$Pq-rS%TIT&Q{#2o(*P5`1H'	<Tds,N ^\r%3\r&4B/\0kLH\$4d>/ඵH*3JА<Hhp'O/&2I.x3V.s5e3ێZ(9Eg;R;JQ@vgz@'dZ&,UFb*DH! \r;%x'G#͠w#֠2;#BvXa\nb{4KG%GuE`\\\rB\r\0-mW\rM\"#EcFbFnz@4J[\$%2V%&TVd4hemN-;Eľ%EEr<\"@FPL ߭4Ez`u7N4\0F:hKh/:\"MZ\r+P4\r?SO;B0\$FCEpM\"%H4D|LNFtEg5=J\r\"޼54KP\rbZ\r\"pEQ'DwKW0g'l\"hQFC,CcIHPhF]5& fTiSTUS[4[uNe\$oKO b\" 5\0D)E%\"]/ЌJ6Ud`a)V-0DӔbM)`%ELt+6C7jd:V4ơ3 -R\rGIT#<4-CgCP{V\$'gR@'S=%Fk:k9e]aOG9;-68W*x\"UYlB	\nplZm\05Oq̨bW1s@K-pESpw\nGWoQqG}vpw}qq\\7RZ@tt;pG}w׀/%\"LE\0th)\rJ\\W@	|D#SƃVRz2v	}(\0y<X\rxq<Isk1S-Q4Yq8#vd.ֹS;q!,'(<.J7H\".u#Q\rerXv[h\${-YJBgiM8'\nƘtDZ~/b8\$DbROO`O5S>[Dꔸ_3X)'Jd\rXUDUX8x-旅PN`	\nZ@Ra48:\0xN\\0%f\\>\"@^\0ZxZ\0ZaBr#X\r{˕flFb\0[ވ\0[6	 =\nWB\$'kG(\$ye9(8& hRܔoȼ ǇY47_d9'z\r  vGO8MOh'XS0\0\0	9s?IMY8 9HO,4	xsP*Gc8QɠwB|z	@	9cKQGbFjXoS\$dFHĂP@ѧ<嶴,}mr\"'k`cxeCC::X T^dÆqhsLvҮ0\r,4\r_vLjjMb[  lsZ@;f`2Yce'MerF\$!\n	*0\rANLPjٓ;ƣVQ|(3[p8|^\rBf/DҞ B_N5M \$\naZЦ~UlerŧrZaZգs8RGZwN_ƱYϣm];ƚLcŰIQ3O|y*` 54;&v8#R8+`XbV6ƫi3FEoc82M\"GWb\rOCVdӭw\\ͯ*cSiQүR`d7}	)ϴ,+bd۹FN3L\\eRn\$&\\r+d]O5kq,&\"DCU6jp\\'@o~5N=|&!BwHyyz7(Ǎb5(3փ_\0`zbУr8	Zv8L˓)SM<*7\$\rRbB%ƴDszR>[Q&Q'\rppz/<}L#ΕZ\"t\n.4gPpDnʹNFd\0`^\rnȂ׳#_ w(2<7-X޹\0s,^hC,!:\rK.ӢŢ\\+vZ\0Q9eʛ˞Ew?>\$}D#c0MV3%Y\rtj57{ŝLz=<8IMGL\$2{(pe?u,Rd*X4\0\"@}<.@	N\$XUjs/<>\"* #\$&CPI	t? 	O\\_Q5YH@bch뱖O0T'8wj+Hv_#06w֎Xd+ܓ\\\n\0	\\>sA	PFd8m'@\nH\0cOwSY`RDna\"~?m|@6+GxV\0WӰnw.؃b9ÍE|E\rЈr\"x-\rN6n\$Ҭ-BH^)y&ךWǧbvR	N\0n	T`8XA\r:{O@\" !\$KqojY֪Jh}d<1IxdTT4NeeC0䥿:DF5L*::HjZFRMրnS\n>PO[\$V8;#K\\'BRدR_8j*Ej\\~vvp@TX\0002dE	HVD\"Q'EDJB~AAIl*'\nY.+9pg/\"180IAFCȨV*aPdУ5H\"A6sY;訞/0v}y\rץ1u\"ˋm_0焄`\\B1^\nk\r]lh}]HBW`0꨹rFf)W,ҧ]sm9'OxԽ,9J8?4\"҅۽<-SM;v6y|Z%a#8TC!p\nCZ(9|0<BL\r\n]PB0&+IŌG`hu\0\0005S@\"Uؔ@\0\$ސ\"Ҡ]l/	IB4.6,C @jd>dE*D@jf`:EnbĀ71)C<@AY!e\\oYF,M\nlt/)\\43)2ɸ)N[ ppp1#Ðp\0Œ^{ATH6\n\0PH.\rx|TFD0Py0%KdBC%E)Ts He5)4 r!ۚ*Lp1<fN'+LJSa\"\"lq,>Hm HV/lC&H)c&Y2%n\n^N(6D Gq!\0.#\0vr,M&A9#XBh!W\0_\r{@09IL22wA)H^^@rpG7Dd.I5|1Pk/Mez}҂!x~ qbHu?JlC g\nlEU	F|1rU&8F<' dӣ5%YtȺEA!/@Gtx9~I:)&RZ~	L!KBX-hc/oPINJ2|OVI\$0)e M릒:H\$y1\n7m@sX@T@w	6TX5+'\\`_S	_01!n_sg9x\rg,O9\$ݥ&zbQSf!D*U\n0s|(CA'tr|&?rnTkxX=i,\$3t[r9?Ʊd1fH4<(:?סKUJعQCBTP\0}2\0z+*HHQ%)+!(gUD:y\0\0*%@\"|Sh|y\\'¨ml e`V1*MZ%jQ}(~		PHWwZ(-*FF闤~OQΈiXMeFJja5&EzNNTtp PQƏEb+H-\$j'S=cMֱ+3bO6&[)7DuMjVLi:*fA8\nle\\nl鄖]D%~!W27TU]!=bJ'p>1f\nx&s'P/\"*Lo#c^I(#7V\$F!р^\$,|YH(MЊ\nA\nR*l'`iȸoAQ6ȍHԍ&0Sݷz\0RߏF fIP0|GQ:\0QH)\"8|%Ϙ*\"ܓStJxjMP!@*2y'\0P	ŪXR)\$ߍSU-ZD' 5H\n/㐙|mR#^Ӎ*Ȫe8B灅:5OE_=U5Tm \n\0CZZ/k\\+Cϓ(W!MHp3VB)`@BU#tQ/QQ Qʢ~PP#^@__|9T&sn%!pWQ\0bs[G\r=\"FPg\0!sht\$+O	ө7IMcSitYŐCFJ[}spQgay)ZAwDX<-FQ36t=[]5!\$a`{!HlxR{vM;g{(fIl*p\r^ĤKV9K r)e!vԷ`DDAȺ@DZFP xcAMhi4\0֘*,֟3LM(cG\\ǐlScͼmpLqIV6E=Ī1	u|-l0+\"~mT0h.@^Pյ5mDl2m[iېnqJޘrđ\\}M\"rq݋JמfsrX7 N\"*8|:I-%DF7|D0\\<H\"(E\0\n\$u^@]*+\$ڄE{t2念YǄ)~\$Ӌe&+\0B+n[\"Ij~s_)bݨ\$X*\\5G)WLN1+aI҄^Tj]\$U>N2!<ev;ɬրZҪC/x=1ry8ި\$*\rc~\nz:o-B#ܰ7\\)Ĕ(5@[茅a#UK~2AFY3!CS߬Z%,_N>q :lמ!UYXW r@kaEEEP\\eaw\rK\0zv`9lF\"9P\npH?P5|+xjz_Jq`,\\	ѪKLr;9>E'HI*u&QL+ua()!Y^Љ*b;\r)V8le|G6G\\{\0 .B48K_)kj:þ&,I\"\"15|T.&va\nK]u k{	?3Ĝ[,[JPCk\rFةk	9^II)SQBUghgMX3x!Mcd7kyZ,)nJ:N8Ey\nZW;!v62#A0{-i7~\0VX^11-+t̗VG.eyYRD\r;1l2/VFd\$PЮ0=@kS0hɈ@/'(OP-Ӕ4G>(rX6%XZ@:'#06kE|\$|H;e g%WfO1#ïv̒fI9(Odw	9]f}̷GDsX40Bf2̄+A}͝0}K9FݪNh/7eTsl\n4勳P~wO()Ig|9ţji6ݸ(ejηo>Bϩ)Ku(}q1odV[Ĵ\ngRvLMзr\nF#{t*#xܤ9Dsk/7up:^zFqϋĨ22n%yiÙ *8-tH&l\r4id8`\"hZBvT\0ަ9+䙂~\$ީ(LP\\{XAi:gzѨ\$`yW馴oA	5Ğ\$tU6jGP:\r3O\"IDZ7kh9f+ܝ,pOYNi=\\u_dg\n/lMTI\"Tt0-?3Pm\09,`|e5bɵ\$5<-RU,U\ntsQ@	tk_9fR\0؄J`uͮ%Slp\0S7\0P>&߄>&[gφR0P6C dd=GP\r=a(5)?a\0kvNUn)r=L2߮ЭQPHSMv\\X=ͣ)(\0!0v#qeTʳNTޱԨ~]pxi5TDl@E3peCڀIOPbz\\NܹIE9hjϰm_evu:4;S*@~[,^ɼX3~	ƙCX5xZBOa@L)-\";{V&u(<^ӻdTbgB\r od;@\\BژЕ\n ˜=`)	̤JCZyknt\"ORB޾`~	o#&xC[b7,˂!2+x\0;*uNK&8=sp\\aЏ?1|9Py3IKtZż4,TSN,zfe(J?|;/3:]M(#Y14S'sM&7rHLZ|D'm~4yc!U)ud9kÚ[8af8\0N^CDH_و˚&8n*8\r:n,88f\"\$H껀=&u\n2#\n>%h\"`	)yWVf0q= I%r؍\\EW9zC)	|ǨHBQ:5bF\\`01aa,.'dϐ9N]C	r\0~j#,-Kyan	bK,M!/@1BfGd\$?doG\\9VN5UJфɪc[GmL^v({ɹs<-]}&\n\0[腑zHnD+RldY=WVs:-H_8jzj5\"\0\"N?@;O{aN];,SOFHӪQDR!\\l ¯оcGDIH/.x\"Rߤ)	^A]WB颶.dhWL	}x&4?zt󳷴<*8e}{HZ1,(ooxWt2P#A*o[.x>NPjO*\$LAoF\0>	\r|=sFp\"ڲuuXxb4\nZ|\"AmvB;`y(mB8dEFH8qs>!UR搪YHqp\n<GboTj:974V:	3IBU{^4Z\0'n^WEvIsyI6V-)\$CI!Y%)4]pח4\r%\\,8Y2MvB*R\"dwo(	/\"hm,W\0c@{^߮ZDP]u6P/_L\riPNh&jl_\"N%uFc 4L1b{\"ٞ@ۛM\"wO.2L>EPGG9dVN/[u+y68{Y9Z@bнD\"߀{p SY|刢?оow\"8D{`~\0b/!˄/`8<!ÅӾ9v!V(?Pߪr?J@{}I_\"o,k@21v~V%06K2n1q'kTU鉪EH_/Ϥ&_K+q,~ieB~î3Ch㜪ߨ	{]T#a_-8A7~X??׊+\"񧺨C0X|)ii\nڢ.)B1o\nX80At.)4oo=/(\0C : \rV,AdnPa o)\" Fz2oc\n2!d#\0@4\0;.Z=ؚ;\\f.FZ@O\$\0!3*\00pbAQ\0Yj´{N\n\0\$~ԠVJ% Ut`i|#w>#:2E\$5 #\rdY\$B^pD5ȴK Bi&rl\0m,框B	9}Po\\0QR\nP)\02d?Ahk\r\0W@B*\$j)Lxp{-UkyzmATA8ओ:aGjǘ\0BA\". Oe\0z>EpAKXhh\rd-`4V!fxV%8xǧ-'rPZ!:<Hl\0");}elseif($_GET["file"]=="jush.js"){header("Content-Type: text/javascript; charset=utf-8");echo
lzw_decompress("v0F==FS	_6MƳr:ECIo:CXc\r؄J(:=Ea28x?'iSANNxsNBVl0S	Ul(D|҄P>E㩶yHch-3Eb bpEp9.~\n?Kbiw|`d.x8EN!23\rYy6GFmY8o7\n\r0<d4E'\n#\r.C!^t(bqH.s2Nq٤9#{c3nӸ2r:<+9CȨ\n<\r`/b\\!H2SڙF#8ЈI78K*ں!鎑+:+&2|:9:NpA/# 0D\\'12a@+J.c,1@^.Bь`OK=`BP6>(eK%! ^!ϬBHSs8^93O1.Xj+M	#+F:7S\$0V(FQ\r!I*X/̊67=۪X3݆؇^gf#Wg8ߋh7Ek\rŹG)tWe4V؝&7\0RN!01WyCP!i|gn.\r09Aݸ۶^8vl\"b|yHY290߅.:y6:ؿn\0Q7bk<\0湸-B{;W&/nw2A׵A0yu)kLƹtk\0;d=%m.ŏc5f*@4 cƸ܆|\"맳h\\fPNqsf~PpHp\n~>T_QOQ\$VSpn1ʚ}=LJeucaA|;ȓN-Z@Rͳ 	.2`RE^iP1&ވ(\$CY5؃axh@=Ʋ+>`ע\r!br2p(=!esX4GHhc MS.|YjHzBSV0j\nf\rDo%\\1MI`(:!-3=0SgWe5z(hdrӫKi@Y.\$@sѱEI&DfSR}rڽ?x\"@ngPI\\U<5X\"E0t8Y=`=>Q4Bk+p`(8/NqSKriO*[JRJY&u7#>Xû?APCDD\$Y<X[dd:a\$ΠW/ɂ!+eYIw=9i;q\r\n1x0]Q<zI9~W9RDKI6LCz\"0NWWzH4xgתx&FaӃ\\x=^ԓKHxٓ0EÝ҂ɚXk,R~	̛NySz6\0D	؏hs|.=Ix}/uN'Rn'|so8rta\05P֠dẘ̕q5(XHp|K2`]FU~!= |,up\\CoTe╙C}*f#shp5mZxfn~v)DH4evVbyT̥,<y,̫֞2z^K2xo	 2 Iah~cej6)]5͍dG׊Et'N=Vɜ@b^p:k1StTԙFF``{{47pcPطV9ىLt	M{Cln47sPL!9{l a!pG%)<2*<9rV)|AIp=\n7d>j^6\09#՗7T[i:XD'&8/;#f%Kj3;Z^]NQwtȬ\$ҹǎ-;LX+P̄:N \0ǲPyjt>.[<w\"|so-;';ǟt\rt	IT\nL\n)(Aa\" 	&P@O\n師0(M&b\0@@\n`=*̔8/kHF\"FB&,<4beN)FEONSNO\r.x\"kD\r 0p[2RI0Z'fixP0d|hOmkHΒ7\nneP\"0xP02n6WχN[!6ﰣ\r.u\rpP.(mGt\rox1!\n\r:z+lV'|?PP:0 bTaux`co}O1Wq8l\\u@\$NePKqgA(mcL'`Bh\r-!b`k `N0	nN`D\0@~`K]|ʾA#iYxf\r4 ,v\0ދQɠNRom 1&Ǫpr np6%%ly\rbʕ(S)')@ޯDMIs {&KH@dlwf0x6~3OPh0\"D+A\$I`b\$\$RL Q\"R%RFVNy+F\n	 %fz*TMɾR%@ڝ6\"bN5.r\0Wd4'l|9.#`憀أj6Τvvڥ\rh\rs7i\"@\\DŰi8#q8	\0ֶbL. \rdTb@E c2`P( B'0/|3R.So*cA)4K}:S\0O8B@@CC@A'B\0N=;S7S;D	MW7sED\rŨp<DȺ9 }4_o.rԉI\rHQzEsB\0eJ KwHtJ4,^25h2i%;=LL6}7#w<lrT;tPl76PrJ\n@5\0P!`\\\r@\"C-\0RSH~F倵ņO@ǭg)F*h\0pCOu6ҎYORg w9BӚL\"䘵_63gU5\r7,6\"1yV%VğWX]OJ	#XQGIXɰSq+(qRGH.l6[R0\0%HC}Sr77cYK).Cr;Ц)M+3 4|Ϊ1ZJ`׉5WL-SmxHdR*JЦ\r|52-C-1RRT`Ne@'Ʀ**`>\0|C!nE,ag.bfÝ8ӓ_a`Gp`m6Rz\0[-#mO1H\rdMMNMqnMnqR6mOn-tvæ\r]`-`jXMo]`OUAF37p>'J'm('M=j9jVZbBn<@<fe:\0K(NuN-!1vҍH(QgµxC<@ c[c\\2o,5˃q0m}i~+eѶ*}Ƞ}M~|̘\r @\"hB\$B2c\$g\$5b?6!w+~l1`	s	.v7mEc`Qecb6`\"&fx\"2E~Fz\$[/0,w~`u>w%X\$دvV\"-R%WD@ʀVoE@yh1\"tЙO/![`:x}@]b @5U(KyS>8D͸yw=|T,'LY\\L͌d.@ђ9<`9EZCײ\\h=qR`GGWX{5-LRJ\$JP+7XulӘh̵YPgzuiwyLycY7yF<v\r57dOgkYq8p	\n*'9\"`w[GHDy_]ciR˖ow9	{]Oݍ8C67:IvS:_U71zڵyy͹M0ͬc0z?z7}W'5_eƸzml\nCX_(Ý{@}X`SgBլDuñ!k~YOvK\0crr(^`n;y7z+{W:\$M\"I%omŠ	,PK9ʅg\n޸a~x%~WؽRٌ݋Xx%zSzթX?y#}L);!yߕsو:xz+UԺ|1uHO'cϩ{c<g/V:퉠Ɋ<\\3e\0ZTxZq\nl_I_Zy,ۙ]9ۚ͠,회k:;}-E\0S~2\\	UͺTV3oE|E CmϠI=\0НzkGٹ\0ّ91	y=5ۛ<Й]GЙScՇ!\rDR]P'pLtǚH+`Ӿ=e9ڇQ{9_b\$5lUzynz`xbkM	3 Z\rq])ֽ{#cWI\r8\r3䩽aSI'^a~eD稟>o2 NސP>cΞ^GY͞~x^Rg\\\$+ՍPkY*4~,MݶW-hhG_Iԉv-?ive>T\"\$[Ը+,)Kuq?KW\rkL%}tԻ~0|Pk՟T=?hEn=Es~xJHKVuk?X?7B)ciD\rא>D',ʟ>v@X+\rr@\rUXׯӀ1P>U,3G>>tѥ}\"=D}<T%9iʫo1e]hi&]|*l1D\r)XZRYl\"E/8ײ*ByK45Nrz\\pӽ9YzJHS>/4C&sCI;Z,ۆb3\rϖ{|vD\nٟNpÁ^Ay0az<ԜMPS0ڠjew=Ooz4>h1L%RS	}u82𦴮9oncM<uƶ0\rp~A\njQ3z(;3Ea]eUl40,uffH0݆\$1CAfi嬇>XcʂT\"6pHgDH?\"pl&K/?`2lm*TBK\"ϋɠ\$P\"oeVk<oIr:=(x2*Ȁ@=hCEF6u+,ZYir^lPx,g*ȖQE)1ihJ\"IFlY|TfV}Ueo	5Q?)\0cMFʼڑjllPm4\r*`⨸LMiqbV)QWR^a.>g	ox\n\0P`@`\$4鏍rZ#H&ncv)lF	 NcoXF9 g\"9'4t^!<	#0#hG|\nBx\0PT06\0TD~#<Ԑ@)Hb1I[hGj7_!0	CX@\0\n1@Z@\"ǎ8N\0jH\0E#ۊi:i#hDs#!TL\$\$)B׎v)-?hcP	 Oto\$pօB7#~D#-0dbDH	RlJ?\"`\nA?\0T,(RMp\$\":ISRzt\$'I>쓜'QM262PR	\\cxF&69^	pN)OHj:Q~y\0GyzFcĹ)s*<mQ\n(228zT#~[ G?-1.P;\\&5֍\0mTQn)p\$\\vZrK(c\nYws/gK]nbe.KPp:KC{6arؘl1)/04KUS@x˜QvT̄c.ʚ: 0ķL1چT0bhZL]AqVNL\nr0V#\0Ta2``2,\r-imMhSITxC,L.IOt	7_TrgIKxq8gIqMcDŦA3	 r`\\ULӜ'A9[8PQ0821 rBK`P%Tq	CF_hQu<C\n@<y,&Cv0%PO\"x*綔2&X)=p.\0{(N'y.2\$>a&)@\0Ov#X\nNz,xbiꁦ=iZyRg3MVs\n\nq\0?AhA;`;m(KAz\r!O\0EBJPBޡXO\0@Q4V0kuXtYK٫h=@(P9'\01\ncϙLhBk\nU	F 16+BRGަe4m:	\"Z=JLwO:HRA7ލ`͜? JB[_:2p:XϩLABB.Ra|rAFџ&Tiir&S4e0FL11.Qk@+Ta}Js:q4%B!V4їt-*~da_@;c*mJRRY4ϥۘfd؁8ɇ9*09wf/tk.JP@v[ҐR;\\cMTJN+^X Kp7T2,䨀d(VFK1x.X?)*NDRU,,=2+Ik\rFj7zRu*\nHϓRګ\rCeLJqպLHwN!Ёt\"\"ǳU5Uh!4`9Ԭc: E:T򞴪Y]aR\0\0#!x\\UMf#Q3TfÈMByDXTՀ()+MSꉤ=lkL*V1\n\r7UzaUdPiP4Is07cR\$gJGCt	>`tQB\0l	8JOm%`^t\$ T ]z`_Yo&ZjXFyxf\nvhHtͅıAگ0o^ X\$W\nA\$bKX%(`A%Xa^M,¯-u?I?QB,i	HRDnc\\Z`mY:8\0; le¼(6mvv¼U*QwK:n 1aS#g8{CUy@AـB:b޴TGj(MtRimY6'PV*:+6;uqCiKK֯q@xEԠak-?Of-_Qzׁ^Pi;hvϵj82mpghmK]\0\\:׵#m_\0^kh6\$ųGnKŵikl2ˀEI!1g3o>%T)0\0Xq.PU715p}\\aXWbjz-e36+7PW-h:,@Gužb0*|nRrRPAڻ]Rck\097խ{u3&]Cޱ,ݤ;F/WƆD-`F8-e'\rʹ'X*ވ;JA/Hbwe2<XnM}@zdp1F37^FPXjk{тU:`WIOWnX^tϽ\ryzlJEM]ӱ{3	Cc슥J#vdr\0_.u˻]x7fW-ѿpv1908%t%Sp~\$a`3xEh@ہ`KKbn!x\" {\\	yW?2ʄ)r\rH\0>[\0\0L\rp0iRH|@J٭q2&\r#&BHڢf0JKrkyWe3)xeJ;zQ\$\0V4Aa3)Dnw,0chF.8&L~La+D#\0>@\r7p?Z< 8lHd50\0_Ą2b`z7l7Xq4l @=9>v\$\"Hgؚ	(4Tq(6a:@!ٶt]:/₍n	ܱob\n\$OjHҷoﱀd\05{c&G	\$Z8Dz!5\0|SSXxk\\c݁XyYCҴ--yLu̯NܪL=õX\"Z1|\"	lcؒ4\$.*>@+@CX\0\0(*T@p@s/ y\$2Gf V<\"^ | \0dV :YpY[!M\\cx&^B3p#	8C8w5\06.r8\0ۀy#n6qβH1pug@%@pq\0d8Q\\:]\0\\^c0&,>6K%L{؝jg<YzhFB:҉w-ϖkʹᬣrm	+yo7qM1bzRi;0(e[CՎ<Rl6hR\0NǥQ8S*k+\\Bv ^QhD&74LY8뿕2XKt!HWނi`k|҈8NCczFXLV^XZ.'K˨ &KCC)q1]5dP9@ubpZLƾ\r v|Y	[[v 鈹ohtmB#R-H@R0 w@暋y\0qw\0qdN־05bsZL*3ćcjtBCH&T۟לtV>0͵{菎2\"yu7µ9\r~_>P;bZ\\qIXʨV<d:[(tir[: fu`^V*v_kZ96C_`C6JF.ζ&=衬\$L\"w=nZ^[oV6ۺ-[vT(2 JҨ}oEr(LK#@(ɏ&4m\" pۻn\\=.PA5FbѦݗiIґs\0005].+\"ˠs@|D=ئ.'ψMˠ=KUc>a.`nVvďP\rg\"=<Hi+w\rXll:TG]<7K[o&)~gdRxI\0@k-Dp(ҿ/s`+t\rs\$wnDENKAn<pƒXI#;z:vmj\n	6Zچೡ{؂Y CCPDC	vs\n1pjZZ7zjh,l5qտm9[|o:0n?~AEIam6/,Q'\n3*Ӟ!oГC7<y=W\"HRK!/h,t)ٷ5.mʱ8oB%6aH6'oJjV6~J3=2%V(p\0ͼzZM[ʬ`Q;X	(!\0Ntsi6zU;m\r0\0b3̰jczzU倫b6-Pk#{MJx\$RnOt	77g8.GNIJq`70(\\gHӳe3FZRP	GSZru3:+L(.\$«EJ+sj'>< t@C^2`])*\$fMUAA7aBBNP3];Ys'Hf<t|/WKh0*ᨓ\0e<S]jg[>nvsn3Ih.t\"<_jzbs3M{cpOng.~}mp92wӠ!S()x\\`ZQNëJoh{=JuPiP@A?p{\0003@?A*ü)B;>Nw糬pz+מϹ}@pL.}M9x{`C)]XMμ]'g_<A.'<\0X\0㳃v]<[p=.ѱ*};QYwCɳwv,W]<@@p\ny\"z~)7t͝u@Sl@}ǃo߾A<xkl#Z\rzV,y`Sӡ&6pExwﱍm\rO\0\rg|\0^{!*h}@^1&ȸot_It=<?)OU{Z7J`@~*&\0^yQ-9/ɉ}du\$\0002\"9ǿO࡮?!UK?y/\n5[\"\n>+4\"yA^y-OV]?׫c	}hwzOO_Xc	%?P){>`F}|޿	BŰ~;ն>ψ|;~}ҿ}ɇ޽\\'?}\$Fo~=|߇Y1,?U?{ձW}\$gpk\\ bN7+ہ\rg΄\0^\0B@-	T6\nﺅ5o(m~Nq8_8Oʳs|:s/d!\04\0D p[٫Lꋩa^/+\r\0\0zbln?\n@6]p`-83\0p@>@f	\$'PH?p\n\0\$\n@*\0b4p\"j!Qᅜ:d`+0 a\0MGS\nH0%\$Z(\"AJ\n0\0.	#oL+m\0\00;Ak.\0A'AA#@׀FbHWx\r@\0VaMJp?4?`n)5~jR\\~*K\0pALOYz\rla2m.ޣ&A,̐;-K #\r2HK!YHi\0#\$pj](P,]oA.\$T3!p/\$0dWbe΁\n6\$,,J#@;@0&LG\r_lE^ \01\0	DI\n\00!or[	hɐy)k{k\n\0pB\rj \nʎV>\rJK6\"W	F{t\0;<%hp̓ Bi\0\06h譯@)JЕJCL	>\0,_~vX8 0w#^2I\"kLB1CoAH\rϰjF>q\"iOP\r8~Hϐ(.K(\nljMf`1\n8>	,,å\nܡxZ:C	X'tPpȸ@ళ4=\ríB\rTCSp3<>\01\$\rPe83\n?0X;̿z˨;\r҂W׌Typ0D.BAD[9أm!h%\08:SmpB62d?˅)h̿ҁ0DC&Ě\rh`	\"\rx\0@ h\$ndI!қ2ΑD\\CQ9\rBKY檀#R	,K8L12P3&\\P9,: CBAN]4A؄/@	<TU0Ϧv\"T;p눐-P\r\0HMTEBWq_EUXacqcI@!\\Q\0HQBL\"71ŴUCcnC	\"1eES1\nEZMi\0\nj E=	_~C	4QW[\r6ú%x9H5~A%*@DCvIC7`\"c-	H+F&x -8\$Ede'=@itf2LCˊJzd׀<A0тT 叄\06BT=D0lP\rUT\n`M!il><l,FPѬ08iFF\r+ѬZ? 7F`B/x'\n*ˌ>l2Ч?qtkGG\0:BLtqmģ4pkKh7P!o \nna,bD2\0Ahڢr!0\"	Y!R(G+1J:aBe:vX4hR:8y>< Q/\$472˙+ KGP\nP3t;5lL]tN\0ZRV\0AP86\\\0\rl~	^p%Q,bttEBĈQ<6Dfx 3xEyĚ)(H\r̈\04q̋|==A(\000517_ DhFQ9Hd;Ȁ\\%--L'e -4fd+3Jz,#8G\0؊(ԳI.d\$c[#9N~%#{Ds됨@\0h*a2fؕjo|BD.QH .Dcx5zoQCBTvlq=³Tv@EC28zDI(\"L'T<zh'',RtI%ip;\$Q)\0q%'?R`\0\"Cr*vPV҂8\0?F&!T;&@9\0002CS)TJLAdD<o'bq개q)zA&\r\\<=cCD=pI`40*tp0|CtAh)+=( r'A؍dJԩ;.\"΀,B*	Rb@5W/+.cTO,v)BbE&(LHrEd6J+?PJ곤8\nK-K',rE+,17-|-pnKO-ĵK-)1@,l9r!-Y+%\0-̴2#,E.(\0D.Cv9`82AE/8[\n/,E@I/T]X`\r5V0	RPn81qf%@(3N_2P@\0\$J]AI0jGPx赜Ĳ\"K2B<_@+R)ږ1K)DL{8(\r22HBAr:@wh\0o	8}\",	!U/\r_\$#@5~b^Oձ8]13𥑿p/c\nR[C>^ ׃1AQZ	DpBĲ%jI\0.[;3!.Ժ~%1SS3lsfkJ0 )+ ` lS)9>P!\0`%5Nyֺ2S/<.d႓'\0T\n:P.>C0\0`(7h\nP`\"M\n@`\\\ni5()\0)5\$7hsO	\"Oz<S}@\r!̻68n4ЪrLj'G6PfMⅡKLLڳnͮT/=񑑪&F;麀&>A0V\$b@4#(\n? 	`H3o.͗6lͤ=ۏEL~6y\0@\0p}SpNBFdl\n&\0^z/N9|\0N9۪X;:Ӭ:i*y;|+O(}(8/\\δExo=8Ԡ<\0%oUx\rJïu=-=o潺SVBSOddY7 P	>p9\0Z^\n S#p+|?'>R\$:00	ϻ>AHITDSOȋ\0>|T)4Hϧ\nt\0li>hl@Ob)Oz7>ࢣx?	Џ+\0>\r@\0@Hi@PKA\0003?A<!@JtOA\0p:1!>[O`ϒ?h?\"4BTZT# H# AȒSWTXSȈ]Xc0?T# SyJ6fLo3,ҷ5>Ќ&\0 EB,K  )4F/	Z2P܇4GoD߀8\"B0+p63aC2> 6QHOTQ@9&\r`O4U[E@3?LP<mTmQD4NP/FED`MoQyUFZg5F[TmFiU7?\0[KFn&TN\08FHTjGuDz-WGe9Q>ht-G\r>(C?+- QD!t+\"4QD!O\"!p\nJH`2RU@9PehJ&PaO=BI8aJ&UQHq\$viD)ЈJ<5)<\r'bB(tҶ#\$#!?m,ʜR-;)9Kp+T56m#T)KY4ŀ.BAR8o 0KE.д=KRJT@TRH*NH2RL4KS6xtQ;J0CPKM)+HmSN\n-54ΤYH-66SsMTaL8\0]8tSTް+NM75J|,ӡM:PPQeM7>E\$`3O;4j?}\r@7Ct++,\01\0;@BS7-64N8b0yOP%Tm>+O>QO4!dB!ROR&UG]>TP@#Q+T\$}@x>SP];\0EQT%P<=\r:WD]Y\0XoRڴN-E?tSF10R)rۿ7O=='5Xl>+Ĳ<`L(74GRd:EPK,aU QOШd}ODCdQM=»,?HBUD>RUAU*:eR>IT\rRUQ\"*6}Uu'XOSZSOSTFVt3OZ UGQUCX\neP\0 ,՗G\rOuaԥV-Sc1TUlHRZUh,V`9FM5tмjTMF[UUoE]uECTu\\|W]T,QW!UmաVZUv\0WpuG=&\nBX4^V)>bUXHCuI;myV\\5aUY-cU{Y]ՖWxaz7@f5^5U	ձYu KC\0O#ց(zBաVUUhՃ֑Ms%Y]	/䄞@OMS8T>\0;u7OfLMVMZlP{A[ T(<VZ}dSYeo յS\nCTOqLP02	/6Db>O\0,N	f\n`\\\"*G>\nU\0VbVs]]#Wj()\08	Ax*EC]uWb\\쀎	)\0] ,`\0ut倊\$c\0?p`&^26e^tUWL\rv@)8\0!r_@Q	%:\\+\$?u@\"e^+&>I\09i\0]D@!]Ex(X^esW]ҧ]=xU]`\nXB?`_Ņ\0̻a`\\#W%>|WaM`ŒDu%^@؉a%v`'Ww]	w]튕뀒0esEWnީ5X7aj9i\0bUWPiF\0`uXb؍7wc%(M^vUW^}CW^ŏ{돏_XaaՐ@X_u~\0~u__C`?=V+WbŋUXcjQ6_VOu\"J7 \$`X	-6n)bV\$GcX\\idh \$חe vX^	Y`\r\0d!%]ߨc<sd8SX8x*\$P`Sʍuv}\n?UX}c%jF}I#^\0^ЕVG_3dFi`>WȕVZ3bv}[b`vf6Zwg3	8%6ڈ?\nQhŤXi6PڥjZ)\0֦Zah\nF\0jkU\0 x3\0׌Z'OڅʏX	k~ )WV>VXj޶7	hڳ^8x-V7tu?ը%7r; %	\0hcXiVk%`X-k?EWl!s`x4Yn\rArڣ_FڏƑɀ?sYmeNm`Y~u5[n@'ZeZbpk[uk}lۈ[d C[o\0*叻o+`ő]ժ \$\0\\s^6`\r-VbX	*W`	@'X	6ˤDUϐa邭lvaa\0W\\b]*\$[5q\0[H۰@C[mu[l=&nUlP	@7rM70mkΟ8-xi5=NeI8\n%7\nUZ^j9Ycc_t5[aЗEV?y[\rCʏMAYt-i6YH4\nܡmW*]AmWWۅ`\rwL/eU۷umS]oap	ܥt]uW\n}sK7d?=uݗoUķݮ[@\${m۸%vڟvW4ܮ?t]]gݣuWxڡvC]Q'#=`0EsE)%%p%u@WwFEGvXJ=nXkIN0Qaa+qmA`a\0dlWh	XdMig<׋hH\ns\r	ҏ	\$Ig6:#:2^mx'zI\nEzX3z^wh\\t%7Iގְ#mfϣڕCi@(^49ar7Vj>_{UY[h *r=K^	rfu7Nh0	ִf9vj(AG7eVn\n+]dW\\^\r _C`,kTkM¥hp\n]y|\0|ő#g_XZVu^:M{~͊催?{N(\n\$ױ.YaGv_]}z9v;XdL@*\0xXa`76`\0u_6}\$?nj~_y&7,3H0`u!ڃjeWl-?q\0\$큕usUhڏ@<F`[UpJ^qͮIN^Ihױ^h\"x)\$ԓ5I6[:8&\0007A?%V`\0 ,?2X4`zH1e{6zJL瀃u<Ȏ͢@\rsۛ{xAfv>_LḮVpU_%#W:eu!lv\rN^󩀌>##mw@'3ulV@\"p}Ʒڮ>݌־Z7}W`]	\0/ݻdk8\02a~l`?vm׹xxUX_շWE_կ=\n5^#mpަ@*aqziZo\0\"]GgzN!U%`\\8g\$DD̘k`\0j\rK!p \"\08>#gm`~&Va>\$~Uf6	`Lز5Tݩe|wٰ`6v3+aŒ;6^vVh1b?57r[ڎmZdQbrbAVoY:~C`O:}\\Y݌%hި2PV&8d2Vقl`\0asިZL?}6+cF,>4j*TYw=UY0/ÄN5ׯwBW\ncXɍxb?x*Q-u8V\\SpuXH>{?;/w7^7^/Xx}w8{'xgZq-4 _i5{gw\08kVk͟m`!>ӏ\"@<hF!hkp@ izG	/A63s!UB7I0Lx|9t.(?G5x26]2.C=Vu<^JOK1Ap:dӑh\r3>Lk8B^G{):Lx쿠3njPfQ9@&Q9B\00d>#|EF`)_T PIhpP`)N?qhDIdݓYbadySނhkXФtVY\0Wc`h``!ejget6YX(ZB.Z։e,eYeh!eF\\p\"˖MvUݥcŦ[M97\n_\"R\09賤u\0` v`aUfkA64-@^ðݗn+t)6cJA1 Y%9\0;Bq6(:QRpD0@lQ)4CFkLT2K\nBHCH\$ƹX!tIfvbs2ۥ\0EvL`a\0ҪFXN@њt/OP(1u\$ASxR Ẉ8l\"x-|\nP(1JaU@D	,zO`p[A0.@O0p	Чz>\r\$\r042r:7Jr)BpHdZ=)vXL)u~xш#8/}@(1*g-?\00056JPjY,U\0\r\\'/%?p10a/\\1x+, &-ܥ:f|+h\"Dp3`6F)6\nN.=d2݄3IO!gf3g|r!J)䣡ˆhvֆ!Uz:#~gJz5Kן2.}_拹6TzV~\0:2(#Tlzf\"hu9hpaTJ:'A8H^P!!h:hĚ`l淤'n026L0969{ޠ4Q)1/	MtCeBYR\\ЃXM|\0004+Kh(UKeQe0OU~HA[tMQ }@\"2_YIn41]T!Xf	Nd=hi6,O50ʰ0>f,a3>WO\"ZyE,`Bm+z=<[QdH>7eof#%EY0;R\\ذ)%&= !=dX,&!Uj'l@fSx@9G4\\CcFR^A,ީ\"W꘥1&	1K*BhˏgP\r, E&ZFh>xk@xd\n=>S\naj5j*p;:>aThH?cE3>>`3S C\rHKJǛ>hHNj%%`ɳf9#۔>TK~Y3hbQaM`QLEIk4:뽮ƺ 1\0ɮԿͯ%zk^~Zkn 5%zk#&뵯\rFknZ6;\0NZF<&SpItYDC#Ǜ\r9fEeIe(ڟ\nM̟\$\rS2rι\\(HN\"E\"yT鞴{\rQKoGQzvoZl[!c_iw5}pn![W}efkl毛)rƄ4,n59M~!:ʻ9Vzz޳[=lަ#8T1%JhR6[+'!m\"!^G?9:)	cNmJa6YS[KT\rk#0\"(l)ӛXlhaW6ZUapmclEiF1ߨtr=퓦f\0d%0H\$փ_ퟵ={4>CAmVt왷Yd;oy+muiR\"`8f=iDF+~ ;rFɌnmf}e]f'8NVU([WFUo 1tn![1_amۚC9\"pf#Xx\"fP\$iL(5\0ZeReݡn0eUgn۫Y=CAgX.mUꥌ)^+8BUWKlBMZa㲾4ACY⃇^9F'dF}0dlG+~D;nXX7\"Ɲi	Ѝ&Ũih\rk[nPf&6tۼ%~r\$.hP[nk\0ݶUya< o칼Y-n.P\$֠_nt/zH~Jf;铧۱齽L'o뿣8n)4ǹ4f#(V%A&0W\n@4A1iqe6)]ݞ+b;KV	Bg4c[x{KV5Xﯿe1J緝WQ Kﻱ\rteTjp'cE;Z\r#I	&nxc@\\%\rc\\n|B-.p\r1'U\nUQwr|@>sD nE.ɨ\rЇWŗ\0005[ŏ4KSp/zƴ|Ma(,gI!w3@@{PM\rL<\\ke@9+9NAlpTyyuDAj?W\\nA)iqSCwմGC5ǳ(T\$l\\zp-86Rj\ri.[!SEGɈFBPZ#oNei\0jv\$\nmήfF*[rF[r\\JÞ.;G\0a<[3jSé <\ry5g\\,jٕj>S]]gMQKvYGF_>/%,P7Q*6oHJx8(vzd+.baN Kc*e\"<;7|sU&7\rn#Ga/o9w/ŵ]de!:y&q0ZS'I:\\?8\\O9}v\\ϾS={R^n;C@b%=]rţ@A.Д&= vQt+CaГnwBZt%Ez\$t*MUt+Km/PnoKБCyt+ U˥H`wѯBZ՟>LqK453ҿKhX!W0R;G*3͚<QKہ;N+.s1QWi\"`>rI̟OQlrI\0mJAL,!1oQɞ!Q>RAFQ[Q} Jyd 	7ʜ\r9yEᄺ8O6ťծd\npzSJ0h1E1O֕Z{6RVn5J	W֕ZzP<oZQz{jչ.;\$Y8p#oUi\\)ךd]|:[#QXd祢ѻ}[9j_ذD\\hW=s8	c4V{) ]qRcu	?_n;z`	fPXO4f1 n5L\\n#}1v'_j0'HN#YBCU@gkYԸb?a-<q<3):[K	#f{##^(R' 51^٪C\\핾p}Du3Ф&1WhSg=Dw_V¯ORmbC;nUw\rnҘ@p7Dv7;\n\"1ׇU-\$ܜFf\n@8XSYp{xٗ)B4@!HZ.:qIZTǹQ>t#u۹[ڦ;wJq!uwЁ d16ExYG?E'{Z!wfƊJY1TUWRGx9ՇJ;{ٙ7Yn;{ҟv0<܌Uߑ2G	1܌Ap-wӱF)%sih'p\nDx\$Zhr\0ؑV(p`%[Z 4YӺNI;IRe(at9}xaIw\\ժ<M̯.N׼C\"Ə|@O>^K!C:{5׏~L9\\(^I'@q\"eSyMlOV8BOVƸ0Wc  >0l'nT0>dySWV\0_x;h]RuYmK\nLyQxPB0/?#\0TFU(!?/@%D0ғE]҃baUpHb^.d>w^z\0'^%/Tfn]xQex#ޗTePS枒AA:GO> @3zeN%>п9_>bgdfX_B#_L#m\0u( \0djiS hsPJEãxTY(o1-WG6s0B0SQ`>\0O[y)[\\By\\ij>r~P\rZ\\oXzEz6%?6Wf>Πe7^JQW(^؏\rWzuޛlg^Yz]^si6cgjG׶_{zη}	Wբ8^8UWOcx=o`\\Al-y\0y'T`>ܕq{[{k]KއC{lzϏv]^|1_`al\r[=}^:`\rmۧz6	 %%ڣE^n!`_&]'t6Xi\n`^\nm6|Vo?׽O7++m`_c`m8]/8\nRU]WXYC^lW?[lOvd-7X\0e{pNxn~anu|`Wz,Ι/˗[|o|6Go\\|ox}y/?\\mOv'ض<Qoͽٿ\\pEֶj_iDfX'hNmV\\'5_yX	lg%{:볩;S}}ˏyu}7Ze>cͪ^md]N	dGUΣSMfW?;^rw78y)\r1T21@a\${\\-\$bwzd}A_}w߀QWgLN4N?pay}kzy7\$!__~3&'ɬEYÆ%~tIgIal^9pg5n(:gYߠǜg~r@t\n-\r*CvcE9fz݀\nPn,Q\0ӘmMpˣy'hsyfmFi3Kdy送!6QUݕ)@<\\NiAg*K	LS菘&g	7`gFyF1;GiXD3@\rߚ4<f\");8\0JYg9F`()C\$q8ϱ\nz J@F\r\0\0o\n4BA\$\0AV34XP)hIZ:rA	Sq,RHDN''QQh``1œhJ3d0\\@*q8NڙEe&H!PXFeMT\$sdjvQmgԫ|[q'=l\$l}F\0?1k[CnRX@h<` ;s]10f&Q\"[<b-Aڅ\nh,1yk|J@+l\\mKDR0@:&\\\nxmYQ|&y e+~A4\0<\0ԍǌ\rvIZ\rjR1JMKm5Vq(_tLVy; xGڎ!ɭ@pizv~:bpӵ @SZNro`<N>,uhC7 bEwx\"/pIET!aXh%E0Mk%pL`8	k%IJ98ӟ(/\n\na!/1P7I%*RAEu>\n\\w`ViK]e؛TYh60[31 \${Ӵư_]1'8@ %ƙ*0\\Att'fP8䓊hvF#H|Ʉ3M\\wzY'#(QmE@_BlA&w[\0kFM7R}m!`Lйȁ)+ǰPsO\0ک9#0u\"aK÷#.g\\؃bP}H7gMHxF)<M	*9T>Q;;t(2#\"`;i\"\"=ۦ\$KH\0[xpY1*OA	3pNمDp!B'XyDmĶ5z\r1W?R6ڄtzXmZYB?z#l\0B;ꄴb<!'NX@\"HА@O>èI!*,/k4D'H.-O&AdcM'iH\$6f,8NП3Nf.hlR0ٕu~>([bQ6E<(Qg~U	;wdrHP=\r~oR8N-PIB=܂	 U,TE2l('p9mx'̐hhԨxhipZΚ#DT}!-ж@|KA.4ԅ6MnoX\"ܨG=У)\0( \"7fPڣFb#v!BoN>KLL\r/2L* A.~=(T-.\n|m^0A\"OA+Ea((]hYܛII\"ܥthN/NQ^}ZQg@`Y[ܢV4-8Fr=Ujm!h	æ\$COr!I!9mVU۱BEeuB& fOmqm36IHnF0D7(mpF@E\nRG<U2`uBN]x	-2H@5rW83xr҇36@K[+uqbxO]&ԌY˾*0?	mf	kMC,q]\r0HX)\n	!sYAuXvbJ>J	ְnTGp\r.sH5MD3Ek\nSG]\r!xHInRN\"Y ao8,=tS:s,m6T]DFm.KO Sn~+;΂\"=R5(p_;qBeQ\n9CtHPl-ܮl@(A?\no*֝|iuE~[	mb&nZxDA\0,A8!b+9x&ѽ;4Hl hʀ\"BVl6GbD|^;P[7V>,˓7H 7(A\\\"9I5\n(!G5GKT\$\$I%N:t`z%JWXF\$#v4.Īh%ӧSـ ij;Cz;.&aCD\0Gkyu!bm4(	eQ5l6'2nbsTz1\$/eL'zV\\]:뉗	Ӣ;v~QZ;J|_lwffq=v\n؈̎\"EL_Ih\$\"?U#\0f)PUF#f	J&\0#pCD\n)|-;A9 PEJ apS6EPlBܸMBMߛR<m\0-\"E)Ɋp^0poI~L	Jw^5'jqPdo3eDs	kÎb`>}(HР['srd3P,..QkN̽32K؇ŝ1}qkObrԏ5#w\"l]IJ0!xQn'Q&xbro,<<t;B  OI\0@\0HNY=O\"_&2sg^ImOPvʂIbe<Ob8I'N˂y)O\"<ؘ/<;z^/D_ީ{\rC`_qI*e }+(\nAeP	?^0zq\"jTF&UB\0Ѷ+K0ArQ}>1pPlNR;\rGd&\$)V9[`ǯNF\r@!UUiCRaFsך\n!\$=`Ň%v2y=c2h|Ǵ*^2FjRߛaDGr6u-}r%} ih++(-uV_+^\"*\rX-`Vj_4{PQzbwWXdpfYҳ8]_+:cJF^r}]8K.i{ܝMY%@#.9bɁ҇_N,LX>5^glX;`S\0\r0ee>iV\r, WW@4plXTZ:\nOקP2a2W-azu28'c-|1:{H܇bi52#X#íp}>^.w~\nŦB#r|v1IC+Yh,S b_+#VE\0YͣX`}L^.U#d#1dXM^etm(ϯAXǹ?+߇5d@7CW&.l@%(aGTET9FAc`etI\\/b,?Y<dQzi~ZY4&nqZk?D0nVS'VvY3}(uBkT#EK2LA@ DP42+,	T[U em>[9B5L#𕐆s*LP5o(QB&67pD\nr^p_޿DT䄎G,J\"\0(#Έ&,X4v(>,>.E\$Nm	0-ͪ(crlR&w010#;i7dNLf[AIZ\"bBlv]P)x]`ŀt!l)I^\nA\rRU5TW3PvppC4aI\$4R&RD`\0xA(& Fmx#.LTmo*Ą?h\"03Mm\"2C؏^1 \"0`9;=ʑq{I<.y	bEȋt/32ԣ4O	'xv.@CQ\$Yy\\pR\n|\rz`\n^t+xgXp \07JFFp\0\r@\0003F`\ro] 7i6\0p\0@\rdmH\0q\0`\0GĎ\0\$\0o#G̍8w.\0̐` r\0q#Y\0\r6\0a#zHT0 \0G)JdP\0GrC\0\0H%C\$摪\09&Kdn9M#VGx)(rOu\$Fi)r6dn6\ni`rNdHӑ\0H@\rH%fJܔ,2T\$]\$J\"rOd\0000\0b\0K\\`28%\nH&Ts2\0k\$Il@\\dl#(E\0005\$쒩%[Ɍ%GL)!H\$I%vH䕠\0001J\0a\$vKi5@\$I&Iܑ64I%\$M, @\09%fHiKdI\$F	j\$n3/%zIy2D\$\09\$H<*Y\0IK)/`\rdb\0jH̝/`\$I{w#J@I%%G<RU\$\0i'G93J\$&FO,\r&G܎I RVI5\$Ii0R\$In(M<DɉS\$:G?\0004_(\$2p4\$L\\i2PIb\0F)+RMJ:9#P:\0004Q&DI\"AI-%ZQ	9rH(^GJғ%='Gt	KP\$\$}\$P<9;Ғ\${HݓčJAJ#%*Lr\$8\$nHI5lF)Qi8E'M\$-RLeHvMlIFvIw#jRԟ22d{&k*>JI5z\\H'(|y;#CvOԕ(2w59)RTY6R.ޕS&K\$32ne9Il&RxIWdI+&LY\\\0	ʱ(N0)P e	1K+&G|\\}{\$2Oh<9%CIƓ(Nt?e\0a+Gx4풵)NW}N\rW(V,9-2=\$J6*8t9Z@\$M.\$#d HI'%TDI\$,\nVL d\0%HD@oK>%Y9RrAk)&:Y9`pI8%BGTk2qZK+LF¥nC*.WYj~.)FGlY2rA6Je-GFR{C,6H<EreA,H99?%K_+N	o\$Ho,\nOFR}%Ix,Wd+r\$\$fU\$#J.]Nr-֕)rR̸G2ʤIӕ.*J)FRIM[&S|R2\$J+Ttr5II&\nZtYMRKԓ#'ITyAeD0pZH̐y@Kdj֖#nW)]r6^@s%BKܣuLvY<Yd`IrK\$GܾR>4&Qd9@;\rȕ#RD-b&\0J\$Nԝ]CJ(VOdGS֗(QDy42q'JX|i]G	H瓧.Wd<r5%|I#ؘt\\SI0W4Y;\$Kk\$zLJ2J\$nLT-&\\ܗ \$ed'jGũks٘1(2QĮ	\$I9\r\$Kģ	lReJ\0PBz:ɋ\$NԱ)FEKCA\$Yҍ\nۙ(nFԨiM򡤎;#aD̜{#NL4#Ҍ\$qJi+F=bJ[&UԧS&\\LK\$f4(\ndqJ,NL	\$Io%W9u뤢3)]썹BR%TI2Qi(>\"̧\$Iiu2J6'OrQƘ+H4Id:[(FԤ=&t9,>^l%\$FvG9R\0I&8'Vd\$eK[W+aT9?r%ai'se\rFS4.GI8\rړ\$HװOK0)S\\I3:e\nKԚ0Ti`RH.Q\\)dIeKD/#fPK%ݒ2S	DLR&):LIz%\rC)Za	DT*:HI|Re\$\r*j]ɢ2q2E)]`k/#Q4=REJV{*WrVLϘW3OyrVJ&>kdوE\nʑs&nm:sI*34\"lGҾ\0i{42O<YUi<Jb%Wé'MEQ4gt+RĞFr@3\"AJW`Ꮪך'ez`rp0[9uC6'V(M^k[/Yĉ&-Xvc9@\nˍj-u\nxW0_81z,b\$JE{kk#T{Ș^pj`)_0N'~J3\0u@2_o&pa(	k1d6ǰA\0:h\0L\n 2aO99,@g([XL64WZr3V&`maky/Ԯ\0u84	]{]DG-=LGވPrX0\nk±HhBxŘRF+AQ8]nlh|W/AWQDw5Ο}_e{U&yfrA]b`?q(;3g],}bu	+A>ݜ~aXN\\j(\r_ZZWur9|(W;Xϸ'k-e\rj9k@TF6dD}I#Gf/\0TȪƙd,O\0SYalu`kK(;h.Wljm\0	n6/ҧ_qH%k_+X \"Fd]p\r)d%`*PD,zt+\0-=kOG6^polk%v]l,Q2kזuWz~	Sѧ*O]Z	{!2dEP~://r9Sޥݞ\$ʹqRרO/b\n?jό_PqN|_A8\\T窯>G.\rix\\@aW-|x`kN\\\0fy3\0ϳ{=*1_Pp+kK>~u\n2쟎@\nT5o,ߟ|	8k%|>5{`dl	*-|\$k&!@,be'Fß?2˗D|7xڟԺb4IWƀ\0OXrci\r.bi:9s(iWRs-ps,<ajbYɳӬ.[ľxish/\$|k1D8r񕧳FA.*('?v]xxtV7PX-8:L#h?Mֽ|t\rYn}Y>&*z\r)k~2ue'<aYDqAp59^hML?\0`+ѡ4ĕl3X(#.S#Ϻ%9z\\h8IW7Ŗ%	%T-gSAc*KhO\\;qiP:s{#4~@2\"v(k?j\nP¿խl4]'@#XC;9j4P+@^uHԬhwP|VZ\0hi=\0>SR.aC#\rMD5KAh/J)ttT;\0:Iu\nSVQ,D̚&h/J[=5}tϡAo,'k(][Cu;>QP}\nk6ܹ\\T#БdS^.Bmk]\n*RAQq9euTN(Pxު-+	5PFt-^\0Yo9fushFJEec0\\~&u)dgZ7#MC}`:J5bhYQFtkgjm<&QZCހSEso\\)@Jޠ@'5Gl5.TѪ~GZ0f\nYoQ@%:9kZP@_AG\n%J#\0WG}8K2PL.>4MփDZj'}Q\rEMjA+wP*Hަ\\\n::F*}?SEh	P=l:)ЌXE5EبP\rE\ru P@e!HoR!OAvmJHN23FoaR!HknQY\\-\rS|Ev`6k=ZȊ,;P\0YkH`	 i@`赙oaZn|L VL~6kI(;-i\0GoI%K[N43& 0c̰ȹj`Hq_@!+#9)L%-OJm24aS9c\$JRԣ'4 #j%,Opf#J-,<T)xnsHye٥J-p.wS,=\$}A?gsZGrZ_3y,B\$}^7{X2e>cJR{G`&~3\0:KA]Kƃ0:-S4WH!mu,iGBb]L}^	URԦhpTǧIS;L4,I#MSFGxl-GQDI5%tҩSX}ڀ!\0ӡ\$'6 4@Gr|=:}4Jjh^:5UM\nU̧[V>5)0\$?\nZb(Sb<rŧQ\"[]:ƆJۊg\n)RN:EiѭYNrۺdӽVSzp%T(_g?^v`~d]-^e;iٔ	ERO;xUbCMX\"o;uTgkSэR&\r9Ū4iM1_\\v}cSƷҊ>kѲ_9:*~&eKM~V]l`ƿ@*\0bO|@ݵX6\r(yL\rhu8r_[=Px->SpL.N}:6W^;D*`\$b/D>Й: \nF¨J,5\n|A2yN-P&qa\0χcTh?.:/X˕fGJ{THeڏ@SϨMNΐC*),Pbz9+OCJ=A]\$*A(W [6\0P[xi`lTO}\$,CQ#Hhru4)ԀP\0\n'j_|_PHE:8Qm(NYy|4ڧ.0S8%us#N=ur6Orf8ݘS[8]V)PTY	QNFTC.Ԧ@*:e@~|ec*-^Q!-`K-\"]LjP#(S}[* DHui-D\$`YyR,bW\0UWrx\nEt֋FpIڨI惘z RrZpi\r\rUL(Nr)ZdSg,-UQ-U%.ҚA7cLdg%p?u	IUP`UY}E%O1@>^1^B}sjϲQ:?2@+4g؈쎠CK,F@D\nѺ8X!ј!ӃA#2%x\"X)ra`\\F\n.rvXxPX3\0ɀ.&|3s@-<]S\$/*-8gJ\0\0\0	+`\r\np\0	  %\"J\"[y!ľ(ϫ܏~(\0ְH\0006ڰd\0qXNaY^+IXqc;]!̸MjkJhJ~UX*bՍV\"%Xb+#\0sXΰ+>HY\"ubgVJ=Y2dĕ+VZd=!VSXge՘{VWXdsX}d\r;%Yj+L\0aYPfZ%VjXk\rhU*JmZ* ZR*+Zbdu+VYLjՙIZkju+[VnIYc*[VXikָZڵl5a_Z\ngֲ1m*۲+oɠ%޳jVwYUnە+uV­XH%nU+Vs[ʵc\n5vW[iup5«hw[=pZRlV%ڶpuj3YYpJuN\\vKi\r5[Kp;̫ [̫ebW2\\d:Uë\$e\\z浐e8-޹cnȫKw]VMmYnʫV\0]\"emJeU]w]]u*s]R}vz֤WC~%u+Wjc]ҹx\n5V^ubk%[V-uzkVp]PߵjU8NfjkךX&yW\"vZ'ץQ]ybU+pu^JwjUWc^{z5\00023^vH{RkWʯ}_6|UkWͯ_N0\r2HBԯg_*\r~9)R]'-W\$~{\"+g;_ԴlevW/\$vv\0@9ɺ	.F90\0ϯA)Z]I_n}\$k:lo&Z'<6Ic`Jj<,*w`݂2^,ְ`ҽK,\$:&F-	,'B%<K6+a26,RaRk\0Eoaȓ;\r,8b'zmk,;j' X+5թSbá\$pW*O;#l?\$bą{*ţR6Xp\$\r{Ū6XH_f͇5lPؕb=G:5RWα_F.lEJHobŌ\$ؕ!bJ݌nX\"\r#Ei:2,bIBb]FKv&EJ>`B7SX#P@,oر\r`<r8\$t؁IcFk)%\0 ,lnX̑%sP@ٲM+-,NIcą+2,@67b&d[#>NIV;cGu#,l#XKbU\$FSXP]bI,x^{dFkOlHaǌk(3HIAbŔ'^+-WX!)=L33b0BwU߱&g~*ţkX۱1er*(,sβ[˭r[/6YlVYyb\"[jI\$Rݕ{v\\X&͌+1YY_:ѠG!]H\0g%> >. jBwRʆ `	KֺRXh&L>ͩ`U/!bUPVQ~Egu8jD+b@%Ӌ\rNR!u(ET{D֑g+ΰVxh =ZpJ*YIfKާ`\\&\n\nT\rWsϹ~#I	aksfzo=	*\0-.^-2B+k+-%i@fLA%?5(IYfU\nBKol٭e8<\07n	Y]iFnU64nBJ=9+1IY̳C*2B>}\0P!ibTm'\\=:YHO}^ T1Bu:c6Qt{5/ʳciz\">(avtj-L#ZH ET<͡OlUZ e臫aO2=SRh;jcuu֋lڣ-?{GVpl݀+{DͽFo--j}Ӧ0Mj)h<GED:}qgr[@e5ZEe26-`,z|KFFӪBVzF^F_\rP	ZZk-1NI5V.+[Z\0e3Z56'뵱>ŭJS״N{azOu.b{>\"Z8ioox<!6M헊CX0@\\Ȣؿ: TПGh|a7Cэ@4ym߱=g*\\-@H6MM*(Һڙl2~9dh6[sgm٣1J}O\r(2hm6_09Rq#:Ѯ-`D\"TYb/G8}휹(oZzG}tPGzb0@.h΢ųF{qMmD<I.`Z=\"7xV\0(Aڪ\" JVϱ'ö[|[bmL-ؙH4D KE,KOWl\0'%%J|c>\0007MpT+ZS*RdHPm{i͊۬fݔvmO\0,\0cYC.iu NpJ2jJ8wp+u*oQH+5Guq.>忰y@p[*Xf @Peijh/n^t0Cq'ZqcKu\0aC@6m.〞mNnyq>byFK.@ډ7x*r4D(P#.)Zʻm*rkr.4W 2=ndgKzW%-lPf	8\nU2	S3.\0\\o@\r/C/sJ*'kdF!D~-A`\\%GNؠˍ΀Kl].xς3>\nءM\n	RR&pPr@8s. 'ܶvn\0	\\\0 \\?jRc*+͵Wfn\0l	2Y)5 @\n4t'Ҁh.Sd=5Tf6IwNB]u7ƃŹ6(8tN	qlU3\0.)^e`ĺ\nݶ%OpZn]SSj:(׮ۓs\"մ; 2hVADvKoU{/\r\$ϞntF[9}#v@\"f&onEvu);S7;݆qV.);vF\rˌ5E`V\08B={)>?laWrH5o:Mp9@ٺWk܈Z`PjP(\$nU-Cթmr;뽷z\nDۿ\0lCw1;N2J3뿧֮7B6+\$GLJnE\$\\\$bOExQpEZf+xd\$þM` )ϛ*@gk;O/YSQre@*c!{Ȁ~M\0SCy%7>y1\n*%=t\$P#7^R7f`5;cVB*Jv.4ۍGUrA4\0005ʐ\"H \n:wBloB2DyNind(");}exit;}if($_GET["script"]=="version"){$p=get_temp_dir()."/adminer.version";@unlink($p);$r=file_open_lock($p);if($r)file_write_unlock($r,serialize(array("signature"=>$_POST["signature"],"version"=>$_POST["version"])));exit;}if(!$_SERVER["REQUEST_URI"])$_SERVER["REQUEST_URI"]=$_SERVER["ORIG_PATH_INFO"];if(!strpos($_SERVER["REQUEST_URI"],'?')&&$_SERVER["QUERY_STRING"]!="")$_SERVER["REQUEST_URI"].="?$_SERVER[QUERY_STRING]";if($_SERVER["HTTP_X_FORWARDED_PREFIX"])$_SERVER["REQUEST_URI"]=$_SERVER["HTTP_X_FORWARDED_PREFIX"].$_SERVER["REQUEST_URI"];define('Adminer\HTTPS',($_SERVER["HTTPS"]&&strcasecmp($_SERVER["HTTPS"],"off"))||ini_bool("session.cookie_secure"));@ini_set("session.use_trans_sid",'0');if(!defined("SID")){session_cache_limiter("");session_name("adminer_sid");session_set_cookie_params(0,preg_replace('~\?.*~','',$_SERVER["REQUEST_URI"]),"",HTTPS,true);session_start();}remove_slashes(array(&$_GET,&$_POST,&$_COOKIE),$Vc);if(function_exists("get_magic_quotes_runtime")&&get_magic_quotes_runtime())set_magic_quotes_runtime(false);@set_time_limit(0);@ini_set("precision",'15');function
langs(){return
array('en'=>'English','ar'=>'العربية','bg'=>'Български','bn'=>'বাংলা','bs'=>'Bosanski','ca'=>'Català','cs'=>'Čeština','da'=>'Dansk','de'=>'Deutsch','el'=>'Ελληνικά','es'=>'Español','et'=>'Eesti','fa'=>'فارسی','fi'=>'Suomi','fr'=>'Français','gl'=>'Galego','he'=>'עברית','hu'=>'Magyar','id'=>'Bahasa Indonesia','it'=>'Italiano','ja'=>'日本語','ka'=>'ქართული','ko'=>'한국어','lt'=>'Lietuvių','lv'=>'Latviešu','ms'=>'Bahasa Melayu','nl'=>'Nederlands','no'=>'Norsk','pl'=>'Polski','pt'=>'Português','pt-br'=>'Português (Brazil)','ro'=>'Limba Română','ru'=>'Русский','sk'=>'Slovenčina','sl'=>'Slovenski','sr'=>'Српски','sv'=>'Svenska','ta'=>'த‌மிழ்','th'=>'ภาษาไทย','tr'=>'Türkçe','uk'=>'Українська','uz'=>'Oʻzbekcha','vi'=>'Tiếng Việt','zh'=>'简体中文','zh-tw'=>'繁體中文',);}function
lang($v,$sf=null){if(is_string($v)){$tg=array_search($v,get_translations("en"));if($tg!==false)$v=$tg;}$Di=(Lang::$Ei[$v]?:$v);if(is_array($Di)){$tg=($sf==1?0:(LANG=='cs'||LANG=='sk'?($sf&&$sf<5?1:2):(LANG=='fr'?(!$sf?0:1):(LANG=='pl'?($sf%10>1&&$sf%10<5&&$sf/10%10!=1?1:2):(LANG=='sl'?($sf%100==1?0:($sf%100==2?1:($sf%100==3||$sf%100==4?2:3))):(LANG=='lt'?($sf%10==1&&$sf%100!=11?0:($sf%10>1&&$sf/10%10!=1?1:2)):(LANG=='lv'?($sf%10==1&&$sf%100!=11?0:($sf?1:2)):(in_array(LANG,array('bs','ru','sr','uk'))?($sf%10==1&&$sf%100!=11?0:($sf%10>1&&$sf%10<5&&$sf/10%10!=1?1:2)):1))))))));$Di=$Di[$tg];}$Di=str_replace("'",'’',$Di);$wa=func_get_args();array_shift($wa);$hd=str_replace("%d","%s",$Di);if($hd!=$Di)$wa[0]=format_number($sf);return
vsprintf($hd,$wa);}function
switch_lang(){echo"<form action='' method='post'>\n<div id='lang'>",lang(19).": ".html_select("lang",langs(),LANG,"this.form.submit();")," <input type='submit' value='".lang(20)."' class='hidden'>\n",input_token(),"</div>\n</form>\n";}if(isset($_POST["lang"])&&verify_token()){cookie("adminer_lang",$_POST["lang"]);$_SESSION["lang"]=$_POST["lang"];redirect(remove_from_uri());}$ba="en";if(idx(langs(),$_COOKIE["adminer_lang"])){cookie("adminer_lang",$_COOKIE["adminer_lang"]);$ba=$_COOKIE["adminer_lang"];}elseif(idx(langs(),$_SESSION["lang"]))$ba=$_SESSION["lang"];else{$ja=array();preg_match_all('~([-a-z]+)(;q=([0-9.]+))?~',str_replace("_","-",strtolower($_SERVER["HTTP_ACCEPT_LANGUAGE"])),$Le,PREG_SET_ORDER);foreach($Le
as$B)$ja[$B[1]]=(isset($B[3])?$B[3]:1);arsort($ja);foreach($ja
as$y=>$Gg){if(idx(langs(),$y)){$ba=$y;break;}$y=preg_replace('~-.*~','',$y);if(!isset($ja[$y])&&idx(langs(),$y)){$ba=$y;break;}}}define('Adminer\LANG',$ba);class
Lang{static$Ei;}Lang::$Ei=$_SESSION["translations"];if($_SESSION["translations_version"]!=LANG.
2336550987){Lang::$Ei=array();$_SESSION["translations_version"]=LANG.
2336550987;}if(!Lang::$Ei){Lang::$Ei=get_translations(LANG);$_SESSION["translations"]=Lang::$Ei;}function
get_translations($ve){switch($ve){case"en":$f="%(n0Q :\r	@a0p(a<MSl\\;bѨ\\zNb)̅#FCyfn7Y	h5\rQ<ΰC\\~\n2NC(r40`(:Bag8i:&㙔yFY\r2 8Zӣ<'Ha2܌Ҟ0\nb豌n:ZΰUQŭwDmfpQqacqw7PX3to	ZB9Nzs;̑҄/:|<4j'J:0rH1/+7(jDӊc栢0K(25B87\$B/h8'@,-BƎQEP#O7Ct\r`j[z0c|9h\$>\0\r\n҄=Û\0x\r\nC@:t\"~8_)9xDjΘ2(-xx!H㌣.-D;W+863@Ɍ^F+u\0ᠡ*,1,i8cxؒI¤fۣlZ*/cs.00~0YWB07U\":3xuc@#пC`2'3XIl*83ʮ߷ 553#\r9{5Uwxj0B͡.'(ǧh\$FJŋļC.!n(hڂ߉@N*㢺칈05=RtP5&ĻɓEĄ:ew%8beUz+q3dɓ*\r|7([Ӱzʲcw<]0|]G]MvXl̳?wG핷W:*1ngQW 2<1_OlT@PT%PwQG\"p/'!RD[	9Ufi*<&xޫx{ApEh*P*\rBukI)G2zSj/i\rYuLOjPJF\nzS	m!&hbd]IF\",C3DwIBܜlcgAlW\r!+Oz=G\0\n@QXj\n[16\":9\\5reH_qIy9s	Kn4lL|L@FLQH7J12h匳uDX!0O)8kxDI\rF'F8d&e3[#-k^Y+e܋r	9ɠ*ٷ`+QD4ʾwbKL	L*4\0*Vv10K1?R4s	50G]#4o\$DTHSfDe20fFhH)vbz7F\$p \n@\"@Up\"]J\\0PbJ1H&26J <Q樞LT2ЋSd_Nl/Ś !L2r_j#KB%I((+\"	r*3g6yӐ3:p#sP\\#Oѻ01Ri4\\0[`k4W\$DY2MUq#Keh.ivrꉁX+|<c4bZ5\neh9&k#>/``Z)elL1n,EP]d\$LƦUoң:u_ݟNIlSli8ªAa QB7~,5`N8;9y^.i0ak#AB{V,Zy[̋@Ny/><4BmL5vsRhגGVlјSG_ vu˹0 uԏ%)9%2aݞ,x	G(+PŲ,שFʆYˑ;%+#	f8>YQGگL%1dם0r%,&(F`fZdaAo=vM~mlY4!S⌷[aA8e,Զqa^j[dJ605l^d^,BDKH){6quB(q#GCcpN	md\\JԵ\"Wq~ŸoI7!MzݴFIݒR[}rUߎYWhǓM't7;^-*V4:<ޓ_߹	Ó@Pb&mZhz.FHK&y.o|e~\r\n(\$m6mĢ9?,S߶ENfi'`Ճ?Zz~)`n\0l&`\"`b:| n6:B#Y*<㐂\"'v4./20b60gNB;4#%D~Bwf\00B\"\rrHn_LW0GP޶	(/^\\p/bТ3i,e\0,VUc.fduvF0i|Q9os9;BL]\07\r})1P <F&H|7R%Ц \r)K\n#b>mU\nk2όﱖ\"q|[!-YmO&SM\\I>C@j>\r,ZD:vH\r vAZq`\nprc\\.\r&Dќlߑֶ\" ]fֿi..	:\n6.Q\"&quS͆K\"8Hc\n%=%x\"l`rrn.4r\\2+g#bKLRl&ëQpHI<\0@dH+#-B-&=5Њi7'\"?|	0,B@-ι&\n\"-LBĂ[\0#on/So7 Rx(";break;case"ar":$f="%)l*C(Xl\"qd+aN.6d^\"(<elV&,lS\nA#RNd|X\nFC1l7`ӄ\$F`!2\rl'E<>!!%9J*\rrSUTe#}J*d*V́il(nTIdu'c(oFe3Nbp2NSӳ:LZ&\\b\\uZuJ+ωBHdNl#d2ޯR\n)&<:\\%7%aSpl|0~(7\rm87(9\r@\"7N9 4x6x;#\"~2ѰW,\nNlERv9j\nV:Οh\\pO*Xs')ir*&V3J;l1B+l>j\\z1,t*4܅NA/ډH%-=lLHBPG)\n\$R2Et,]4R25 k(3\r1C351A(4.00@9`@Y@2D49Ax^;܁pVT3(ã?x\rKJH\r#x|1mNR*))U8I\"TL\"8I[R3Qӌ>,j\$WB9\r\n0!VPH9CMyRSDBY({*QT:0E\$D)*0)0kZJJI16HRY.\nGKk\$#kch5 05+\$&-k[96]MTlZT=&gNĈX[1r/tّQ!oݏ#ۦRJBǕ{!LP!N}sYth9ki\\C`ā0|f\r!X =h(i_	@4(x7a_0\$x΃RPA:g343`ث)TJm\"ĘE`\n\n/A\0u]\0l\r5H!08&0RaI1cSrHΌ}-CD\rQ%_@pn@H1`4+]l\n\\@`\\jBPp:0`^9aF&#\nHx|2ȋ:S0*U>Hj7qx5Cp\r+]-5#[ˁq.@D]Av.t%\$kj>ΕM!}\rS.ʑFR.d#\r*,p=NrC4C5yD%XPgH s2u	ѩ\nF⼈bDBhOA'`jC@p\0ZI#N A9;5Vra7Ue?a|N&hБٳY\$\r\r1w74Fη˿0Oa@!07\",GE*(qhĭIj %\$ʚ8Rb:F:޼`L6>g,AK-MZ3yI2K(I&}XzAt7k\0fA?͕a`P cHB4:lmhFT\"řj`.\"5>sZA3\"\$({Rd917\\YpD4W. (gn@).uX s2@kV`F\nA39Ƚ7#HqG%VrJXj_yLQpp \n@\"ra&\\ΞKe\$aK6{)¾\\NI\0T̶yjX\$~Ih.T LQ>ԼK[ʹ,#lTDi` r,=ؾzdu-3]O{0lcBցF/+-|c~\0D]Li'g{nD'>v	uomzƥ\n^q,m裊8S\r!SUCHx*if@ԺrkC(we2bifGkf?igL1st(Х\$界A0ABTz7׬B(Icq(КK?˯5;WdŦyNY*hR]l+DIJOǆK6&yI]͗x Q\rûD\"X)H~0Z^),ȇ1ceʻ2~H֜hׯ8j=\$휼./_v1Hֶ̄toC\0RRT(n8OV-,C(-OO#g%IdO\"R0lMV\$\"`0k%dh)AV\"'c\$>wJ&Gt3\"\$!\\xM6DTB6fT!vNSRq``-	!c	p(dO	nm\"]wĕgSĲFb湥48-lKA\n'~\"dOltwzM\r:JE\rdbpMD\0lFFޮ޶0LpHj-pv\rPG!Q.%Bud	o\r`hت\rFDc;1yy1\nq\rG|17Dq*\rk)F1y\reeg\0hHyaQ}ER1<1vH#P~PDՂ/P+/e0p*gMe(I\$d12RbK?H&.l@:I#AL2Pz[\$2o&%Rr\0#\r^rc(Tm쪘b#ѼvpMR\r.!c[Sr	pF\"0R[1Pwr<sKCc,q,`8øcSO3#\rS\r0FZ13_1s+56s0,qb{#%/gc%Ŀ.-8P51@\"h&3c8K\r8;	i;S#9S);-=s\nHhC;2Msw-Ӣm?\"->n4\$ ]cJ&nAf4k4\rB@BAVD`k%`95QSa<E6E):tds2vNpDb14U;bEE_I?PN(BhSfSA&v>b-8mhlC*Oi-	3ϸMEoVg0J&hMΕLOFeon;h\rV@BjYkxȐY@|~KвH&\nZ60=O/\"/]tg!֌Pd; R2&~Ƣv17-SzGr\0E=\"2MZ,mV\r\$\rZ8/5V=\"-,/|n:LJGqP\r00P0IҼ(>SW`hf4CIC\r\\{5u.F)NZm'y9,\$bCGrce҇Hy-M]Ve\nt\rB\$q,1B\$gtI/^_14Q#rtж\$6Hu5cvNJ3*Jn&Dt?f\0	\0t	@\n`";break;case"bg":$f="%)h-Z(6Q\rA| P\rAtX4P)	EVLh.du\r4eܞ/-O!AH#8:ʥ4lcZ2͠.(\nY(\$\$1`(`1ƃQp9(g+8]*OqJ_\rGiTh~McN\\4P򂞴[1UkINq呺6}rZ״)\"Qr#Y]7O㬸2]f,D5(7'1|F'7QLs*ns0,{ ī(H4ʴ\0\np7\r7I00c(@2\r(D:Q;\">P!\$p9r낏02Pb&٩;BҫC2izꤨRF-\"؅-KAOłJ<\$i؃,ߚJ)(fl ĚhQ̴-r:Hz-;RƵ*4l\nԍK\$6h=?TavW)\n7(OƁ\"OLf\$hii̝;P;l# 4,gw\01qpTgEфd;#7H#\"Ɂ4C(C@:t,6@p_cJ|63ElX4px!\\&Nze7iCT.)>6N8:bztjJh4Sbʰ((B9\rׂ\nO4N%*M)뎕THhpңH1 )<SHd6t,m?\"h&I%.gх\"⊿	qYKo<\"Ups봷4IrA,4K-htz֋ s;j)Ϋ;z%v|kչ(İh925=mdƢZwBgTuZk@T\nsV`Ԅw\$b\n9BA'4T<A;'	<(~ BVP6z!8\n+`6P掘3*a!:Ԉxr!図gC>l3C,mɔ.ʊHsEEPtCŰ!]3*O#\r98RPcy%ɭBޡpaE;;@taHq(sRLD#ihʤSe}1}Ju*p\\U}]ʕ	g-K<TlɘJc{2ynI,J5ʘ'-܉Xr]\"|L h(y\0\"uo\r!q0`@SaA1F,t91BѤё }LYn\$9QXI432>.B)HIIRdZ=>2\"A\\( al5&Xq2E#ntՕ &iQJ>=;'L*=LIU\\TA̰KT8#-]Nw!-DX\"Q@hFKP@`lKChen3Iê]:۠<~_/e  l&fCd 2A'(\$+Vi[)hdJP	B3ХSlzg[\"9: L	#o Qo_#S=d\rTT@\rOYr7_ ?\$\$ɭh\r!4Eí2!0ˉ6)Ti%[WkhEY}T*dMTJ!tQYlHq9;\0j.ohG{8bkhI%cH+eyǥ\r(TL0NuΑJz'J,)S)iPNE9Մ'WFi+崲)CaqB֕-CVKER1t(eFÝ(o^3YW\$M\njڛgVyI)nJi*V\0/3>[h,X q	m2}E;Rno/`QlL ŕ+sk88BP_2.u?ˁ)B!<FO7|G	7t&B[=iAJ:ʩBשFYA#q ﭛŊcZ;JuVfי\r_F>\$Xe6tU]>]?^dĠų	Vb@A~㨿\"\n40&bҍ+`(&3lFnu;'ulG砥Ay3!\ne<Gh'zhו`gt.{ϴׯ\"ݭP/u/-0K L)~(2P(8).Hkd` a\$XFLTx)P<(s-ţ4\"%ngDJuǲ)֣F8<0π挄hWE+\"W\n 	\0@ DFa,BGK]\0\$S\"|kK<<(n^\nÊoFR['\\o2'r}i^oq-R!)\0 \$1%kU6q>HM:>)D.cY'pnQ\"3('QSQ,Б21N@\rQLi^|br;{}G%.Wq։0%ܔT.um+<\"ҾjqG ,x,\$|,/\$~\$0]	Ҋ^-*	lhr4\"\"&Ĩ Jg#6T0\"gƆuO?F\"Jʄ\nۊT+\$R(x(L'j((d+ϲ/m,	\0R\0\$⫒܉.2rc'\0.&kȘ<hM@V(FsBiЈmP2,[`DL\\uIR.(30Ns0cHDs10|>Aq~z)_\"\"7'n\0X%.vSJ	ҊVz\0*:g)>x39^S3N;;p;-3xK<F:RpnU\n2>M=S;)H)X;-f\n4iAC-HXCjBTE2TIIq:rH2N;?#@@GCP:\rBHMԍAAR.NlZT(#DAv<|4KN:Y.(5yBHIMzޑY3fLJѧΛ(PfI/==4),vu49p?nP44O\0J7JR*~jS,Iu^B4/Vs;:B55>7YܰmWDKz;'f41 7uQ\$I\\Kr77>J/^..&4GHE[I2BC`masUrZ`_\nԳ/uvƔ\\&vm?2`C\\tib4	dj?U~cc4o	\"	l<0upQc5|AVvVchW|1:v;=ԽBVv?YbnRh{kki0hXrY6jLm	ӁQutoalY̷UV9[y0@VDMGfa4&PQ@֣`&BFs0rUsDn:-72WJ:`)6\\Pcoqbv-BCIB,Wy\ri+?}wmVRk4L7z~7 ~ Ş>]}WҗYSxRj}2`47Z'w|\\woK\\K.S+TkeIi\ns)1YJNO\nJ)-BqebW.n2,7p'2vr맔'3X,4}	(XA+eET,bK>dl6Dޗd,&MhbN\0@\nZ,uga~\"Yx}DlB: \ry.ҜJ\n\"g؈g]_oVRO'sb6@2`)o	5dY\":=\$<>.E^=\$Rf%d}ŋnxբ,V	/M71.m\r2qRzs+h>99ɚuix6Yőۛ2)ms2Şi3QMEVV6g=1\0e\\=e`SOVTQ)*8P6+4V|C'*QZc6䁠qZoj\rFµ/Jů&rs+4C< 5;ڙC'6J,7mmKn]Xu%`Il;WQl";break;case"bn":$f="%)Ut<d sNb\nda\n 6#k:jKMŐD)RA%4}O&S+&e<Jаy#Fj4IjhjV\0B`ULcqؽ2`S4C- dOTSTLZ(JyBHW΢Jhj_\rmyioCZNr,N%Dn৮еU8O2nŭr`(:NS7]|􆇵82ɼ 4NQ 8'cIg2Oy2#:\rK:#:E3nm ;KB+M	Ь#G.S9h6ԫmTd\nQD\rIlj'@Ep{LDЦ\r#pΝ2*b+\nDNtɨÄ+H*[;\09Cx0o`7/h: AR9C7KOêx߫N%4譖}4k[Ư#mq8	CP{]G:\rQ-R(1T47AMc4	ҚDa*;6Bj(c֍etZ-QElLt}CEX'J]6\nY4]f'1OQa\nB*9z,ilKL6JvP;B6˳AEѯu 9T@0c9ˣ>LRK#4C(C@:t9sAC8^2},9^,A=A\r7^0SeCIxɵ|EY@ BYQM^\$Lp^2be쳕 EcxRCݥm4C.4ˌ'4B9\rJ\nMr>Ǵ-.ϊWk*/zN9]c_u/asIN*k/PDlA: lq/p-S*:r|E\0:*HNL'e喺d؄.\"mUK!C\\@>S2CCB|/&e,FAa\r()QG+Ck6!ABC2eb\\	%;g?]\$XDt.\\Q1\$Y0ˉcʔxPFy*\"A@q'xF'BC<FT.1	iU:5 לa44Ða.9 ɠCq4yf>,.εU	?:U<  `srK-l0rG30f\r2r\"AyoAP7 :V( \r3r!3;^8\r\n\\<+(مF谦3tf\"A,2c8*~8rM!/mN\\t4Ft׏Calm[{q\r97f\\- }^\\R^53Ad̿bf8v\$-[LIQu*Afjᡃrj@Uiִp\r-MֿZ#fm\r6nO๺v?'\0\$}kx|\\O q!©TGUbPYH`M;,prqB'\"Ɖ^` j!*#Y/d0kFi3|RP!\r9A(h<MTU7:.@\$,H<-^%_d=ؖ;VGr'nAۢ|O>0'agD\$zX񃽭 fԳF̩8P)Woet\nEҜ_l{\"Hi)\0C\naH#]IiL\\-H>Fbfp8\\6)˕#BɎPHJ1z\"VZLRZY퀶%Z(ΫHy<~.?M82\rzܳڟC+Q8+3)c:%%JŐ@xS\no~FN8\$qѩ@MV,G5>++řw/.?#smŔ[qiar7FJѫ`\r75-Ѻ\"=j}gAQ%aQ3K>5]yFĬF b*0\\dO#Ɛ4JYtvRg`˃Ruf)<JGq+Gn˾Lea,\r'´=c2yg\$v|q!LIds>°+ȭR\n*{G/4Ӝگ۾s`L黎ظ]bNJ6vÄOM}b[\\Ub\\\"+ZN(*^8\0`Ofc\rɃL !	<̔BLxdHK\n`>̈ɄʤLROܑ;4blO(p\\{#'GXuBZ%6C.|{H2VIwxNT \",L:84OoJ~l` l0\rpT얍ヿD*P<uOŘ~-4p1JP}+iJv>bTfhbPV#/[Ne`	xfj\n 	\0@ܰQ\"@E6'MDx)|B{ ^Ee4{\$5cqCvkNCÚtT\n^)@TŅoXaH(SqWn9_!R,1EvJ!W1\"ŘFʳ!QJ>D<*0\$hFCQ_<Ejo%RJrm'Y')e1c(\$I,Ғbs2n\"䮗f	9Ƿ+,3D#.WcB*J4\"\r]'%Ī2+rt\$(WRW/328h-pYP>/\$,bC.zxDԂ/iE4*0bGPGVp1Bd8Su/)\".9(#.^'TS(}u54#\$X-A3V16x|D_0K^Ӭ皐=0Ea\n\\,r5'P\$exNt\$A\ncUh>>S-GCO#A3A5B\rT\$sHb^'T30Ie;R%	5_\0D56R^V:ԍGQ:4T`0fnӒW:4-A@=J'Bt( ~4E&\"L4<)3N/q(ưHxTPD4Dt%tJ=\"C@5T5Qt;\$v0?RSR5INvRO]Oo(Diis#\"=@rQi6.+:}PRI\"tVSESe#4v\0QK(4@2L)\"\\./Y4<40IէGZϾY/OTc	 TB%\\}Bu7-5O5W^`BbYXR//ţUH~Lz+5	Z!cNNB6F/|N沯c̀\\,u6HDsKLpZ6Ŵd./iVAqIK6Set5`31fr88p֏0B](9XϽ\n!Lu/VkS%nK{YvQ%P_.6b)wV2FuI;V@+(ط-%4vqUarQs8r7Msue7?E2UWc9eueuA<VY\"rhA]k61+w[lX6KZBV\rzsp3|u\rAnS)u|5}wAYWs(dmӦo[m\$qxA`5m8-XhW!wx\\G!/';eB'\rDv\$sp1puQVc'}dYwաu퓆Ulmtda}Vq5UKqtsxP}؛ ؞^Qt(5L73}釕A(Ez}8n/C\0=ϠowF?K퐈lY\ry\r(gL;ԃ;ņO \$aw^{w	YW0?R}UH]\r:|H'~U݀c_ɕ8fUSׂъugv{CYNXۜe9v'Hq\"t|5GU^982{у%\"]qc]R3d6I*yI2ZJ{T]07YU>h.*EDrY:Ew3>Ӳ r@jb\rV ӏjDBjDt\nZ	zK#Ze]º㸕V'pS usږӢ;SD:h(V`E@:2N]yK|MJCg}oF\\s.J@:Wt^!2]Gߴx<Cdpl@[m\$0M<-\\ٰ'\"pE.VtyV84:XE㍮yi@鰶Exˉ8߻QR=D,3עUY{C{8zUpUOT\n?C=y\ngr[	@LTg[4TM|Yg+\rhDI{RJ]OktԏR310Փ{C4SS䜆 \nƈ\r3{HQf;:42+@}\0/Bt&;OORbo19\\ȅ۾r|юG\r@\\x`t\\:6y	\0t	@\n`";break;case"bs":$f="%(l0FQt7aNg).&0M磱7JdKia20%9IH)7C@iCf4* A\"PCIrGn7+,lbdѶ.e)zCy\n,΢AJ -e3Nw|d\r]ŧ3cXݣw1@ay2Go7X搳\$eiMpVtbM Uk{Cn59.jc(4:\nX:4N@;c\"@&H\ro4n\r#8@@H;*\0ߨ\rò腱P.\"k\$b#{:Gshl5ϪҠϠ6J9>0Fî,&%iJ3*5'-I)#U.AЀ1mPS<P(@;C5IB#'\n\0xC@:tt4:p˘x	BJ\0|6hbp3.cj4px!=/;=ʃC ɋ8?C;N2^w|6'2LQ9\nL ,MNC!>ãdvCH4r4# kkҿG(0d c	pP:\rpb^p58ɤ&!\"V:5;#'֜M5T5HChӱfӠJHJnz]_^:=3w\"9|kwjĆF)A1<zsખO*X#\n/<]GkCMg\0@6PWg2WKhm۩93,gEmZqm1%|g#(\rԽ9dfC2fQ\r3BH{SP7լ~J)`K\0o9CM|o(TA@s\$*zI%PfXC:~\rZQDiLo4V\nZ+epW%`%L1>ef貵\$Yu\nj)#	5RQcn.rXdgʩVDbժW*^\0bnX?i\$^InƝGRDA㧕r :!rC,ĝ.4JKEF\rCARql*\0J?\"`̂=*/;4w^K*O	'r*2&`H\nԒPPI0䨦Hn)!3Xh4)jj;\"BLL;05lcS\r\r*UNsue2fldjB/aL)g\0\0;SGC*kf`u\$\r)k9FkRX6f*S% 4r&lޝ48I a؊Tqfՙ MR\r~dz9ͳhMM[2D`TNC\$)'XRvb\$1NS\\\0n{%\n4?0oWiP@ {Ғ'ۂMDث/Cg7)Ph	 =aLbiA	8PT2hQ s\$1B\n@U\"~=Jl\r	z4ҒpvB%)Ҽمv!V!2u%s#]8 GeŎLdmtѹ3.slͼ#υ+;xU4v^ɩ'9\0ql\rW4.{aq/d#j>P`IfP\"~AWD3;\$0P\0RpWL1AB~^eQ\n7xvȿyAwΒF7MлtLiC(wƫɤ'tHn;/:~ˎn\0i_cBo1/k7kLXs\0q6={whpS#'\$pR6m!()2~Wѻj?HLMGy@BHq `Z\r.dI\$(QQAy1@^\0SL`N '1R5 \\05	US̴]N3m\\B<Bhz\$sợnll&u.!WdLs?:upG^uӁe1Dܯ~a{O	U=cjK'EO!\0)\$4Lk|Б́<(3\n/}9Px:N\nٸorQZfqK?'\\ˠ\r:G\$Cæ	H}cͦH=e|Lo^+.\nbTxlX2F0o\r؆#\0@f<\r\r~i|hG&+\0-PD0`.0b!fLC\nPT=mCʣ\n`FdMHPPpNx@uJ`\nD\0ɐp'4tMho\nE\rA`ʶ%n\"ƢY^*.ޜPg,q'\"1B& 颡gY.cC(2mC&%-cΑZP3oB.b:%c>!O6i8BdQ\r'1SJَ:Roq麞l	'\$\"^܍\na`^O؄Mur\r0r\n_qj)m i8!22vur0r\"b@M%RJkE\"XFkrcOE#Q\$dc<h	!.2E)2\$5%E\"*CE+	)U%rm+_2b *-F#p\$sw.C#%.,v2^0&C`Kҡr+d'\0=\$dM3#!Z#Jm3V0>.I3@4<MRfݓ\\-7qq/c/t1Vӌ&9sPx0\$d76-5zK)d;<9\0	/)LTuj=`)`),VĹ iZ'T*@t?l]4&1F7(`@BQ9F¤h`QTJh<U(\ngM\nZ\rȆ0\$ jT@p1Pԣj>x43kPxFxLgsE0&=p>z/c6 dH3j;~\0)`=,N`OeL)ed f\";C(R Lnk7RD?OIS̭TԎ\r>\r>M:: iK]l7@YR'\"pL#DC\r	Jvuhx@\$\0g&\"hRpr(n-z2L|C34\0,̺rU01b]bL.\$\$'9ؠ(rPH\"";break;case"ca":$f="%(m8g3IeLa9t<NBQ0 6Lsk\r@x4d	s#q2T\0Bc@n7Ʀ3xCf4(TPfS9?Qi3M`(Q4D9pEΦ\r\$0ֳX~`6#+yedya;D*i+p4(8\$\"M<kXXēYNT^y=E\n)joM|*u4r9]֡횠: 9@9Ȓ\nl`6=:*z2\n&4욊9*Zz\rI<H4H*̈;I!/HȈ+2\"*\r#&!<&:Oh\"D׌06r0.Pʯ<\".(r\"\n\$H4bfQM&P2%434C|	7<0c7>44Y8ʌD49Ax^;r%LAr3_!uJ0|6Ȃ3.ɓxBR j:`Nʣ:-̍ǣ5ꓵ7\nLc0]I+\rP @1*x9ڽRĴx/8+\"0З=22ш}\"2+A((3%Ei\$6-cގ\r`ߝ	0ܝ9aV474#KK]Pl,H 0l#*\nbZ%81Oj\"WxWӀзHϲo=+?Y`x2sr06dh!.C7vK7G,J2Q	ʹ߃I\"/<ܷ:Ia7#k+[(ir/|'Q\$LCi\$	qPؕ@Q4`81&Ҹo*\$7*-zdU3+S(h2\n`sIO\"*CPBgx)u;!茫XKc,zY=h^KFwd\$嬅3NTiGetT\n#\0ISOU#+Q *Y]ȲVX%e\"G;P5]*}E`ƃ!o \"ȱ\$Hdq^DT%\$t #P U1hI6cA3HH\\#l\\n8&pʶ_&bC1`х0'JP	A%AF%\roQ2Xpldw	<D[oF]Nӵ Ĺ/3]h)SC	\\rZA*GsA(/\nngkZ`FT@#'FAב4R	IH@_Œ^LS!3f	; <ZƐmfꎙWHUM:ONu(lݭ	L*E}\$AIW@\$ZW^a?^\".UZ\rqE/~5^UH>ٱ%TÌq@RLh#5PԒ4䅢BARd\nXm	8PT\"@-MsµL\\#(9ZeI)PŰîvNriI<&dy/TPR+T1]-bQfSCS5DSHŜPHHE`rW%qآP*QDcHT:riHGކY\"LA2t3F*,Jy]s̐@	C~I1\"a}UAѝ[8LZdI\ng0A5SHriR#mj)RO\n\nHj1PjH<22\r\n!@yOg}I1~i&~dY\0/E<BXw\\]4TZ\"W \\JAnkKMȉY.؋xb9R;%I>-&e9r^I會~s9^RèloUb!ur:q	ƴӈ\"IIuF<|@Klr2갲g%I#\"2Mޑ.ثW~\$JYճ~\\Ju\\+#BIʁ-(:Bcb+hHyE9hq}/f#1!ߊ{.l,>9_9^?%|Vqʶ'~nz/ԋrX|ضKM}@?#(fr@#l(\r\0.\n@@6Z(K)`'C.lEP#фp/j̊vK<#R,nvl`0v0~0onЌ\nƏum%\ngt3nZՐ:&JJДfM΀݂44W	p?a\n7bP06boP̀4ȒRPp,H/p1BJ6h*dN\0N.sE2%\r0Ced1d`^/kҎtF^}Pcb0c*\rQdfqsp䆫l(k20v&\npfiްJީ\rEpe\nmq ލ&\$t00NNF#&Lʕ_1\roЯ\$N8Gs@LTẽ%'-&\"ģeD{\nP-`;a%(`)y)\$R[)r)ҠRX'c)*2}*P<'q^Br&M[.W,.&Xؠ4ℚq@T.s0JS1c	0`#M\02m-	\$?Q+s@.o4-rO5Fd&Rt,侬sKN\05L8\"\$?ɜэ\$\"RNki	C_dj(X04\"/;;?%L!bPT4b\"/;8p<ʾN_<LcpdI\0Jk PETƂ\$`@grzk`\nZUp|SE?QDEyn\$N!BpǅګxB6jP('~=c\r1M)@# °/H(d[V@\"CeV(e%<DjRGnІuHt0 fagN/BINO3ƂOyP1?DD(C53>=Rӕ 1lU\nNF'+ZO\rTJnXnB8npVnCACl -ƈndS:2t,/d9IC\"2\"3 ִ\"lRGoZNOgP껠.Q+HH\$.[h*	\0@	t\n`";break;case"cs":$f="%(e8̆*dl7qraNCyo9D	m\r5hv7e6MflTLJs!Ht	PeONY0cAn8d:VH+TتX\nbc7eHa1M̈dNA^/J{HLlPDܮZe2bclu:Do\rbʻP.7Dn[6j1F7761T7r{āE3iǓ^0b穦p@c4{2\"&\0cr!*\r(\$B%k:CP艨z=	1c((R99*^F!Ac~()LH=c(!\r)<iaRB874BB`5k<<񌣒n99ZBDFo\0B4B9*MCI l4HhL\rx[f!\02ÐLb~0z\r8a^\\04Bx9r9\0J8|;%A\"1^00n=EC{P#57CkH77L^w޶l:[\\d+0}P(S0bc*:.o :(\n\0%	F P\"\"L>9Ŋz^d\rzW@:\\HWQCX&#H4!#A*CFMBbNȈ@WZt.z' LB&%̹[@V23:-{4;#Ӝ(^?6<\rЕ/-C;O0@6X<w/wJvbWr=\n8@6WZC x@o\\	9pH:пDBƆпڧ#`6~xvPQĵ '\"1?\"D\"OE=)ZNNh˘ )?(L'~CVRA`Id &SaL+!ja4\"F'́!B 	'.%C\0{цdF)XtM1\"}\"!s(,0ߐ(nZi:\\²V\\+xXabp^yP\0|Hs=6g5%	6LF«%B}!tGd +PmA:4Rz%%UKtY%UH5jʻW_&*\\7Kܴɝ\"+z=!E\0It!E2e-x<Г{&RHvTխbn	]JHv1LX\"XRQ>KqTH{\0\n\04u\raRSH\n\0\0h((3hH5C=UgԨ74\$i/Ci\\ç\r\n1PʃcBA'DCBJNdM(~L5ĿfS\nA0N2~d9=Z&aE!8c8Jz&V:&wmO,?b1Гs\r\"_tF1\0\"%*O%92)aK|4'ͦÇ\0et3xS\n&t_LHH[1C|KMK8^\rz?\0N	<Sl`؊r3Dho #Jo;8n0Y\$a\"a=Vp]TF:W4=CˑkP > :xN˄#m-ĘzufeHa#x0H:ɰT\$Ő|QxUT]=F943Ӫ4L1(n9(/rx_pt\nj/JQiGFFpQo	}1T'u1nJ&=\$Gaa8'DŅ;#Ia1a?S\\=_42\"a\$D5\r+\"_D2/662fl<g:Eቈ-DPC/AnE%xFW(Wq1LKߺt;xl`tӜ8]4\nw\nq16P/O(= @\rfiBSr4t|QHvɒ3hǬC	:ڤk'@_c\01[2r? kd1Þi}9'5YQvZq><<GayXX3xGu\0HW\",c@PSr\"7i,\$Lc9=/}G(>y_?=~_Rm[\$7\"ѡbb`ޯ%\$R\rDB&PL^BP~#u~MfP\$N~\$r%ʣ=]%sJ&},N)R6\$j8j2#,7a#~~lɫ@sc~|c^\"*Abr&yЌ&p&k@haP@%o\\40ètC4f0dĤxg~Dhl Kz(\nEH'*&MdN&hb044e%>B`fq2\rжv@M<\0gPg`PynixDKy1毑u0P,b=\rX+\rQO*|jQ0<	Q\r`2h,f ѿ2Ȍq%R,l#/1!̤4=.H#Qxg,\rc|>Bdl%P|B`g`DKU*ornZdTdǤ% T%bHZjC̮BjG*Sw\$/%A2<0 #*&Jd8j5/GvYR\\\r1\\e\ns0\"\"	1 7Z*#j94y13-ed~d<Ƅ<K\r0s/8r\rΝ91.n i㓮`X#{;&9x:\02z[(eH\rbnC|+Im>fZя5>s?9ЬEDT<YA3CR5?2:e0@> 5U6RӍDNc:RI?NNgtSsFA:N\\&.fJ`Q032LyG/ԅGe)\$tc%FwI<]IxEG.5D2''G	KnK2MIT1PH\r5_ Ӣ^g2'K2=z7- 3AHOb#PGOBD	b Gol@g#O#OhT:o\"@P)Tbr4O_\"2\"5uZv5Q\"]c'Fŉ\n&20'eX^Ҫ{'A\0D)* g6i@ۆ\nZyrTcU Pwےoi]ui]tەs Og\"R! i'&	F\n/FI\"	uKhK&B,9aZ/6!Z㰨dm(PM`b!\$5bq(fo\0W`gf-2\$PpV*xK}vXa̛6h79Qi{k>c'0^hՊjV&\\9##AP#PBwdso.#+d &*'z\r1pPrv`lgCGr\"YlcvVBi-<:\"rW*3rs`A\n1^p ";break;case"da":$f="%(u7I:\r	f4is4N2l\"ц9Ü,r	Nd(2e7Lo7C\0(`1ƃQp9gC9GCyo9Lq\n\$	)36Me#)76遹NXZQ6DL7+dtD 0\\AΗk6G2ٶCy@f0as܁[1Z7bm8rGS8(n5z߯47cNo2-\"p܈ә2#nӸ\0ص%0h&i'#z(!BrFOKB7L2B.C+02b5,h.ۀ:#<0-܃\r5c	2\n	\$\r&6@>O#1)4\\H4\rD0O9`@PBd3t4\"B-8^xDjЅ\$x|(X+(\$V:cd3JH;Vmx<M\n&(J227=uXމ P אL7\0 Q\"1W\"0:uzSWPY#Ml7ځu;-ͦraCcPBbC?^Z64>h\$2c\$b\"k,5ڤ*'v24+V懲@PF&0ʏbk;`+	#k9%Ql>x!E;]I@A4eXp\\#q]#|u03c/6B<*ǨԭW\\ݏ2	PܐVlD8lB,-L760\n|I/!Ns͆9Q_0\n]2R-/ʔ:#bɣbSLxCI'\n0(TtR]L:U\0rTJ5jP>r:r6;L<x.@܁)Kd0đ:Q\\K.Qj5G(q3\\U wBV6%tѤB+#@h9/k!+3'!:uI88[\"1!a͞\nVgɛ4w?DYЃo{*PS\$(9a\r%\"\"JȳBȖ0g\0P	@dJ@('@R3E2-1К	*\$:R	X0_HU\"I\"9>J9\rA(UN@w\r1Z5R):a4A) K!(0OSPD5pDI3ᘙXoI-6fa8A\$荄^)~]	Iqb(\$3rI\0ģ.|sԶ`ɫ8|+Мzj\rk֓/I24X˄l7̛\"DR\\BZBN9J@PD12CIƱf%XT2MO	*\0BEl\"Pn\nP^𠸥3}I<&Wv\$[Ș3Jl[20j&>NՀ4^P):d,5}{5l͠WoN\0]:&e.cNP:u+EBL)1LB438u<YPmDR~a{:3LAB:7VCY\$iHзְ:N}[]co5дV8l,Gk/\"FYMb\"df%lmD3aLh*JQlB:\"p\0R]Ɂ1p_\r4,X+@A K<z^p/C	\0[]LN\0001`VG8G\"-j5wLRj4[|<%cykD9B^֖dmͽHآrnjJQ_mC]AmBX. mpɻ6	 ɚsDuù'|2*Ů6BfUC	=\$բCI6nE%8?JSz>A~ih!ؗj_@+!-q!#aDRpÃ^(o[8K;Z#R~kO/_i{cqdD()bK-\n+{@qqh>`<AϿ5	q̷9KcbumzĿGN39W,]\nG`2{I{n=xv_]gս2ϿiC\n7ŽN\0'PoQ0iޯnT9d/Q&=\0o	lf8͆bli\0d\n ::\n4%QH>FL4Kft`؈0@\r8 7(d>C=(yP\$B#pJfl,-ΐ>VžX.oo[fZEԏNkϣ omKJ\rK\rm1	-E,b0I%:+=aBpq8kcL{c4ìBtT14QbNYF\rd\nwqE(qONYwQ^ϸHOjot#qHBJh=\$.ױ#.naqTנ pЍ8\nY/2#\"CU#dC\"K\$LE\\Ir/դYo%ch\03c\\?F'D-\n1\r.m(d`̐Nd)* )bȦ@2[p\0,q,E``@>h&CNn60bVx\n\n@J%#m)Bp.S12kM\"+堿T킁\\/PB7ΠG5C./B/hCXOD\nlB9&bhK&4D&+,()4FA;3;n.<n4N\$\$@\$3>F2de\"ph	F| #f\\b\\\0>úl-0\0Dp\"ڼL/&DC,0;4 (,l^[=\0ҼtA8\$i`@-jpP!@";break;case"de":$f="%(o1\r! ;C	i9	MQ4x4L&:Xg904@i9S\nI5eLn4NA\0(`1ƃQp9& >9M(e)V\n%⡄e6[`rbQfa\$Wn9ԇCіIg/* )jFQ`M94x 0·Y]rgxLSڸ@wŎBx(6nBh:KC%-|iz9#A:W7/X7=p@##kx䣩*P@ȳL9Cx䩰Rfʡk1Cˆ:)J\0ߨHЉ\$6(R[74ã!,l	+8CX#x-.+	ƣ3,q=#(,6)p츰th@;Co&\r:PQF;O[ j9.^C-sH-3 cꁴ\$\rBhx0.\0CD8a^H\\SKz	5LcC\$4DGh|\r\":Ct:p:;K`%&K(2*=B?\r̘JC,a: BV`r1Losƃx[p\rn[C\nփG.(H҂lA}H\$kt4ԸΜ:+/n8ⱘ:1&ժK~,>76\n2ف#,/5N/33N-&^Y~ô\"4\\	QSXNϭ}\n\\-*T5-X\$\n߽(D}:- VF#kWvۀݻþu\$h3/(cj;\r#|T~@ק(tQ.pfrIb:=zZNpoUM@l!1R[hr\\A3lAQgNX.dH7	q4y2K4'ZXPl&\0Ot#BayņIQ)CP\r\rqbD!17D-\0dpp)Ի50P1\"OFڽ`5HwYjeMV\rL-|rt9XC3)pR/tkZ]%=h3c\$ǌ9\":7Z*mJޑkaEBYT-A{l1eNof\\&ZG4֤rZr%MT`@J\$?x:ZFL\n (ЦG!w,h2?72Jj'#E	#6榊6!CR[,\n9̷!yS`@\0yc(\$\n)PߺxH`=FCj)рLd\nIAh03l.191mi~-7_T*Je@ɑK\n㓍TWԣl%9/OAc&j5\nke*jHZѥ'H@FP7c`EnN|u!ivfP	*6ڎONJI]}UD?6KNe]p\\	k0a\\l.f>꽬&Ctذ9h\$4C!E\$(kBO!A0F;'/p+f)4b\\\$|XVO]jal\nY^r|p\rE!rGђEX;wLFf6x+06,H A\n2@.k;,Ɩ3x&5<ۂf	r\0Xͱ2a:+	\r#]R1Hݹ  w_4yjBuAC\r%X0EOθtQ?R[!ŊTXo!\"KR7,f\"X)8`P`kNS˫ bfҚG\\/Bl轞nŤkX;\\Z;2us*҇6lCB:64hVdLC-a5^djq*F\\y7#O^yS3(RX#[>\rM81>\rΞ&j\n!VahrQp)A*\$A\"-ŐXdj}'k|BbFq/H%3OK{SG<gwPq}YfqEEIځjT^T|>jPzȎL}QTMܳDH4̏QOE#c؆C(}~).AG4M1_A)dr tD@lu.a1\n`9Fǣ\0'D|4bp<MP@s]bdbPPHxA%*I}RoVwr\$Lg\nmL@9I҈VLrv)|gj'}MJ-Gm\n~DRƨ=J\rcj+N,x#TmZ\nT	ЁM=X䎐Nspa4UPy*pCb3AD>ty`dH?Uc\nNGeg(O|AZ^\$`ι0>/LW1~'цɞ\\˂@Jg0\r!Q0CNQ,qPBǇ	 \n&0 ZI @H>!oLK-\rJE/CZD@EP\nN&mr)FW̰Ð(<\$S\$`#\0\"LHL#B__'qQc'q`w.걹(Q\$+)])(/*+0һx}\rc!	JrLg?\0Q\$1EDI/iЮ4`js11R1\r:C2RD}@2.hjBg<O a'35\"\rU63U600e5s#7r\r[p{8,q=238v1nBċSBr'\\s9;a(1|ry*>\$\r6:s?sx1 M2=I@>sLA0\$H	>-`.@=\0\r\$T^lFC2h<\rD!EtZ/LlBK;B'z4Yo>F^`6Đ03>ZdG}@\np4GtH17Pb%,G] 0rTb]	|#\$@F65-\r00/B,B\$JEQ4#H	6Eec	O(-ĴL\$\rnS((@Pd0{	tm?M`0Ue\r-VȋW5V\r%5X_d`'9X\nMc%6bpݢ{]lDLR7& c3-p>\r-Ge4ܳ24FVN5%LQk(qWB,.,zT2VULGƶ_Y-ʻ>8Sf=\$I@b:bTd/b";break;case"el":$f="%)g-Vrg/x\"ZАzgcLK=[QeDXŢJr͜F1z#@Cf+Y.SD,ZO.DS\nlΜ/*	D+9YXfad3\rFqck[)>Hj!uq*?#BWe<\$]b^2n>z< TM5'Q+^rJU)qs+4,er5-3J7g?g+1]_CFx|-UtLꢻ)9n?O+;)IjtP#0\nQ!s'\n|W+IHsH<?5RP9~%3ٞG(-4COT\np7\r7I00c(@2\r(K:9@;\"P#K[Dr())JNO1~+LR0=8*ªqt.:Mcδizbm\n:ĺQnIr\"MUqљĤ E>FH	>!dhӷkAFv%PQwKjOzިOT:gE[4L]DӃhTAr,֍	z]jh2N)uw.Jb6#t5ͳ|9γ@0c9#>g5̓45H4\r0=ϡ`@i@2D49Ax^;pÓ2]0x7V9xDl5e#46̃H7x6+]|\"ᇬ1A^œEz/{&DTFͼ|/t^'<	C[j3W(1;r|PH+#ݜ(C2>7Mإ\$^d=b\$}Vv5ʍæ)v6ޥ۔F̊\"\$ap\n'|he]y(AM):E\"32vfE'/hL0GM*2.\n78!\\,\\=J\$Ԓu`i[!°1(fP{L(\r~Kd@QuGϠgBȳ	YՕXUGĆIA{RL#af5ZH%҅q(\"FqHr9#~Dx BzQwW9d:4S34Ca.i`Co4yhe>TTCf\rU&MZUPs8ob8lɄsg:&+\\Ϝňsu5:6PL%}*ȕ8c@)qr5*zӜїcI]jOQ1L.Q	r.\" bhڋzȧ\$u}ƞzDE!VRJE-#bY!RJtWSo\"Cɂ&P4rLPriqڀ jMQ5`퉲WKklF>7yYĺ!؄,O)i\"I\0I\"W0zb!Ijq	IiEVZ]k텱׆SlӂqY\$(jQǡ|1Q*=Lv5ET=\n5?fɓ^xν<a65Z2bB4&ie h!6<q\rs՛`C`o50@T`1:a\rg, D	nkQR|*BWsY=e\0\0(,RQM^%P(.-ɴ\r̨1k;{IA;cINh'\0\"YŎ5\$b )H*]zN޺3Éu&6o k0њJzODcc;#)4P̹S<03\nd&,\$\$%km8.@TI	vSp,1-gAp;l(Zr=ԚҬBAp8<kS0\0\\ƥV|))3z*\"GUC*sZ\0¦څJD!me!G3xb|FF).d>!gcVwБ䘨,0RxDG[=?U0&)LI\0F\n#=D'6P:^{ȍcTwߕ{+\0U|črZ9'\nNbF_p\$}Pδ1Lth(}<!\$<o_'rN2cp/|)ʑ^se5-t9}ݛ~Nt+	\$)<~bAXEؑ<>h*ܧ̐ML\$.Wg}qJKE	22B|P85	RˎCp9\"Dn\",\"6OLbx2utϠAzD*zL,q\$W	\r \ri<Gl@\rrve'@ @㒿+hEzHÆ͚r|mEʎ0JrooQ\$P>òZè趌DQAnt`G&\0W]P&\\HuG\$O>pYbD::ªl:` jdMMb8\\iQz5./f8f>,b&YNw\"#gg\ra%9<0@&E,_О\$ \n`\0\r\$ffFbGOǤH-0X47g@Gb)!Xy&u\"%d%,Sé%5-4\nx%.?'%D(lQ%B]'((ۇ?().&0s*.c&̾b+3+2+HT{+&\0_g2,,R*q(3	(0&2)+(쪵\n]E\0H(+0^pb#>|-!krrQF=~*\"d5F\$\$OCb+ԥo@Cy3bY/o\$.X3X:@\\'o+\0\"Q*\"\"B\$Ǩ 2RNZC2ɤK\0i\0B6l*M\"INW,wdӬE2lwACD#WbE©DN~4RHҥeF9#&cn\rI>o#E0%1b1G:8<(F#IeB8S 8DFBe擔jT(rx~t*+-:J0Wo8ʩNT\$1D\"/:J*uQ\0 \n^OPEp9DW-TҾe\"RU/t \\jKEtVUIVIk7u)Wc]0S+T'VEQ\rV!3RD1XqZԸ(>'<(0#()c(g*rܫc\\ȹ]]R2\n5uқ^r^)/XO3`-TBeBwY[68[b1b'X@ՇRԏc-c F6B+ZI1ZeQszuȞ\n>8DH,#[Qc9&(BR>\\\"f=32Wh/,!gd&3eh6/ccFM7e9dA_4JҥUbq,8Qrv\nCH<.U#'ID'Ns4c\\5=vejUssU էK0BLt'Q\r!b#U7*-w4/XWYYxS4W\rWVlqJdwH^]fwa!WF\$\"2L&|}@bhw5^\$tAkrU(UTEwSVux\\xrVJ_uxwBQZXiv\$8sHkd77pl,!	77{MlX(2B2NGjm>q4*BCw5xzlyx8׽X%6RXMRPeUYxvo~sksx=dzj>I-7ueQ\rkMLmdNlQ\$%*M0L`qy(ADȠ2H)eq ]WyDxapGչIz6TYa{fsɃ\r%O1ۑwul1Úfw(8=v3R_]#S[-d׏w˜fͣu .5r8J4\nbqp@Y,*Tx7T.?\nb'*pM`6PS!::5Y4F8@JuN/A%o,u)H5Mv1F,,^:})-ig}ahr:1``\rR~{ds\$y(s:Q!-kKO6`iz\0\np&I*VGtG6tr\$\rF#?.s/0EtJwНo4r^yB89%8MVQ2i\$/\\BBXƼqz˧6,M8<@B-\$Z'n@*]Bb,&Nh3R@ϵjԂiB\rL/R&\rg/I0֡u[ER)6Q[,uYq8\\!{,rKxحHzS)rJՅAb%l\"\\A%BR&OSQ;уU1.6zv1*Gu4(25A^zu\n |]O:Z?^3EToN*85|Sm@ĺyh%qcϨjnzsB<fAAd^%Լ3B@&r";break;case"es":$f="%(oNbi1gBMi;,la6XkA<M\$N;abS\nFE9͎Q 2NgC,@\nFC1l7AL%\0/LS~\n7M:8(r4FdJx#&̆1*rL+Z	oX˕.ifS {4gCcpt:\r'*O{0dd}ɎE!(o7-[NNn2\\AjH}C2f5Hl\\S9㈧+/js1\r3OFF&5~:5L7Z8/Ø3ȷ\0s[ B'@+Z,F'e2P2k4-!)DOP\nL2(9el*\r(jK<9x'D,<QLnDr0  `޹\rΛzH@202\rTx!\\ی#ƅ##DN%\rD R),:5C3:xaM27Gr3_p(I|+SiN6\"Cx!F+F81:L,ڲë^H°Lެ#+J*s(K.\$/PJΌCʘuF,Hx:\\ےMBH14B\\PO\"6ht3 S)\$Γ\r&gF.&{|1ϽGJ`&=;-;Zgi3r >.)\"`ܮB1׵|sW:qW8xr|r*SB\$C΂JӬRz\n\$<uG.2;\"\$:\0絥60o<\nGa¬lgE]]#^#>\nPCʅ\nIC1_.y<l>Fkв	#hIܔhM^I.XU\nA`BKXć0ڑzL&\"&( @YaGuujq V\\z\nL)䲈\rwU9E@ȢI^I\$0ʆ	!LЫ\"3d\"&ز\0T!tXKcD蠳s2H)WeׄB\nN!*x%<od۔ӶB)(2PZ~%RPԐdP80TD᱌>'7GBQ+!<xHԔXgxi.\$q\$*dFD藄,(Aao\$x\ne`0s0%\0Q1ip0Sj! uɦrdm'4@y 1HQ-G\$NHCD\$4x07vTECg0o\rr!0nļH CcꡆHP\$#p9<4J\\	\$\njގQ3̘\nE]mU.q#B,l>\0T@@rqJAmD1CC+Eg7jeG\n<)D|ݜGDMAp J!:*9)%d!CPϑ.!{yآ&aTZڴ0o2`=yAʞ{Fw-\n\$D%BT\n\$MA<)+]hb12AN@@v.Mߑ1f4Gmh8܆t)DF!\$ia5N)X/&r5t#lnwVe\rݎrQ<kSS8O(''dKX~IfaAɼEcn|EHvÇ&kbCόsUFZW\"E0hS2/(a֟\n`,8֋|%,.CJđXtxhu)c7FM,D϶5hS̕jp[Kot*9)\"V%vtNBQ\rP*_bTȄX\"71D#1^S˽24hgc9ou<lj\\p	i܈M>*,ܭ^Ѽ6G%<ZDkO%1=҂؅p='̬s1c=<uz7㾲I:QjePFI}(dx^De8\$l9[Kyh'oqeOwuS|_tX'bn%h^rM{{	m9\n}:`\0q	\"߰v!QyQa}xZ[fdFG*13MzcDZ\"PK?fČHuJ?l\rխl!g\\fZKh\"mj0eFIPm8IDqB0q~5C(\"P>\"1̡OPLs6ldsZ0lPqDRvCHP@@.\\cPrF2}\n:HLC\$p5=vTʎ@	BD\n-r/C>^/CP6S &c@!:&^2|\ng\$LLLq8	Vx&PFx8rR\r\rdONCl׭ck8?-PPrP<.k֨0W_bN\$ei-щ񦤐V'\"`A\r3eOGH1\"6	2J2oGS1֭-֭qC	Qƌ1_#Hݒ;vb3\"V248+ RmG}\0G@ʱ(>Mp:Z`;]&\nj\"b2(2rb̀҂B\$aR0`0(qO`-*+V2ِ+\"P2#ҶJC\0IC .M,o{'É.2.qv\0A/ͨۄsID)01[){2*b`b.m\r13\$*RP3HAi4̑4C:[gd#G=0DteU73\0JjJ0:}RPڃ6b9CD:C@\0\np\$p*T.a8D{5'K(!\"jH@vr̂O.3#+<@ݮ5iHs,uC\rl\$2I(l^-XFx&D!N(fp/|b	Ϧ4x	0)?(tDG-T[Jة^9E2+IdL8Ѡb CoHf`mp40)LA\"(\nk1G`@àJPZ,\$EBJ-1`VSi~OCO1\0a.\r\$Li 2MNg8J	\0@	t\n`";break;case"et":$f="%(a4\r\"e9&!i7D|<@vabQ\\\n&Mg92 3B!G3u92	apIdCf4(aLA0d2ࣤ4iF<b&l&+\r\nBQ(ԉDa'89\rfupNI9du'hѸ&S<@@tϝNhgP9NI9;|)@jjC,@m\"ٳq|F=ZqF̶`*y㹸@e9Rr!eX\rl#8+/H:Zh,\$4k§C|7[־Hēè1-i5N;:*-\"#HKp9BB9\ra\0P<B87走\n0)xQ >\"xHH.1>H2:\n&\rjP¹*+2;@?[8@/1hX\rX\04p|4C(C@:t㽄\"-C8_\n#Wv\rR4P\r#x|țR'8j+|ܦZ-j2h\"죷͒䚭`P5P!΂>8A@ˊ\n*41\rhB\"V뜣^*%L\0^IdՌzHBxL}jDk#,r\nH90ycH5J;nX64<9lc(h@Pvf-h(7-b\r3z\$^xm\08Zm=<5chabq#lB*Wݭ8@+\"LGH&'n;X6jOsP#p\\I=eivV\0}2b\r5O3}2\rhӟ'aeC#A3bF`!dRÀ\\SQ1fhe	?`a >Dv8eC\$R\$0Z2nI'\nN *@`,,jʻW`5V:Ya2VљnmT[9΃\n:@BBi^u0!BRNJMʒYY[UZ+epX;HFc	֌k-X\0V=G\rpA`P[delGIXt(	rolCU+3بM!M6BUL\r<riT5jXi\$iޔ2^BމI#DPQ\\\n (O(IID,ω28FiL{`'&BxwNԭZi[sD3@u^q@jFrA-jN4]\rm`@R8L4j@9Jb%j\nC\r!4s;V6?9Hy2MRU,al養8*\$mR}IS)TpTXS#\nMWjG[k`H<uL\"Vj,7Ʉ3\0	#`CWCwM\\\"A'H#jr(3Rem\0\0U\n @oD0\"\"!^\nNɺUIJ;bx!@5;{8ʶa.(1HLfLXVQ\$?TPI]O:Lnqh>M^8[[<#̊3')-tUNsի,g'fBQ\rPUU_:]r	*]1>g\rSd7a\rg֬4h(wHbLj<LNlx{nEc:+\\NNRBh[d+SSPkmWF9%oY%@B8GI(8qxK ~HT5cB6RMf~/LCS++PPsk&pWO1*DXft+p␵D\"nc-@\nk\\CF\"\0sVZBA2ȾLGCĝnIrhv*2	quWz[Eȉ\"S5\\8q6:^ÑrN!!삐4g,LD/ka?iMS9zb'?VLӕ.s\"wO߲%أ=y>Ǣ}=d3Yq%>:(MS:JVJǹ6j䝉eW0|,iᒵyNj@B\0l\"\rM`,D5φ&rpCNeaxe nf	l+.0,?Ee\$/\\0`\$\$o\$tEt\nox#jygKo+f	ξ/\nm\nƈBnLߨNnTnzbGΆ'BHj!o	mjMkn-pKb5ZFXWC8>I.D\$J[djfDc|eV.2:϶o.iF؟\rl2TDG΁82q<%@-eW@ZV0\r#P;_D_\0101_\nMWqȂ.n#Q`# \0Qp.cX1+0+-h \0vLG\"brH@\$)7@f\$9o8C]4 m\n	lrjl^'&~r#\"`iis;'x,D=R[*(HV1S\"})1`--9)2r\"˱2eD\n/\0\n<2!\"2ʒ1-\$)B&	/#32L-3!3k.[rRJ1ͦmd-S'/3g5)r\"ͫ5j]2-*y5\r\r݄GR!cKc/X\$QO6/҈\$Nb	\r,\0+,Og2`r11pns1S?\0	p\r]N#sP?\$b|m5\"9O2J`\$F'˥ #.z Z*;ND(dNd/f!Hv\"P`߀nHD',Q#9m\r(\"V'Bl\"	kn!ûvbNhl_q\rP:bl	Tu\"\rD!URS'ooL3C92#RJ\"LU9:4*s㘕IXB\0gXBdEW*d>\"j`MVujTP-\0[Į#ObIưOmPd4 G<ǬAR]R\r5/04\r:8yȟ辇`.\0	\0t	@\n`";break;case"fa":$f="%)l)\n@T6PD&چ,\"0@@c\$}\rl,\nB\\\n	Nd(z	m*[\nl=NCMK(~B%	2ID6MB\0Sm`ێ,k6Ѷmkvᶹ![vM@2ka>\nl+2H#0\n]SPU!uxd)cZ\"%zB1C2o\r*u\\o1g{-PsW㤵>--#JK<֋TsFT/\nS0&>l`Q\r{US!\\8(7\rcp;\09Cx䗈0C2 2a: 8AP	c2)d\"rԢŒ>_%,r6N\"|%mT\$͊S%楨J>BM[&%ES<HPW;'ﲲZ%nS,+>'.r%!R@ȩbҥҡ',2Ϣ8N\$#F0ҒЪ@XO,P2\r\\\n7@0c09c=o\nЄ%\nH4\r80`@Y@2D49Ax^;܁pVU\\3(ր2d\rT(P\r#x})ǒCHIAhHS,sH3\$̻8~Ƒ	#\0Q%<^\n7W(J2<nTSB?9+2KʨLZ)3TD%D2嶘HQ,O/,kJ,/EM\r/,.j\n+bMyjV.2E˭<8ڟy2oA*(p(*Ll3#u-'NXdK--'⭦0Н߇S1sa%3wY̐P!x7ǸZ &A\0:p{.dy`p3\0F# ЀlB ``2軕H\$B@PrDC \$4T`0q&4WQ&8@r(J5&yHEel&TTB{cɵ:g5* 2X yjDl8AVhW{ab1׺4;)!ѐc(\n\n02C ~*Z:p4E^[in- w\\ˢP.p/B|:0`37Ib~KeУ%QQ&^2\"!3Vp|Z!IDHTXGRU-V\\ksZ]S/׻Y%5#;{LbtVB0x%HOaFELVόQdK	.A\n+z\r\$(<\r	s]`O`oQbp@Ф`1yLa\r'fdcjG\"*N+tQ\n (L>J@Fd\nd9QIYX S/!P9z{*oY44\"D(f޲MJ6଍eDK_hef4F8,2!40bܧR0-\naH#YֻQ<.βW;Y%!PPR\"u(IEԲ]F)&6828U5\r3!I adYKi\rcUCC;-}X@:s#\$6\rb=G%0ldR`=wfnE:t.Ck_ɢFhr\"M&HуA>)\$JfB\$li|NRަCKwѥBO^hE6!)[*I,qQ\0PO	*\0BE:L\"Ptֆ|Q,VgWLUMɅ2\\E\"Ձ➥ɌdRSL7iţ{|5`DNi뫅%\rPSqG\$-#?GWWG/n;d1oTT l㘁QL< \0=::s) HcM}kD^vGC)|]6V}E κ`e1a!7O3Z!}ObEK/8;=ۙ>`G%'db4a5,9hKݨm!B{w5%U	}yus~ZY`* @+u VǚsMrq*\"?pU45G#o.q,SDMzu_1?mϚjN3ߓ,oT/yͅ6F<̮k#\0,>%O*O?Dc͹lJ!<hϰ\0000Ol .f:p@S8xN'/{.Iemm90leP82IL\0~2Rԏp<Pv1fHr磒87w0݋	s.#\$EI|pǐkbBkA H~Le\n2CMD Feb+p xbte.+\"qq­0Xvcpu4ypc7%8.e\nQ2Sî̎Q`&.^x1v6}xlp!{,bP2oxk\n@\"fQbϦk\"ѻ	e5ފMqF_	:qb*2jsG'FP#jVLДlF_Q#BJN:3f\"o7q0\n0q2pRZ42eл&̉\nq	(=w2v3қ*#dF1b>RdN+j?A\nN)[c8r(n.1'2c)xnҎ\n8E D/*q\\IyO`:n312ަS3Rv^17%E1R5&1A2%3a4]6ST3[1.`֕\$\$kܨPSzsC*|\nĩi93~ ة\n@_8eC4_=.44Ss sĿ+~Ȁ37#e0F4'2m@),̈́LلfEAt:gJ{&zޭN15!TL(q\"zR1+z(³DmzԃcQTwz.LOu+\rVŋ7ࣰGth3\"1\nZ	,#1MMPvlvH@\$\$_6|{*.7]O9({ԝ\0(qJ26/.RHMZ4(Ժ#u.4HND6+h*0||R#Uj\$Nm{\0y\$nN&3poFu5\$zUwZPKKMXmVFhvZgʍc{STJ\"dr5^k3΂D\"UR.MUg sKS?SqWC0a\"XTʍ=-Xi c*]bN#N\r@OU&83אMgQ3`";break;case"fi":$f="%(i2\r3 2Dcy6bHyl;MlegSnGgC@tB\\ 72	aR,#!j6 |=NFt<\rL5 *>k:+dnbQéj0IYa\r';eHmjIIN_}\"F=\0k2f۩4Ʃ&ånap0i݈*mMqza͸C^m6>㞄;n7F,px(Ea\\\"F\n%:iPn:lنhA7*bn%#\rCz8\nZ#Sl:c٨&0p*R'(BJm@0@L7E^ԥ+G	#zJ:%#`#N	K`!\nBKJI ҕ#\$;<`2PI<c\\53D C93I\rM'&Hز&,	!`@~M\0G4C(CBh8a^\\Q˘\\7C8^J; ^(aض\r`x!R+#;#l@'λ@݌S!r52^ر\r&\\[O:x:8fMU*2II++-æ`\nH	p7hiX =j3LY=ݬ3?B#P\nN9+Mb*q?`Ұvidd5XT(j{!s#cm%2Nl=ݼ6İ;?s1{>Sܠ\"	* [ÁNfqV#\rZ`c<vSYZ3\r#:Z2#\nRu=[!r׳w5[d<,<˻E;\03L(Z@3B/[4=\nZ7h:E7(EMNB%šELOM@D7`ĔsyBCdI!\0\$\r S_,<5\0{ <\"&vX<Pl!4PcfCa\$AH`u\r(!{z(ŊKb\"Ԃhº_,rX%e^B6kP\rq-DTj\$x\$\$œOn?H/_6ػ\$H|C-TIDD\"mq\"hպWj_lyk)fP|Cr(+MjDhHx`%DSjŵV\0v^hjJIb#L![!CRsaFk3	T2<Ɇ@]!Q`eO( &/Oa&qb9)/@\n=fxqHţH\nM!z+IAC*FW\r2% (,\\&T'B LЦ%DLɩ[iU\":E'\$*e3g2!mM@rZE;j#\rճNc&) ZyEH\0[죌?IHnAݒIw\$ůdk3|aƄHvW-!ρ,½G,ぇH/e)Z\rhGM=bP4%H(jJPͱ\\=`l}!<x3S(x #(8Ԗ+R`cﬤ`00T2.A,Ix\"HH[.l.l8@BD!P\"P@(LfA9sqjEdf@e-\\rm \"va\ry8 Q<Tܚ`ۊhk37ZΪ%SmptL̠tM+ǆ+%[49C1\$9_9/ YBH*1665\$f/&fԎb̒T?ӣ#4^.qIq6 (\$EXR!gS&bl_cv,jH:v#BcC (!S\ro4\${!RgAL\r()D^WH@K	6M;@CnIF^IZP<Mg~?Fāx al4Ȇ#.hi1/׸LA!LKGD,N_U頃ۀo7dwǹM)bKө\n;_EPFXJ1\rIn8_pc8_G:OɋVb6l\"I1k'̤𴈫ILW[l؁A@mkF;t<}jaA SpZh'øfS0G%5T9f^{(dlj_܄G4lgA% e\"ˊnB(b	\"KdF|&tM`dX٭R( @8jmɼ426Jjk@LOdrSpvKVƾͯPwL\0>ܰxШnpR&K\nD\nTΔbN@ᰶ\"BU0η\r4l:or6ʞԑ!\nKd'@ԃ&JbQ\"3\$\n,q\$NzBj\$@ڐ^FKT\rP8SL=c1B6qLr/O-1L&&,^mOѺG\nQ6\$1P qH1n)	O0G\00051 (`\n	<\n	D%Bh\r#\"̝0p\nR:	\0fl9RN!+2'RU&e)%lx#%!bc`jB&(`(\$)CC]C.1p:(c4\"R\nЏ(\"%OϦ-RsRݍH\0\0Epd!\"R\0RF2.r.\rs/pm> %2\0@3ލ)Q\$7ApSBQr#@߱ -4\nF n(=cU,\nr-A~U-O`?\0#]'\$n_).P!hCB1!sA(&dhG)s<\$odIJ&(sQ#IcnWt0D8F;I\n	0t~P%\$A41	rdR(&&f^̒8c\no̲TdBnP]\n\"5@¿sY+1+STJdZUnblz-6W\0#D\$44JbgLC})񚪐Pp䉤e`@KljM%\0N,#_QbXqn1̠\"\"hU#neTMfNϟKwST!Io=Mi#&*RCF\$jsdЭ3M\"";break;case"fr":$f="%(m8g3IeAt2c4c\"Q0 :M&xcC);fSF %9ȄzA\"Oqo:0,X\nFC1l7AL4T`-;T&8̦(2DQ4E&zdA:Φ脦\$&̆fn9',vnG3RtBpv262S'I\$6N\r@ 5T#VMKxrrB@c7iXȃ%:{=_SL\n|Tns\r<36΄3P\"Ln7;N15h#s\$88!(V֣p7FP2Z\$\r;C(2 (\n)`Ep6L\n\"(ê(c@a\"\n!/L\nL0PI쒜B8CVʲ).qT7326l9ϴKdXPT2C0\n˴J\r@-Z20hʿj \"ҵ\$A`B9}42OH\"N420z\r\r9Ax^;܁pXn,3(C,2`\"cp̋%@|/pŔTa;^ılj51Hؓx'*#(#c\$Pv6h @7h 6C5|<K~hKbL9A6}B8\"e-Dh?Q!:3;4Ϭ)M*)y\\ΣlH!vnj&\"^&;02D|/)vlUƨN8~eT)\"bN>vI#p-dS8A2h' E]]a׌\nR>\"8ֹM^!V6ۚ\0ھ^Q#0\n	!0bI\0>iK!6)dC6~7,\0n}wPϙfFx%w\rX	L0BTBGDvT&0<oqP5	lU#\0`J'u\\U5FEC\$^H0-)ꗃpk&\nnQhF [m-żI5ֻWzoKTxO\$N)\$2Z!Eb\rdv:EZ3EiNX:fMպ\\ksLb]%C2k+._rh]<f2حVgaFBhDV1!	JS<<DjXxukA2Ml4JMk7&r!ɜTj28\\H\n\n\\u\n\nr4(Ň2i\$*jɵ|D6i9JWmpZ&Ѷ(1HYxyk`SX[\"C%-HՌuJkX\r4ՃoD͝}պUBo\rk02*HD^IdVe*TE:(y\$Nq2KHYhh(uTae64++i)JQC|63x9-Be꫊Ihii6\n<)BQwY?*\\5NZ}Kz*\rn\\KIۛ'=XӲG`HBhͱF7wf\n&@A\0F\nBb˃W't]H\"KT2uDRShgPic4A<'\0 A\n%ЈB`El'n\\qR*\r%s'qDu6՞ԼS\0T+nk^mY>BN?)GM&EաǶl4&d*FaSRͶ7'R!D5SD\"E\$4\njEʟv\$SC1`ʣS;(JJm;dՇG4Oj&\n9jau;2.#[1ͽ\r\nS&=gS,ޔ4;m'2.@!Rbh\0Sapqtpb\\,lL3s쮊#4DCUuȧҳa<Rɷ%C=sQ.R'7SW)ѹt:\" DeayՏWriuBݠC	tiWQ&:(%Ou;ch\0C9h&\$nVGX:QIXS iCq!ubo4*zrR=ތ ;V!x\$zd<%FO<\n=ʼoY̏G*a5R/9?Ol7\nB[e%n\$`s\$@\nO6'\$3J_2AC1+;3kF \"l^ϣ\$jOB:f&fR!R(pfF\$q\rKj)fAҚJu~VW\$Ф#\nrfPu	2OFLe^YlBLPqfPw\0B\n<-N=h|6h\rI\$Xgp؃RfBƘ?:\r-2{9w\r0YqHijQPxJQDX0&%V[lPyGzP~O1FD\\%k@B6#B0)o1Əq\$M.N[.^.e\nup_*R0b6:Ő'e0l^̊RCr%bVCCN\rz.:Gl/\$R@\rVJO8k\0ΒYrF5\rd:d!2\"0.\"NN,>00dR%q\$d-!,p\"S\r.b\r_-2Nѡѕ?/',{.S/21Ҵ/S>'1fjB\\ZUeK2t#Fj@!	a-K0yC3ds\r-`Vr.2'V_s;4ղkO8E2=9DT\n#70s/k,;7S3&* %;C:S>AS>.0[70X11Δjz4di4D(6(O\0ȡ\rt\"&&d݀C3D:X)(OH#<;tX~B5/i@,Β4o04iG@+@b~tqkG+HnO,n0L	t0ArєKQGH0ODLԋ\"s?qUjoҲo#1mh3Gd!hn	5lx;#hkR!POa	M/CQmE5-v`)l\r0P5C9.AclGO,F\$8\"H2L1J\npog~J7XZg!B\nd.='m~N3'KfdUx:L#\nO^ Nq@㮡!VK|4M1(K2kq2dM63>8~UӲަvHmc[Pq6:Sd̌bdaU0d}gc\$C1h<%d)f,B\noo5LLkk'4Ai|:*ϤM2Mi\n\n(lr\$E(\0P#1dc:\rdk_Ek*'n`>sQ`	,BD洣G>g; ";break;case"gl":$f="%(o7js4Q9'!@f4SI.iXjZ<dH\$RI44r6N\$z 2U:c@59\0(`1ƃQp9k38!uF#N\n73Sue7[ƃfb7eS%\n6\n\$s-]BNFS z;bsX|670·[VpL>&PG1\n9llhE]PӒq^k0&uQT*uC&&9JӐ: @9c2%#&:¸M22CIYJP#\n*4*\r?hҬ\r!)!:C*p(V҇4@7(j6#ç#B`%*~ԨJ0\\6<Z(Co9+dǊ	[@i@1@#\"@M:64L0ȠG8As\n43c0z\r8a^] i\\{\0UlJX|6.3/)jx%ʉcүn ڏz8J#d=hƧMRW\rB=<,\"q?B7.0((J28+T6jJv='#7O\rU'j\nˬ&)(G<ws!x\r\\\$#;631lzqjRzp9.~R2BdbxDN\\8\"y`lNOC☢&U\"7j\r78!OYu \$܎#4l۪9صto-Rn(5\rT_(6ǈ#.޽ u/c'b\r	YZLf9!/\rB9<ͻoP	aL*[T	먒)~\\>\"DOXgqnF(jҐ0h4p鈃Q4uғQ{JVQnE\n0))6fHD	>@A`\$zM I\"\r`S'Q#z!\$-vHa[q*\"C@dW*^:d,)}[qS%	\0002/(KlH\rd*JC7dQS/ӝûU0:b\nWJ_,#Y-o~>R:Z~m-t(S>(\ri;tD1B5n b5F9H	\\S)3fSFP0bqגaμUlj8ap6?\nxD4aOe`\r\0PRI`E!^DH{!\n VG\"a%7ԸoSx7tɀ\\QdĜJ/@\"FNv&a.Oα)D赃U5Њ`i劑@6D50F}(PB(nB=H#ӈ'IoM#ipM	jPlBDrC!b8YcDˆFj	7DLzإW%Y|Hu̾q`BO\naQ\"qky\$nGŔDZ8fvq)/F_P\nBM}(BJ<#&9ki	-%zP(veZGrM=@_7x>y(ɽ@)i 0BL	!h *,p \n@\"pA%A' q>)&\\_<oY<_A\0P#d(fuIa<8]^Z;G*z.{^ELǹC<:f,uə&;\n*Xbjy\rɹTй@#sjM)\ryXjQ\$L9<(T@qIDzH[\$Zii\$3\rT-}El\rGAB%PaSsBPYX洊CuU&P?Pڛs\$x\0(aӞHX`q)u<dEd=IH'.`}NOC\$a5W{_\rh⎚ۦxVZ^zZzZaͮeu\0)trV*N@B@ t\0#4ܴabٞ#@)@X^PlvW]iaVk~(Pth;\$-P?\r:%_@{%k!z{)\n4UFyKOn;AeF%J9S*g?FrSpFI`G)bDާ2v]Q]%<}Ԃ7nABBgDe雹BI`+4%㖜px9xa(*%\"\$d,Ro`^\"\$0\"7I7g4FPr\0`ZMrL\r\$͂ \$D+ZЊ\\Mp\$* BozېRZ\n#>'B(51<Įl۬0XI\"F/\r\rwbѧ;\ru8K}\r3egLM\$0.-n5NΎ1Z .\r\"/N92BPqbi\r@dOvkJ!,G3%pV	9d4!AZ@\nGk\0\0@V\rw&{cc\rdp2q*\rwBxȥu\r#C p3rd_M	r(#2,j#067v KO\rͪ#\"7KH		P\$vf5!Rs(P[(>؀@h̙Lcq'R\$.*4'*zdr˵FzB>\r&te-N-|=rsҟ.r\$.RF;R/.u \n(b-0ȝ.91RLE\rdx`,B2s*Ϡʄb2N)3ʄf\\wµ3|QBvo1\n1H	*1Y(F1j7ts`8NM16/&HsM\$\"xW)sd8%:Ӷ@AbFm]'dI\$,5*#bp(cB5*&<Lkh4OU&4R,\$A+4`J `ƩƢ@3io,fv1Ev'\0t47*FހT\npq&B*j,!(xy+?g1l\\cb:D&TM묩RD/r䧙/r^)CH\0qڴķށt3mIQbfy	l)!lMODD5\nPGR(.UQPϕ&tGr @4NmmUV\$\"Q&A@&:\r>~RUʕ.6xobL.)'XJM\$^ʐNUZ~dj;0*w9\n#!\nB\r";break;case"he":$f="%)kƺAAvUkb*m(]'mu]2וC!ɘ2\nAB)̅E\"ш6\\׎%b1I|:\nh5\r;*bJu<UBk0i]?F'1eTk&G~_&0EAd4U¤MBi~ŕ\"U hn2\\+][vGbҥE(ŷMƳqnNG#y\\\n\"Ne\rStN/c2<\$\rC6\"iJ\$\"k'*V*Z9гw3rk(@s5K%L-LRk{0ͬ<Z\$\$3iH/4v-ry0b>%zZHiR[!1S3i|ľ# 4\01o<=s;#7?\0yK3:xW<<As3(42z\r+<(\r#x}z6\"ݡRT#Ap+\$4ɲ#J9\rB\nr!MrO!B&hBHJ9f9/s4(%z	|dkw!S#\$),\$ˋ5E\nH0P,ȢZL]JJdlN]6ͧ7R,H(L7mJ{\"#\rs[c78R!\$2Kf\"z^2_8q9CjI[t\rI@6Ou:{ChZO?@93\r#?H22O\"\r#6><gp+,:\rk\$f#ۿT飏,|*\"9Z8\$e:Q%(d\"'.		0hBp!\$4Ȋ	GI\$dradTjSVUxwV*`/>O\$:,v!,F0NX%F\$2M3@PZ3mNSʁQ*ELRUC̭ʻyD7=8~i1)7rDI}\$ԉ3rXMKkkcQ:d).VlGQ%@|=YHd WaF00f6T\nH<)^LqvTk3`E|(A=2%`ryp7(r\r!4@,>-)@̛_\$<x9RWxx&%\nUL  h\r!49jA!0ʁ_(@8_N,t\$E4CN8 x fZ48 2(@tLqbAT7zb-N='nIy\"hNLC\\%ҎIam-	?\\\$\n<)JDf12\"`|DJfi2`38d\"}	\"a8:\$8KHCnoq|%t95HfHQ!MJ395ceI+6	P7TZ0NB&3N jHRa1#Br!o)۲A]˛xL\"240DQ!7UԔm35n\"`QJrXA3|g2}QỀd3nf꛳~Ғ_, 07)`u8!\"!Ҍ+rG0e+ޒ%%Y.aMu8	\"\ru#)\"\"E9h4@Kja\$>+Okr|1\n>2~Ҝ|	_dNIL9MłtcH\n,;'.2\\!.\rg`5s8DT\n!U8%Dy)8EGh5ifv!60E,~HI;2dIµS\"D\n9NQ~ݥ1%;ACJkT&yJ\n.jv[>!crID3\\~!*y	bM]*Q	(Տ^0{,JM0&iKבFB6% .w/,[z4I#p%,Ɋܷsh]w;-3e\$RG%hͱy-=Ǆqn?Mxm\$K<G2Igc-xq}ۿX`kw2Fk[k_ȗgei+.{^[`~yGldp|>'@RJ83W`7A9Hٛҷ48LTG(r^g\"njk%pL\$(D4Jˑ\"V)&&@LB.\r\\ĊNlrOefq8n+f\$o3	^\\0\n\"-	ie|]\$j諢\nl\"\$1`lp|88]m~Ng&HnXcldx^BB,:l\\J/\$\"Dep3lqSr8^9	#k/nԬ\"#рօ#ܥ%t>/\0d	m+S)c Q ؖ@nfFd(fA oq%@ Ȕ\nIz\"Kn:p!\rw!qtd:r͐⯨6\ncBB0DZi`#Ps-G!:G%^0D:`Vk8А|7*b(*\0KRq&\r0q\rgC({)>`%,\$M3D\$	21FTnK!CKvDDK0*`CEJb\0<a,'#3.¹n2cOP4Br`TɌr0v&NeКq2N,bjG2ې&h~lD67l+&Npf<֧.V\"F(k³&s%5/o/@z&q3Bȯl!?";break;case"hu":$f="%k\rBs7SN2DC3MF6e7DjD!iMNlNFSK5!Je@n\r5Iz4B\0Pb2ar\n!OGC| L5\nLL<n1c*))`k56Lԁ:'Td2ɼ 4NZ9@p9NƓfKNC\r:&hD7, *msw&kLxtl<7cVAgb=U\n*GNTT<;16B5x73Ð7IP޸oX6*z9C;\"TʑR&XҧLlR*\nh\" Ȣ\$\r##9EV/BحCacz*.6.51*e,\$HZ8x-\nձ2RYBR4{{93\"=A\0 mk\rI1l(\$t 1BA\0\r5L\02\0x\r	C@:t㽜4ґ8^!xDl.46H7x%BR#b/5c')zh˯n/&	aaCR'@Py#pη#ΓNC.OD\rC'װsk28>]6V- 3#6ר2B[dì12֕:v3>9V\0V@zl %pbP5+ktr80&W0LEL󛃇\njeЂK1GH_#-juD:=(6-3#ű#mHkx<zxZGJjw ܕ7@g\$ڞvPG0CvWC]a4pN>EMh0\"kl}<ܪXs%A0Fi4H%MYF(r4@!P3N)AAzC#NK?9\0T[` E/RɪPU@W8BXd,ZD0-Uy	u} K'dJA=6*Uze\rRjT1t?\\-tȠp\r\$+*Y+-fc~[rB	\0HH̉!&Hd:96H	e@hEETr+\$ðS\\Z#HL|#r+0؎dQȲ \$>U+n ȉU7@a\r+yFMhE̔I#E1:^K,\0(0gTVȉ*AO5XY\r{6ّ=2jpU^ܹ\"C&IFz>\nhjIU01bW(Y\0\$XǜVjiNJTRČ=.ZŘ.,ȏ#Ɵ0+%3 S+2tSk\0p886:(\$0iI5]NËSd3 %c 1jqoţhP	L*UszA\0C`پ?<zYEssRݹ0tP76IjP`#J`0zs<eB.s)	g5g8\\Rhݹp&4ct1[/f!8pj:b1pPze6&щ3%Je>(&4L]TJe}שᨒhPNzsCȵ&N̹=PF:Gڲ,(Y1 g\r-?W(i0p5z{*\\xld1 EgXCfS,MR=(̬.Y`\"^	ٯʅJ\$aDədF2r\\{gx\$&մq0[R!cw;[	8lE>M]Z!xC'fV˿ρl3YNo\$#ztU&ah LR0\n\nLpN\ryxMq252c @BHo-ڡC(n]ڤw2yTd 92fE:ASrX-֩6g|YkQWN\nRBS8.9T5xYh#;Q>vx{]W}߰w\ngf5=0q䪏{-5\$pY?Ezb6׺EtH]*^6&䔍bܲrCyKX\$k)&ag\0WU8Q\n1?k\r[ֵNֶd/ak5~>8AklC}oC.:\rVF\n#L*`}=L\0n\$4ذ2%a`Ɯ0Agw({PD?R?+H`/42&'H9#l`Alj'\nhF]f&0DJ\r,Ѭs\n0p| RtG&M;D|ۭbjaKr\"V,xϙ8\$Н̌8,Wlb\0wP2v'wdv'q1(vgXCRf\r.?.FhDtQD.\nN1JQqXg%1VQ\\61`-6:\",8آ;5Q\$lM9iFd(,k\n@2`tB)\rez\$\$sλzjgQW0eLN\"ԞU\rѦ1\"\rQƎbGp%``QLhS%P;P%Ub;&.w\$*NS?'P2W(&X.N\"2;ҟ(1\n|	b<F	s-@##(o,V8BE҅&r%m.\$)Zkl/K*Ka@\r(Jc%rr2'03R\0;9%.9BE\$&10?2#oSJrAsM/5@Rw+>0-7sP37Q0;ӄh~ߍʮ!dDM?~>u9cQ;ު 	:pj@N7	=9?=nS >6O?SO7\rIA\"QnT(nZL=On\\J5AS'q?C3RcCo-2U	Fd;\r\n@ʾ\"/Emh1F0ft[FF(fO\nB:ABp҆EsvFOI3J.Jts_ k\nK]eZj-Tr! ȒET\0\np%QZCcGTU&U	T \"B(\"\$},g0\$BI#;MNDaC\n`0HOH:8A8/.l ~mLdEī;WC7\0g`\0o:PR`f~;nhbBB-G/Bp4b![o\\SE8(.T5AhhHK{u<RR&+B \\!B\re`s n	Hr܅jT\$V6\nNu^?찓2D\"4H	CTaX\rcd\\]e`-ag4Fˆ\rb)5b8)Db,3-afF@\r";break;case"id":$f="%(i2MbItL9(g0#)a9D#)rc1M'I>na&ȀJs!H\0Na2)b2ar\n 2T~\n5f*@l4цa\$E8S4'	ldu'c(oFe3htƝ\ry/s4aUU/l'Q!7nS>S/W95&n/x\n\$NX)\n3 Щx(6ǝӑ\"\"CiߚyӇ!9c\$9:A*7;#I0X\r|iR(ڑ+#:>%:068!\0AmhɬjBS;87QZ%\"m N}kZ(H)\"8m	\05Rڗj6>1`3XƎKDâs?`@-@2D49Ax^;ru4\r\\z&o2~\r34ƣ^0\r(	Er%\n5+Ldtt+sx\"7?9X6Gzį%	)w\$H@'B%0b ;@%׃@#\":Z1q,MXJ(Q\n:}i#.#ㄖ4)\"`1Knb׵4J\rr+!mni%~(2l/=BKTZs%jh6_C'苨Q]c\rO\05po|!0Ҋ|0}		&/+/<'1; ,3]V%0BNƍ0̴SP7r\"Ϝ:AtCEcrrܵaJKID*1IYXx3<9PRMTCEѴ}\"ԪS*mU@7*}rE̒cʆ|H%^i\"Kƀ*SvQgCRYLu4T\nWNK\"Um8u䜢9\rq/0\\#CЖiOhH1XHf|Ɔ1DpȑDau'CYoy>\" a\"@1¸P::bRdHE{\0\n0JA,\0POL/@8ܧc;Hc0Wk&C8yFIDc#/B84J73H\"Dƌ1ԁ)41{Q') (L%&^!7\\êya+P@ c1S?JD̚y\n\r!v@ɇ&+7'\",C<MS,5О,!d@xS\n9JI1睌dNRL\$r9,!9E6utr@	W*[0T	EʶpD&G\$)Ȱc^ԲxxNT(@(\n \"Pl@\n	Wd\$2D\rRe*H%]\r9vH02X:gUzʏ/I(V+5Q\"R1V]0OQ#jAky<lc\\*!R\$OӔ\02%?Kh/\r	K\"c\nf`_%n=0wjG2Xw[^I\"F\\FT2t@M Zkiɮ%SڂV\$7WrC5C;K145iCmGm62O#jbL&x\n\nFؚCkJWK\rta Aa R6xf\r8Vt:XdA@&1%!e1ق_Im,TLYI?裏ni\$Q-DwV\nh\";S%l00tY+&*ΉkrI(T͒Q4Bh=c(HT5lT9eQTGBiDp2tZϽ=֪3H\0Եx\r-ĤpޣEЧfW% 겟>84BHnm('k\$Dt\"P'{2;yGas)Ze?Q%7[@YyI#ۅ-J3Tc-zuSɢZVFqj]Ff{q1	x=,YƳ-fW@RDZ8.-\"i!&[:^cZ;_wWỿ}]=s>y%5\r]:E\"ֽR뷴&@9@l\$G8v:mh.ןXYx\$\$dOlF\rS_/ٵ\$,5\"o\0O\\bDi\"L`+ZBK(gj:@Ƭf2-/rPEpLK#G\"i\$,I`d0\"aP|\$|H0B扆f0T_^_\0io:]N\0n	BYnO@.0_tx1\"#lGP%0@H!q\nZA`DԚozvɐ¬\r1-\rN*[Pq<[E\0\$I@.B\\H1adlʨUٌ9\rmJ&`zJM/+JE`j],`4'zD\$@줨r\npsk(\$M 0p\nbb7\$LDoxz4	Fj^>m,@*2L-(.xp\"N[x^jUV'C:\"xx@4dg,fqRe(DLwBS\0 \r(\r\$Ol܏lV	*5N6T#-fR&Hi몌E+D/9L+-b\\҈CúWr\$\"2\$ˠI 2cA\nF@DdDT E#";break;case"it":$f="%(a9Lfit7S`i6DyA	:fL0č0qL'9t%F#L5@Js!I1Xf7e3M&FC1l7AE8QoS|@o&dN&(fLM7\r1xX(-2dF}(uG&s4M\"vZgZ-(J.WCa[;fʒ 1Ņƭg<	 gJerKDSd׳&ZQT\"H&9:oS!W3G#sѩ8Lg{AL%,BRP%&J\"tjh@e:H\"=@7c4PBʦB87f*\r#&rI`Nb(?\rã2#^7D`޵#Ll2\r[: #1Ȍ*\"=%/i(`@%#CH3:xK7Ar3 _A?o^'laL3-	x\$³޺\0=%tíM|:+͚/K0Y.5Kى 숢,7/ġ(CʚWeܥ x؎Th^jXK(\\1+-B4֒\\Y\"30@1J!+ޱ4J'N\$Hr'5;3lX&1<IcME ^Z9%-]~#pȈb,ﶶl={YĒ0Yl,I̻2	#k9.NˢMkf\"J#8(٧\0ڐ8T`i,05nQHIWt0.hH35=#\\LJLȀS9HL	ޓ7l\\3YTȗ%A2P{K-=xͣs\"g(}-~ŗZ	cɾbl!k'˭|wL3\"MH0<`dCpkt9\\8 *m0%yq (&TzRjUKu3\nJ[\rT#P	3&T0aKF셇'^yd@fHn\$g1SC\$W:pRaM>؂t<\$:n!4!)\".0&͘АJq'#G)n8֝W(IAc\$!(Pe;nr߁F괸30eM&i0α^bDw80È)4@D	A\0P	A86{('क7t˱'3r4OmdNGtL׷^,AntfoPUf)EU5'Y!5P7S\nAL@*-f`كIoɐ	o0_KH(ș:vOqqxPVhȍB	Cd|:*OS%CѬ:y8BxS\n曕\r3=I8^ՀЬf\0PPF%rC;DiDh+\$h#ILG{+*&u~4)o'@BD!P\"z E	a3[>V4VsY(f052e1XL9[椵PZ0qSZs>\$ՃX_mw魷!4S!27tHww'b-nHniMZS!cFɛ7?nBo*x\rpbD	`\"u\nn\nmN0%\$ɡՆp\r0҈QkEWFVѼ8HLY\"@3dBM?V3\r7htva\rsV@PFV:`)I`c-\n!@ɈIJA̎\$'C<L*7^iÖ|^ \0ZC\n]e7`ì@sX@Z,*LM./7gNfl)8P&12e㺊Tz\rX8[˽x><3Gi1qƒiaL.j~RpJArKFVȀpN%']LVEBgW<*D)GUf5\\d\$o3\$F>I8.Q~yO8jWƂ5IfieaXE3;pD B~XR{tX\nY	UΒg3Orn5\"%3\"Pn!Rsz#QzoKlڻ{1{wlFӺ~f[L7nUpv`7Yb'yA{I?kۇp@t)D%\rֈn\"b:P\\	<IփTCn\$iN@*#C`tG¢`6GQjL\r0L% ͅ  vcfM06e5/Z0		タ^5/ŦnFκy\"0ν=Nk\$\\mob\r2Mˌ2\"ҽ<\$\r\nȐ5MϚ/\0c_\rR.1\$&1'a0aV+<3dm\n5%N	AcOGF=ZGPol)f |iHw&aGMM#ѷϭ\rhj&e^ad2'N.^L?#9c:Ѐ@3gKK\0q!'&IFP2=RG rNI֌`&dHJqI<ͱH[^'4v.]rv0ʬI\0\0]h\"-hb1M,B'ݥ`(r\n+e+2J`9`:0逡o0ac;%+Xr>3jZ\r%mpͶS1BbL[0~B@&qH5˿%( ۢ*:#%*o<L)\"K*kVU fC>eR%cg*#\"#,M0	4։RZ\$b,s\0mj ^ :s3:ӛ;#rFӹ9,w<0J˳;	,vMʛ5>d,;@\0g\\q&:E/&\r16	>s+&~X˸(7Ӣn;gPz@Z<րhDmW\n\nGLbnI.4 B8";break;case"ja":$f="%:\$\nqҮ4(b*JqTl}!Mn4N I*ADq\$]HU)̄ )dt'*0N*\$1)AJ堡`(`1ƃQp99UB[Hi[x9+AFCw@~UM^_PPU! F^!UМR<I'2mhK,/P[PtRW^XEvu:kL[&|	W~G*)Am4TO;%~sC\\10G\$%ReK8myCd~\\#%{A	Vr_L(Ce\$\$i	\\se	^1Re&r@I	Fd		\n@ư'HFĺ-:´@򘱜ĩ`y.R\\DNK,U1	)dDK)<EpAF%U%J!1<AMSOG\rp<A'9PW%\0'H1f[Du_5l3XVPNAiy`\\<g95Hk'VȂ2\rH2QMD-KM]Y@@GC1R1l_͒x2\n@4C(C@:tL7Evx3(9pJ(|t%Z^0MW9tze,2I&dKzZ1\rnܧI7QP97{ҁ8sV)\"EA(ȤW'JhM7ѻ1\0Q2U9@?GN\0sPKSa3.sQ;%vs}+'WF[hd\"^KOi/?*[KJOHMeH)\0P(gO!<E2w9\"zηJNO}[,IW=n;\nPn+nspX!>􍻚re5Y53%FiBL Na2fU7J\$HEÐA> VtdHRK\"-HU9\"cB\$aLO 2HII0^HtB ݓ{bGJa-#,K\r9)U2BЌ([a\nJT5ZkED\\uAbD1B5oICQ|dX\0Shb\\M3j#^+uҺÒB\$\"Q?t1Mf(@cWlMA.Bb]:#dX˙27Lg@p\"b{J!싐ǈ ɫ`BpOw%Iڅ2;Y(y\"tR(%\"T g4Sm18Ǚ\"d;U0k/f,2̃fl ]EA\"0)8UD	CG.mΧ(Xznb\n~(Bh	¬ī,#,kME<TN!G!+R\rrFF-z\"j5+bN	#:l1,@耠BV1فz_AE/~}9]q\\*A*kp\"!(	HlU*蚊P4m,g\nMa%)(T!J{IM2x@G9CLƱS'yUtv\"!wFQ'(iA&|@VF!*9Q\nKG,j[蜲bT*+2\r&Ț\rEhݎlj캥%6)(Ђ\\\$b*+%/U;4y\"xo!(	 R͢}#J)t\0¢YoK'FI2zOA\$b	w\"GӝsIșXrfRzd	`P(qj# v³25adGH.տv4K5QJwE \"\r!E;v]:\0U\n @x &].\"<A9励Kx1SS{OyoJf%]WuFLϻX|}̹;{\"؛PVoIAb5zԟL)ˋcsBHe(QTR5\" B+.c4ZآQT+G@\\aM^1 #e\n	K`k_\"*T(M`Es0'c Lx}`>jd%c<(&3t%Lr\"-cjUX+1ek*laV+QBO][{C=6^FHJ>zqM}RCU/j@DlAL&rƶ_Gb	[o@@@o&4*oVk.KP\0|J\".3\n\rGPJN\$pooh0.J.46Gnw#Kl)ծBj&nMXQv\$B<5f6LZ\nExD>,\\}0RBo,L!&PAbOZkv!_3C83m&}.\"Tb&6h7À8Qhq%h4 ƼtkQ51&l*M.BJ7\\lQT.6Z'mI(RǺ4L\$r:P?/YN1AJnѪ揲^}Ѱ'&\$vpmx.% >߇ ed,_nDIEbKB1f1d&\"n\"^kr5	N} 2BFj\$,~3A1y\"b1d6p}&BLu&[0#}%H؈/S&)LTfҥ\r*<ֲg^}y:!>ժ\0* >e\$%20 G-%EQKcPkg̽ML.~\$22+C&v1`M%o)%j\$ҲBG+1,+,SN2.e*'O2\03Vq)Qc61W6oS{3+0!jAC<^@LP;G}qpsL*o=/=rz!26,3b(	hfk?S;?\n6S#3B@3nFQeA%FO5S(?BҀ㏈t7(Vt@~r&tJt<TRV.R_F!s@XBTlTRUe'\$yE-GEHTIG%gDCTty''FeBĴtpofw>OdErLL>3MܬMO0S~sSHt&TH,\0A=uKQm^%sa'8JTL	J%PSSuC94Sf'O'9\n@ɰ>aVgy\0GCxg:>\r`6tKUYw;&yÃ%uS/\\r䆺TPLn\nZ<(pF\$\"rcoXQj\$.#^!G9D:s;Cb܂J/(9Yh3!\$?9.OfBCNg#>3%b˺ <3aԭ~l\"\naxan{BYoC4TkQNg,UamBZR(tOdf[6/&iNLlA6~W66p\riE:,UC0j\0jw1RZ%`j!v'p#Cz`%Qas%UPWV3ĄD&\\";break;case"ka":$f="%)RAt5BPt2'K¢:R>5-%A(:<PSsE,I5AdNi=	  2i?cXM\")v@\nFC1l7fIɥ	'\"1UdJ	.eiJ\"|:\r]GR1tYg0<SWµK{!feMs'Im&K=e\"r'Q+˿}-<^}nnZ,:K<թ;SV\"zq=o۳*#\0LDζS:-JsL\"4Mi(N\".@9Z7BŴϻ&Vl7RRrF\nKt-Y(˰KpDLΣ*x#	Sj2S!RL,*ʐiDO/ۊj\r1ЧK(N#VJsR(TOTS)HHE:1	%iRՎM%jtfG,>C*^͵LYP\\t6\$\$5;b6#p9J:'TtYRoe\\]J[@4C(C@:tD7{x3(9PJ|(W||MQjxTӧ dwmN	=kRzM;cڮ@CMHh<McJrө*m\"+q(!1lmNQ/O.U/]03a\$?VͭsDj6j7ZNC-]%:o;먿yoGں(Ḩt=I,	Bh!f ĥiEJV{5fоꚋtzܥBb-<u:ގ!?<+\$L\$j(6TUs샇jfnYVS^!+q5|I2#%	^7&	[Z-,̦!8mFX0eD 7\nQ4dBT\0m:1\0Θt7\0CrA<LX:a7`e1ꘒI4Q<%mi+L>CX]¢+EeV`tNбh}d(](G1 !4xfH&D^1>R8\"N+K%gܕe T\n6|CWƄ*fW *N	Dā+\nro)an}\n8i)vJ{Q^K{/3l?ӭ`JNDM\n>LEV.Xc셑YS,e2G@Ltg· mm6=c%b-Q4MSiz،vB+pޥ!4,%zSz4h\$\"F(Lގ\061F,ćvHɧ)elPps,:HީC=b&Rby-ԙZ鳒SYgfI@IũBCT4˧g&E&dN#xYqX,-)xPxv=\$LIM\$3H	4Gt㐶F`2O\0L_bmۻCN뙪V\"+M׼uwj.\ninzs\0L'[H?`[VOv܉QI>&jiAC\naH#/T {#6H܋'A7W^%iڒx)U15ymE\"K?v2X7P[PGB@%{R-Yp\$0^xʽ&l{	Ph\$ַs? ¢4(\0ɭjUt,bKtSWdJ_MQ@e%Oe+sձTS`a^mD9:\\?JD3M<&B5oM7MA(`ޫֹ\\Sa%lIKcc+zI4nQkQw ʽ뮮2oHS>E	2Y\"p'%\$x2.~DJК)>t<0KְiU#XZE|P6@>0SH'2Xu;^઄w5Qqߖ0uBHo;nV]B+j](epA6PνH,ᙫwZů^&(ܐ4Sq8@Ga>3Rm+2W\nCɻyq<x])Zi6QzN~ rt|t{oI߀Nl!YlVP@7&\\|O4g؛)\0 4.	ΜFթF&P`zo\nTp`a|uX(Ī%ئ@\n 	´CVyIĤnZ+n;ֲ	G@DhG\0^-Em֐8@Z:2)J&Sp7,'T2h~koK>AS@'lR|i=|hlh|BNnb<LV6dz4D)Zf¸!Cht\$&-78Qjq&hͦ(Fla 䰘r&΁ȆD&Dqݏx!\rdрl04'b4(-C\rr@F0\$jr<Nr m#.UL%gfUl#u+:Ƣx`1ڗ0G K\r\"i#I&p:tq)-tR0M4φNش#rD~/#Tb=4.\rZ&.;ƈ+,.qd	,F,b.O-n(*+,uO`	XM)'!1oD-M`VW2\0,nr:.!00̚Q\0r{/o%6	6B/6OB-7u)31n,6ajOB`Q7Qx\$B#2zl}nP+):?:\");lꥒ̂*жTONhp\nmSxo=:e=:b}ѿ6rʰq.22#L)Dǰ/\r8sZTHmDE3LR%B˲TMsF+>G`a@g6X&TH>aS1W5MJp<MԚsIKKQt'̦?Ep@m&S&NozqZ1kDI4t\$45]48SsRS@:QӁ\"1b?}C0qS>-U(pp|:HwfVNeUuU@s\$:Z0ys2Sp%/\0L4I0Bv5?.PvYu//52[L%uR䵾Z(ENU+rFi,(Q[STu0Uq;#S`9`\rf&f@@@e@\r&6 &v+bГ%c6\$\r)b0oد\0& e\0X(QZtk\\<94US4ևH[uKXV\n֋T2s]W`uTr+%pVrrj7X,5i֑\"PVTiӖ4`:h5U8EZ1lBK=ĽZ/U(4ǷM\"~^	OK_PC)6U&5aT{*&La@qklzb.q_㌩uI:KE>*pGĀ\n\rrM4O\"\" rbol)A]>	r,P~S]眻&KvZ&sFiKMskW]sZ/jX&zx֪l%m|WDV1OZ@aK|GOpp|7Fs\"\"5F鐶#yW/ ~l mǦON&J-E{-:w WrD^X荈?IlDNΑ,?vl:R;NP*͕&YF/\\)~{qǥ]ٌe8(l6lSRrסr,\$»oE#*\\.̹T*U\r*]Y%/%jE!at	4`";break;case"ko":$f="%b\nv%Ю\nq֓NU)ЈT2;db4V:\0BapbZ;aا;O)Cf4)؋R;RȘVN:J\n\\ZKRSȈb2̛H:kBuY\r֯h!a/\"]dێri؆&XQ]n:[##i.-(Y\nRO)igC#cYNw	NL-\0S0&>yZP',l<VR\np7\r7IX00c(@2\r(A@9DC09Ƞ\$aHHAGE)xPv	RX3bW#gaUD̸=\"V3d bSYa6'0JI`SA\0<7D!`uj*FRO+9:e/T-M4[Di0t#ZvBk*u:I	Zv(d# ;1KQ1p\0\r1\rH4\r㭤ECY\0ym3:x\rdB0p_tcI|63Bl(4px!WR5=S !@vdE\$:aB/i;<\0kh:eeiU/!NF\"\$:n@#X6ewZ-E:BQG(!LNpy#:WQ+1NHpdJUY@V,ĻD?OÈJ\\Lb@VS*δ`P\r,6CC0x&<R&P<\\年KU4MXEQVgiRe97{UCOVo:.;!Z^̓RjM\0-/]qʙb'6P戗{^A:\$!史WC>lt3C,%4hHsvj	4L2VlEÑfI#JAQ5G%`_؃AP7( -E \r30Cr!3m\r>k2\nYV02E.hw X7 Pi%wת_+~X`Ƀ^\"\0tc(Ϥ2%p<͈Rk`mPH/%J%Gu\"/f/ܕ1E9W/]y/E_JD3aQ#ɆI\r!4ˌ7kbȥJ4ܘ͢@HB*m1nL46;PĆr9:tn]Q8\nO᥿DNi5dDRiSX(jʁ*iP°)C>3\0Oᕯ-\0 \rJ2:Bu	\\b%red>Ú*Z6,]uHc\r3pAOwpX2ً5g, aL)b4!X7\"xp]7\$h&@Aԑf9HȘ>>\"#\$Țb7Gqf/\$|dR:@HS axRI+	\$<T7*\"C![>3 (ɵ,143T*d(\"yAJa\"]vHɹ9'x\nBkGPP@(/!XN<B. \nnذM0T\n2ia\"dTĈ%LREK5#y`3bc861f\"ukssxo 0<	: u)ڰ\"	i!aER=:Q:#u,r+R#]W(ͮݝXT>V:73\">i#/h[8@|̛clګf(L\nzN 1QP|k=iRB7uzWTNoDbo<9RQr%ʹcbdBP\$[pbv=Dǵ\nӢݞ8ޢ'>Yf-҄=zzBhb5@=Z!`'\0PC^HRvB\r':O;S=vURb,(sgQQ\"vIRmiZY0C	\0҇\nY\".Y\$\0d/\rp22Z=hْZ>Fլ`O#ޓDZ9|ዚ~[]_L~k}ARizgE~ͬj)Nt cOvoR-ˤ%JVidn҈{>B4gIL49n?'&r\"=;pj6M#Fi0#\"epVpRR@LӃ%\nV6lhO	oIP2'k090i4R.2dN1cHAF(O.7)IqAbӍP\"FNVd[<ٍǟEMyol7\rgی4%\nXܱJ̏z|\"P1PڑcIg,!FCO,	TC6Ѱ44Эפ0Nzqn|\$1G&\$\"\")!:&\"\\8lc%Q0\"\r`qzrgR΢	eg!6|\n))*HO Q\nQz'1NP5rNͣ!gҝan'#2+2*QW ұ\r6/6lnt\$:D\"iH\"b#A66:/))0Q-q#g҂Kc9rp.\$H94(\n/`\$%#4\09#.a6Q&661y!D83)7-4bVNp23P2s*Ns:.G0ZG4ޕ0a\$7EC=o<ΓS=lHh>\0oeS3jS*4Qr(4 r:pB3C.(O8?LT148e,@F)2EUFTY*ƫ,n@C\nl18K<#Aohֳ3sfGFC T)16Tz1Aj<OGKKKM/w! lJ \nt[fo4(\\BVw(Dl\nZ~\0[E7NB#'-6meϾԣLjh,>s:unsG#]Wq)VJg\"=I\0/\r[ oWL܁({'\$i*c~Lh|6OycȻ/\rb6.U^p60!6h4H3+U:1BƇd>@CSA`	X>=k<`b܇G 0)[-R5fLxko,d>nkTm/aj}u)\$_M)f%,\0=#bn]l&ƓG7tCt!*JM\$";break;case"lt":$f="%(e8NǓY@W̦á@f0Mp(a5&	scb!iDS\n:Fe)zQ: #!j6 rT&*4AFi7IgPf\"^ 6MHC	1Պ\0NE\r:Y7DQ@n,h(:C@t4L4:I'S9P춛hb&NqQ}H؈PVuof,k49`\$gYnfQ.JbfM(n5rGHt=. 9c2#P;\r389aPCbڊ˱fir'5*?o4ߍ`*B 2C+&\n5((2lP0MB5.8҄2!,,\")#bz_ r.\nH5\0('MTkX2\rC\r1p4#ϤN@?#AxXD49Ax^;pJRÐ\\zu2h\r#,\"Hpx!: \$S]bc/x2_>.+&͚1c\nB(=t239&?\rKX(O갂#B	#pOC\"`(2We(1c~x3F*#*:9B4\"I:-RF(BbGG#K<2ÚH`յ1#s(\0:Id?J9:T6罸ϸ8h4Lا}d1k\"uS?Gg2,T.+8խ9l,b*Cq.Ly%	@6Msmr507=Ҏ|(f,2|&!-.6Ct\rĉrSraDQ\$o6)e	\0*Ipyrl:%HYp\r\ruAh\$͏Pσ((`J1PhCLhC(|	B7䜴p@qV.LWa,EYg-y-+D }\"߀ȸϵP!iDR\$ǊAp yQhWL#yDuCIkaUV\\qh81[a%BR5	r@K2PHbHJ9*ÚwrE8B\$\0cV@ejJL|0bo>Aő=q)^a\rxd\"7,e#\r%J]\n (!>(&P@\0O'm5^R%Mü F,fmԳs1[`GB\r+4,w5.e=Qr2TN:) 5HiD!9Z\\r\"v\$]q5S,:H\"HIAqsаԺىuKa	B	y/L,s\rN&>j\rQ-<sc|R26Q!4._\r	L*Xcm%k#\rdAglo)!uVND3ma5~N5r\\%d-i)qLוȒ\$	N\$Q:\"\\i]|6`̤ʳ`4:Yi!Ü3<F;wY9+r+*\"(Ed.ID1xZxYt'~xe˜dP>,jnb5Y2~|\n70i,ش* Bȱ>C:jQR]u&GEJ_Z&P(--*yf'ȅ&=2ASzjE\\g{y_暛^H#\$t\$vSB+0bAv+'47F37p1E%D	\$XSmՎz<xaX]l!@Hi?ˇY3y<>z~~{op˔3_1Hn.%RAtb\"v!d=ݒD;a*@@ |eBxCةA.q,'(AXl;	g9dD9-?k'@^Ix&J.bf_9\0tsKDˤu-Ɣ7/zΏ/\0)lEzoCc0ѓEC_7*Owq%nE'i.bk(\ni6!(VXmr\"}Ƞ2緂ZR[T,FႆB'Pl0HBld<I0#L\0}E:Ч.2Vm.bo--f#.a.@(p<LLxȦ*Z *ºwǊVi0*2nG|9?\0DE|8ebJ;@D(E	D#2!LD,ݍ\$,B!0D\"^ނBnj I%mO\rGVl;80@P&[&:DPOa@J.L!E+ort.b/k/\"C1>eOy>0ACQBtҜpB%bp#ĸ,FQ4=Dx|Dp~\"eilp5G	\"~!\"*@B*@pδ&\$dΕ\$&M-6J7\0ONy'm:1-mlQɢe<\$\rF`M*S\$\\,`H;nl!%8r;'U&0\0+--)B Յ?,C ~kQF6c#[M'p;qsU-R(:uk.@]_Ù).&,qY/\rDLa,K%)2r2#(B;/Uk0RvD|;bAs)-\n\rq-&CK4d&@'fD p297s8\$.\"(R.w\n;R\n;3R=6<>Ң	t-rMD&&BpMs!\n.R-@ܤKj.<\0/-°{L/LTb}&>3R Px+3&KC(]g/NDrOD#365?JDj:	}FQ56x&/\$12e\rV9Tiv[^t;\"nظv`\npH@#f(\",/kMNB)\"pJ%d?\"/\n	Am +48@,/*8`cBw3(\$98[J,Ț[P?[#\nNN\$Am\ndԁic{0J@줳rҬXZL40-rMsYʰ2\rom f\$Dl&`tMpdI1G\r\nh2pI3&%/Z`@]e+X#Q\"҅5GgB\nD>է)B3^vYO]J=M\0,2G1*GNN0\$M\nB=\0";break;case"lv":$f="%(e4SsLq:I :SHaa@m0fl:ZiBf3AĀJ2WYCf4(#Y9\"F3It9GCF\"67C8'ab:ǥ%#)DdHobٸuN21	i@ S0Mө_ni2|9q#{o5Mat5_6̆Q32b)V,HC%À9\rRR\$I7Lsu		jCj\$6C\"\nbf*\r40mZ 	d\r#֥ Pbc\\7(轶O5Lh׷r.7\"LL(	²l:& H̢H`7Gb)CAЂL#Nb\\4C(C@:t\\4Zڒp_	cxDò89!Z\"7j@ x!.=!(PNP+(#/p于(U/\n	ݲ%.RrK!YPa(A؂8:\r8!\n%ʞ@c]C,07C̡9)\\x[0%NPhsPv|)C(5˻-!P3A	CV*FLp@3qx90(#UȶaJ~(8Mvn3_qGxCW4LC@I4 <ѐ#h`*e睥~B ϢК\"=bT+ď6c|!`3/E\\[}5AsA>猣IEİTv@H1\\fkm?7B=9Crihܸ)Z4rڇ8e	p	46C|/A(HD'\"FJ^1lV/Dў\rND'!^\$!4T,pDEcm^\n Is&Dj;(A\"a\0Әl2ltz\n)FE8K:\";\nTTZՌJ9+ur	caePb}d)@Ҵ	&DEG)`%sS!\r%̧JW\$\$Sh[	n\0ND2UJWu`l\0U|NVa5PZ}d7dZ	>sLDI9#dϙiy/\nlH!k|3ځPuAa)IPR\\J>7ٙ!\"Q3rk\n%(0 \n (uF4\"DL*+\0c&a<R!J!wKQ}yUUc\0`&8xBѴKP#`h4(܋oҧ\rY`/\n\ru23\0F77yÜ7C49B4\r}P/\rm5MͣhG@ޥ(&rHC%,Z*18tXݰ8a,6 #C{谡<)J	E]eq,RX*Eu&@OC3k+B_ۤWP@b1H \nn>HI%\$jlɍ\rbCG]#%bF\\DM9%{2c.9ܬ1KN&efk\0PGn9'L6\$L3wEFp6M(p:zD!2ha.XGzQ}0PB9,BH*/(V\$\"tc5KZՄx\n\"w. u	XRGaP(5*ӰN7R!@WJIza nqM76{A\$ӵABKLddd͓v4nN3PZrEA!CT&\r>=q{PdW,͓ͦjA|OsqzrfUw7Ԁ6gc/\rc#08Aa\"n+L-Um\0@GujISƍ'6}g~~}\"ݩȃ\"PC-ۯep'=&|S=,TǓQxiD<cCpkKӒ+>gPb=hhsa<Ǹ]>H/\".\nGSjA:31!e_wĲ*/<(\r}\n:}9N=w#\$l F@fnE&\nEr,@0-\"zĚffza#42,LN;Jv4,BB\"ڐJOR\r' OTf&%h%^Pp\n~A~) \"0U,fn#zgdZ.C>b(rfxJz캸L\nШvF,J^d%К ]l0'2A\nXʃ*GA0`bzc\nuQӱ0vpp\ng9FML3ospͮ̼1+(J/R[ n\$kzHu!Vˑwz~xbg#H%!pǬऐLΣbR	LIE<2*Ee8T 2*\0Bg\"Z.s&VYpEq-̆_o~rͮ\\NDm	x8?##\r'. tP,u2Dr\\N]4f'2Peh%'ft@Y&OȍtR|r#O.'\$1\n@PQ]?&+wTs4)~tR_g+n+҅\rƏ-r%2+ib\$B3H+S,Hs1;zKc0Ρ(c2ĜdRfBU1RO'КtQ?%3JN:\rRr\\D(\02S5n@\\\"`{\$m5NO5^)cnF% 7X'<\$22l% ;q42M2n1/.a:bc&LM\rSMΪ2u=u0V8	\rf\r+RP\ned!/cja,AcOB\"fq,·C&>\"#\rhh&/N1;7E,mn3,gb7@K`\0V,&u\"*9*B\nZ.R<D.#\\E&gLyM=Mn3~DE\$&ECc1D<gvB>X2#BOP<L,rh-8\$\$HcK\np\"N&!0.]UHUoHcM3N\00ECWU`ƍcj,rxc\"/'>#C7JI&bKCLi\"=̵ޔH`/O-U8jܓJ0͵dMG>U#Up:%1'\$feĤqɄk\"";break;case"ms":$f="%(u0	 3CM9*lpB\$ 6Mg3ImL&8i1a#\\@a2M@Js!FHs;MGS\$dX\nFC1l7ADt@p0Qs7VaT4\"TLS5ki9k-@e6Q@k2()6ɝ/fBk4S%A4Jr[gNMC	œofs6!e9NyCdy`#h(<H>Tk7r!&.7Np|+8zc*v<vhH7lH\"p=xÍit<(íBSV3#ÁBRd+3*BʝLޮc\"!P	؄;QjiꉃzZT3{1/c Ժ?ì&\$bn>o;#7T@X90z\r8a^(\\Ncs=8^%\"9xDk#3ސHx!2(\r+lL#\n&5CtF'@P0\nT (C˞ׅJ|R\n%L!`FPdt6HI\$H0lI|P)L\rë		Ĭ2X9K|rZ9<\rئ(S~I#p/Vka\rB!{K<ǙI+:ϰY9P{\\[m\"HJŪݦ<v*3aLLr|=>c=1u]A(\"ģX&\rZot0̶HhE*:&|9n,Cɩj*i\$xp')PwSD1-w]IQzrރHo!FrRolͽn	RK6TTj;x UBBCIiVCH]	?FXka6>7iJ鍇?0,=[l@\\SJqO*D2*9*`ú̞2`] kmA*_0'P\$9%\\\\ViC7j 62c!r30c uO\0003R&3Q\n((LrS7RtrB@{/\n (fA?2GZcI Ce1cy~٘+ی(Dg#܂F9tx?w+U[(IHc'3+dtr'H2(L\0C\naH#N;bAa9@|>|FQr`&=*(bbfZ.9]hVBNbG88BRɱPN_U=Q0M=\n>Q0(%k'O\\\"894'Ot9=1WL*\r\nGM;iA#(2*LTNm呭fY)\$Wq&3ƾܒA<'\0 A\nЈB`El)(uIJHq5Fkqd,%ޛO#HM=1[4f{3!%Jv`P2h0oKj-ohD蹰!ڏ7;tctT(V:efٖ\0L9OSMbe'w˽\"ܕ\0/HzJVV=QkO:ځV13#XeԪ	ugI]\$OhlΙA:ǭƸ=\rv@rpcgA\rL@.z@%h-)C㤳Ti6MBwFW\$%jXz, jU\n!nNr2J+V /wc^\0vHY\"%jMzc'Pe.TVRv=?D9lH.\r;xmv*0 bb1!D3K*>( 2GaI5SY9##Z`j|N=&bku%iļ:Wԇ`j\rQ!RG\roFFz:ߐ2+E\\9[P0wIXyn7⠇2vۢ&{ͪ\n?b\$}>a\\{XUud%w׮_\$9GO;bk>\"_&}ɾބtCw6Uvx53?_o?:>Ɔζh|C'B9T&g2zJ&5/&9z.b)b)IJϲ,5B,;egxLl*PE:ڜ0XIMD(u\rF{pr:O	P L:bB\nl\rJ~CuBF:`B\$l*|Z=0tNh\",-В,XeýJ]	5_\nMC\n\\/1:&:R̥F߱2czvO	%b\r\r!8?bb\0=\0ł3d 'I?p1`,'\0ϣA x\$\rЭ:PCM1\$hQ ߱\"B-C	f0%wɫ\rlSbi<GLl~^,@(^fzKcm&BN\$V\rVbp!o)j4o\0@C+3PhM,,N\nZ2ڭ0nNk7n\"kn\$:x8IL%D%R+T\"pK*b\n\"pmŸ\$J\0Z˒m\"ǣ#%2LkL|\nx{.\"y0qB1N\r3bO2.Djxc7h\rTKL*BVfZLԨ0@\n 	2-ppt1\r;-}/j '/@zK;Rd86y\r:\00!/l|Y~>~n";break;case"nl":$f="%(n6Sak3do0p(a<MSlde1tF'#yNb)̅%!MуqtBK%FC1l7AEs->8 4YFSY?,pQi3MS`(ebF˔I;ۍ`0߰\n*͍\nmm0K`-Z&.O8Qh6w5m9[Mֿ5!uYqoEkqȕ5u4.T@f7NR\$Y8C)6,ûBю)ϛ\$=b6h9ØtjBȣ^K(HȾX8- 21b(ïC,7 r1kN,+rt2C24e[Qkc2P8cs_2Ѥ1?\0P\rbDHhԁ=jԜ?ʂ:,3ʀO\0@=Q4Np0´D0z4crx[\rAr3^ٶ,J(}>ы94\r |FːƍD[ o+)û\\X!xx\"r:J585_Ӱ8B#˂Xޏ̢%m<37rY>r)YZD	p#?dLK0p2\"̏h2nLj5\n3Sm.f#V1.H \nbF 9.K\"7tN?mUP2;\r{;80BR2\"H8hks\"\"^mkEͻ4\0Pי(VTKIaͩk\$Hc#t3VC\nj¶Ш.ް/#zүI(?Xs3ט3hZKOdw)􌜂\$u@\"TfgW/EᑅvO	\nXⴟOك?@{8}\0PȘs:&3(gIB\rBgN\0AQ*,9*UU*4*^UV\\õxXA0U@>2gfL`#[AV\0q6.?rNrN3(I\"XºB)傅W%۸<	-|JCh\rӠM*dm^	)Hc{\rF\"SU-rhq\"_2d18M\n!S~qԚ	;/`f=-\$B@[MI_~o(\$@zI\0((ȼ&|Ci.E䲠sdA(fvURE)&!uĘ[f>[d\"dDLсfi<)LTʡmMN&^D\n\0F%(	EI-%AgÄp\$ZsTg}G\"S|qnD)>pPìח]U\\:Wj0%\$r&/čd_SfeO\naP+D;'^h1𴆒1e[֏LIx]QX2S2́D6g)#xL0TW\rwV54Je/Զ \$V*'\0 A\n\0B`ElzB+2_p	TIFiPКX1Xk0m7e7j!rucH}'\nC[m?7r<\n	fW^}\"Tܟ,ӶȇҗVABeJ\\6W2,f#Y5RY[L*wܖu7zLux!Pn8'9rxr!//{Ew3ІZCPA\r@ݵ	.ᜅ-T^5n2!@J2Fl33Ǧ\n!GzAB*?/&]\n!@Cy3\$EUX\"^[\nan0eXn!D(f tT0*1;to2λ%,D:	ll༸L܂L'\n_x}옸'Kit,)o2jDk=)(>HL;e<VtkkzlIcCp+Ka4cIA aR)	B,eKVPȒDqgIBO|P3x{>Rӈ^CA^4_K`\$a㗛њ(u\$dL`_gmN,D <eBroi|&--.ߡ<X|\n?}>E7OWp-%{v()-دzT2l܊\r~Pp )-o\rdM`m\$\rk\r6p\"^ 6\n-`؛K\n>ψKe>!UB2bήFش\"BֻW^Ë.#4C!-+b:\"]D\rEC0sl^픦P⤐90)3Qэ,rpzehЮD@KMÄbn\r`̈́GđJ؏G	qW\0Q\\PBAFh\rjY7M/rO\0001[gupQ6a*anqbF-Q#oQ\"&lJKB-h&{\$\rjmJ#N`@1`mc/##`Q^r=\$irDՒPұv\\RN8\$<\"TIQ3m#ʣZ1a'&RSF@1\$n-za0z\"؁2_+.|\r(P-ܥ\"i2_\rHa\r\$\n\\k<=&ȥ\"jH5	n1C.	A*\0\nq~8pN\"9\$!#a^.ͲCI5TO\" bke([ҍqBdi҅0\" \r`NQ5SKB\$\nV/Bd}m(kG\"Dc;f&.L42&/83J\"&>c-=<K838GT0d?`0s@b+bTh5%>C w)l@LjOIM\rjN\n*q.l]\$*!m-r\\&MLT1\0;	?ff5XIT7m\rD2~L\$i.Cz	##B\$`";break;case"no":$f="%(u7I6NgHYp&p(a5&ө@tNHn&\\FSae92t2Y	'8C!X0cAn8!	\r࣡\n7&sIlMzb'ґkfY\\2qNF%DL7;g+0Y'qH16:]40gۈHr:Mqt醡B傽JG\n!n7S:D0LQ(Ye93^;#\":+(#pصa\0\rmH@0j&i#M|:	((@\$H-L܉ ;'2\"B	<<;9Gp7B7Nc|p!Cs69h jڤ@ c\$K&ϚlH4\r㫞0`@RBf3ЕtL19H!}%JC ^'aڴkh̴I@7x@|2KP :52հ6Cb'.+\n7-:\np7 X65P\$2WS z5x ǌ0:x췎6P\$#U%#n	b&;-,&x5R0Xc&\"'h\$2c\$\\Ah1l&^SN8!@R\"[[B̂\rcPBz.˿{n0˯9ۀ[K#l0\"*Ci!gvgI/jL&#͋cv43ڣ/NC48˺ڴtqZs(7\$VF&(ȣy`Z4&r,ѽ*3Z0\rxA4\\C?P6(MgKF7+n0쪔peЪ7qT\rѫrT	N\n)`qIS\0M1:âTjSr\r>v2:0k986\0sh z)&t\r\$j@SpP*%HN0V%^^+y0\\P^q8vhISoݬ4Ơ3`kj\0LLXt&ӈo2/iODBHrȝxRo6?DPJ\$9R4\r%\"Pr1Հb\riBJG-0f!PNL\\Eq]5ጔ(\$TwKOFoMܿ@`CaPI*ȓ\"\r҄FOEr@HZCh}fd痉w/ؙ6Fz`TPoX0B!MV(3bӃ14e(P&>/BsZˉ/tZ8i&p ƛ=b4ht1JD*6,O .bR̜r^LI݊&\\Z֭	yE)`Ly^\rntVEЕx'!M5-VҐP(\"Ĉ.PB3\rPgAjea<'\0 A\nЈB`El	~&WTyY,_Vqoc4~\rRӇ}R/͹u?	kP7\\'!PvHUck-f܅zlY\n˪aĔlVD9Рtm fm̵N!t9鐂l_`o1H(GX8Vw£B86vqiLָhzXKkw#}L4׊[9mЩA\$.%ola1h4ӗrgzf.\nYpfh1əS(R\r։ĵ4D~Ov)(^VP uT!\$\nN5}=3ǃ)!IbM9{ȽW0!.}9	-Kmdr!@FH {p2s'.dvg&ɚI85htu]0o,A117DESAIl\"vS9b)%n\rJ+PaX%skцLkƤhϙ\$<Ҷ0\$`	`!K!sՠ솺qdx#˩IR*vAlvk-~/7+VZQI]A(QcKG\0P%E^WA\nmr[W&\0د;F	}ᲅv\r?xB{]~)ʘ{y'93E_}<72t)zsĊv~;AKsq-ӿ44\nNo\r\r-me.pѠ\"p&\$#GЫ,PbdNc`,0N5	0Fn(B'kPT\r,E4&d8\")f4m(&b}-<УrM`+MEl%['02@PBׄ[/l\"#0pO\rlXr0\"8Q	Ÿk\"PbҜPMmoN>~C\"=l`'n2di|;</vZI#(CQI\rњ\rqRpϢmGG!1_0_\\mqyN&*\$5l.ӑ\0ʙ*)\rr.4 r1ӭJ)\rÑ1_=#QϭH!%\$f\n\\hC&Jb\r&Ѻdc4aD` \r1n\"pc\n:B'>f^ш*pPB_^ʨ2ô0n1\0.+@db\rV\rd!~.+)	8ܚ*c?蔓*\npz<ޥ;-\$g2f8\\(1aJî8'#65\n5^oX#lANb:0HB` ДP05\$6QEƴq	:]O;2qE3N2\"[;fCp#<\n&=B,%\$.:k 4p<	,n0\$4cllN&/?(ĔmMܾm\0/:;C\nc'l4XaZ-Ծ1E\"\"\$8ؒZE\r ";break;case"pl":$f="%(g9MƓ(l4΢劂7!fSi̢Q4k9Ma ;\rmD\"BdJs!I\n0@i9#f(@\nFC1l7AD35/8Nxp:L =M0Q\nkm!y:M@!aݤhr20gy&*u8Blp*@do3Qxe5^of!hp[73qiy7pB\rHL>\ry\r+ry;¡\\b@t0.\"D)*a=KS拎;A*7N@@n) 2Mt'5B:p6n3޵藴򂊌r7KҗP)#|h:K*#\n0	65 P?-H6FN?.Ȉ[\$AH޺\rP7H4¹92cU\n 69?;+CMpAcXxƌD49Ax^;ׁpH\\7C8^P;؃ ^'bmB7\"V\r!^00#)ʃ-Pʈ6J,#n\n-^L6Pt1x	LH\\\0:8\$⸌ωC%dfJ?)a#z̫z#zb@6[0B07\rm\" çIcC8=!ؘ]iX>&\r+@yrɹ2V3)\rètH9#_K;Hh(P:V/]38	?s 9;4}Va%Q@0̌,sx/NX\$.tB*Qlo2YW\n!9>~\rKMV#92CGc 1}|)0ҁ~2aI W\"	ȃ0>bވC#.2X\"@Sl)&6%C£<R37CP\$B\\gС#aҪC2d2HiUH~,h(^Ŕ.9\0pO<Tg#r^\$D\n1EF(;r2E:˜b4;.	ő-!\"5ÐDc@\nǂ#UZՂV\\+xeK\rbp.3|h0&Køyp\nUdpiE>N0r.\\!3X\nV\\{*VXdPCrAC)K~yq|D\$OYzKe%޾0CIqGd\\ByL)*Y7^a@\$HWB#0M!)4ZJt;DM%1?Cr)2A4j\r\nYA	>HK4|l5YP(A?*VE6/C@ЧރBtp*5u?2ΌHc&!;%CjIs3JDD`ad4BKݩ/T/OQ>[\$l\$q@R8jf\nBd9>PK|w:9%d!AAe\"\$2H-\"\nV`ɻE!SuPIR3&'LE?!5ROT\r\rqFM\\v|;\nY8L[pWи/&@\$1yAІ\"iL|zb B\n49&fxF\nq1=`!EY,l#iI;\n~N͚{ ٱ,&ZZ\\5}Ʉ'#6r\$n	TÃT0Ԓ8u\rPp|y.'yi\",ȹԂF\\v{'q[e\"/<*yIo9'^\$[%!`޵Cs5sAB#8!}'/kYb[	PM3!6[4-i8ОJ>9GĔwt歷jYR^052!K[^ߝ6\$_w\"B6M\$~cy+ع;5י95ހq'7=g[`&h[Y&pԯZ8+и\"a+iih^4Ҙy:\$a#%_L&8Aa P\"6׹V	<<(i)Ř*c&0,	FLjnbi2RL#?}r!{LZC^,<ĵwǴDcfS:jƧ\\|_M\$W\$/~D3`#mL|\"B!BtK*BMi4|lDH;?c\\J%kΌvC(x\"h>Hl	\rXKro/&t\".LBc!e\n\nB.X\r.@ObHиCtH%riĤmt\"]\r[%\\Y+x^~%q@pgBj}Ü\nB~,g&br.OgQNq*qePlK%KѰ\$D.w-\nqіlOC1Bg0XMq\ngjѕбN2v\rQ\n@	`JQo  r!b2#\n.Z+P!23!9#2l\nzİƱ\rQ6c'rg'C\$4@Z\r\"|\"l~8#*F\n7Uf&\"6\r\\)D'lHB9ҤH*X|tkق6B!`DfƬn)t6]eՍ&:.R1K\$sPs0oO2(\0uΞ!P\nNh\r\"3|nC:~5NhӠ85z9|><@#`<z8fM\0AC:k\nf͊De\$O7\$r\r3Q7A\$G%>Hs䛳.6uit33e:\r@A`z?_gjd Ic\$@4qQ1CDDE?24_E4%:'aEBĆJ>Gk,Nz;nDsIMIΙJIWHA<.6;.6RkHP᲍(4LbYM@1FAcNBAN<6M*xi/MH\nx#M;PQj49EQ!g:)?øRJ _03UFL-DMb;\"h2&5eUkU\nxf:0'Gb<; f&+\r%\0Ś;%MZ5R`+d\rV\"a\"*C\n8z;\"nˣL{XRPb(Bp-\$v&+-\np\$Y,̊\n2il\ra5;a\n8bvkx(ȴNTfB/ȶ^.y&Hv8]q!BC-:ZRؠݐ;eAI\nR<ЃP+;sl~+ވk(\r\"{6JlV h6l.[lv!&ԥnnQo`7V9^B#7F=	vTVjd!^DĂg1rFB\rGb-fG[o<Њgok瘹4te_Gϫ%ukUb6C@Z6LBط36d`y\\;CoGN, `w+HG;b6";break;case"pt":$f="%(Q5Ho9jӱ 2Ɠ	A\n3Lf)oihXj\n2H\$RI4* R4K',t2D\0d3\rFqTe6\"P=Gࣱi7#In0 Ը:a:LQc	RM7\r2tI7k&i#-ڟMQHٳ:e9al])#cs+Î,qX̸q9W|=:IE==\n\"&|q'o<qTk7N9%\"#p0(@\rH6z·0H3O@:;\nZ*\n'\0ԙRCj̈P&cȒ錮0\n8\r({c!#pҜ#,9RҜCfHa\03o.<k272 ҄#Lƹ)|6M3|p\"ʰ.sӒS j@|ccƲ/20#;#`:Ӱ#	C XD49Ax^;؁tI\r0\\z2`2&@˚Z9^0HMp)21xՃ|1Sj||i<7'\r%͘+3(Cʠ4Hx:l1pe-@ Տfk2CsS#ӥ(w8CfJ\r{	2Hy{`h	RX&dZH؋ԭrƍB\\&L_hP7r`Ha\"過|~\"#<7rV4b	#l(۱8T\$r!=/N3lpl;ֶ8:^\\?q\\O9(\r,}y1oߊ=nuVֿ+?80f=K\$B̲I\"'\\*bK2!O\0 kȫ3Cg/Ր((`sAT6,@A*4ح<UYY\"Ԣ4]+|H4\0pn.d7X&ehp\$04PۚP԰aa®BHP#8U^*ǋ,9,՞byZ]ڇ\\_;yD1vdKCZU\$:2	HA60H5EKQg8ШIcT70rً a?^P>زHy^Gc X4#	0DN#!:G9a\n ( xm͈(( yD`bKDT6LTLջ\0k9!q0X:dMQwxIѼQDPn\nA-9n.c͒PQ%ATFԌPRP!9\$o3:\\#,(#&DЛ:c]TSK)K!r<QDmMKh(Ln͉ke=r?ToB<)EIYk]3ܐKԴzKIy\n5gPI,7>FH+ڵԄup\rT\0F\n҃Xf9T\0\r16,QAY{g0P*[{ E	YK\$G\"`GFFǄ`L/hpj\r44eCdԛ>,]!0i	)D]ꓺ}DjVR꒻K`C\rZ*98ʧ}:GVנ8\n\\S0L	9AXNPAԢ7t%z>]m9&XX^TQ|A0`!\ni&'mE*\$o#xԜq84c#a;0txCFrD#OW*](mG,bcv9!kK2؋5W<Mg\$5qDC}¹	mrj9SDͻy[ี<b\"5 ,:yOg@@ kekgo?Gt6:Lc_s8;)VGEg!S9(\\h?!,R9O,A2\r:<pf6	KȂ/<t9g^_ҹ>02ϧi\r9+kRH,r'T1wϡNM=̣֤}%t@\$(4QI}n^Cnw]z+,&6 'rx)ANABGEќlc)SJdEYxӾ<Loa'^:XRmU=`_;IG>vu\0ny.h\$դq'rH8a2u#׼k8 X֤&#@dp@h¤./DLv|*C6#\$P(r'>̉o@'LD00N\\x5\0Tmm.\$΢6Nz匲%aDPyCc,͊(0AcP'R_o^-^\0.dL\">29N94;F&dJVd\$>,00b\rF/z9BdW#%Դq\n\nΎoq\$?,=\0f#d\"\rmL_yO1q\r0\0@_=\rPcb)^!Q|m~#DZ\"fo\"lHuNEZf:bmr-mhh2&SB<1w3 #Qah\$0M'\0(N&aTe9#?q\$\$Aq1mk%7!(#%`#Z &!E\"2d9O!(\rcJDc`DBْ62z2m*f22Җ=%-2+\n]5k0QD1%3LS.R	\n\r\r*\rG-8; ̢nj(6\"*`kF;f0\"cR3PӳW7\"n{ < k(\r& D\0[B\"\n0@Efy0j\\\0Zg#bnT	GԺB'jF	 `/jЏ8&ы\\r.C\"/(p#R	buC<\\&hHGF~&XGQ\"C0b`\\\0@l164Dh%|Nl~\\60+#NOF2.tuHI25\r9%:RH+1djG6]w\0AL<,bu\$\"x:m`3y>j@,.\"Q2It,8ddĥ(<E,]?A>mK'2N#+OE\0004MaJ";break;case"pt-br":$f="%(Q5Ho9jӱ 2Ɠ	A\nN\\\n*MqmaOl( 9Hm4\r3x\\4Js!I3@nB3'h5\rQXcach>#Qz4Fi7MjblLQc	NE2PcI>41e!',΢A+O_cfkNC\rZhbL[I9OvqŸnD,\\(ǵGM7k]3c/_4Iț`&U7094ÒN\"7S`: 9A9ȓ@35˄V72k(RRbγ:]\r @j\\9. \0Ф2(#ھ\"҇h(h7#\$/.<H\"|12KPĐ@+ 3B`޿~#* \0ܟD|Ʒ/@@0Đ(<\n\\:(t'\nC X\0D49Ax^;tG'r3_	\"5`J8|N3/Z燁x8`Ƽ(y>Bj :T6*\0@HMzݭ-y	z%\"+t @1*lcx:)Dc1ˡ2/LdC bkt\\n{&#cOb`ӡh(w&0I 6,'ը'&IbhJV<eT^}hb.n1!B&LS>[& މ;mCtq<jO*rc+ sd=]ZH4b#m0Ɉ^r=1Ps	q\\\rXMxe?\0#ͻo@c6x|xl=L|h&L5r|ƁW4Եh0f\r\0c2Jy/%`Ͱs5Ey䁁3U0RqC	7< dM'\nuGQ9*beV&Z+epXa(:\r>=DL)Se=^#Y@~˳)4ƯUTPfeUWj_0rY)єҎC.a̩wJ\n_P<St_\r2kq5\"oASQ\\*V%7G,80h옠d^>%K&Mv%GuӠGc p4#9yNP\"S@\$0((ऌTfdC*Pw'PmXr6J)a'>\n\$4QQ.VHHiR<sC/`IP\nOFZlPL:*a3VHl#DuwI2&伡BO:\$zG'Dy5HFd6扩T6il;D6\$BA\0¢:䕿4B:@\r4r#%>QRSJsgib[qjJ߂b܎\0'q;ywDU1ZEQ1%22Vbܢ	8PT^@- IP6X\n9O31E&+f%+TYg1fLɪ`JAMU%u\r!%&f\\zQJP .;`T<=\";v-<b.A_qAvG\$T;vB>_\$(oR)ePM;'qGJ\nFbMrbPI&7[0A;F5\nZ%&,6?s!*)Z^23NϪKQR'lhF(w,xFaN/Gԭ`Իzr:Ll;uv븼Ά\rdˆS{5%c\rd{+FgQ!|>l&\n\rqRAdޤt_E\"AEюod,*@@ jE?쥔w\0`AbCDM3a=3msE*zTFU_Í\$p\\^ˡsy!4zbTmU\$\rH'b@EMʁK?Cw59gJߦYL,PKsqݴ- K(I#ta|QhCHw{K'DlΌki?u]<ғ`h\$&|_Yc&j`}L\rm9q&jˈTloN.RݰND0;cAgY=}T9~}-R_p5eFk\$5CDmАdM\$`ˠP#[*b̾\0/O/.	n-TAHn%OqNncmRD:J/OQlTǬr`,dpqCD?drpA,ZfN#QPU&H\n<-4@PLLp~Do=0OMr%C&\nM0V^|b>r~Pz6j'Ц5xM/Qkʌq0yJpNcF81/Z?F*bO\"*-rbj-f>U䚖D!a[0OukX9fh'2\\k/ú*d3)p^OC\"Mn\0Ӄ9Q	10)spi9PNP}O}Q1plEH:1݃(fz@&0!LΒnJ#̈6p=\n\r\"pmQ#&*ȂIi \rCf%rg%e\"J.qyBoMBD- Q#rC(RI@A)ґ)Q\$\$(Rvһ)H/c'lϞc2rQ<!چ>̈́51b2D'//\r/Co/35\nk0-f#`Ov\n-bO,2R33R43MTP4 f-N\"3pĩC6-	\r\0#:{(^%&4bp϶^\$^\"0V/%:бja&T:\0a-b2jH\rl~\rVjB\rZ'4:\$}\nq&b2-|POn֖i46!B! \"I\".Ʀ|τj*31 `=(O?#2R\$ǈ\ro27aŨOC`OcbPat^hîT\"#oU;cDN/\"-jMGAQ	0ÜnNv1-:61\r(BNNC,D?Jr)NL\$m=DVo5-HI:BF!FEH0,4Dj4΃&\"X0(>4It3S1N&]L1AKN]BqFc H>Ѐ++d~Ă";break;case"ro":$f="%(uM0r1DcK!2i2a	!;HE4v?!\ra2M'1\0@%9dtˤ!eұ`(`1ƃQp9Φ㡕4\r&sQFsyo9Z&\rن7Fh&2lAH:LFSaVE2lH(n9Lf;̄+,o^NƜ :nN,h2YYYN)Xy3XAK׬eNZ>A#\ry۳qLYN[Q2lBz2B5x#𕈌S\$0!\07J;\"V#.x掭/qp6JҠDR`*	0P.B,Դ?JD229#\nH/q),#x2h2J`¸+#j\$-4.ύ/\0P!03@ΉxÂB*Έ)y\r <9)\n9oBL*;CCe\\H9`@#CC3:xouTAr3P_זXJ\0|6	23/	퇁x91:d#*:E1-7(*c=UOɇ#N&2cbF/XKҊܽ(J2~:9k,H!#H럼hƍ(t3 3j#b;/)X##,c{#;Qy,T?[ƴ3cѳ-	\r#\"1G-^\"`@8Ðo#n\r8cuVP	Ixu*=t&|\$ǝ`O&J|4vSBO@&Cg7ƇLS\0~]yhr8<|O1H	@L:/RڪEgl9Q#Z@(ؐHC0fOʤGhT\rT\\hcWa3بzN04c\0!0RP \$`3O1+\nS30\nqv)@-&V[kuou«\"?k7._u@;`V&&4|ʀpKF)g Av:сfL*%a5\nQ*:zIhVh[in-z\\tyyʧ22Nײ T	\nu`u/'BSi;`b9IWNl0i<cC9ECI}AE-(,o/eA{5wa\0уr*c1`n4yYrPTQL	F K!5B3jhwxQ<#AX`N:\r5,BC&Eky%a) p|0)Y%2lNiԒQ\$DRȓ&5蝡_[1_?	M'Qx1&M\r,Z1NA<<nrB䱫1t*qJ!7lLBO\naR,቙PZIi!TNzE)^`l5+4x	)Gݗp8W>G72RQɻ#A*gSC(kNIÑ)\\\"P!ڧE,c}a~mj8UK>IҞ]dYLpn\0ƔP	X&i.cZ\\rGD0ùxŗ%E4)B,YHiĆ `ˮSPf[K)Hi3beVi&I4\\< (PI/i^l	8<1Ob\n_jlZ0l)2L	Ab|2sHOSwX\$ڜ/%?3vCkF5v3<|XCg5.\r1SM*j8BA_iop1\nb^݁(0:|n;j0o\nq{:ʙViR^\rB(g%26[99\"_/O̎'qT\n!6IJu[!dh4a+H44-襳aqP`m:,u9&[y5AOW\$=d<u#IR5].a-Ff1œ7Zݼ;q;^+HAKHlW)b85zb7Q/GMR٭`\nGneYG/,Y阮J2`)e2f×0?=A5ۣ ̊M&/\0C\0B6oN\$`çzDdF|JKbjL.M0l\\ÉHfgg&L<m/\$rj0|Ob/m\0dCp,LdE.,б0LSK\n̲0`6#Pc{gjWdnMd{gPp\0p\n%L20n4<Mp1lq&.\\8l\nl\$&=0ҨxQ\\?QcЅ1nlp#\rql\nhìL&!L;\nt<qþ*#uZc\\\rc;^\$>%R[\n1^#JBcۍܑ\r3؆1!&/!g\ro4qj cF\r1p:+\"-mJUG\n,*#.R!!1}N3%p'T`q|;`zu(db@䉏j`f9(8|eJm28Ly,RR!rR#ь@-(#2vB=(j\"q!,q\$-b/&|AV4 !r\02\$s)2ъɓ513?2U=374T25I23^b-6D0.r]6cLnmLӁngnݨBUD-LD``9x2s/:ӛ;#i;`:Q\0Dhݤ/.\0Hs{%2uS>g8Q-dy)@Q>7A_BP-rAnR40	({[-3To\\c	?EѦu/H+F4TQ\"ˠR:&J\"\$fNvUi!ìc-GCT{5~NkZcӲ#pL,DWY&G |2j\0\npC\0hKfW0P.;Pn2!B! {*0̬@{bs|C3FʛL#3&oB\"H)4rh- Ȃ^pf\$BFJfN]5Xcdq`PG'Ή=5)Qp\rY[,>QWC[7̻*'h6Ӹ0-X{:՚G1\$r4c+g梣ly9\0hDQpx;Qb>,\$CdLPL*@c\$.:\";!\$nS6p!Ί}ƴul\n^y\\G\r3:e+!O8-P\$c 	\0@	t\n`";break;case"ru":$f="%)h-D\rAhX4mEFxAf@C#mE#i{a2fAZH^GWqh.ahhh)-IhyL%0q )̅9h(HRDLD)Cf4%Gf\nb֬{R\r%m5!s,kPtv_hn]#Pօ'[\$!&chK'FAIE\$e6jllѬ2\"\\횩mKV7ťs6PhNCh@zP<l:\n,c;jA0p9m#)Đ~ZĎc(1^Ӕ07Ϛ8ŪGHE *8C`*c	..80	9\"\\ҫZH8M\"?>jRʴvȚkKLd ģEQc*\$|z2qR*JC<h|5J~͑o\"ء(SςZ9Ԫ#A	 Y*Wzi8(vI>6\r.רOOJ/=N9w#П4# 4(B5'k֢D_ERs/C\rS,[ӅG\0x0@2D49Ax^;pÇb\\7C8^2x0cxDMF*+~%H2~\\x-|%H&RũD	pv,Q׊zֳ9@7&IK.QiP/U(ɑ	0v\nKb=՟-OzhKb?IxNp&RӋ3yRRFrhq̷\$J+d)#;R\$Iz{>uYfj[9漱J(nd<JK\\J\$P+l\rR6`Q[01#Yd+]\"pv؋AL(Zu\\I\"zHDZK')9U[A/J8pLDhMstrm4jSiLK-7g\r3Yv 0I\0IE.^l\$@)yYedUmBdZ&Lrɒlm9BBAN(U-#@Xd?7'zKpsϤQ'aUT0OQ	`tIҐțe!6U\$Fe+bJpQ2)q1%)h)ҥɔ4;-鸦X\n AgdŁnO3CgYK0\$Y9M.ET>D#VY*ҔQtFgptOZ@qtk~z\0,)Tv8Lg顋z\nuD3%u;?aYEfǕ08<e̅0C1ID\\G`68psH3fݜzChӚ/7m#ZkKGj]d?B:gNrQ!Dr\nf5>J^!C@Z	ܱ]d S}43fpΙ>h\r	v,Ki=Ps\rE6oL/':k<CX-VYrE&A4ED|s)_AMC˖M\nm;53 \"ɿEʌ)du-Yv!˙*ntbdƫ|59|%DKA<v\rDi\"@,xz|-{*(31N=Dl#UJ\0CoǚAd2d1Mm1H\"?(D%^zaK@;S8M4՝\"2%`%E|hAl#ZW-b9bf\0!0m%KGƨȂsvA]lռf\$T9m]m	⬚9&}d.[B}˴-cF?Uy4>rZn2\\Y>m~~i6A.jdo%sH (!5E3UFPQT|r_%2M Hck#83&l5cLnSƤ[]QM_!%E0@PU'Uh}; zq;,fAnɢP<zlU1qzNՊq1<aV}~Εc=	^TdoPcׅ,	ub)vFt#HMZQzQdǋr\rS?XNQ\"\\y9Χ,G>ē&G鿙;d&dƮ)o\"FԷdwUg(W(D:_c(h	nȀ	\0)ʬGi,V|@t{\"\"DR̞|n j\$(kfFӯ<LqFŔ?g20+HinGG\$D.E썦кGDЮz7OSJUprϢ-P\\B^uhK\"pq\n\$ձ\nG\"qŪQ\$Tϒfo2\$jc~L[zpbyBp34wD^k>g@@@,\"g>ǰ\$\"iNJ:*Pp,8En~)'|PTȰɐ&-8MhkFsF\n 	~\$9hшdͅbNivʦo)r, GhvV\" wFI#*[pb#*.\r\"GB*McDRH*L.w2Zq&e\$(&¥'Oʞ*q\$I;\"؆6&LJԉ߲s%Ao+)+l>*-+í,\nҴG2lpl#-2}+j().R.,h 8#%c#fo#E\$=/ )%1=1G!S\$&=(;/\"+)5%C2E#3:NI\"dGN3r)\"\$_XQRxzī!\$Y&\0車PL.Cq:\"#3\"JB(r\\fqķ;\\(,+;p+Q:4.E(,bu?Q=RP3	g1?ji/Qd\0Or}#	ŔxHG@NMǼ;\r>|bWJO(D0%3!74^F\$	kB.D\"]]\\oQu%,K>81'N5BĘtLL,;>E^A.eVtsK\nLsp\0'M\nNΘb?'t#bbSNiB4.'Q̮GT~d4/?6-g f2tCF4I</TU-T=&sCgUr!7+b)&mLWJTUAaU:;U+)R0PL|Ru(rps.\\L\\d_uOU (eB.P/|F\$cDg`V\"g25(HPLt+P!46Y14TC]S]pebDZ,S60;AtJ0ҷ1ړT𨵏[qL[֡W֥=OwjB+QA	ll!Jkя/jvoo[hS,:WcYkmd[og-/W\"r	`U Ǌbf8#Uрc&J1Rmj+UOZUʦ=T'v{U\$v\rqwWeWTwT'h%!?'ԋrvuWξoR	~cWrwz`Q/0/-\"UMaxAjPf*O+cUvm6\nfscŠWszƌ;7\rYqϗg771\r{D3X-0:QCeylU%+#8EyqFǇ|6߈ekHG9SWQa5s9mW88&_eI?xm]x6(8ӌC)_x5صiu\"\\'kQ}\nPnGwJ݅сw_wo\$ނ8xP\r\$^;`=v5B9\nn2rXRru2KX7o7Q7U)!kKukoW@-3PF9Sf-(u1(n^uGf[;n'u;I8ri\rVSq\$*E	!Ïj<@!2l3`CdC[@.\n\n0&(c,\n.\\ZH'_#\$a:O[mGS3qLӅ3ו)p:y;1-('y\nfkm)\$g\"nV@AF!3i1FBMWI&\";6UPmT%4[	WзbvzO@6Cj+:V24&;*YϠ[2?<')eJ;KAѹYLÊWju2Z@I\\vqv	%-C8x8kb\rP«dd@F-X#Uh_d:S4O7rКt{&ꅴ]\r9i:+~P]BNpS3hpg咅M}'Ix%p!qthTռT0A";break;case"sk":$f="%(](!@n2\rC	l7&P\rl25q\$\"r:\rFQ\0B0y%990cAn8yj)AB&sLR\nbM&}a1f̄k01QZ0_bԷ  _0qN:Q\rA n4%b	a6OR5#7\n\n*8	!\"Fo;GA#v8.D8ܞ1*͗ə\n-L6la+y5O&(3:=.ϐ@1xȂ\$2\"J\r(\$\"<jhBz=	1\rH֢jJ|)J	F<\"%\n<9\n\n)1P),`2h:3. -\nn9fR<ʣ3\r4B@P7[0\$Be\n;\"@ؔnC\nEXEQR# ں*lRVR\"(C,Q\n`@!3:xc>Ar3 ^8HØxDP1̅|TzU-\r<!\n-5	\$4&M'Nȫ0xJ2:8;997.:2t	rb:J4LV93ٽɂ\n\"cp޿Cè5h3;hX!|:@P2n7Ԍ='J	0:Pyk!\n{t;S\rfB'40[\n\"eLc:%ȳ::uk\0᳸Q\$ݼ}QR6ᢟetC6	!BSOx6;<x]:xS\r۽Tl*0A*5nh\n\r`䎏7EԐ72:P}\\?*MjPd6ɺ#Cavj\n\$&Jjl\rq \$!<2)BLb<DKxk20sSA[&BTK@\\b[;¡[.`C@\r2Qp.hM(RȢJi:(E&!5&-è!#g2hДtp:õM*#1]a5:#\$/5 NBUB^+倰\"Y)P,՞CX/ඁl܆WF5,_-gm##=ʙ\n=:v=aѥI2.\n(=`J5vUXkcujK@10^߉\rin<0LR-PJ20M.FIZ\\Rac:!{p̽;FLĄ \"4޲*bfҐS\$VC0t	Ze~,i:>HK̎2.tBrT#e\"(Td-!z)<Xp@\n\n0)C\$X8 Ա&*rBL*Lth\$f.j]MG&63Jq9PDBih2*:q&dZaIΙ8AUfA\0FQrvlMB|9 Fz!&%#3Eաy_%T=Sk/d܂Go\r1l&NYr|,ɝ\\z!BZf.(S\0P	L*/@\rǖbk B7PQS0wZOtR\ndP\0Sr\$<0(KfRCz,(!*I+'DfCvMnB.jɤQ5يjTEJt͌r[aQe1\$a44tؤ6f(xOl9\"^ghThwBKm^;LCA)Ѩj(BҳwJr5NAD!L̬ĘB)FO&\"2uTu^\\nq';L\0%Ժ\ndm\rG78<u\n;l&v!8MFhLl=Pȝ{^`S} xMh^S\"\r@(!n	1gOrG9?Kcs'!tpTsFmHgi(\"i\"nT%R2H*#\$U#G8\$.](e15ϼ\nP 0Cs!f<b9cRY^/*̈0ɌĎ0ΓV.6If.Ev mjԖ=qr{Mjm&Mɑ\nGa\r\"t*/LVZ(j錴0>q2_J\"AYJO\0n\0]\0l&S#4eB#'_\"ðᢈP*R#(tRI> f!5`CJNf#H1F\"D^x\r/&@MFpd]X:Kbr\$!`,C\"^&cdCP{P;⭰#zψ!dKiBB^0qй\$>yp'!Lh`ȻJDpLM.\$`- ,ȅq\$'nOidg^ml\n.RaPMPmtA=Leը|`e]'3PѵOklg1+gQzl\$4_,.l%wQc2Rl! rIB;!%r\"֪r(|΂D\$,T%&RRl9]'c \rFLjo)+de!'/Ul%f9)}+jF\\Ϫ{тxl䌌\\)c毤l/*JJFBA%i'΄jO1bnpn^ebNDdg 2],\r&.A3R(M3(u2M:p36Wqysbby\r}(bP0Ш'6IL7<š/ct?&jb	b<\$n@Ub~@.o.5]	<23#p'Sz1!suxƤpF>RCs#Mz>k??r?:o+\rbjEjK53l\"64H=CcCSi\"PtPvABT	8uBB6dUR<=dÑAJyfsB_=Cq=sj\$47?DRԔs7H̘PK%C'30R!C7sGKa48mnD Gd53\$ODgK<NOdO]=tOa}(4C#C/<M\nNmL18U;r\nc%_sTB\$T\rE\0u\\I1.dD\rrN T3WIcl##x\n@dKc\r 5F5ka'+@7BLIGG>FP+*RֵLfc@\nZ6q!\0_E/\03T0\\'_\0RHc!D\"b*i=D&\n6M7thB6e,JiDҀ.òER#y0\"9^	\$ABrizA[j^=&\"K2-j(cc7G|-kpі8gsl#}\"(iʭ/tiv 4pl>N5b/!n9.:k 2hq;4b߂q6vqrр)XJDS,7@\nOEp\n6:-鴕08%`0l'{gF]-B,Ӱ6^U)wcfަ=E44Mhc\$  ";break;case"sl":$f="%(eM#)@n0\rUi'Cyk2QF\"	1k7Αv?5B25fA2dB\0Pb2ar\n)Ǆep(0#Upz7PI6AC	laCH(H;_Iуdi1ȋ&aCl2̧1p@u8FGCA9t1f\$E3A}kB|<6?&Ʒ_7K08ʱDы*PIFSԼU8Bҩi;L#.}Np!7c2\$B9#hXϿ2:V7(@	T<ˌ R~:sj Kx9,@P\"Ȏ2h:IDr<C\rk86\r2<+1|\rn%\r2c'T~9QJT\rH)52H2\r{>Ki1l7V>/@;CA+p9Xx(C@:tT6ʈ9X{90^'a926cH7x\$NʫpBޡ\"3 ĵ\nj#!6mB	|5qO+ĒM_R_\0ӄ`#`2`P'B\\.,ɼ)2P2\nsS6&yH:6s־ë1S2CnPi%4+n\r8&A(R\"\re9(*FXy630k7&-c\"n4spb1Wr B\nSho<;|:+;\rF|HŮk\\}\r.n'hHzEpdid93-8ÑSM'LBz}h<#tcm[O Va1lln2\\\$Bx5,7v <0fe缂#(Hڼ*S*[bg` c1XAϨuqAaC	َ!}P5JJUX+%hy\"]c}*yrJl)@Y-!ش\"	ȏBEnT	@b!TJS*Tbx9+5j߈\n!#H\$B4ޒ\"a DkՃE8rTg`!(Faє?\n hHC;+aH@18HF0SDH1FBa\nCHhB]yIب 0\r+Nf\\̆Y^YO)?%G*HXXECND!8A*1\$S1:kdpFX,B%/F pt\$v8i\"HZx8	'І2('T@^,\"N#XY<3m\rTQBYǴByFHc\"J:f0%hD4XP	L*FQح5P7\"+BD澚XrM6T1@܂` x'IaB\$2-nmDX1cvFYVʓ	^Z!K*:<^	B	]\r̳kqEMuDҹ1\"̍RM\rI9Nǐ3<`LT1ȦrD=2v@tU,!#vFP7nj_Y݉=uc&%vBsΒv`G\$L{`o68ABxs\$djlXTtF`:<L!LB<BѐH΅S jČDm0eVS.R:ul{!\ro͐j]Mr_HgM &iw!fjt/RK_,{VlKVK9zY:I\nF^]\nKmhiy1*4	%,'`C	\03s3Pbu\$oc0E0\0002-7_z'zޑI=U\\O\\JޓnCyƫ?RЮ1qxZ[~#C\rsY/5Kr8B8w602r-0\rWgۄȜyyԹ&E.xyq<.i`}ê[^ku2j;V}\$ 'vIHfB3=M^Fݏ@M_[XSrH\\G	dIy`nL;1tMn (ɑ\r϶FpKl\"Ho\r%z8xnCH[ñp{1ÀbnU\0Jsne̅X2+C\n=yBZ\\FB%ŢАK,\$ږ\n	-gn,H<IILF;L̈\0L.L\\Db\0l1	0!	\0Xr	}0XuPpԉB\\%9(8b`Nm!q#	fh1n\0\rpNbbANWnQN߈<-Fan7r%\r~KNw\r0G06x71*b&&b<Chў0(ID\"\"5І9l2KbFxCj(%Q̔ 2hf=d HH!%p&E,`o<7\\Q!;\"#qt\"k#-\00020'LBM\"Q#I%S'm6,%m%#LBJK,dc/Vbg&i'\rc\rf{%-20#Ŭ[#k#pgdpNK'=\$\rfy2xZ?B5]0̀\$mO\nS/ i#1!1+1Đ~)0\"bC	ү#9\rp,4>Iff&@LbR18.ɶ\"(ݳS6W6ʛi6@fhmbB^@#-`\$r_:9104;'<d>M&Dۓ):N/\$;;3>\r#,&6B+i/|4=~,B7EC{BlZ3q3B\"18\$PX@)7( \$oTR2Hnk,5ET~.CCt4|䞄\rV3nIxDDʤ!\0\rT6\npz4//'1\0TzN0WfQP\\'Qj\n_cX\$¾@.M@4/5j+Tl`\$9*b-P3`hj줁>Vn:& 6L6E .A٭ͱJ \$4mu]l\n!Zn&RΉ[0323p91@\"e[J2\\hBdZpaRu8\rb`v@Zf_K\"9ZD2ŋ)lP`E	]SF/ȹ\"cfZ0\"Y24t%mh\0p/ercUJ@2=0L\"d4#Oz`L\$";break;case"sr":$f="%)h.i4	|Ez\\4S֊\rh/PHPnv0G h\r\n)EȄ:%9>/M}H`(`1ƃQp9WhtuO`J\re;ьF\rgKB`X42]nG<^PdeCRFtɼ 4NQ 8'cIg2N9d08CAt0ոD1%Co-'3Do8eAZA)@{b0*;p&\0\r#p΃4\rY] s(>X7\rn07(9\r\\\";/9 踣x:Äk!;ƣ\"N\"\\:C*	zE<E-¶-н\"#JҐ+d*{^@51DK0jF9AhuPڬXD**L@2^@-8R6U45z'QƎT8ЧVG3RD=Oi1 l+Hc#1#*3ݷ,r1Gn 40T9`@`@2D49Ax^;ppqj3(#&\r\nѨ#x|2\rGYA,¯*77ҰeýM:	+YJ\"oVˡMƦۢZS:'Oږx0Cu悄\"\"ѽHiѻM=5(T2_Mz01 *jSO1a=b&0d;#`26fH#IKCDj?3N%Ѱib\"ˢpOI2k+Cf\$L4#L[/_bE-Fu2٣פ6D*zk0Z&JS/k*n\nTFyY9j))I\$/L*/#O ПhM`k!pt^ck&jǶvԂ B ЉB-S]:E`el,:VڻQlA<tKs\r`eD+C7;ǄG\0@Qn&GC\rɛG~\0\nsfq<D\n0A\0uawA\0l\r\n6!0nh0RV(%F&O.\n&b\nBpKd\r!r0kb,Mv2L}5d`NhY[ycE5HlKeW\$Brji?kJ\$vv%dXZN`&p0 Ęcݍ1܌sd,@H)	<XI\rD#\\vHC[/IOSVidSiDblZ\niuh!(4E<Y _a6\0q2F\$dҞʩX:u|!emZC.jz_FL,	@\$dR\0e99in̒xc3NsNxenI9Cw\n;\"L\n2gRs!\rZdFL0\0W q.&`m;\"lgb@#WI F)bkb!\0\$xFE _*Н#M	\n6M=k#u@(4!*J\$(uW\$& ӤË\03#@5)r伈1ʤy`BI:UJTGP	L*Yc1JJ;5y,q&-(&DԂn/	cE\"Q#\r2`,p%t`uS^3\0e1`innA2vCG\r*q&]<(^H܄P*[WB^4M\nm0*Lg! +c\0B`Eٻ>Tdmn\nXdba4\r!N-Ւ5aY\n`k-w:TBc/f]nxflFJAjLfsMǋrmNo,=7<OgO˄\r-Mΰ^Gubn W4OΑhO\n\rIp2ZlOV-CJ!:\"\09Q'{zl32g0\$dr0s{!S1HEN2S7#CЪ(Z8o&QC#!%|F)fRWmG	>ᠨvI8\nu1\n_5i/!IJ8OT7F\$s/,0TTJ\" @rxϰwbKPSZlm\n`Dm];Dzdn&@fj60vfʂ0dJ*LBh.Whb`j(?[\0\"+\nc\r		20	/Q\ncK0)P,RF0\r1)K+2.XD-ïh*ȟ]\n+hK0W-neq9	q=	E1.m3\0QWT%GLXh!\n',%Wtk0%?MXhVqZ*M#b#AbV5C|N.\"P,xexN@x0QGL<C'ox̀>f1	lk27n#\nq AC>DމV7,|tj2F&ŬI'HN0]&|{CD (U)gAA\$4%`xwޢmK\0h1rho\"/\$c^Βx%,.g(YPTW*h hXeQ&Rr')+U\$ܮE,LL^6D!(R'Y52sM(!0Z+oP9'16Ȇd|F6A82'cP?U(.'ĢK6F\$R>q%FЯ3,bƣ;0<Gl<1_==S*>0=3s2^w6o)2U3)yA{:QBBW)wzH\0Q/\n(\rm,Nfx\r>R!>p`n4}>,TbrM4H,TO=g.\"Hqyk7**ET|t'It*x Ϥ\$4X{'/G#\$=gpg.kC6[DO8nkB4-|dD3h4-Q2?PR>5/7%Rb)UDSPu*yƇ\rh#sSL6D@\$\rʼ[X#'i\02tS5\0Y?CSAZT=rQt(R\"uez7	6ua]ΉDo5֓lN/#Sq^3՞V\r%^OaBwYAU&>cd_QcbhpR@T]HO`ХJrUOGkdE-jofpt*0gghnʏB\\'<\\iP-jbUP)vdӗQR\$\0vOmD k\n+YSDV1buk2HK¶DO īpdGl5akTZ5>;BtƖUsU_N\$2oaBPwthݓ4hK]tWS?XPB=_iuF[%w7~LuK>\r\n&@<n`\rVV\0A10D̖F\0\np)-P10\r7WutmAB\".0fY(և	\06CSpMK/q\"1|R+&b0`#Q+9*u}BX),(~4+)GuoYQ+)RQ(.B.sD282yd2Kk8'C;42%'XuUNW{x{yM#bJa++@tҺ{\${n4SK\$T1@-4f,%p ]st=rĉAJNȃvzxfF';%\rz#ΫS0W`ր9C:L\\YX+ՉHx";break;case"sv":$f="%(e:5)@i7	 6ELp&)\\\n\$0s8t!CtrZo9I\rb%9iC7,X\nFC1l7AL4\$8uOMfSt7ASI a6&<b2\$)9Hd7#qu]D(ND0(r4\$U0!1n%(Ɖ:]xId3O\r3Dpt9tQN!ݾr#-+/5&d~hI':4Td5gb(ī7'\"N+<c7\"#̋죦E#μj(\n\$Crů\nL	è63C7M@=9<˫!\"\rh8C*҄3	#c<H<*)C&p&?,5ñH(,lD(4\r̫2\r:/I8LD9]!>JU\r?\0\0x\r0CCD8a^(\\#szJ;!xDlSr`7^0z6\rMK\nHFc:¸򭐖.\"p/-7`Aw\"H(7в&WO8]B\r6rvF :R\\c\$95Ve5B07ZcM#8.)O\nU+.dv)3X2o0<d(腧F4E6c\\E9BkL,mn[Tʂ\0 M4m%9t3I#8	#hᘹ\"(Yz!9[,Z6m,05A(6`\$C=20\"f:FQMv}ϐDKre '3@RN&M\r\0چ.Y\rǩ5J\\gXÓ['p;t6Rp	υWr}O\$C}ւKCX\rh uvC~P)=AA4\$,lVgM		RLU6TTj;xhUEVZ(bl*c d-?ޚPB\$ :`#:b\"\"5#a\"q#Tʢ褫)1[+	\"()1ؼRAo@>G\rQ	I7fi\r+ 93;R77/RviA\re(aJƝE ȫȉ~T9B9'.mzȌIAƤ\0l-82}d)@kH.0sơ3<Q\r0˙6LqBD0\"AГˋl\rѽM?7	u҃#!*ca#,d% nQ\$QFL)C\naH#OX0 qahzP!^9Xšdʍ!x&)t'+51*TBPՒOK\\&l+RT9aD3U&tPAOMI`>HL(eDa@'0Tb3 <*HQX-s1}G Rd=?`I\nmX \rIP(\"Ӝ%=\"Y\$3	N@2v1dő;`\0U\n@\"BI	f^p@xR\nP p|_(x0PD[R,.vL?cGL1hp˾\"FF#|9dB񕦖おRƭ'g[= @9h2w\$1+<X/gtXdH4gmʹu/&n))|ҿWfay:L݄aq%?RKxnCy΢0meqs5ACPD4Xd\\V0xb<Cv\r,YgGvFp,ɆT9jAhd֛ei	hG*E|18W()(hj*>\"-8^)a!gҟwhS\ny#xTDȸ/\0őUEd=|~b1\rPs~k˄`s0XN34K0cxi	Jz߭[!`\nzrPIYlᄔ9p~m#1Fi-CY6̮亩X%Rq5529qqY=yJql0emÎC4r\\qJЖ\"wY8rijcPӍ'\r3\$|3zhoy=1F'0F8!%\0&L3n-^%yylv=縌lYS	4<MIЃ9\"\\.>(W>\\w1?y~ߢ{#ߛ7\$@:R	nۢ`jKH4LG~0vi(,N\"j\"mf}mƏc0HN,oDϔNMig~`ZibA	p?\$lBIؼ\$L.9@=ÌaJ*X\\'svԭN5#Ռ5ϒ%T\\oF[MBo1N\0N1/\"0#\rENРPv\\?,\r\"5Ji4\"mX1cqO%g\0001,[Tf8d:5.¾;#cf:X6nQbZhĪAjJIlDJBPK0i~lLigB\n\nj\$(.Ep^`Ql#\$nT2O!.O\"r\"#\"mx\"HN&\\3~< @؃1m%jRc\0t2m%\"rR\nr}'\r&\r\n=\$dr̚oyKR!Ҫ3BRNH[(@>c\$=x;\"b&dH*Dld/@Nf-\\%1^0eY+W,Ns0-*2U\"f\rV\rd\nO^\"kH/*Ǐ	\"&> p4\"O.ƀҺ6z򳊢c1x\0rq/(\08fR<A;%(^8o!DP+Ŗ	R0ij%Q;D@\\v3<^s.P@k\$15ǎƇď@B \n!9&&2g\$*&B43[De0wJBpnϠD&fK	͸'6=(8dMH<bJd/í<7>P\\AAl@,q@odrG1AF\0U@";break;case"ta":$f="%)J::u>8@#\"\0p6&ALQ\\!_ FKh3Xҽ.B!Pt9_`\$RTmq?5MN%urι@WDS\n4;(pP0cAn8U_\\dj?&JGFMSIXrJ΢_'JuC^ʽp i4=xS/Q*Adu'c(oFe3NbNd0;CAt0l,WKɨNCR,H\0k7S*RޢjMY`,#esrʢ\rBB4;2)(|\nD@\0P7\rn7(9\r㒐\">/9 ;x\$9X;̣#wI@k6G\"I uW(R0,d\rØ7j*+]!1%n,Lk\n.uHY3V7drڱĪ\\)Kz0\\W+q1ezwv櫖J)ӮdBH=Ͷ\nZ̫kF87-8l2=u@)uLWbDh:a	;@@<orR\nh)R_9dMtFa@6f\nMilƪl\"֫\n@ۓa۷J*4I+qj8Jښ#A5kEy# \"LA8;:\01oU=\"t1Mn4039`@q@2D49Ax^;rW]2x7=ϡxDlȃ464}?MV=*bZv±SXUU+c0_Y䀫F@2x2y.lP*V-	VdҐW!7\$@AA(dE͍v#޸zi4W[U5\"jW`=sͅKDav!:WƵ\"8/8WunaT4̉` p;TAAe+`:i-qlRH'oƵ\r]t]R}KU\$x{l9b\0a<1ܐBL%z3YHFF\"HsP2ƞB*GP+\"N~ZCꗏ_FygF:c\0rq	GdL+Y03|.cCW)xuHt+402VP(	&;Hi3!ѡtAO-_RMו\\,A!4Ltŝ3V#zHL\\xavL:XݓA<Rj3O-FŬJϴ;e2V d2V\0s7pb\nco66vfD@@xn (6ރ4?3@v5ZAwHO(`',[rn(Тm6ҵi	H\ni.tc{Di\r!ܫs.mιBbfu&yޤZ\$f,3b4ץ\0ٕE@-\$+54UUW!\nyH	\\\\ba44Nn{ra9<mWeӇ'RUfS;JJ\rJh w'bq\"ekqeVy&\n;Bzsva\"A{o!K쌘YCٗ a` 1ldbj3%j[\n+*gDW(bCz:F.Kq,iQ\na8{<X\$ti.þ?5r(2>\rG5961;yo Gpq. }ChU9f3\$7 !0qU9@xf\$k/U).Qʿ,Fh\$p{	WNI&yAq5Kȝˎŧ:Ԫ{Fxi{񲍤+9Z*N\\錒)*_6Z}-QZ<eHy:=nL8Zp m\r)M8n<F!UH%O\naQV8ՇAJJ4lgg~ȋe~k	hRhE\r6<;Few:Diru0rRJb)ASdq*i=M;q9\0Asr(*ŧz%ţSUWO	*\0BE_@/HB=a<nRا(vpbabꀍ\nFLM\"f摥p_/ҧ|knxGD*X/^[C>!Za.)jRjnJ^0:ㄘhj	fȮpx潃y̢biHtc	%o4<wԌlG\0iқ\n<hd)\nb(Z+K޵/g m\0?CdVj\$\ny<?\nz`鍖 t#L2*wʨ`fɹ%b@%K舲:Î9NV(\"J\nG(r`\rHp'p ,	 \r ʖ4k@Ίmm)P6\0jV\ny,J\rȄ\$\nm4@´l\n(\$<)qP7i5gL-\$\r˘[\"P.Щ\"m6dI')\"i%2N)0Z\"70J^`ˀ\rb\ng&>#rV1 7'/@Dj\nRf`3(bc7+g\nD)!AFm\r%frv>&HQ9)Ҽ1(b	rQ`P,am\0PDj:F#2bO\n`L@N\n\rp>Dh:O1*\"B2\$la\$!%00I0\0]0O1\$nе.L'RtG|жz- \\-_99E:S:~d<92НӣS9pURB\\2=r2Sn,3-5\r-oBs>H43Cs`I\"DT@.OE,gD3nQ#	p@L\$ViJ(&u#IRE\nOz}`\$%`Rxo%,G)\\bߴ}\$#7\r)k\$S\"U6`3dZ1UMn\\bv|`\\M-L'R\nS=KnfU\$|Sb;iH\"`Pc΁fH&Ady\$79\0+jrKGIK@dIOtN.QSMuBu7s&RXFDԨiUsH4vxռtu;E5cE~VE__TU_w:\0Tu>@TwU9OPVrЉ&/(x|XuG\nFLઃ0AR+U|tv6e0u848*v6l\r+_I]?\0,'h䰩\$Sb[v;ij.5m#26\0,2LGt3t=q0\n]՟buo,vi62,?lpu<W꒣DZYpV_yopqs&s`'tw-4ab5`acTY(#vbW+ZWvԚ5<Tb(	/cbl*N!zp5TmN78>u?3kN6OU<#{\nYwk,EtY=82]}_?T+KrT*lt|er`&Q+vrXb贯J17&MpaJsӌ8+vիw3yTЪ])7v&aO6##4^5rQs\$V5_p\\ͪMl-\"+I֤	]TT&b_)uB!\\3Piы\r=I?)lSxs}5@jc3V \"xkAA_z5QYMS/yn؁+Rw+G]'!\r!Nk[z6\r|]oՕpcx[)!7ۙUsgySly{yJCbjAR\$&P\r5krudC0y՝e\$LXwI\$P9h9#\\92ل;+K%ʔd:3V7VupFՑ\\d-I㏦5NIiEmVU].xyuq/ZuW#8Q)?tYpOO=G3y2SYJZA:IDk!ZsRMk:Ԑl{^|?8WfGZŰ%u	39Y;;3\$[K#AjIX%\$cKn85xm;yn\0ˤ٭9:ϛ\$UV{;J-m[s( (cMmuff5;=lɼR\r{ý˼5 )@)S~M:yV3Gk|GҫM[q{;)<-hE;]yXNěl}[7__VyADdk a\\=^*Jѡ+1\$ka1sPl\\B	ˀ):2z5x`%0YiEEGWx8Vq}3eqQ/\nZ|)NBB7aQ\\pTD#g(,(9:	=HsDmuN[.u~0[[Ųh97W֒ޅ\rV Ӽq`@phJnNlۄ\nZ\n=HEkgɽH\\^|>]s;/7סZ9Gjܥ״]zcʚ\\-\r0UxC&	Zwg1\rSɥpwOWRUO|{f\$x{w&T[|;E)rlrf?qH܉nI~sL~m-Ch{O;]\nJ\\(QV}5\r6{¹S#,SKU\"x̤|>a|e=c;L\04 %^~?qBIQ/l>\"𜌯)(dH،5ϰ7PDvج5jFM @&W׸Q`ZwCUZɉJ	Hmqf=)\0e\\XN[' fHd*H#zȗY)uB&!΢&s`\$oKx06Ɂ\r)hR50%z	j&r!j]·\$\rh\0&4@S";break;case"th":$f="%OZAS0U/Z\$CDAUPȴqp*\n*\nW	lM1\"T!R4\\K3umpPUq\\-c8UR\n%bh9\\EY*uq2[S\ny8\\E1BH#'\0Pb2as=UW	8{#+&\\K#[[=-O5,%&ݶ\\&TJ}'[AC\\k%'TLWȽg+!'MbC ɼ 4NQ 8'cI3@:>2#:\rL:#-ڀ EM˘a9~NsL^\\.-R\\\"CCEÚΩMR:()E<)CH3srR7!pbLB5ø7I#|@9ÄC;\$(θ(34#mSAJsت,pA\0b)>֪m/:\$JR\n;~&uU*9l\\S,?#NDN\\MGR\\Ə6\nH#\nj&4ŵ̝{8R!*L1	pNY52-SR<+/օ\\f)i_H.!؜ϊ8؅P'VŶeJ)7z)zx4/cWzF7ȢR2\rP4CQ9P1#3>S;0cݶu 9`@n@2D49Ax^;pðlS3(ѣH\r-#x|:RJ3+|ΩɃX\\铎TKS{a2I7=nzfLÑnW쳺\\;`P0Cv9A(A\r!씂#ȗF1H%	#ʜ#.IGgu/4∅*d!hO	݄ GClP0W]>[iLd&h4bh#2IN9ZdAҬ0WEᄣv|(MJ~D׼P(gtJX')2@\nI(#C؀ЉP0 A`ND0ߍmDGoedd[k__;f^S\"Q\"@evd.%aJ\\5`x-	<YxBB\"tQS;Ch}*\$^hBsa1tt:5[Ta.Cv4yh >X@-,\$II:3D(oGdan,cbBUSC*py֓VC417t0tU(0pEhih:PM;t)BP~/\$ŚR)'PCKnIl5t4Fq=ȹ7*˛9B\rт }h][\$)H FtW>+pRr?MjѪI)s7it:\\Zp&8 䜣s9烓tN:*Oi]XI\rD(IC[Q֤_u]Ya0<̩䭮v\\Phݰ oC#0ksptFCJ@xT9پҒv)Cm*jȱ#\\+<eTvd@@P\0`V%N2yeQ(Pb0s@g+ma po\nL~l;\$HƠlzuu	5(sA7\n]3J܀ H]n8=cJ\0C\naH#@\rj[@3џKrZ.0\\LNINF [я@[,[\nBKBd69#; -ja\$MDEA\$d,nPÌ73'pao3ci1D@<DeD;\$f=\nE-\r4\n2\$K(\0ުdAkPrDtsq'恪nY/3 ?#L#_ij.(nzG<a2E~{ ŉU&p \n@\"|?&_YA<@/Qu</xތ#6hYl\"W~ɓxdd'vlCYg-?047ZZl#j^)mZ<lO'ߗfRz̏Fh&6/|e5)jEjiTD@MGa2NawD\"~(XI4h*ȴc'@\r6#^RWƜ͞\0FD/\n`HpK欨pKx@昉͞JMGM*+A\$Ǌs?POȾ\"\")`|IF^dCO\rv-n_DdH|讏tdNx0ͩr`qp.\rbz+3V&2,@c\0dT\"JHog,xhPZ*1xb:ͺirZHeeEE4 	\0@0Pg>QmΔڎ7mDHp;eDd&QڒgV.g:()\0>9OFN /4a1dDeaJ';\"\"BlZd)\$JF	o@NfC'E6[5D4.~/!b&WvB~9c4NdN	i,D*D{#\$yR+H;hd\$pG*H7I'(00''c^dOE#%z7ض)6I)FO6&Ԍ&G4XJ2k5zX}KhѣVST87U3xU3nS:bBd'48-0p87:BO0\$g;#d]Q2.xg\0NX@~'+Hc.'甍̑jaG1<C6\0gW)B/Ue@XӼZ=0\r @==As=orZяB;.;2-e/gqD\$(et٥~sDQ\nTz|KԕHOI}lp*o5e7\0\nLSI4LnԏctM> DlQVƀA8#sN21!\0003MKd&jZBb%FGHOtBYPCCR̛/]m<J;Uc0%<lDNnF	:Y-IXPTKyT{:d_31CCncSFI:IW\0HYéENO*EJudT7Vu_X3W3F8D<{OZ4H4UU\rNKUr5{'RT4cE5-uyHIRu\rSe72dCW\\\0h)+Ntc6-KDagd2udv}vq^/h1V+gR(8{U1Vc)ֳ0T:p^Mbgdp^\0e(/Ή֮VS\nFlS%ӏWN,VCopFe69TVJ[N	\n\rvw]sc\rkSssrc?tS6& +X/\\4󰢵sd\neWr5?iWtM1q5tW5Vzsj73hTJ\${{֘_|lcsyqeWޏ{}i;a~!UM,i1bR4Fbq>>@tF>@RQ,1(x@׃%r\0F\n0@_yġfUjhuX|{W+DXuR9Wr~A_o8hN'eȏ֏o6C'Q8|71e\\5Ed FY)	\raȴͺ\"`ļTyQrR*{׃i6M/dpa=,CpqLW4C#EJ95R2\"*~Wѥj\rVӃor_/4E]x!xj*\nZ\n:n\0KrQ!Q-%Koi.NLE`3&L@\r\0EB<;éY|L7{hOU9uA63ay|t*E'ZGZBYٮK~&mg܉x35g}<D,W[\rY\\-L'hN:-H=OKU6ofדj\$>#\rfLi:fFF5bOe=We\\u\0%H0)^V<ݜ{?YVP3\r@meh7}TgafCť\\cBX3>/04b^NթfFC<Oߨ:E@\rAW{ZrgĽ{S#T3<4B\0	\0t	@\n`";break;case"tr":$f="%(o9L\";\rln2NFai<BS`z4hP\"2B!Bu:`Ehr2r	LcAb'\0(`1ƃQp9b(Bi=R*|4&`(a1\rɮ|^ZɮK0fK\n!Lx7̦ȭ 4k|\"tit3-z7eLlDa63ڜI7FӺAE=FqH7PuMn7Q#j|aŘ'=sx03=g3hȎ'a\0=;Ch6)j2;I`҉\0A	j%H\\:\$&0@A#H :#\04B\n(ޡS\n;IƜB9Ãk:ê!0XB7\0P{GxҲ	;4=	 \$σ>#\$9p!pc:\rzT#9`@!c@2D49Ax^;Ձp:(\\zNүI|6MjB3#Qx4!^0Ɖ+4#Dym(\"Q92ڼ(*5<O31,U7BL!PTL\"XM-@08+tj#C'4PH{DmnvN֯#-L,b43%8Ô)fd &\r(P&&:X,Pܽ+@Ÿqx9b	Gh0c[Y=B-xQO\"x];纄\0x>ӫ)b,.#cn z,Jsrbp8!n[^=660b9\$Pl6USH|>vIc[\0Myꌣ87+h\ra&6>qp}	|;a \"y^.YbpNWr#ɡ#A3PPy]hGvzM,M3Fq8Q\"\$L)@TT*XrmZ+`KX^\rŉea^*B8nCJ=Tl/3!9IMQ-t.^)AObEE⟁Q;@`bF')jg\"4HT*RuRjJ9+Un^݊9Vs|wJ	\$F)\"+qs>g\$l&8Eсm6s.`g\$NN'бD,7)k1r>f<\"S\$Py\n7 g]H1V Ƞ&>A;1u)]-P//+?1hJc),pOR.Ffj=rAȯ)5tٛa@DDn\\u٠cEd\\3BXkj 2u<i`) DQ8!K2P ԀzdM	-zO@}#Qt@#}\$HJPLAA11\nP *9zCH|C(G<<Ìh2ca~/1^P	L*&W5#s9@&@D8<2DIČhLpG0T5@z/-)P,U9&l3~}EAӈЭ6>\"	_m9X:I	8PT@\$A90`\".fQ +\r.\"Ę3b.\"NF\\f˓v>2\\J:ȉ<[\$ Yrʳadrce}s!#̱ZMp\"Jc+˩dn@8w@\\ΤX#uWoᬽЉ0W^t'-OԞq6oM'! b%π7TOqpƻ'<Y/5davG*{\"	:ߍIKpm8(.!6̞uм+ؔm#ۈDh0BGl5?+\nQhQʓi\n\"\"O 	\"q\"JmD\"|BC	V0'@\"9fLّ#`zu2b\0C+/^1'Ϡ's޵8!O]}t{جv!QtWpL!u@8g f0]c`S5~5!ܼvYzrӎıG~JFtHem{/Y\r*%nw>`Zˋ el7fPH\\̲6QI\"558Rj']6qB.PT\\Q*o;>{CcY2dԬFN.j6)\0'<j;	+\0BUX\"pF4c*n\$|lyˌM:/|pRL70(KZ)0:r`mNo)\0-\" L/\0@liŠТ:	p؇>\"MЛ\n6ʇC\n\nLpг	\0000֜paoN07\$b\"h\npArt_0\$ТO*\nkϏ\r@5mP#C~lD&D# \"-VE(SQdTh8\$LqX;r7Kl/(3G,ߑjn\0D8.2[qI\0ܭ\\Q:jHWp#Nc0p҄nYY2'0v^R!\r@j-a,Jz\\FE7akJL\\K\0002S\"CHdYe!\"%i&cer!&Z!vӄb8NyA&*zP\0 hC'*I# 1*y'z n>\0:>Ü#..vʩ%.C900Rn1*b%\0ⅎ2&S<\r)3n/3R<;rKr|SM \\KPoبZrR^i8C@c]*8~S\"#	9*FR\r!Db-7%賞2Ws\n g++12t3bD5.5H i/8O^!`\npl\0A	:Apbq:3:1:v+CgE&^9\r?in,D_D4QEd_⒤rb&NK/\n:\$NDgu,e,|1Ql1l,ӹKg;MSc\0:\"*!.Ql7QN[ 	:GCc	>i~{,:P	#\rm/0e\nÈa	X55Z\0/!o7qU52s'1&t&LE`gΦ\"d9*'-ƊFR2˦fc";break;case"uk":$f="%)h-ZƂh. h-mhĆ& h#˘.(.<h#v_Ps94R\\h%p	NmcL4PҒ\0(`1ƃQp9\$&;dH5}Q\$C˩ZB	D8(iyA~Gt(ygY1~Қ(BdׯKmJI\r.(VV1>#\$:-r%CǴ)/tp^\r>[73'6SP5dZ{h>/Ѡz0)28?v(P|\"oKB\"i{* 5ϲ:㹉вH8ޣ\"JBZ薉(F)ZY(\$&Y6,X\\Nz#DZ9)ĵ+;DLh1(3 (1@ݷlhQɠMH>K X Ě!аqQ&1d3WH\\C%PnTxH\$D-hU͋^5OR\"\"9#:hƁGQ8mn#NO*# 4(&Ԥ!rްX_ܥ0\\kUsɐ;(~\r3:x\r`Ap9x79cv2Fn=,@Mn;GB^0jXƐ/Q Ѭ+\rbe^V8<\nvxZnz	\nO[D_qNliRI!7`PJ2biZBʫ\rs5hZ~H(5h|\$`K ąDUDΐ':)Y:%<N3u^j\"Se#Yj/pf<Ǒr\rAS\0Zޖ|)zP8FFVTz\$,bdÛV.5'EJ,4V@PS\n!11hA>&IF_:НnB\\1%!DBIUġ35b<NX+x[*S]HaM2[\n׍*o\$+\$-hj\"((k0fҰ dM-%JZP&=5] ÛL!q1M׊20II0Eb!RQ{\$NĤqi%&A@)Y1'F[T0uG\$eB렟9LDTEaI2V\\2ȭC4&T'5M	NQ6&\$6C@\npDj\r9zqCӨN#;DCY>w5	mЩ7\r!ӕwiқcsD9Gf4PO4bu]&WI&E4DI<MILذQ\n_9&yK<8Ӎ2&HəC*e3&hͫ9glpa4Elh,Ea)<FDIT2#+4L	J+aU%DJ/RlO+Nha:b?|İ;6ԊAe8+s%d쥕^Ywf޲3xϚ\0eџ;TICPU5jڪ麟Yil0Ksх.jBi_'Qx%UnDxPim󾩇'v'fPOsRٻsڴQIC<<;y,̲BF,@*PP	@ㆡ,ݡ9\0O\nU 1)\n \0_L^A\\E;@')|<]1,JhyƆ9a70ue[r\04ɦTI\068-CDGg#h2JS!0Kgv6Iϼ4.JmWGUP1d>ykL&moF,\\R1X	\$#uu̥PWƋԚrBFĆV&qYlZGRDɚS=}2:BsyxO\naQuCaIW%bF ܯFImӣ`\$ML D9-\$uiON\$Rf`BIڄF\nBhb4pUB-u!TxeQT[LL\"7&wBn3#mت5uep)EW#E[F)?y~	EY~DM3\$>%!1bIzu}\ny^qLAǗLG\$Q&7jǵBZDf#6;fFz>_u-BșKDⴘ)R\nB\r\0I(rmc|~SddEMyNViNCRa\"Fl(PFÆFm0Ozhl6P脩ĄEcÀ#D&g;\"zS=ԋ'lOn*nGD\$1\\\n@0./NC/&2[OXBDr14:D:qЂ!DGT6\$^̦&*((Mޅ]\rwZ\0DDB\nCF59(Ⱥ0ϵ/jWI.\"U\0\n 	GnJd\\,vk*Nm-t,s\0^-4m'tt#u5aEA9&jܐH>a|F3B<)p1S*@uq1q2	80hX@a\"Q.7b\\s\"R\"+ V%J*㺞U\$#i\$r[\$sbb\0&K(UP΢wR;R*FL	#J' +IlFbi-el'B^©+Cak&L*V%'Eƕ.JNXW\rE4~VA<RlG\rkb^oorqQsR'o[45Nk]4)sXC	SLr169(8'7/4MvF#:Bn.\\SyI'Dz*<?0kH0DO\rlEo C\$*2L%e\nG\$5u6h6<v\nbGb,\$a;D%ć/L9E*SBJ\rTqH:(Dc3;3|\\\$QG%6Q,舵t5t[9ScHj,4JB\$\$\\4HZ/\rhL~qSaFtzAS&ԙo0ڛާjI.UIs}O\"4-N(gNE(:C3'xM[K8<AUDKSt)NԛUPT%Tp;KiI,\0jW&qPbY<M%35Xp~?mm):[+#]ؕ05\"{VYV]20=ԆfpuZ-HoB{TcIaM8ԧU0[	fWtWtfcГ1q\\3EBev%QV`dug`'lԐd|e1wWtZhjuCwxxQH|[lAJ5OcufdRTmQbkURmyKTgk/p0U#k6HPpRoiBh1ؑ\"QUf0cV_L&W;_?gdUSt8GD^wSVind<\ni&awwd\\VZ\"QVg^(Uib`VpՎ6DI\"ttw[kwU9:|nuzV&{g]šy/Hegqv;y*7HT-~(zZqpLLZu*wywp'HbwA'd6U!J?\$\\C[wm4CO2uV2[LIM\0d!\$&j?O34tX	j};q2ee4m%D0K!7'vN3^u2w!8Me#n8	XPMRXyg(KB&j%,.0-:FB\nq%2#Wc!m(#qPh9!rtd6\"\n:/{S;on\"*^cx#PBDU4h)Ή|{Xq3A'5Һ\$rM	/=x3ND&EH\r^E	|5L0RTV`UlWy15vB,ᆗ856%otL0SpZWEEn!{Hi\r7:\$b|SaPm`dRĪOY豪nLCx6\"x&(T#5DO}q`tyM2Zg)橶[ܱ;\0b42j=	bgKFKqX11NUSt`2C#К[xVq";break;case"uz":$f="%(a<\rƑk6LBNl6Lp(a51`u<'Ai6&%4MF`B\"u2Kc'80cAn8'3Ac4MsI@k7#**''3`(;M6,q&ƙ}ģ+77:B:\rW.3b\r4q/|\0(a8ۍ :`*{VvN-o)dgxiw7MX('b%Iyawu:D50K82cz(\n2#ؗCX:\$VL[<&{♺\nn*2M47csX߯#%ct\$n5L P2)s\n</s&c\$+*F6ј1Lr4BCc7+@S ޑ#;Ȟ\rhAPsS@t\rAID3Њ.P\"07c2D49cx_)6̈ġ|9c\"2|-8L4x@/O2l%:2=&KZTȳ\n,=&Cw;˸ȼ~눲!(2,'xa8&L<N:D\09=9+C,#79;Wи:CF`3C*d:\$R(('#j2FRn9L\r!(:!* 7@]m;f	\$	\r67H&J(<8O<\rJ:?9%!;'!`=F/S	)s6%##}.K.u<!uHsQcii\0004۶I@Ea9Øݴ|а:*D́reYcG(`S,3Y#R\rb1M\\jM39¸_#5l8fAc{BL}0NnD+,CRa}Ƣk\r\$DzxRJ ='R:},¢bϑ2%bhC@V\nɦUnUڽW`2ı2\r2VJ4zW{t\$3PNHS2KҐjze&J@;8*T{TS* \nEϏ\\40é3lW`,)(rX\$2IZOY,~RQXBʰsL#g\"mI?dm9L!Т\$#sv)bȉ#-(kjhIT*/	\r4( (i.r|\nMhe,\$£tR]L+NF\n(Ю*\"NJIYM\":}Y'qH\0a>2Ql#2J9-\$@vu_PZFDwLNH{\$4:Y@(^g*E\\W_Ep43) 	(|bm,ɸq'ہ~7-@kKa]!\r\$P-b!%r((k{@:dd?z@n3n%Ie]5ēb\0F\nXCx9q#^FR)b0'Erch,HL@y8C	\$)bXp\nd줚'bxLKO;ݏ\n\nhHuTZ0^di!\"ǥP\\yA<3M`|VUT\n\\5ӷKe\"Ip	Pg#ˉwlUt2	\rOӒtXR\0HAĭ`H֛*MN|A:/N'(,ZȉdѺц`LLB\r4-nb>ff#j9x㽯bx\00ۋtC#J&0Ү:,TTM<sC,ć=6#L}e\" ('H6{\n\neP{t]'=NAVLb)bt׳p}05dFs#92\"̊@(ME!Ta@lz/yR\nD{E\$vnc.q'^\\I΁2pѮ٢/vG囁0yL3B(UCn7E	e,	YnxrmEy(2K:\0MyA`>9>%Sw/RR\r!ὠtӵ\\؈n%!'=/fzMp/;'\"_\0pȌ~`l\nfts.&H`A@'FF\"e͡\n\r?L|O`eݫko:Cv\$\$MIL>~l/Ф l|;	PvN{\0pPPt@vQPCup}\rh6'&|ˮX^lOnmu.VP콰J,8^>p\r\rp1-,<'X&d7X#-#CHe{JbJ1l%Dj:DqPVǂ}\"ݐHZG-66I:\"\\J(=*J\r\rN|oqtv4zʎ87^lЛ-ɕlB6%P\rR\0q D;!GI\rR\rB=`i0x\rqZD04G(7QRS\r%](&0jl\0'q8yF\rƎKB^i%rQhP\\# Z qu*]*o*R* r2@(Q12-2\"\nLұ ..~x2.D!.oqSᲛ0T(cN30&Re2(R3,S3+üd\$Kp%;5s#6Nsa1	FcRDO0'J\"2,(yFF+À\"ϱ/<)3уd::	`ش\rCBz :9ʐ3b8[=\0pnh!	4\\&b*; F\nZj\"Ѱ^nIZw91=*T37eЯD\$#\"6S\$;4`\"Pryp3;?o?CG?8#NBbD\$hmZƻ%\0,H<c6&\r03x|LK@Pxd0Cƶc\nHܑ6Tؐz@/CE,Mj:q_M!SBgƬy@.akb'\"vvU,]Uf7<] OBGO1sF0c\$=c'mSr^-ϐslX	ɟN%ҊfwG+R,LeF4#@䊵 ";break;case"vi":$f="%(ha\rq]Ҍ]c\rTnAjhc,\"	b5H؉q	Nd)	R!/5!PäA&n&0cAn8QE\r Y\$Eyt9D0Q(Vh<&b-[no\n(U`+~daH8iD\\Pnpu<4k{C3	2Rum]/tUږ[]7;qqwN(a;m{\rB\n'ٻ_2[aTk7)o9HH0c+767 88@@ \\j L+@ƻl7)vOIvL:I枧fakjc]/P!\0d! K P k<M\0\r@h4AN!c3(7\$Xb,(R-2j]2<!iJ NA1[(Rf1B\"\rAZ8B<&u=SI#qtI>(0P2\r<9ph#n\0@C҇\r㭘B%\n\0x3:x{\ra?/p_pcI|63?k4^02T.́BED\",9e9):&Y^\";\n7ZH(J2/C2S)cs2R̩JVJ\"!7\"]q:V6qJćeJZ7k,2 JGV\n5Hƈ3Q7tWcéVI~;U6Ê4J4YfBΓF\n#TĮ@-џR|[46'h(PCcn\r)+uߢ\$\n)C4{au!FTz~ص%WhUH*]RTs/5ux %JaK:V~>91C>h3,t~J6A@	8nZ(C)\r\$\0`\r3*Ih;\\F BnEP.)],\\ Qz^Qfi.Hn2T	3ŕx3@ @WK1@u޼W^|4\0`A4N\rL¢B&~KQAC:G4ċY3oČEғKuK\$t.ػ^|/2}er_D	&BIfmOd9SCNa\"[ȹ{Hq1B@X-IfhMd, \r'C:FԘ.@fԡ*.]Sצ8u['p&i	wD	%|D\"xw8 vag hb>TycHMCY\\E	j:(뾐Ӓč	!KitA5zaH#X)f1&4Ыec6i\0(;(v(Msrsj-DȚ6BI>腦mRu\$\$0\$74B]Q@\$3s&9+\0դ+2| M/\n<)Hws\$LpjĘ\\XK݀:M+C3\$<R3~Gr\"RH(!p*ζ3dҜE2ti-b^f,+N ^EGB\$yQ+ jgF\$X\rE)w8I)>12Y;'zzdqv\"m(YhDӱ^h?#taL_(#/L\00*:G04Uzm(bz\rPM=5 0\$\\NPT'řȆmQn>F%_ԹmDil=W3Cfڞ[5(ⲳ\\8+>p!\$Kf|7>]jO1CoLS:556>p\rs	_L4忓LAIn֔\n}#*\"eUDn5\n5GC	V|Y(:;R鑅a/\0*\$Z\$=S#+8\$Ġ\"	H8(,Aa<By/(	!_I)c)Q؄;rLWYk~ҰPIdKb-Ź\\\$ԮTb~u#7a%#vo)x#V]e/>*2KrNJ\09Zlbp\"KT K#lЛ IcbL#>06{H.!J&klX+<o6A~#-*s,1Nn#btz!D+@5(\"ؘ)TCPLj]\$dmn6EÍ\\`C6d\"Fk2GKp@.;4H0RLӱdq!QH-T|ge%\")UK/\"O>XE<{B.c\"coNQqjq0^8\\\$\"̸P'¡f\"9|pqNRQ鶶Ed:jDŋ4GF<\$mB0(nHяɭYRq^z.БBifBeJbfpPG '!qNDx|*!!Q'l&GO@9Q%fe%nbkrpvN78\$JR!w\0L֛n:T\\~KTU \"/+%&F.+\0{'zW8F2'Re7MQ*9T<+pF\"\$ 0Z-I-sI.G2,'lD,3w&\\)'sv\riF@\nB`#	jFBTZ@`lV朗5so56le{x1++s\$,33SO;yWNfxR}9E:&ZO:Q	%>nFméQoMd645chA%z6:w!Oq#c:UtwCh-KHCJ)\0-\n@GIF\"SG9.S\nHJ,)\0\nq0.\0JOʊG\".\$x/JLg2nS/Ѹ/kG1-tm.3bn6cГJdJWd+X\"m*K vp.(W0-P#FA/V\$5!:F8v`Z!u0#& @6J/F_#%p4TDPݬJlPx7j<E,JOOlXXV%;Dp35ĎHLnm\\!roUcvMKL\00\n4jPa^0Rd~%P#SZD!_4K#S@h1)n\nf:WWm&mƺ`4B";break;case"zh":$f="%:\$\nr.r/dȻ[8 S8rNT*Ю\\9HHZ1!SVJ@%9Ql]m	FU*qQ;Cf4usUUt w:t\nrU:.:PǑ.\r7d^%u)cxU`Fjrs'PnA̛ZEf]EvitUλSծ{Pg5	EPN1	V\nW]\n!zsΟRRVI:(s#.UzΠ@:w'_T\$pVLD')bJ\$pŢ[MZ\n.>sKAZKaLHAtF3D!zHC*re^K#sXg)<v׬hE')2Anrj\n:1'+ֲ2izJsͲ h7]	9HN_esK?	RY4=DF@4C(C@:tT3>x3(9I|1B:LΝ\$=0!tIE'5(RMy&s#SE͒CH]K:KC%um0KV)\"EA(CGAFpܗ&fTYCG)\0DGSW)\0^cTewa D#8s*.]\"h^9zW#s\0]c9a Dj<V]2gC\$CCm8)\"entI4}|=3Q''1Q,g^nKsSL̋&eȜ:ϿC34;.Ml`#@6S6::=9CZ\\u|!p4Z)M=?pA\$_Kz<O66ҙt_No-6MHX:+3.~ɻFbt\"\$r!bJՄP~T]'@Gr[\0 @\$\$C1v+ʛS}P5JJUX+%hxdx:2°_:X%PQ'Ea/1ir\"&B\rBoM ~pOrTJS*Tb*YUnCtV'+uABV2>,E\$\$W1,\"r,E4H=I>ŊH9kdvd\$?M#9# 9t,Ǩ4zZ) @@Pz\"MQ-DV':HIAØG\nTf,8o&Hs_;0hDM#bʹ{mR NAr@a(3WT&(8LZ((-I\0PP\n\"\0C\naH#.)(#g8/I\$V&.FR:E=9)%hhs\nj;?ca@+\\p ZлНW*RdȱQ4G4\\р\0£RAOXcHUt*!Y?l 	EL#@CȈ&	8E@OIy\"9+1dϣR	c(YP*[s E	a/WE`LSA/DMBsFQB.QwEߢ)0t7gʅ2Ş\rna#/-/)&dF@&g@DCOA^|\n|JIaޫC+:t3DtP\\39Pq\\' `ܡpNN\\i mNtᜈM@!6%\0C\r1xL1)hAttΛKeM&HQ(9}DC\raƐN	s8M9]@BHǀ\n#~qrǈLhE6&\\\n)v]!0fmt\n&\"f)ȗf;Cm	Xj/2\\-*ޚs;F,NV&*XӀ(+Pm!|ЎQa k`fB6-9vZ9Ĳeƺ:D,b\0003kg,뢹_΋ôd*\"5m#)#PL`]1pikS&Bk;ʜG<a~6+`AhL\$Xyߗ.I/R\$__gۻm2M~?Z;[ͮ/wx{C\\i~yHSC>\"7dd%(ٙ3%v[ͤ.(a\"&pQ6;jCv!!(Ik\07D.+so-6Oψc|o4lҏ/rPat\"2oj^\rp'\\^~#fAu	mJv\\a:J^o\\h.L\"4Ψb֌6Ͼ^-LώЌ'*eN֭zem<p3\"a<Oh\rϝxK'=0αmрSet\0l\0@\0'GM^'OlQq qxv`)\$~1~M(n\nӐ]1QmD4FG!N.FFDQ:o,?	t`i	#\$-t>F-j^.tFʈ,w! 8m֟>,g\rv~p 3F) PC\nZho0lC!d*H.!6ì6-VNdgʳT3\n-Rˋ䊪#\\JΐQ1\$\npX-4*2fL.nҽ+,NAt,FE \r!(,#G/El\$\$039{1#\nJ::9L>784Co50\0>(+DD";break;case"zh-tw":$f="%:\$\ns.eUȸE9PK72(Ph)ʅ@:i	aJe R)ܫ{	Nd(vQDCѮUjaʜTOABPb2ar\nr/TuʮM9Rz?Tא9>SNeI̜Dhw2Y2PcмW*=s7B9J\"XQ2M/J2@\"WrTD{utspS\\=\0Vp\"R )ЪOHΔT\\ӊ:}JF+JV*rEZs!ZyV꽯yPA.yZ6YI)\ns	Z̢[2̒KdJ12A\$&Y+;ZY+\$j[GAn%Jst)P)<?\0Uw*x].2ft+<Kd(A2]*X!rB\n# 4(tE\rl	Tr{:OpbJBO:F@4C(C@:t㽄4)Kx3(9PI|t(B1֯B|\$	q/9H]D̸et\\K6?஋LQ\\1H@PJ2:@ea	&s2So1Qd0ם3Mewd:<C)xGdrBHreBi^1I@\"ZP@fg1pM	j^B<JLf*83(ڰ:s (&^)Dr\n淘1(\\մ	_ܾ7&]>Tt734ҥr</hCHHs,o7|u+wxbØ@6XU:Cp@09#uW97H}U1	~1KTNFQ8)HTKPs3cM#& )FGpXa*%)FG4B',a\na\$\n0Cո)Ȉ%)(pfD N*R:a\0(&D	`\$UV\\z\nXId,xd|:ζV\"@XCt	e/0ʴE#Ȫ髃dpO­WJ_,\"Ɗk%e՞nrEl-b(f\0CG@e}!]>]w/U\$fEhC51QB'!!&Ѱ9sa\"CQ>-0d\$TD2(2xDv\0 \r\$BGu\"#䄑Fօ*DM?!PD*\$G@&d͘tl!E*U)\r\$8lG9i^*hЃL\nf#@A\n/8F[(4ZjI\0C\naH#\0Z')E\$&ra\\E^0\nG0\\Ck=&ȵ4tXEP,S!'BbS*r?QXʼW~9KĂ\"G4N\"xS\nVEFLIfdΜ;&/Uiਪ\r@50T\n;&8L%DޜG*sp,96ԹBLpO	*\0BEX@.	d,^1 #G9##=V0sn黳ba:XVAEX/OD堔qhTػޛE\0*0H P\"`\$ӣR\"\0\0R]aeP\0ֈYEhD4nAj07PlJ5&LY*>`9&\$͢*j+Ģ]h\\uYk:xnֺ(8\"EL`eK1T30/'0Q-BKm΋oE滿#]	Ñ rYI}`(!^j:P@<\\W2aܛ9u2<A/D9`]4H2uEضֆU:T!2S`BHn[/O*+\01f1@H<c\0\"&b:D3&FӉ.%P\0`8<7ly`Kyx!yuq)(=|9\$DNM/i((\rNs+Ee<k\"Q徽?'qbuE\\%ra1#t7*{\rOy:05Ű_0aB{07Egȇ\rk__ʛl~cX_ts6SBV:yP?<-FLGY.qu5ƺKb&#ϨGVo^π>uobn\rG<!W\nNx02Ԣ0\$s\rFu<h-lFZ#..N2^pOlrAkrx+n\rp|ب\$9\r^Bʛ0>\$fNU풁\nɴpJ-8\"tLUzK,m1JpB`&6,1--d6\nw<pjm\r{.5F0pCQ2A\\rB.GB^h+B^~(7p/(!.溓!h\re0%^hqcyL\"'\$-߱21pt({ 1ڭ\refZF2\0@\0!!R\${(R4ڍ!\"A\"`ۆ82FM\$Vܡ20rv'-C(ݰR'Hq]rK}*\r+\$#*\n)@ZMM.aLwAD<L,i	+N?H^!Fb:!k/D:V.r3!z\0:6:èb^6&rIj\$YP+@\np9'POvB!gJ0Fe涡@9dÔ1\ru{5E\nh\\^S\r8Ht:Ӽq/Bl-/#Nl/qTa`F'	{%uai#͂/Ă\rdnO, &ʨ\n`ڑS++@\\N0k>xRw3>,nD0Hlj0c&rqBM#*\0L";break;}$Ei=array();foreach(explode("\n",lzw_decompress($f))as$X)$Ei[]=(strpos($X,"\t")?explode("\t",$X):$X);return$Ei;}abstract
class
SqlDb{static$de;var$extension;var$flavor='';var$server_info;var$affected_rows=0;var$info='';var$errno=0;var$error='';protected$multi;abstract
function
attach($N,$V,$F);abstract
function
quote($Q);abstract
function
select_db($Lb);abstract
function
query($H,$Oi=false);function
multi_query($H){return$this->multi=$this->query($H);}function
store_result(){return$this->multi;}function
next_result(){return
false;}}if(extension_loaded('pdo')){abstract
class
PdoDb
extends
SqlDb{protected$pdo;function
dsn($ic,$V,$F,array$Jf=array()){$Jf[\PDO::ATTR_ERRMODE]=\PDO::ERRMODE_SILENT;$Jf[\PDO::ATTR_STATEMENT_CLASS]=array('Adminer\PdoResult');try{$this->pdo=new
\PDO($ic,$V,$F,$Jf);}catch(\Exception$Dc){return$Dc->getMessage();}$this->server_info=@$this->pdo->getAttribute(\PDO::ATTR_SERVER_VERSION);return'';}function
quote($Q){return$this->pdo->quote($Q);}function
query($H,$Oi=false){$I=$this->pdo->query($H);$this->error="";if(!$I){list(,$this->errno,$this->error)=$this->pdo->errorInfo();if(!$this->error)$this->error=lang(21);return
false;}$this->store_result($I);return$I;}function
store_result($I=null){if(!$I){$I=$this->multi;if(!$I)return
false;}if($I->columnCount()){$I->num_rows=$I->rowCount();return$I;}$this->affected_rows=$I->rowCount();return
true;}function
next_result(){$I=$this->multi;if(!is_object($I))return
false;$I->_offset=0;return@$I->nextRowset();}}class
PdoResult
extends
\PDOStatement{var$_offset=0,$num_rows;function
fetch_assoc(){return$this->fetch(\PDO::FETCH_ASSOC);}function
fetch_row(){return$this->fetch(\PDO::FETCH_NUM);}function
fetch_field(){$K=(object)$this->getColumnMeta($this->_offset++);$U=$K->pdo_type;$K->type=($U==\PDO::PARAM_INT?0:15);$K->charsetnr=($U==\PDO::PARAM_LOB||(isset($K->flags)&&in_array("blob",(array)$K->flags))?63:0);return$K;}function
seek($D){for($t=0;$t<$D;$t++)$this->fetch();}}}function
add_driver($u,$C){SqlDriver::$cc[$u]=$C;}function
get_driver($u){return
SqlDriver::$cc[$u];}abstract
class
SqlDriver{static$de;static$cc=array();static$Lc=array();static$ne;protected$conn;protected$types=array();var$insertFunctions=array();var$editFunctions=array();var$unsigned=array();var$operators=array();var$functions=array();var$grouping=array();var$onActions="RESTRICT|NO ACTION|CASCADE|SET NULL|SET DEFAULT";var$inout="IN|OUT|INOUT";var$enumLength="'(?:''|[^'\\\\]|\\\\.)*'";var$generated=array();static
function
connect($N,$V,$F){$g=new
Db;return($g->attach($N,$V,$F)?:$g);}function
__construct(Db$g){$this->conn=$g;}function
types(){return
call_user_func_array('array_merge',array_values($this->types));}function
structuredTypes(){return
array_map('array_keys',$this->types);}function
enumLength(array$n){}function
unconvertFunction(array$n){}function
select($R,array$M,array$Z,array$rd,array$Lf=array(),$_=1,$E=0,$_g=false){$ie=(count($rd)<count($M));$H=adminer()->selectQueryBuild($M,$Z,$rd,$Lf,$_,$E);if(!$H)$H="SELECT".limit(($_GET["page"]!="last"&&$_&&$rd&&$ie&&JUSH=="sql"?"SQL_CALC_FOUND_ROWS ":"").implode(", ",$M)."\nFROM ".table($R),($Z?"\nWHERE ".implode(" AND ",$Z):"").($rd&&$ie?"\nGROUP BY ".implode(", ",$rd):"").($Lf?"\nORDER BY ".implode(", ",$Lf):""),$_,($E?$_*$E:0),"\n");$Ph=microtime(true);$J=$this->conn->query($H);if($_g)echo
adminer()->selectQuery($H,$Ph,!$J);return$J;}function
delete($R,$Ig,$_=0){$H="FROM ".table($R);return
queries("DELETE".($_?limit1($R,$H,$Ig):" $H$Ig"));}function
update($R,array$O,$Ig,$_=0,$th="\n"){$hj=array();foreach($O
as$y=>$X)$hj[]="$y = $X";$H=table($R)." SET$th".implode(",$th",$hj);return
queries("UPDATE".($_?limit1($R,$H,$Ig,$th):" $H$Ig"));}function
insert($R,array$O){return
queries("INSERT INTO ".table($R).($O?" (".implode(", ",array_keys($O)).")\nVALUES (".implode(", ",$O).")":" DEFAULT VALUES").$this->insertReturning($R));}function
insertReturning($R){return"";}function
insertUpdate($R,array$L,array$G){return
false;}function
begin(){return
queries("BEGIN");}function
commit(){return
queries("COMMIT");}function
rollback(){return
queries("ROLLBACK");}function
slowQuery($H,$ri){}function
convertSearch($v,array$X,array$n){return$v;}function
convertOperator($Ff){return$Ff;}function
value($X,array$n){return(method_exists($this->conn,'value')?$this->conn->value($X,$n):(is_resource($X)?stream_get_contents($X):$X));}function
quoteBinary($hh){return
q($hh);}function
warnings(){}function
tableHelp($C,$le=false){}function
hasCStyleEscapes(){return
false;}function
engines(){return
array();}function
supportsIndex(array$S){return!is_view($S);}function
checkConstraints($R){return
get_key_vals("SELECT c.CONSTRAINT_NAME, CHECK_CLAUSE
FROM INFORMATION_SCHEMA.CHECK_CONSTRAINTS c
JOIN INFORMATION_SCHEMA.TABLE_CONSTRAINTS t ON c.CONSTRAINT_SCHEMA = t.CONSTRAINT_SCHEMA AND c.CONSTRAINT_NAME = t.CONSTRAINT_NAME
WHERE c.CONSTRAINT_SCHEMA = ".q($_GET["ns"]!=""?$_GET["ns"]:DB)."
AND t.TABLE_NAME = ".q($R)."
AND CHECK_CLAUSE NOT LIKE '% IS NOT NULL'",$this->conn);}function
allFields(){$J=array();foreach(get_rows("SELECT TABLE_NAME AS tab, COLUMN_NAME AS field, IS_NULLABLE AS nullable, DATA_TYPE AS type, CHARACTER_MAXIMUM_LENGTH AS length".(JUSH=='sql'?", COLUMN_KEY = 'PRI' AS `primary`":"")."
FROM INFORMATION_SCHEMA.COLUMNS
WHERE TABLE_SCHEMA = ".q($_GET["ns"]!=""?$_GET["ns"]:DB)."
ORDER BY TABLE_NAME, ORDINAL_POSITION",$this->conn)as$K){$K["null"]=($K["nullable"]=="YES");$J[$K["tab"]][]=$K;}return$J;}}add_driver("sqlite","SQLite");if(isset($_GET["sqlite"])){define('Adminer\DRIVER',"sqlite");if(class_exists("SQLite3")&&$_GET["ext"]!="pdo"){abstract
class
SqliteDb
extends
SqlDb{var$extension="SQLite3";private$link;function
attach($p,$V,$F){$this->link=new
\SQLite3($p);$kj=$this->link->version();$this->server_info=$kj["versionString"];return'';}function
query($H,$Oi=false){$I=@$this->link->query($H);$this->error="";if(!$I){$this->errno=$this->link->lastErrorCode();$this->error=$this->link->lastErrorMsg();return
false;}elseif($I->numColumns())return
new
Result($I);$this->affected_rows=$this->link->changes();return
true;}function
quote($Q){return(is_utf8($Q)?"'".$this->link->escapeString($Q)."'":"x'".first(unpack('H*',$Q))."'");}}class
Result{var$num_rows;private$result,$offset=0;function
__construct($I){$this->result=$I;}function
fetch_assoc(){return$this->result->fetchArray(SQLITE3_ASSOC);}function
fetch_row(){return$this->result->fetchArray(SQLITE3_NUM);}function
fetch_field(){$d=$this->offset++;$U=$this->result->columnType($d);return(object)array("name"=>$this->result->columnName($d),"type"=>($U==SQLITE3_TEXT?15:0),"charsetnr"=>($U==SQLITE3_BLOB?63:0),);}function
__destruct(){$this->result->finalize();}}}elseif(extension_loaded("pdo_sqlite")){abstract
class
SqliteDb
extends
PdoDb{var$extension="PDO_SQLite";function
attach($p,$V,$F){$this->dsn(DRIVER.":$p","","");$this->query("PRAGMA foreign_keys = 1");$this->query("PRAGMA busy_timeout = 500");return'';}}}if(class_exists('Adminer\SqliteDb')){class
Db
extends
SqliteDb{function
attach($p,$V,$F){parent::attach($p,$V,$F);$this->query("PRAGMA foreign_keys = 1");$this->query("PRAGMA busy_timeout = 500");return'';}function
select_db($p){if(is_readable($p)&&$this->query("ATTACH ".$this->quote(preg_match("~(^[/\\\\]|:)~",$p)?$p:dirname($_SERVER["SCRIPT_FILENAME"])."/$p")." AS a"))return!self::attach($p,'','');return
false;}}}class
Driver
extends
SqlDriver{static$Lc=array("SQLite3","PDO_SQLite");static$ne="sqlite";protected$types=array(array("integer"=>0,"real"=>0,"numeric"=>0,"text"=>0,"blob"=>0));var$insertFunctions=array();var$editFunctions=array("integer|real|numeric"=>"+/-","text"=>"||",);var$operators=array("=","<",">","<=",">=","!=","LIKE","LIKE %%","IN","IS NULL","NOT LIKE","NOT IN","IS NOT NULL","SQL");var$functions=array("hex","length","lower","round","unixepoch","upper");var$grouping=array("avg","count","count distinct","group_concat","max","min","sum");static
function
connect($N,$V,$F){if($F!="")return
lang(22);return
parent::connect(":memory:","","");}function
__construct(Db$g){parent::__construct($g);if(min_version(3.31,0,$g))$this->generated=array("STORED","VIRTUAL");}function
structuredTypes(){return
array_keys($this->types[0]);}function
insertUpdate($R,array$L,array$G){$hj=array();foreach($L
as$O)$hj[]="(".implode(", ",$O).")";return
queries("REPLACE INTO ".table($R)." (".implode(", ",array_keys(reset($L))).") VALUES\n".implode(",\n",$hj));}function
tableHelp($C,$le=false){if($C=="sqlite_sequence")return"fileformat2.html#seqtab";if($C=="sqlite_master")return"fileformat2.html#$C";}function
checkConstraints($R){preg_match_all('~ CHECK *(\( *(((?>[^()]*[^() ])|(?1))*) *\))~',get_val("SELECT sql FROM sqlite_master WHERE type = 'table' AND name = ".q($R),0,$this->conn),$Le);return
array_combine($Le[2],$Le[2]);}function
allFields(){$J=array();foreach(tables_list()as$R=>$U){foreach(fields($R)as$n)$J[$R][]=$n;}return$J;}}function
idf_escape($v){return'"'.str_replace('"','""',$v).'"';}function
table($v){return
idf_escape($v);}function
get_databases($cd){return
array();}function
limit($H,$Z,$_,$D=0,$th=" "){return" $H$Z".($_?$th."LIMIT $_".($D?" OFFSET $D":""):"");}function
limit1($R,$H,$Z,$th="\n"){return(preg_match('~^INTO~',$H)||get_val("SELECT sqlite_compileoption_used('ENABLE_UPDATE_DELETE_LIMIT')")?limit($H,$Z,1,0,$th):" $H WHERE rowid = (SELECT rowid FROM ".table($R).$Z.$th."LIMIT 1)");}function
db_collation($k,$jb){return
get_val("PRAGMA encoding");}function
logged_user(){return
get_current_user();}function
tables_list(){return
get_key_vals("SELECT name, type FROM sqlite_master WHERE type IN ('table', 'view') ORDER BY (name = 'sqlite_sequence'), name");}function
count_tables($j){return
array();}function
table_status($C=""){$J=array();foreach(get_rows("SELECT name AS Name, type AS Engine, 'rowid' AS Oid, '' AS Auto_increment FROM sqlite_master WHERE type IN ('table', 'view') ".($C!=""?"AND name = ".q($C):"ORDER BY name"))as$K){$K["Rows"]=get_val("SELECT COUNT(*) FROM ".idf_escape($K["Name"]));$J[$K["Name"]]=$K;}foreach(get_rows("SELECT * FROM sqlite_sequence".($C!=""?" WHERE name = ".q($C):""),null,"")as$K)$J[$K["name"]]["Auto_increment"]=$K["seq"];return$J;}function
is_view($S){return$S["Engine"]=="view";}function
fk_support($S){return!get_val("SELECT sqlite_compileoption_used('OMIT_FOREIGN_KEY')");}function
fields($R){$J=array();$G="";foreach(get_rows("PRAGMA table_".(min_version(3.31)?"x":"")."info(".table($R).")")as$K){$C=$K["name"];$U=strtolower($K["type"]);$l=$K["dflt_value"];$J[$C]=array("field"=>$C,"type"=>(preg_match('~int~i',$U)?"integer":(preg_match('~char|clob|text~i',$U)?"text":(preg_match('~blob~i',$U)?"blob":(preg_match('~real|floa|doub~i',$U)?"real":"numeric")))),"full_type"=>$U,"default"=>(preg_match("~^'(.*)'$~",$l,$B)?str_replace("''","'",$B[1]):($l=="NULL"?null:$l)),"null"=>!$K["notnull"],"privileges"=>array("select"=>1,"insert"=>1,"update"=>1,"where"=>1,"order"=>1),"primary"=>$K["pk"],);if($K["pk"]){if($G!="")$J[$G]["auto_increment"]=false;elseif(preg_match('~^integer$~i',$U))$J[$C]["auto_increment"]=true;$G=$C;}}$Jh=get_val("SELECT sql FROM sqlite_master WHERE type = 'table' AND name = ".q($R));$v='(("[^"]*+")+|[a-z0-9_]+)';preg_match_all('~'.$v.'\s+text\s+COLLATE\s+(\'[^\']+\'|\S+)~i',$Jh,$Le,PREG_SET_ORDER);foreach($Le
as$B){$C=str_replace('""','"',preg_replace('~^"|"$~','',$B[1]));if($J[$C])$J[$C]["collation"]=trim($B[3],"'");}preg_match_all('~'.$v.'\s.*GENERATED ALWAYS AS \((.+)\) (STORED|VIRTUAL)~i',$Jh,$Le,PREG_SET_ORDER);foreach($Le
as$B){$C=str_replace('""','"',preg_replace('~^"|"$~','',$B[1]));$J[$C]["default"]=$B[3];$J[$C]["generated"]=strtoupper($B[4]);}return$J;}function
indexes($R,$h=null){$h=connection($h);$J=array();$Jh=get_val("SELECT sql FROM sqlite_master WHERE type = 'table' AND name = ".q($R),0,$h);if(preg_match('~\bPRIMARY\s+KEY\s*\((([^)"]+|"[^"]*"|`[^`]*`)++)~i',$Jh,$B)){$J[""]=array("type"=>"PRIMARY","columns"=>array(),"lengths"=>array(),"descs"=>array());preg_match_all('~((("[^"]*+")+|(?:`[^`]*+`)+)|(\S+))(\s+(ASC|DESC))?(,\s*|$)~i',$B[1],$Le,PREG_SET_ORDER);foreach($Le
as$B){$J[""]["columns"][]=idf_unescape($B[2]).$B[4];$J[""]["descs"][]=(preg_match('~DESC~i',$B[5])?'1':null);}}if(!$J){foreach(fields($R)as$C=>$n){if($n["primary"])$J[""]=array("type"=>"PRIMARY","columns"=>array($C),"lengths"=>array(),"descs"=>array(null));}}$Nh=get_key_vals("SELECT name, sql FROM sqlite_master WHERE type = 'index' AND tbl_name = ".q($R),$h);foreach(get_rows("PRAGMA index_list(".table($R).")",$h)as$K){$C=$K["name"];$w=array("type"=>($K["unique"]?"UNIQUE":"INDEX"));$w["lengths"]=array();$w["descs"]=array();foreach(get_rows("PRAGMA index_info(".idf_escape($C).")",$h)as$gh){$w["columns"][]=$gh["name"];$w["descs"][]=null;}if(preg_match('~^CREATE( UNIQUE)? INDEX '.preg_quote(idf_escape($C).' ON '.idf_escape($R),'~').' \((.*)\)$~i',$Nh[$C],$Tg)){preg_match_all('/("[^"]*+")+( DESC)?/',$Tg[2],$Le);foreach($Le[2]as$y=>$X){if($X)$w["descs"][$y]='1';}}if(!$J[""]||$w["type"]!="UNIQUE"||$w["columns"]!=$J[""]["columns"]||$w["descs"]!=$J[""]["descs"]||!preg_match("~^sqlite_~",$C))$J[$C]=$w;}return$J;}function
foreign_keys($R){$J=array();foreach(get_rows("PRAGMA foreign_key_list(".table($R).")")as$K){$q=&$J[$K["id"]];if(!$q)$q=$K;$q["source"][]=$K["from"];$q["target"][]=$K["to"];}return$J;}function
view($C){return
array("select"=>preg_replace('~^(?:[^`"[]+|`[^`]*`|"[^"]*")* AS\s+~iU','',get_val("SELECT sql FROM sqlite_master WHERE type = 'view' AND name = ".q($C))));}function
collations(){return(isset($_GET["create"])?get_vals("PRAGMA collation_list",1):array());}function
information_schema($k){return
false;}function
error(){return
h(connection()->error);}function
check_sqlite_name($C){$Lc="db|sdb|sqlite";if(!preg_match("~^[^\\0]*\\.($Lc)\$~",$C)){connection()->error=lang(23,str_replace("|",", ",$Lc));return
false;}return
true;}function
create_database($k,$c){if(file_exists($k)){connection()->error=lang(24);return
false;}if(!check_sqlite_name($k))return
false;try{$A=new
Db();$A->attach($k,'','');}catch(\Exception$Dc){connection()->error=$Dc->getMessage();return
false;}$A->query('PRAGMA encoding = "UTF-8"');$A->query('CREATE TABLE adminer (i)');$A->query('DROP TABLE adminer');return
true;}function
drop_databases($j){connection()->attach(":memory:",'','');foreach($j
as$k){if(!@unlink($k)){connection()->error=lang(24);return
false;}}return
true;}function
rename_database($C,$c){if(!check_sqlite_name($C))return
false;connection()->attach(":memory:",'','');connection()->error=lang(24);return@rename(DB,$C);}function
auto_increment(){return" PRIMARY KEY AUTOINCREMENT";}function
alter_table($R,$C,$o,$ed,$ob,$tc,$c,$Ba,$ig){$aj=($R==""||$ed);foreach($o
as$n){if($n[0]!=""||!$n[1]||$n[2]){$aj=true;break;}}$b=array();$Wf=array();foreach($o
as$n){if($n[1]){$b[]=($aj?$n[1]:"ADD ".implode($n[1]));if($n[0]!="")$Wf[$n[0]]=$n[1][0];}}if(!$aj){foreach($b
as$X){if(!queries("ALTER TABLE ".table($R)." $X"))return
false;}if($R!=$C&&!queries("ALTER TABLE ".table($R)." RENAME TO ".table($C)))return
false;}elseif(!recreate_table($R,$C,$b,$Wf,$ed,$Ba))return
false;if($Ba){queries("BEGIN");queries("UPDATE sqlite_sequence SET seq = $Ba WHERE name = ".q($C));if(!connection()->affected_rows)queries("INSERT INTO sqlite_sequence (name, seq) VALUES (".q($C).", $Ba)");queries("COMMIT");}return
true;}function
recreate_table($R,$C,array$o,array$Wf,array$ed,$Ba="",$x=array(),$ec="",$la=""){if($R!=""){if(!$o){foreach(fields($R)as$y=>$n){if($x)$n["auto_increment"]=0;$o[]=process_field($n,$n);$Wf[$y]=idf_escape($y);}}$zg=false;foreach($o
as$n){if($n[6])$zg=true;}$gc=array();foreach($x
as$y=>$X){if($X[2]=="DROP"){$gc[$X[1]]=true;unset($x[$y]);}}foreach(indexes($R)as$pe=>$w){$e=array();foreach($w["columns"]as$y=>$d){if(!$Wf[$d])continue
2;$e[]=$Wf[$d].($w["descs"][$y]?" DESC":"");}if(!$gc[$pe]){if($w["type"]!="PRIMARY"||!$zg)$x[]=array($w["type"],$pe,$e);}}foreach($x
as$y=>$X){if($X[0]=="PRIMARY"){unset($x[$y]);$ed[]="  PRIMARY KEY (".implode(", ",$X[2]).")";}}foreach(foreign_keys($R)as$pe=>$q){foreach($q["source"]as$y=>$d){if(!$Wf[$d])continue
2;$q["source"][$y]=idf_unescape($Wf[$d]);}if(!isset($ed[" $pe"]))$ed[]=" ".format_foreign_key($q);}queries("BEGIN");}$Va=array();foreach($o
as$n){if(preg_match('~GENERATED~',$n[3]))unset($Wf[array_search($n[0],$Wf)]);$Va[]="  ".implode($n);}$Va=array_merge($Va,array_filter($ed));foreach(driver()->checkConstraints($R)as$Xa){if($Xa!=$ec)$Va[]="  CHECK ($Xa)";}if($la)$Va[]="  CHECK ($la)";$li=($R==$C?"adminer_$C":$C);if(!queries("CREATE TABLE ".table($li)." (\n".implode(",\n",$Va)."\n)"))return
false;if($R!=""){if($Wf&&!queries("INSERT INTO ".table($li)." (".implode(", ",$Wf).") SELECT ".implode(", ",array_map('Adminer\idf_escape',array_keys($Wf)))." FROM ".table($R)))return
false;$Ki=array();foreach(triggers($R)as$Ii=>$si){$Hi=trigger($Ii,$R);$Ki[]="CREATE TRIGGER ".idf_escape($Ii)." ".implode(" ",$si)." ON ".table($C)."\n$Hi[Statement]";}$Ba=$Ba?"":get_val("SELECT seq FROM sqlite_sequence WHERE name = ".q($R));if(!queries("DROP TABLE ".table($R))||($R==$C&&!queries("ALTER TABLE ".table($li)." RENAME TO ".table($C)))||!alter_indexes($C,$x))return
false;if($Ba)queries("UPDATE sqlite_sequence SET seq = $Ba WHERE name = ".q($C));foreach($Ki
as$Hi){if(!queries($Hi))return
false;}queries("COMMIT");}return
true;}function
index_sql($R,$U,$C,$e){return"CREATE $U ".($U!="INDEX"?"INDEX ":"").idf_escape($C!=""?$C:uniqid($R."_"))." ON ".table($R)." $e";}function
alter_indexes($R,$b){foreach($b
as$G){if($G[0]=="PRIMARY")return
recreate_table($R,$R,array(),array(),array(),"",$b);}foreach(array_reverse($b)as$X){if(!queries($X[2]=="DROP"?"DROP INDEX ".idf_escape($X[1]):index_sql($R,$X[0],$X[1],"(".implode(", ",$X[2]).")")))return
false;}return
true;}function
truncate_tables($T){return
apply_queries("DELETE FROM",$T);}function
drop_views($mj){return
apply_queries("DROP VIEW",$mj);}function
drop_tables($T){return
apply_queries("DROP TABLE",$T);}function
move_tables($T,$mj,$ji){return
false;}function
trigger($C,$R){if($C=="")return
array("Statement"=>"BEGIN\n\t;\nEND");$v='(?:[^`"\s]+|`[^`]*`|"[^"]*")+';$Ji=trigger_options();preg_match("~^CREATE\\s+TRIGGER\\s*$v\\s*(".implode("|",$Ji["Timing"]).")\\s+([a-z]+)(?:\\s+OF\\s+($v))?\\s+ON\\s*$v\\s*(?:FOR\\s+EACH\\s+ROW\\s)?(.*)~is",get_val("SELECT sql FROM sqlite_master WHERE type = 'trigger' AND name = ".q($C)),$B);$uf=$B[3];return
array("Timing"=>strtoupper($B[1]),"Event"=>strtoupper($B[2]).($uf?" OF":""),"Of"=>idf_unescape($uf),"Trigger"=>$C,"Statement"=>$B[4],);}function
triggers($R){$J=array();$Ji=trigger_options();foreach(get_rows("SELECT * FROM sqlite_master WHERE type = 'trigger' AND tbl_name = ".q($R))as$K){preg_match('~^CREATE\s+TRIGGER\s*(?:[^`"\s]+|`[^`]*`|"[^"]*")+\s*('.implode("|",$Ji["Timing"]).')\s*(.*?)\s+ON\b~i',$K["sql"],$B);$J[$K["name"]]=array($B[1],$B[2]);}return$J;}function
trigger_options(){return
array("Timing"=>array("BEFORE","AFTER","INSTEAD OF"),"Event"=>array("INSERT","UPDATE","UPDATE OF","DELETE"),"Type"=>array("FOR EACH ROW"),);}function
begin(){return
queries("BEGIN");}function
last_id($I){return
get_val("SELECT LAST_INSERT_ROWID()");}function
explain($g,$H){return$g->query("EXPLAIN QUERY PLAN $H");}function
found_rows($S,$Z){}function
types(){return
array();}function
create_sql($R,$Ba,$Th){$J=get_val("SELECT sql FROM sqlite_master WHERE type IN ('table', 'view') AND name = ".q($R));foreach(indexes($R)as$C=>$w){if($C=='')continue;$J
.=";\n\n".index_sql($R,$w['type'],$C,"(".implode(", ",array_map('Adminer\idf_escape',$w['columns'])).")");}return$J;}function
truncate_sql($R){return"DELETE FROM ".table($R);}function
use_sql($Lb){}function
trigger_sql($R){return
implode(get_vals("SELECT sql || ';;\n' FROM sqlite_master WHERE type = 'trigger' AND tbl_name = ".q($R)));}function
show_variables(){$J=array();foreach(get_rows("PRAGMA pragma_list")as$K){$C=$K["name"];if($C!="pragma_list"&&$C!="compile_options"){$J[$C]=array($C,'');foreach(get_rows("PRAGMA $C")as$K)$J[$C][1].=implode(", ",$K)."\n";}}return$J;}function
show_status(){$J=array();foreach(get_vals("PRAGMA compile_options")as$If)$J[]=explode("=",$If,2);return$J;}function
convert_field($n){}function
unconvert_field($n,$J){return$J;}function
support($Qc){return
preg_match('~^(check|columns|database|drop_col|dump|indexes|descidx|move_col|sql|status|table|trigger|variables|view|view_trigger)$~',$Qc);}}add_driver("pgsql","PostgreSQL");if(isset($_GET["pgsql"])){define('Adminer\DRIVER',"pgsql");if(extension_loaded("pgsql")&&$_GET["ext"]!="pdo"){class
Db
extends
SqlDb{var$extension="PgSQL";var$timeout=0;private$link,$string,$database=true;function
_error($zc,$m){if(ini_bool("html_errors"))$m=html_entity_decode(strip_tags($m));$m=preg_replace('~^[^:]*: ~','',$m);$this->error=$m;}function
attach($N,$V,$F){$k=adminer()->database();set_error_handler(array($this,'_error'));$this->string="host='".str_replace(":","' port='",addcslashes($N,"'\\"))."' user='".addcslashes($V,"'\\")."' password='".addcslashes($F,"'\\")."'";$Oh=adminer()->connectSsl();if(isset($Oh["mode"]))$this->string
.=" sslmode='".$Oh["mode"]."'";$this->link=@pg_connect("$this->string dbname='".($k!=""?addcslashes($k,"'\\"):"postgres")."'",PGSQL_CONNECT_FORCE_NEW);if(!$this->link&&$k!=""){$this->database=false;$this->link=@pg_connect("$this->string dbname='postgres'",PGSQL_CONNECT_FORCE_NEW);}restore_error_handler();if($this->link)pg_set_client_encoding($this->link,"UTF8");return($this->link?'':$this->error);}function
quote($Q){return(function_exists('pg_escape_literal')?pg_escape_literal($this->link,$Q):"'".pg_escape_string($this->link,$Q)."'");}function
value($X,array$n){return($n["type"]=="bytea"&&$X!==null?pg_unescape_bytea($X):$X);}function
select_db($Lb){if($Lb==adminer()->database())return$this->database;$J=@pg_connect("$this->string dbname='".addcslashes($Lb,"'\\")."'",PGSQL_CONNECT_FORCE_NEW);if($J)$this->link=$J;return$J;}function
close(){$this->link=@pg_connect("$this->string dbname='postgres'");}function
query($H,$Oi=false){$I=@pg_query($this->link,$H);$this->error="";if(!$I){$this->error=pg_last_error($this->link);$J=false;}elseif(!pg_num_fields($I)){$this->affected_rows=pg_affected_rows($I);$J=true;}else$J=new
Result($I);if($this->timeout){$this->timeout=0;$this->query("RESET statement_timeout");}return$J;}function
warnings(){return
h(pg_last_notice($this->link));}}class
Result{var$num_rows;private$result,$offset=0;function
__construct($I){$this->result=$I;$this->num_rows=pg_num_rows($I);}function
fetch_assoc(){return
pg_fetch_assoc($this->result);}function
fetch_row(){return
pg_fetch_row($this->result);}function
fetch_field(){$d=$this->offset++;$J=new
\stdClass;$J->orgtable=pg_field_table($this->result,$d);$J->name=pg_field_name($this->result,$d);$J->type=pg_field_type($this->result,$d);$J->charsetnr=($J->type=="bytea"?63:0);return$J;}function
__destruct(){pg_free_result($this->result);}}}elseif(extension_loaded("pdo_pgsql")){class
Db
extends
PdoDb{var$extension="PDO_PgSQL";var$timeout=0;function
attach($N,$V,$F){$k=adminer()->database();$ic="pgsql:host='".str_replace(":","' port='",addcslashes($N,"'\\"))."' client_encoding=utf8 dbname='".($k!=""?addcslashes($k,"'\\"):"postgres")."'";$Oh=adminer()->connectSsl();if(isset($Oh["mode"]))$ic
.=" sslmode='".$Oh["mode"]."'";return$this->dsn($ic,$V,$F);}function
select_db($Lb){return(adminer()->database()==$Lb);}function
query($H,$Oi=false){$J=parent::query($H,$Oi);if($this->timeout){$this->timeout=0;parent::query("RESET statement_timeout");}return$J;}function
warnings(){}function
close(){}}}class
Driver
extends
SqlDriver{static$Lc=array("PgSQL","PDO_PgSQL");static$ne="pgsql";var$operators=array("=","<",">","<=",">=","!=","~","!~","LIKE","LIKE %%","ILIKE","ILIKE %%","IN","IS NULL","NOT LIKE","NOT IN","IS NOT NULL");var$functions=array("char_length","lower","round","to_hex","to_timestamp","upper");var$grouping=array("avg","count","count distinct","max","min","sum");static
function
connect($N,$V,$F){$g=parent::connect($N,$V,$F);if(is_string($g))return$g;$kj=get_val("SELECT version()",0,$g);$g->flavor=(preg_match('~CockroachDB~',$kj)?'cockroach':'');$g->server_info=preg_replace('~^\D*([\d.]+[-\w]*).*~','\1',$kj);if(min_version(9,0,$g))$g->query("SET application_name = 'Adminer'");if($g->flavor=='cockroach')add_driver(DRIVER,"CockroachDB");return$g;}function
__construct(Db$g){parent::__construct($g);$this->types=array(lang(25)=>array("smallint"=>5,"integer"=>10,"bigint"=>19,"boolean"=>1,"numeric"=>0,"real"=>7,"double precision"=>16,"money"=>20),lang(26)=>array("date"=>13,"time"=>17,"timestamp"=>20,"timestamptz"=>21,"interval"=>0),lang(27)=>array("character"=>0,"character varying"=>0,"text"=>0,"tsquery"=>0,"tsvector"=>0,"uuid"=>0,"xml"=>0),lang(28)=>array("bit"=>0,"bit varying"=>0,"bytea"=>0),lang(29)=>array("cidr"=>43,"inet"=>43,"macaddr"=>17,"macaddr8"=>23,"txid_snapshot"=>0),lang(30)=>array("box"=>0,"circle"=>0,"line"=>0,"lseg"=>0,"path"=>0,"point"=>0,"polygon"=>0),);if(min_version(9.2,0,$g)){$this->types[lang(27)]["json"]=4294967295;if(min_version(9.4,0,$g))$this->types[lang(27)]["jsonb"]=4294967295;}$this->insertFunctions=array("char"=>"md5","date|time"=>"now",);$this->editFunctions=array(number_type()=>"+/-","date|time"=>"+ interval/- interval","char|text"=>"||",);if(min_version(12,0,$g))$this->generated=array("STORED");}function
enumLength(array$n){$vc=$this->types[lang(31)][$n["type"]];return($vc?type_values($vc):"");}function
setUserTypes($Ni){$this->types[lang(31)]=array_flip($Ni);}function
insertReturning($R){$Ba=array_filter(fields($R),function($n){return$n['auto_increment'];});return(count($Ba)==1?" RETURNING ".idf_escape(key($Ba)):"");}function
insertUpdate($R,array$L,array$G){foreach($L
as$O){$Wi=array();$Z=array();foreach($O
as$y=>$X){$Wi[]="$y = $X";if(isset($G[idf_unescape($y)]))$Z[]="$y = $X";}if(!(($Z&&queries("UPDATE ".table($R)." SET ".implode(", ",$Wi)." WHERE ".implode(" AND ",$Z))&&connection()->affected_rows)||queries("INSERT INTO ".table($R)." (".implode(", ",array_keys($O)).") VALUES (".implode(", ",$O).")")))return
false;}return
true;}function
slowQuery($H,$ri){$this->conn->query("SET statement_timeout = ".(1000*$ri));$this->conn->timeout=1000*$ri;return$H;}function
convertSearch($v,array$X,array$n){$oi="char|text";if(strpos($X["op"],"LIKE")===false)$oi
.="|date|time(stamp)?|boolean|uuid|inet|cidr|macaddr|".number_type();return(preg_match("~$oi~",$n["type"])?$v:"CAST($v AS text)");}function
quoteBinary($hh){return"'\\x".bin2hex($hh)."'";}function
warnings(){return$this->conn->warnings();}function
tableHelp($C,$le=false){$De=array("information_schema"=>"infoschema","pg_catalog"=>($le?"view":"catalog"),);$A=$De[$_GET["ns"]];if($A)return"$A-".str_replace("_","-",$C).".html";}function
supportsIndex(array$S){return$S["Engine"]!="view";}function
hasCStyleEscapes(){static$Ra;if($Ra===null)$Ra=(get_val("SHOW standard_conforming_strings",0,$this->conn)=="off");return$Ra;}}function
idf_escape($v){return'"'.str_replace('"','""',$v).'"';}function
table($v){return
idf_escape($v);}function
get_databases($cd){return
get_vals("SELECT datname FROM pg_database
WHERE datallowconn = TRUE AND has_database_privilege(datname, 'CONNECT')
ORDER BY datname");}function
limit($H,$Z,$_,$D=0,$th=" "){return" $H$Z".($_?$th."LIMIT $_".($D?" OFFSET $D":""):"");}function
limit1($R,$H,$Z,$th="\n"){return(preg_match('~^INTO~',$H)?limit($H,$Z,1,0,$th):" $H".(is_view(table_status1($R))?$Z:$th."WHERE ctid = (SELECT ctid FROM ".table($R).$Z.$th."LIMIT 1)"));}function
db_collation($k,$jb){return
get_val("SELECT datcollate FROM pg_database WHERE datname = ".q($k));}function
logged_user(){return
get_val("SELECT user");}function
tables_list(){$H="SELECT table_name, table_type FROM information_schema.tables WHERE table_schema = current_schema()";if(support("materializedview"))$H
.="
UNION ALL
SELECT matviewname, 'MATERIALIZED VIEW'
FROM pg_matviews
WHERE schemaname = current_schema()";$H
.="
ORDER BY 1";return
get_key_vals($H);}function
count_tables($j){$J=array();foreach($j
as$k){if(connection()->select_db($k))$J[$k]=count(tables_list());}return$J;}function
table_status($C=""){static$Ad;if($Ad===null)$Ad=get_val("SELECT 'pg_table_size'::regproc");$J=array();foreach(get_rows("SELECT
	c.relname AS \"Name\",
	CASE c.relkind WHEN 'r' THEN 'table' WHEN 'm' THEN 'materialized view' ELSE 'view' END AS \"Engine\"".($Ad?",
	pg_table_size(c.oid) AS \"Data_length\",
	pg_indexes_size(c.oid) AS \"Index_length\"":"").",
	obj_description(c.oid, 'pg_class') AS \"Comment\",
	".(min_version(12)?"''":"CASE WHEN c.relhasoids THEN 'oid' ELSE '' END")." AS \"Oid\",
	c.reltuples as \"Rows\",
	n.nspname
FROM pg_class c
JOIN pg_namespace n ON(n.nspname = current_schema() AND n.oid = c.relnamespace)
WHERE relkind IN ('r', 'm', 'v', 'f', 'p')
".($C!=""?"AND relname = ".q($C):"ORDER BY relname"))as$K)$J[$K["Name"]]=$K;return$J;}function
is_view($S){return
in_array($S["Engine"],array("view","materialized view"));}function
fk_support($S){return
true;}function
fields($R){$J=array();$ta=array('timestamp without time zone'=>'timestamp','timestamp with time zone'=>'timestamptz',);foreach(get_rows("SELECT
	a.attname AS field,
	format_type(a.atttypid, a.atttypmod) AS full_type,
	pg_get_expr(d.adbin, d.adrelid) AS default,
	a.attnotnull::int,
	col_description(c.oid, a.attnum) AS comment".(min_version(10)?",
	a.attidentity".(min_version(12)?",
	a.attgenerated":""):"")."
FROM pg_class c
JOIN pg_namespace n ON c.relnamespace = n.oid
JOIN pg_attribute a ON c.oid = a.attrelid
LEFT JOIN pg_attrdef d ON c.oid = d.adrelid AND a.attnum = d.adnum
WHERE c.relname = ".q($R)."
AND n.nspname = current_schema()
AND NOT a.attisdropped
AND a.attnum > 0
ORDER BY a.attnum")as$K){preg_match('~([^([]+)(\((.*)\))?([a-z ]+)?((\[[0-9]*])*)$~',$K["full_type"],$B);list(,$U,$z,$K["length"],$ma,$xa)=$B;$K["length"].=$xa;$Za=$U.$ma;if(isset($ta[$Za])){$K["type"]=$ta[$Za];$K["full_type"]=$K["type"].$z.$xa;}else{$K["type"]=$U;$K["full_type"]=$K["type"].$z.$ma.$xa;}if(in_array($K['attidentity'],array('a','d')))$K['default']='GENERATED '.($K['attidentity']=='d'?'BY DEFAULT':'ALWAYS').' AS IDENTITY';$K["generated"]=($K["attgenerated"]=="s"?"STORED":"");$K["null"]=!$K["attnotnull"];$K["auto_increment"]=$K['attidentity']||preg_match('~^nextval\(~i',$K["default"])||preg_match('~^unique_rowid\(~',$K["default"]);$K["privileges"]=array("insert"=>1,"select"=>1,"update"=>1,"where"=>1,"order"=>1);if(preg_match('~(.+)::[^,)]+(.*)~',$K["default"],$B))$K["default"]=($B[1]=="NULL"?null:idf_unescape($B[1]).$B[2]);$J[$K["field"]]=$K;}return$J;}function
indexes($R,$h=null){$h=connection($h);$J=array();$ci=get_val("SELECT oid FROM pg_class WHERE relnamespace = (SELECT oid FROM pg_namespace WHERE nspname = current_schema()) AND relname = ".q($R),0,$h);$e=get_key_vals("SELECT attnum, attname FROM pg_attribute WHERE attrelid = $ci AND attnum > 0",$h);foreach(get_rows("SELECT relname, indisunique::int, indisprimary::int, indkey, indoption, (indpred IS NOT NULL)::int as indispartial
FROM pg_index i, pg_class ci
WHERE i.indrelid = $ci AND ci.oid = i.indexrelid
ORDER BY indisprimary DESC, indisunique DESC",$h)as$K){$Ug=$K["relname"];$J[$Ug]["type"]=($K["indispartial"]?"INDEX":($K["indisprimary"]?"PRIMARY":($K["indisunique"]?"UNIQUE":"INDEX")));$J[$Ug]["columns"]=array();$J[$Ug]["descs"]=array();if($K["indkey"]){foreach(explode(" ",$K["indkey"])as$Vd)$J[$Ug]["columns"][]=$e[$Vd];foreach(explode(" ",$K["indoption"])as$Wd)$J[$Ug]["descs"][]=(intval($Wd)&1?'1':null);}$J[$Ug]["lengths"]=array();}return$J;}function
foreign_keys($R){$J=array();foreach(get_rows("SELECT conname, condeferrable::int AS deferrable, pg_get_constraintdef(oid) AS definition
FROM pg_constraint
WHERE conrelid = (SELECT pc.oid FROM pg_class AS pc INNER JOIN pg_namespace AS pn ON (pn.oid = pc.relnamespace) WHERE pc.relname = ".q($R)." AND pn.nspname = current_schema())
AND contype = 'f'::char
ORDER BY conkey, conname")as$K){if(preg_match('~FOREIGN KEY\s*\((.+)\)\s*REFERENCES (.+)\((.+)\)(.*)$~iA',$K['definition'],$B)){$K['source']=array_map('Adminer\idf_unescape',array_map('trim',explode(',',$B[1])));if(preg_match('~^(("([^"]|"")+"|[^"]+)\.)?"?("([^"]|"")+"|[^"]+)$~',$B[2],$Je)){$K['ns']=idf_unescape($Je[2]);$K['table']=idf_unescape($Je[4]);}$K['target']=array_map('Adminer\idf_unescape',array_map('trim',explode(',',$B[3])));$K['on_delete']=(preg_match("~ON DELETE (driver()->onActions)~",$B[4],$Je)?$Je[1]:'NO ACTION');$K['on_update']=(preg_match("~ON UPDATE (driver()->onActions)~",$B[4],$Je)?$Je[1]:'NO ACTION');$J[$K['conname']]=$K;}}return$J;}function
view($C){return
array("select"=>trim(get_val("SELECT pg_get_viewdef(".get_val("SELECT oid FROM pg_class WHERE relnamespace = (SELECT oid FROM pg_namespace WHERE nspname = current_schema()) AND relname = ".q($C)).")")));}function
collations(){return
array();}function
information_schema($k){return
get_schema()=="information_schema";}function
error(){$J=h(connection()->error);if(preg_match('~^(.*\n)?([^\n]*)\n( *)\^(\n.*)?$~s',$J,$B))$J=$B[1].preg_replace('~((?:[^&]|&[^;]*;){'.strlen($B[3]).'})(.*)~','\1<b>\2</b>',$B[2]).$B[4];return
nl_br($J);}function
create_database($k,$c){return
queries("CREATE DATABASE ".idf_escape($k).($c?" ENCODING ".idf_escape($c):""));}function
drop_databases($j){connection()->close();return
apply_queries("DROP DATABASE",$j,'Adminer\idf_escape');}function
rename_database($C,$c){connection()->close();return
queries("ALTER DATABASE ".idf_escape(DB)." RENAME TO ".idf_escape($C));}function
auto_increment(){return"";}function
alter_table($R,$C,$o,$ed,$ob,$tc,$c,$Ba,$ig){$b=array();$Hg=array();if($R!=""&&$R!=$C)$Hg[]="ALTER TABLE ".table($R)." RENAME TO ".table($C);$uh="";foreach($o
as$n){$d=idf_escape($n[0]);$X=$n[1];if(!$X)$b[]="DROP $d";else{$gj=$X[5];unset($X[5]);if($n[0]==""){if(isset($X[6]))$X[1]=($X[1]==" bigint"?" big":($X[1]==" smallint"?" small":" "))."serial";$b[]=($R!=""?"ADD ":"  ").implode($X);if(isset($X[6]))$b[]=($R!=""?"ADD":" ")." PRIMARY KEY ($X[0])";}else{if($d!=$X[0])$Hg[]="ALTER TABLE ".table($C)." RENAME $d TO $X[0]";$b[]="ALTER $d TYPE$X[1]";$vh=$R."_".idf_unescape($X[0])."_seq";$b[]="ALTER $d ".($X[3]?"SET".preg_replace('~GENERATED ALWAYS(.*) STORED~','EXPRESSION\1',$X[3]):(isset($X[6])?"SET DEFAULT nextval(".q($vh).")":"DROP DEFAULT"));if(isset($X[6]))$uh="CREATE SEQUENCE IF NOT EXISTS ".idf_escape($vh)." OWNED BY ".idf_escape($R).".$X[0]";$b[]="ALTER $d ".($X[2]==" NULL"?"DROP NOT":"SET").$X[2];}if($n[0]!=""||$gj!="")$Hg[]="COMMENT ON COLUMN ".table($C).".$X[0] IS ".($gj!=""?substr($gj,9):"''");}}$b=array_merge($b,$ed);if($R=="")array_unshift($Hg,"CREATE TABLE ".table($C)." (\n".implode(",\n",$b)."\n)");elseif($b)array_unshift($Hg,"ALTER TABLE ".table($R)."\n".implode(",\n",$b));if($uh)array_unshift($Hg,$uh);if($ob!==null)$Hg[]="COMMENT ON TABLE ".table($C)." IS ".q($ob);foreach($Hg
as$H){if(!queries($H))return
false;}return
true;}function
alter_indexes($R,$b){$i=array();$dc=array();$Hg=array();foreach($b
as$X){if($X[0]!="INDEX")$i[]=($X[2]=="DROP"?"\nDROP CONSTRAINT ".idf_escape($X[1]):"\nADD".($X[1]!=""?" CONSTRAINT ".idf_escape($X[1]):"")." $X[0] ".($X[0]=="PRIMARY"?"KEY ":"")."(".implode(", ",$X[2]).")");elseif($X[2]=="DROP")$dc[]=idf_escape($X[1]);else$Hg[]="CREATE INDEX ".idf_escape($X[1]!=""?$X[1]:uniqid($R."_"))." ON ".table($R)." (".implode(", ",$X[2]).")";}if($i)array_unshift($Hg,"ALTER TABLE ".table($R).implode(",",$i));if($dc)array_unshift($Hg,"DROP INDEX ".implode(", ",$dc));foreach($Hg
as$H){if(!queries($H))return
false;}return
true;}function
truncate_tables($T){return
queries("TRUNCATE ".implode(", ",array_map('Adminer\table',$T)));}function
drop_views($mj){return
drop_tables($mj);}function
drop_tables($T){foreach($T
as$R){$P=table_status1($R);if(!queries("DROP ".strtoupper($P["Engine"])." ".table($R)))return
false;}return
true;}function
move_tables($T,$mj,$ji){foreach(array_merge($T,$mj)as$R){$P=table_status1($R);if(!queries("ALTER ".strtoupper($P["Engine"])." ".table($R)." SET SCHEMA ".idf_escape($ji)))return
false;}return
true;}function
trigger($C,$R){if($C=="")return
array("Statement"=>"EXECUTE PROCEDURE ()");$e=array();$Z="WHERE trigger_schema = current_schema() AND event_object_table = ".q($R)." AND trigger_name = ".q($C);foreach(get_rows("SELECT * FROM information_schema.triggered_update_columns $Z")as$K)$e[]=$K["event_object_column"];$J=array();foreach(get_rows('SELECT trigger_name AS "Trigger", action_timing AS "Timing", event_manipulation AS "Event", \'FOR EACH \' || action_orientation AS "Type", action_statement AS "Statement"
FROM information_schema.triggers'."
$Z
ORDER BY event_manipulation DESC")as$K){if($e&&$K["Event"]=="UPDATE")$K["Event"].=" OF";$K["Of"]=implode(", ",$e);if($J)$K["Event"].=" OR $J[Event]";$J=$K;}return$J;}function
triggers($R){$J=array();foreach(get_rows("SELECT * FROM information_schema.triggers WHERE trigger_schema = current_schema() AND event_object_table = ".q($R))as$K){$Hi=trigger($K["trigger_name"],$R);$J[$Hi["Trigger"]]=array($Hi["Timing"],$Hi["Event"]);}return$J;}function
trigger_options(){return
array("Timing"=>array("BEFORE","AFTER"),"Event"=>array("INSERT","UPDATE","UPDATE OF","DELETE","INSERT OR UPDATE","INSERT OR UPDATE OF","DELETE OR INSERT","DELETE OR UPDATE","DELETE OR UPDATE OF","DELETE OR INSERT OR UPDATE","DELETE OR INSERT OR UPDATE OF"),"Type"=>array("FOR EACH ROW","FOR EACH STATEMENT"),);}function
routine($C,$U){$L=get_rows('SELECT routine_definition AS definition, LOWER(external_language) AS language, *
FROM information_schema.routines
WHERE routine_schema = current_schema() AND specific_name = '.q($C));$J=idx($L,0,array());$J["returns"]=array("type"=>$J["type_udt_name"]);$J["fields"]=get_rows('SELECT parameter_name AS field, data_type AS type, character_maximum_length AS length, parameter_mode AS inout
FROM information_schema.parameters
WHERE specific_schema = current_schema() AND specific_name = '.q($C).'
ORDER BY ordinal_position');return$J;}function
routines(){return
get_rows('SELECT specific_name AS "SPECIFIC_NAME", routine_type AS "ROUTINE_TYPE", routine_name AS "ROUTINE_NAME", type_udt_name AS "DTD_IDENTIFIER"
FROM information_schema.routines
WHERE routine_schema = current_schema()
ORDER BY SPECIFIC_NAME');}function
routine_languages(){return
get_vals("SELECT LOWER(lanname) FROM pg_catalog.pg_language");}function
routine_id($C,$K){$J=array();foreach($K["fields"]as$n){$z=$n["length"];$J[]=$n["type"].($z?"($z)":"");}return
idf_escape($C)."(".implode(", ",$J).")";}function
last_id($I){$K=(is_object($I)?$I->fetch_row():array());return($K?$K[0]:0);}function
explain($g,$H){return$g->query("EXPLAIN $H");}function
found_rows($S,$Z){if(preg_match("~ rows=([0-9]+)~",get_val("EXPLAIN SELECT * FROM ".idf_escape($S["Name"]).($Z?" WHERE ".implode(" AND ",$Z):"")),$Tg))return$Tg[1];}function
types(){return
get_key_vals("SELECT oid, typname
FROM pg_type
WHERE typnamespace = (SELECT oid FROM pg_namespace WHERE nspname = current_schema())
AND typtype IN ('b','d','e')
AND typelem = 0");}function
type_values($u){$yc=get_vals("SELECT enumlabel FROM pg_enum WHERE enumtypid = $u ORDER BY enumsortorder");return($yc?"'".implode("', '",array_map('addslashes',$yc))."'":"");}function
schemas(){return
get_vals("SELECT nspname FROM pg_namespace ORDER BY nspname");}function
get_schema(){return
get_val("SELECT current_schema()");}function
set_schema($jh,$h=null){if(!$h)$h=connection();$J=$h->query("SET search_path TO ".idf_escape($jh));driver()->setUserTypes(types());return$J;}function
foreign_keys_sql($R){$J="";$P=table_status1($R);$ad=foreign_keys($R);ksort($ad);foreach($ad
as$Zc=>$Yc)$J
.="ALTER TABLE ONLY ".idf_escape($P['nspname']).".".idf_escape($P['Name'])." ADD CONSTRAINT ".idf_escape($Zc)." $Yc[definition] ".($Yc['deferrable']?'DEFERRABLE':'NOT DEFERRABLE').";\n";return($J?"$J\n":$J);}function
create_sql($R,$Ba,$Th){$Zg=array();$wh=array();$P=table_status1($R);if(is_view($P)){$lj=view($R);return
rtrim("CREATE VIEW ".idf_escape($R)." AS $lj[select]",";");}$o=fields($R);if(count($P)<2||empty($o))return
false;$J="CREATE TABLE ".idf_escape($P['nspname']).".".idf_escape($P['Name'])." (\n    ";foreach($o
as$n){$fg=idf_escape($n['field']).' '.$n['full_type'].default_value($n).($n['null']?"":" NOT NULL");$Zg[]=$fg;if(preg_match('~nextval\(\'([^\']+)\'\)~',$n['default'],$Le)){$vh=$Le[1];$Ih=first(get_rows((min_version(10)?"SELECT *, cache_size AS cache_value FROM pg_sequences WHERE schemaname = current_schema() AND sequencename = ".q(idf_unescape($vh)):"SELECT * FROM $vh"),null,"-- "));$wh[]=($Th=="DROP+CREATE"?"DROP SEQUENCE IF EXISTS $vh;\n":"")."CREATE SEQUENCE $vh INCREMENT $Ih[increment_by] MINVALUE $Ih[min_value] MAXVALUE $Ih[max_value]".($Ba&&$Ih['last_value']?" START ".($Ih["last_value"]+1):"")." CACHE $Ih[cache_value];";}}if(!empty($wh))$J=implode("\n\n",$wh)."\n\n$J";$G="";foreach(indexes($R)as$Td=>$w){if($w['type']=='PRIMARY'){$G=$Td;$Zg[]="CONSTRAINT ".idf_escape($Td)." PRIMARY KEY (".implode(', ',array_map('Adminer\idf_escape',$w['columns'])).")";}}foreach(driver()->checkConstraints($R)as$tb=>$vb)$Zg[]="CONSTRAINT ".idf_escape($tb)." CHECK $vb";$J
.=implode(",\n    ",$Zg)."\n) WITH (oids = ".($P['Oid']?'true':'false').");";if($P['Comment'])$J
.="\n\nCOMMENT ON TABLE ".idf_escape($P['nspname']).".".idf_escape($P['Name'])." IS ".q($P['Comment']).";";foreach($o
as$Sc=>$n){if($n['comment'])$J
.="\n\nCOMMENT ON COLUMN ".idf_escape($P['nspname']).".".idf_escape($P['Name']).".".idf_escape($Sc)." IS ".q($n['comment']).";";}foreach(get_rows("SELECT indexdef FROM pg_catalog.pg_indexes WHERE schemaname = current_schema() AND tablename = ".q($R).($G?" AND indexname != ".q($G):""),null,"-- ")as$K)$J
.="\n\n$K[indexdef];";return
rtrim($J,';');}function
truncate_sql($R){return"TRUNCATE ".table($R);}function
trigger_sql($R){$P=table_status1($R);$J="";foreach(triggers($R)as$Gi=>$Fi){$Hi=trigger($Gi,$P['Name']);$J
.="\nCREATE TRIGGER ".idf_escape($Hi['Trigger'])." $Hi[Timing] $Hi[Event] ON ".idf_escape($P["nspname"]).".".idf_escape($P['Name'])." $Hi[Type] $Hi[Statement];;\n";}return$J;}function
use_sql($Lb){return"\connect ".idf_escape($Lb);}function
show_variables(){return
get_rows("SHOW ALL");}function
process_list(){return
get_rows("SELECT * FROM pg_stat_activity ORDER BY ".(min_version(9.2)?"pid":"procpid"));}function
convert_field($n){}function
unconvert_field($n,$J){return$J;}function
support($Qc){return
preg_match('~^(check|database|table|columns|sql|indexes|descidx|comment|view|'.(min_version(9.3)?'materializedview|':'').'scheme|'.(min_version(11)?'procedure|':'').'routine|sequence|trigger|type|variables|drop_col'.(connection()->flavor=='cockroach'?'':'|processlist').'|kill|dump)$~',$Qc);}function
kill_process($X){return
queries("SELECT pg_terminate_backend(".number($X).")");}function
connection_id(){return"SELECT pg_backend_pid()";}function
max_connections(){return
get_val("SHOW max_connections");}}add_driver("oracle","Oracle (beta)");if(isset($_GET["oracle"])){define('Adminer\DRIVER',"oracle");if(extension_loaded("oci8")&&$_GET["ext"]!="pdo"){class
Db
extends
SqlDb{var$extension="oci8";var$_current_db;private$link;function
_error($zc,$m){if(ini_bool("html_errors"))$m=html_entity_decode(strip_tags($m));$m=preg_replace('~^[^:]*: ~','',$m);$this->error=$m;}function
attach($N,$V,$F){$this->link=@oci_new_connect($V,$F,$N,"AL32UTF8");if($this->link){$this->server_info=oci_server_version($this->link);return'';}$m=oci_error();return$m["message"];}function
quote($Q){return"'".str_replace("'","''",$Q)."'";}function
select_db($Lb){$this->_current_db=$Lb;return
true;}function
query($H,$Oi=false){$I=oci_parse($this->link,$H);$this->error="";if(!$I){$m=oci_error($this->link);$this->errno=$m["code"];$this->error=$m["message"];return
false;}set_error_handler(array($this,'_error'));$J=@oci_execute($I);restore_error_handler();if($J){if(oci_num_fields($I))return
new
Result($I);$this->affected_rows=oci_num_rows($I);oci_free_statement($I);}return$J;}}class
Result{var$num_rows;private$result,$offset=1;function
__construct($I){$this->result=$I;}private
function
convert($K){foreach((array)$K
as$y=>$X){if(is_a($X,'OCILob')||is_a($X,'OCI-Lob'))$K[$y]=$X->load();}return$K;}function
fetch_assoc(){return$this->convert(oci_fetch_assoc($this->result));}function
fetch_row(){return$this->convert(oci_fetch_row($this->result));}function
fetch_field(){$d=$this->offset++;$J=new
\stdClass;$J->name=oci_field_name($this->result,$d);$J->type=oci_field_type($this->result,$d);$J->charsetnr=(preg_match("~raw|blob|bfile~",$J->type)?63:0);return$J;}function
__destruct(){oci_free_statement($this->result);}}}elseif(extension_loaded("pdo_oci")){class
Db
extends
PdoDb{var$extension="PDO_OCI";var$_current_db;function
attach($N,$V,$F){return$this->dsn("oci:dbname=//$N;charset=AL32UTF8",$V,$F);}function
select_db($Lb){$this->_current_db=$Lb;return
true;}}}class
Driver
extends
SqlDriver{static$Lc=array("OCI8","PDO_OCI");static$ne="oracle";var$insertFunctions=array("date"=>"current_date","timestamp"=>"current_timestamp",);var$editFunctions=array("number|float|double"=>"+/-","date|timestamp"=>"+ interval/- interval","char|clob"=>"||",);var$operators=array("=","<",">","<=",">=","!=","LIKE","LIKE %%","IN","IS NULL","NOT LIKE","NOT IN","IS NOT NULL","SQL");var$functions=array("length","lower","round","upper");var$grouping=array("avg","count","count distinct","max","min","sum");function
__construct(Db$g){parent::__construct($g);$this->types=array(lang(25)=>array("number"=>38,"binary_float"=>12,"binary_double"=>21),lang(26)=>array("date"=>10,"timestamp"=>29,"interval year"=>12,"interval day"=>28),lang(27)=>array("char"=>2000,"varchar2"=>4000,"nchar"=>2000,"nvarchar2"=>4000,"clob"=>4294967295,"nclob"=>4294967295),lang(28)=>array("raw"=>2000,"long raw"=>2147483648,"blob"=>4294967295,"bfile"=>4294967296),);}function
begin(){return
true;}function
insertUpdate($R,array$L,array$G){foreach($L
as$O){$Wi=array();$Z=array();foreach($O
as$y=>$X){$Wi[]="$y = $X";if(isset($G[idf_unescape($y)]))$Z[]="$y = $X";}if(!(($Z&&queries("UPDATE ".table($R)." SET ".implode(", ",$Wi)." WHERE ".implode(" AND ",$Z))&&connection()->affected_rows)||queries("INSERT INTO ".table($R)." (".implode(", ",array_keys($O)).") VALUES (".implode(", ",$O).")")))return
false;}return
true;}function
hasCStyleEscapes(){return
true;}}function
idf_escape($v){return'"'.str_replace('"','""',$v).'"';}function
table($v){return
idf_escape($v);}function
get_databases($cd){return
get_vals("SELECT DISTINCT tablespace_name FROM (
SELECT tablespace_name FROM user_tablespaces
UNION SELECT tablespace_name FROM all_tables WHERE tablespace_name IS NOT NULL
)
ORDER BY 1");}function
limit($H,$Z,$_,$D=0,$th=" "){return($D?" * FROM (SELECT t.*, rownum AS rnum FROM (SELECT $H$Z) t WHERE rownum <= ".($_+$D).") WHERE rnum > $D":($_?" * FROM (SELECT $H$Z) WHERE rownum <= ".($_+$D):" $H$Z"));}function
limit1($R,$H,$Z,$th="\n"){return" $H$Z";}function
db_collation($k,$jb){return
get_val("SELECT value FROM nls_database_parameters WHERE parameter = 'NLS_CHARACTERSET'");}function
logged_user(){return
get_val("SELECT USER FROM DUAL");}function
get_current_db(){$k=connection()->_current_db?:DB;unset(connection()->_current_db);return$k;}function
where_owner($xg,$Zf="owner"){if(!$_GET["ns"])return'';return"$xg$Zf = sys_context('USERENV', 'CURRENT_SCHEMA')";}function
views_table($e){$Zf=where_owner('');return"(SELECT $e FROM all_views WHERE ".($Zf?:"rownum < 0").")";}function
tables_list(){$lj=views_table("view_name");$Zf=where_owner(" AND ");return
get_key_vals("SELECT table_name, 'table' FROM all_tables WHERE tablespace_name = ".q(DB)."$Zf
UNION SELECT view_name, 'view' FROM $lj
ORDER BY 1");}function
count_tables($j){$J=array();foreach($j
as$k)$J[$k]=get_val("SELECT COUNT(*) FROM all_tables WHERE tablespace_name = ".q($k));return$J;}function
table_status($C=""){$J=array();$mh=q($C);$k=get_current_db();$lj=views_table("view_name");$Zf=where_owner(" AND ");foreach(get_rows('SELECT table_name "Name", \'table\' "Engine", avg_row_len * num_rows "Data_length", num_rows "Rows" FROM all_tables WHERE tablespace_name = '.q($k).$Zf.($C!=""?" AND table_name = $mh":"")."
UNION SELECT view_name, 'view', 0, 0 FROM $lj".($C!=""?" WHERE view_name = $mh":"")."
ORDER BY 1")as$K)$J[$K["Name"]]=$K;return$J;}function
is_view($S){return$S["Engine"]=="view";}function
fk_support($S){return
true;}function
fields($R){$J=array();$Zf=where_owner(" AND ");foreach(get_rows("SELECT * FROM all_tab_columns WHERE table_name = ".q($R)."$Zf ORDER BY column_id")as$K){$U=$K["DATA_TYPE"];$z="$K[DATA_PRECISION],$K[DATA_SCALE]";if($z==",")$z=$K["CHAR_COL_DECL_LENGTH"];$J[$K["COLUMN_NAME"]]=array("field"=>$K["COLUMN_NAME"],"full_type"=>$U.($z?"($z)":""),"type"=>strtolower($U),"length"=>$z,"default"=>$K["DATA_DEFAULT"],"null"=>($K["NULLABLE"]=="Y"),"privileges"=>array("insert"=>1,"select"=>1,"update"=>1,"where"=>1,"order"=>1),);}return$J;}function
indexes($R,$h=null){$J=array();$Zf=where_owner(" AND ","aic.table_owner");foreach(get_rows("SELECT aic.*, ac.constraint_type, atc.data_default
FROM all_ind_columns aic
LEFT JOIN all_constraints ac ON aic.index_name = ac.constraint_name AND aic.table_name = ac.table_name AND aic.index_owner = ac.owner
LEFT JOIN all_tab_cols atc ON aic.column_name = atc.column_name AND aic.table_name = atc.table_name AND aic.index_owner = atc.owner
WHERE aic.table_name = ".q($R)."$Zf
ORDER BY ac.constraint_type, aic.column_position",$h)as$K){$Td=$K["INDEX_NAME"];$lb=$K["DATA_DEFAULT"];$lb=($lb?trim($lb,'"'):$K["COLUMN_NAME"]);$J[$Td]["type"]=($K["CONSTRAINT_TYPE"]=="P"?"PRIMARY":($K["CONSTRAINT_TYPE"]=="U"?"UNIQUE":"INDEX"));$J[$Td]["columns"][]=$lb;$J[$Td]["lengths"][]=($K["CHAR_LENGTH"]&&$K["CHAR_LENGTH"]!=$K["COLUMN_LENGTH"]?$K["CHAR_LENGTH"]:null);$J[$Td]["descs"][]=($K["DESCEND"]&&$K["DESCEND"]=="DESC"?'1':null);}return$J;}function
view($C){$lj=views_table("view_name, text");$L=get_rows('SELECT text "select" FROM '.$lj.' WHERE view_name = '.q($C));return
reset($L);}function
collations(){return
array();}function
information_schema($k){return
get_schema()=="INFORMATION_SCHEMA";}function
error(){return
h(connection()->error);}function
explain($g,$H){$g->query("EXPLAIN PLAN FOR $H");return$g->query("SELECT * FROM plan_table");}function
found_rows($S,$Z){}function
auto_increment(){return"";}function
alter_table($R,$C,$o,$ed,$ob,$tc,$c,$Ba,$ig){$b=$dc=array();$Sf=($R?fields($R):array());foreach($o
as$n){$X=$n[1];if($X&&$n[0]!=""&&idf_escape($n[0])!=$X[0])queries("ALTER TABLE ".table($R)." RENAME COLUMN ".idf_escape($n[0])." TO $X[0]");$Rf=$Sf[$n[0]];if($X&&$Rf){$wf=process_field($Rf,$Rf);if($X[2]==$wf[2])$X[2]="";}if($X)$b[]=($R!=""?($n[0]!=""?"MODIFY (":"ADD ("):"  ").implode($X).($R!=""?")":"");else$dc[]=idf_escape($n[0]);}if($R=="")return
queries("CREATE TABLE ".table($C)." (\n".implode(",\n",$b)."\n)");return(!$b||queries("ALTER TABLE ".table($R)."\n".implode("\n",$b)))&&(!$dc||queries("ALTER TABLE ".table($R)." DROP (".implode(", ",$dc).")"))&&($R==$C||queries("ALTER TABLE ".table($R)." RENAME TO ".table($C)));}function
alter_indexes($R,$b){$dc=array();$Hg=array();foreach($b
as$X){if($X[0]!="INDEX"){$X[2]=preg_replace('~ DESC$~','',$X[2]);$i=($X[2]=="DROP"?"\nDROP CONSTRAINT ".idf_escape($X[1]):"\nADD".($X[1]!=""?" CONSTRAINT ".idf_escape($X[1]):"")." $X[0] ".($X[0]=="PRIMARY"?"KEY ":"")."(".implode(", ",$X[2]).")");array_unshift($Hg,"ALTER TABLE ".table($R).$i);}elseif($X[2]=="DROP")$dc[]=idf_escape($X[1]);else$Hg[]="CREATE INDEX ".idf_escape($X[1]!=""?$X[1]:uniqid($R."_"))." ON ".table($R)." (".implode(", ",$X[2]).")";}if($dc)array_unshift($Hg,"DROP INDEX ".implode(", ",$dc));foreach($Hg
as$H){if(!queries($H))return
false;}return
true;}function
foreign_keys($R){$J=array();$H="SELECT c_list.CONSTRAINT_NAME as NAME,
c_src.COLUMN_NAME as SRC_COLUMN,
c_dest.OWNER as DEST_DB,
c_dest.TABLE_NAME as DEST_TABLE,
c_dest.COLUMN_NAME as DEST_COLUMN,
c_list.DELETE_RULE as ON_DELETE
FROM ALL_CONSTRAINTS c_list, ALL_CONS_COLUMNS c_src, ALL_CONS_COLUMNS c_dest
WHERE c_list.CONSTRAINT_NAME = c_src.CONSTRAINT_NAME
AND c_list.R_CONSTRAINT_NAME = c_dest.CONSTRAINT_NAME
AND c_list.CONSTRAINT_TYPE = 'R'
AND c_src.TABLE_NAME = ".q($R);foreach(get_rows($H)as$K)$J[$K['NAME']]=array("db"=>$K['DEST_DB'],"table"=>$K['DEST_TABLE'],"source"=>array($K['SRC_COLUMN']),"target"=>array($K['DEST_COLUMN']),"on_delete"=>$K['ON_DELETE'],"on_update"=>null,);return$J;}function
truncate_tables($T){return
apply_queries("TRUNCATE TABLE",$T);}function
drop_views($mj){return
apply_queries("DROP VIEW",$mj);}function
drop_tables($T){return
apply_queries("DROP TABLE",$T);}function
last_id($I){return
0;}function
schemas(){$J=get_vals("SELECT DISTINCT owner FROM dba_segments WHERE owner IN (SELECT username FROM dba_users WHERE default_tablespace NOT IN ('SYSTEM','SYSAUX')) ORDER BY 1");return($J?:get_vals("SELECT DISTINCT owner FROM all_tables WHERE tablespace_name = ".q(DB)." ORDER BY 1"));}function
get_schema(){return
get_val("SELECT sys_context('USERENV', 'SESSION_USER') FROM dual");}function
set_schema($lh,$h=null){if(!$h)$h=connection();return$h->query("ALTER SESSION SET CURRENT_SCHEMA = ".idf_escape($lh));}function
show_variables(){return
get_rows('SELECT name, display_value FROM v$parameter');}function
show_status(){$J=array();$L=get_rows('SELECT * FROM v$instance');foreach(reset($L)as$y=>$X)$J[]=array($y,$X);return$J;}function
process_list(){return
get_rows('SELECT
	sess.process AS "process",
	sess.username AS "user",
	sess.schemaname AS "schema",
	sess.status AS "status",
	sess.wait_class AS "wait_class",
	sess.seconds_in_wait AS "seconds_in_wait",
	sql.sql_text AS "sql_text",
	sess.machine AS "machine",
	sess.port AS "port"
FROM v$session sess LEFT OUTER JOIN v$sql sql
ON sql.sql_id = sess.sql_id
WHERE sess.type = \'USER\'
ORDER BY PROCESS
');}function
convert_field($n){}function
unconvert_field($n,$J){return$J;}function
support($Qc){return
preg_match('~^(columns|database|drop_col|indexes|descidx|processlist|scheme|sql|status|table|variables|view)$~',$Qc);}}add_driver("mssql","MS SQL");if(isset($_GET["mssql"])){define('Adminer\DRIVER',"mssql");if(extension_loaded("sqlsrv")&&$_GET["ext"]!="pdo"){class
Db
extends
SqlDb{var$extension="sqlsrv";private$link,$result;private
function
get_error(){$this->error="";foreach(sqlsrv_errors()as$m){$this->errno=$m["code"];$this->error
.="$m[message]\n";}$this->error=rtrim($this->error);}function
attach($N,$V,$F){$ub=array("UID"=>$V,"PWD"=>$F,"CharacterSet"=>"UTF-8");$Oh=adminer()->connectSsl();if(isset($Oh["Encrypt"]))$ub["Encrypt"]=$Oh["Encrypt"];if(isset($Oh["TrustServerCertificate"]))$ub["TrustServerCertificate"]=$Oh["TrustServerCertificate"];$k=adminer()->database();if($k!="")$ub["Database"]=$k;$this->link=@sqlsrv_connect(preg_replace('~:~',',',$N),$ub);if($this->link){$Xd=sqlsrv_server_info($this->link);$this->server_info=$Xd['SQLServerVersion'];}else$this->get_error();return($this->link?'':$this->error);}function
quote($Q){$Pi=strlen($Q)!=strlen(utf8_decode($Q));return($Pi?"N":"")."'".str_replace("'","''",$Q)."'";}function
select_db($Lb){return$this->query(use_sql($Lb));}function
query($H,$Oi=false){$I=sqlsrv_query($this->link,$H);$this->error="";if(!$I){$this->get_error();return
false;}return$this->store_result($I);}function
multi_query($H){$this->result=sqlsrv_query($this->link,$H);$this->error="";if(!$this->result){$this->get_error();return
false;}return
true;}function
store_result($I=null){if(!$I)$I=$this->result;if(!$I)return
false;if(sqlsrv_field_metadata($I))return
new
Result($I);$this->affected_rows=sqlsrv_rows_affected($I);return
true;}function
next_result(){return$this->result?!!sqlsrv_next_result($this->result):false;}}class
Result{var$num_rows;private$result,$offset=0,$fields;function
__construct($I){$this->result=$I;}private
function
convert($K){foreach((array)$K
as$y=>$X){if(is_a($X,'DateTime'))$K[$y]=$X->format("Y-m-d H:i:s");}return$K;}function
fetch_assoc(){return$this->convert(sqlsrv_fetch_array($this->result,SQLSRV_FETCH_ASSOC));}function
fetch_row(){return$this->convert(sqlsrv_fetch_array($this->result,SQLSRV_FETCH_NUMERIC));}function
fetch_field(){if(!$this->fields)$this->fields=sqlsrv_field_metadata($this->result);$n=$this->fields[$this->offset++];$J=new
\stdClass;$J->name=$n["Name"];$J->type=($n["Type"]==1?254:15);$J->charsetnr=0;return$J;}function
seek($D){for($t=0;$t<$D;$t++)sqlsrv_fetch($this->result);}function
__destruct(){sqlsrv_free_stmt($this->result);}}function
last_id($I){return
get_val("SELECT SCOPE_IDENTITY()");}function
explain($g,$H){$g->query("SET SHOWPLAN_ALL ON");$J=$g->query($H);$g->query("SET SHOWPLAN_ALL OFF");return$J;}}else{abstract
class
MssqlDb
extends
PdoDb{function
select_db($Lb){return$this->query(use_sql($Lb));}function
lastInsertId(){return$this->pdo->lastInsertId();}}function
last_id($I){return
connection()->lastInsertId();}function
explain($g,$H){}if(extension_loaded("pdo_sqlsrv")){class
Db
extends
MssqlDb{var$extension="PDO_SQLSRV";function
attach($N,$V,$F){return$this->dsn("sqlsrv:Server=".str_replace(":",",",$N),$V,$F);}}}elseif(extension_loaded("pdo_dblib")){class
Db
extends
MssqlDb{var$extension="PDO_DBLIB";function
attach($N,$V,$F){return$this->dsn("dblib:charset=utf8;host=".str_replace(":",";unix_socket=",preg_replace('~:(\d)~',';port=\1',$N)),$V,$F);}}}}class
Driver
extends
SqlDriver{static$Lc=array("SQLSRV","PDO_SQLSRV","PDO_DBLIB");static$ne="mssql";var$insertFunctions=array("date|time"=>"getdate");var$editFunctions=array("int|decimal|real|float|money|datetime"=>"+/-","char|text"=>"+",);var$operators=array("=","<",">","<=",">=","!=","LIKE","LIKE %%","IN","IS NULL","NOT LIKE","NOT IN","IS NOT NULL");var$functions=array("len","lower","round","upper");var$grouping=array("avg","count","count distinct","max","min","sum");var$generated=array("PERSISTED","VIRTUAL");var$onActions="NO ACTION|CASCADE|SET NULL|SET DEFAULT";static
function
connect($N,$V,$F){if($N=="")$N="localhost:1433";return
parent::connect($N,$V,$F);}function
__construct(Db$g){parent::__construct($g);$this->types=array(lang(25)=>array("tinyint"=>3,"smallint"=>5,"int"=>10,"bigint"=>20,"bit"=>1,"decimal"=>0,"real"=>12,"float"=>53,"smallmoney"=>10,"money"=>20),lang(26)=>array("date"=>10,"smalldatetime"=>19,"datetime"=>19,"datetime2"=>19,"time"=>8,"datetimeoffset"=>10),lang(27)=>array("char"=>8000,"varchar"=>8000,"text"=>2147483647,"nchar"=>4000,"nvarchar"=>4000,"ntext"=>1073741823),lang(28)=>array("binary"=>8000,"varbinary"=>8000,"image"=>2147483647),);}function
insertUpdate($R,array$L,array$G){$o=fields($R);$Wi=array();$Z=array();$O=reset($L);$e="c".implode(", c",range(1,count($O)));$Qa=0;$be=array();foreach($O
as$y=>$X){$Qa++;$C=idf_unescape($y);if(!$o[$C]["auto_increment"])$be[$y]="c$Qa";if(isset($G[$C]))$Z[]="$y = c$Qa";else$Wi[]="$y = c$Qa";}$hj=array();foreach($L
as$O)$hj[]="(".implode(", ",$O).")";if($Z){$Md=queries("SET IDENTITY_INSERT ".table($R)." ON");$J=queries("MERGE ".table($R)." USING (VALUES\n\t".implode(",\n\t",$hj)."\n) AS source ($e) ON ".implode(" AND ",$Z).($Wi?"\nWHEN MATCHED THEN UPDATE SET ".implode(", ",$Wi):"")."\nWHEN NOT MATCHED THEN INSERT (".implode(", ",array_keys($Md?$O:$be)).") VALUES (".($Md?$e:implode(", ",$be)).");");if($Md)queries("SET IDENTITY_INSERT ".table($R)." OFF");}else$J=queries("INSERT INTO ".table($R)." (".implode(", ",array_keys($O)).") VALUES\n".implode(",\n",$hj));return$J;}function
begin(){return
queries("BEGIN TRANSACTION");}function
tableHelp($C,$le=false){$De=array("sys"=>"catalog-views/sys-","INFORMATION_SCHEMA"=>"information-schema-views/",);$A=$De[get_schema()];if($A)return"relational-databases/system-$A".preg_replace('~_~','-',strtolower($C))."-transact-sql";}}function
idf_escape($v){return"[".str_replace("]","]]",$v)."]";}function
table($v){return($_GET["ns"]!=""?idf_escape($_GET["ns"]).".":"").idf_escape($v);}function
get_databases($cd){return
get_vals("SELECT name FROM sys.databases WHERE name NOT IN ('master', 'tempdb', 'model', 'msdb')");}function
limit($H,$Z,$_,$D=0,$th=" "){return($_?" TOP (".($_+$D).")":"")." $H$Z";}function
limit1($R,$H,$Z,$th="\n"){return
limit($H,$Z,1,0,$th);}function
db_collation($k,$jb){return
get_val("SELECT collation_name FROM sys.databases WHERE name = ".q($k));}function
logged_user(){return
get_val("SELECT SUSER_NAME()");}function
tables_list(){return
get_key_vals("SELECT name, type_desc FROM sys.all_objects WHERE schema_id = SCHEMA_ID(".q(get_schema()).") AND type IN ('S', 'U', 'V') ORDER BY name");}function
count_tables($j){$J=array();foreach($j
as$k){connection()->select_db($k);$J[$k]=get_val("SELECT COUNT(*) FROM INFORMATION_SCHEMA.TABLES");}return$J;}function
table_status($C=""){$J=array();foreach(get_rows("SELECT ao.name AS Name, ao.type_desc AS Engine, (SELECT value FROM fn_listextendedproperty(default, 'SCHEMA', schema_name(schema_id), 'TABLE', ao.name, null, null)) AS Comment
FROM sys.all_objects AS ao
WHERE schema_id = SCHEMA_ID(".q(get_schema()).") AND type IN ('S', 'U', 'V') ".($C!=""?"AND name = ".q($C):"ORDER BY name"))as$K)$J[$K["Name"]]=$K;return$J;}function
is_view($S){return$S["Engine"]=="VIEW";}function
fk_support($S){return
true;}function
fields($R){$qb=get_key_vals("SELECT objname, cast(value as varchar(max)) FROM fn_listextendedproperty('MS_DESCRIPTION', 'schema', ".q(get_schema()).", 'table', ".q($R).", 'column', NULL)");$J=array();$ai=get_val("SELECT object_id FROM sys.all_objects WHERE schema_id = SCHEMA_ID(".q(get_schema()).") AND type IN ('S', 'U', 'V') AND name = ".q($R));foreach(get_rows("SELECT c.max_length, c.precision, c.scale, c.name, c.is_nullable, c.is_identity, c.collation_name, t.name type, d.definition [default], d.name default_constraint, i.is_primary_key
FROM sys.all_columns c
JOIN sys.types t ON c.user_type_id = t.user_type_id
LEFT JOIN sys.default_constraints d ON c.default_object_id = d.object_id
LEFT JOIN sys.index_columns ic ON c.object_id = ic.object_id AND c.column_id = ic.column_id
LEFT JOIN sys.indexes i ON ic.object_id = i.object_id AND ic.index_id = i.index_id
WHERE c.object_id = ".q($ai))as$K){$U=$K["type"];$z=(preg_match("~char|binary~",$U)?intval($K["max_length"])/($U[0]=='n'?2:1):($U=="decimal"?"$K[precision],$K[scale]":""));$J[$K["name"]]=array("field"=>$K["name"],"full_type"=>$U.($z?"($z)":""),"type"=>$U,"length"=>$z,"default"=>(preg_match("~^\('(.*)'\)$~",$K["default"],$B)?str_replace("''","'",$B[1]):$K["default"]),"default_constraint"=>$K["default_constraint"],"null"=>$K["is_nullable"],"auto_increment"=>$K["is_identity"],"collation"=>$K["collation_name"],"privileges"=>array("insert"=>1,"select"=>1,"update"=>1,"where"=>1,"order"=>1),"primary"=>$K["is_primary_key"],"comment"=>$qb[$K["name"]],);}foreach(get_rows("SELECT * FROM sys.computed_columns WHERE object_id = ".q($ai))as$K){$J[$K["name"]]["generated"]=($K["is_persisted"]?"PERSISTED":"VIRTUAL");$J[$K["name"]]["default"]=$K["definition"];}return$J;}function
indexes($R,$h=null){$J=array();foreach(get_rows("SELECT i.name, key_ordinal, is_unique, is_primary_key, c.name AS column_name, is_descending_key
FROM sys.indexes i
INNER JOIN sys.index_columns ic ON i.object_id = ic.object_id AND i.index_id = ic.index_id
INNER JOIN sys.columns c ON ic.object_id = c.object_id AND ic.column_id = c.column_id
WHERE OBJECT_NAME(i.object_id) = ".q($R),$h)as$K){$C=$K["name"];$J[$C]["type"]=($K["is_primary_key"]?"PRIMARY":($K["is_unique"]?"UNIQUE":"INDEX"));$J[$C]["lengths"]=array();$J[$C]["columns"][$K["key_ordinal"]]=$K["column_name"];$J[$C]["descs"][$K["key_ordinal"]]=($K["is_descending_key"]?'1':null);}return$J;}function
view($C){return
array("select"=>preg_replace('~^(?:[^[]|\[[^]]*])*\s+AS\s+~isU','',get_val("SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_SCHEMA = SCHEMA_NAME() AND TABLE_NAME = ".q($C))));}function
collations(){$J=array();foreach(get_vals("SELECT name FROM fn_helpcollations()")as$c)$J[preg_replace('~_.*~','',$c)][]=$c;return$J;}function
information_schema($k){return
get_schema()=="INFORMATION_SCHEMA";}function
error(){return
nl_br(h(preg_replace('~^(\[[^]]*])+~m','',connection()->error)));}function
create_database($k,$c){return
queries("CREATE DATABASE ".idf_escape($k).(preg_match('~^[a-z0-9_]+$~i',$c)?" COLLATE $c":""));}function
drop_databases($j){return
queries("DROP DATABASE ".implode(", ",array_map('Adminer\idf_escape',$j)));}function
rename_database($C,$c){if(preg_match('~^[a-z0-9_]+$~i',$c))queries("ALTER DATABASE ".idf_escape(DB)." COLLATE $c");queries("ALTER DATABASE ".idf_escape(DB)." MODIFY NAME = ".idf_escape($C));return
true;}function
auto_increment(){return" IDENTITY".($_POST["Auto_increment"]!=""?"(".number($_POST["Auto_increment"]).",1)":"")." PRIMARY KEY";}function
alter_table($R,$C,$o,$ed,$ob,$tc,$c,$Ba,$ig){$b=array();$qb=array();$Sf=fields($R);foreach($o
as$n){$d=idf_escape($n[0]);$X=$n[1];if(!$X)$b["DROP"][]=" COLUMN $d";else{$X[1]=preg_replace("~( COLLATE )'(\\w+)'~",'\1\2',$X[1]);$qb[$n[0]]=$X[5];unset($X[5]);if(preg_match('~ AS ~',$X[3]))unset($X[1],$X[2]);if($n[0]=="")$b["ADD"][]="\n  ".implode("",$X).($R==""?substr($ed[$X[0]],16+strlen($X[0])):"");else{$l=$X[3];unset($X[3]);unset($X[6]);if($d!=$X[0])queries("EXEC sp_rename ".q(table($R).".$d").", ".q(idf_unescape($X[0])).", 'COLUMN'");$b["ALTER COLUMN ".implode("",$X)][]="";$Rf=$Sf[$n[0]];if(default_value($Rf)!=$l){if($Rf["default"]!==null)$b["DROP"][]=" ".idf_escape($Rf["default_constraint"]);if($l)$b["ADD"][]="\n $l FOR $d";}}}}if($R=="")return
queries("CREATE TABLE ".table($C)." (".implode(",",(array)$b["ADD"])."\n)");if($R!=$C)queries("EXEC sp_rename ".q(table($R)).", ".q($C));if($ed)$b[""]=$ed;foreach($b
as$y=>$X){if(!queries("ALTER TABLE ".table($C)." $y".implode(",",$X)))return
false;}foreach($qb
as$y=>$X){$ob=substr($X,9);queries("EXEC sp_dropextendedproperty @name = N'MS_Description', @level0type = N'Schema', @level0name = ".q(get_schema()).", @level1type = N'Table', @level1name = ".q($C).", @level2type = N'Column', @level2name = ".q($y));queries("EXEC sp_addextendedproperty
@name = N'MS_Description',
@value = $ob,
@level0type = N'Schema',
@level0name = ".q(get_schema()).",
@level1type = N'Table',
@level1name = ".q($C).",
@level2type = N'Column',
@level2name = ".q($y));}return
true;}function
alter_indexes($R,$b){$w=array();$dc=array();foreach($b
as$X){if($X[2]=="DROP"){if($X[0]=="PRIMARY")$dc[]=idf_escape($X[1]);else$w[]=idf_escape($X[1])." ON ".table($R);}elseif(!queries(($X[0]!="PRIMARY"?"CREATE $X[0] ".($X[0]!="INDEX"?"INDEX ":"").idf_escape($X[1]!=""?$X[1]:uniqid($R."_"))." ON ".table($R):"ALTER TABLE ".table($R)." ADD PRIMARY KEY")." (".implode(", ",$X[2]).")"))return
false;}return(!$w||queries("DROP INDEX ".implode(", ",$w)))&&(!$dc||queries("ALTER TABLE ".table($R)." DROP ".implode(", ",$dc)));}function
found_rows($S,$Z){}function
foreign_keys($R){$J=array();$Cf=array("CASCADE","NO ACTION","SET NULL","SET DEFAULT");foreach(get_rows("EXEC sp_fkeys @fktable_name = ".q($R).", @fktable_owner = ".q(get_schema()))as$K){$q=&$J[$K["FK_NAME"]];$q["db"]=$K["PKTABLE_QUALIFIER"];$q["ns"]=$K["PKTABLE_OWNER"];$q["table"]=$K["PKTABLE_NAME"];$q["on_update"]=$Cf[$K["UPDATE_RULE"]];$q["on_delete"]=$Cf[$K["DELETE_RULE"]];$q["source"][]=$K["FKCOLUMN_NAME"];$q["target"][]=$K["PKCOLUMN_NAME"];}return$J;}function
truncate_tables($T){return
apply_queries("TRUNCATE TABLE",$T);}function
drop_views($mj){return
queries("DROP VIEW ".implode(", ",array_map('Adminer\table',$mj)));}function
drop_tables($T){return
queries("DROP TABLE ".implode(", ",array_map('Adminer\table',$T)));}function
move_tables($T,$mj,$ji){return
apply_queries("ALTER SCHEMA ".idf_escape($ji)." TRANSFER",array_merge($T,$mj));}function
trigger($C,$R){if($C=="")return
array();$L=get_rows("SELECT s.name [Trigger],
CASE WHEN OBJECTPROPERTY(s.id, 'ExecIsInsertTrigger') = 1 THEN 'INSERT' WHEN OBJECTPROPERTY(s.id, 'ExecIsUpdateTrigger') = 1 THEN 'UPDATE' WHEN OBJECTPROPERTY(s.id, 'ExecIsDeleteTrigger') = 1 THEN 'DELETE' END [Event],
CASE WHEN OBJECTPROPERTY(s.id, 'ExecIsInsteadOfTrigger') = 1 THEN 'INSTEAD OF' ELSE 'AFTER' END [Timing],
c.text
FROM sysobjects s
JOIN syscomments c ON s.id = c.id
WHERE s.xtype = 'TR' AND s.name = ".q($C));$J=reset($L);if($J)$J["Statement"]=preg_replace('~^.+\s+AS\s+~isU','',$J["text"]);return$J;}function
triggers($R){$J=array();foreach(get_rows("SELECT sys1.name,
CASE WHEN OBJECTPROPERTY(sys1.id, 'ExecIsInsertTrigger') = 1 THEN 'INSERT' WHEN OBJECTPROPERTY(sys1.id, 'ExecIsUpdateTrigger') = 1 THEN 'UPDATE' WHEN OBJECTPROPERTY(sys1.id, 'ExecIsDeleteTrigger') = 1 THEN 'DELETE' END [Event],
CASE WHEN OBJECTPROPERTY(sys1.id, 'ExecIsInsteadOfTrigger') = 1 THEN 'INSTEAD OF' ELSE 'AFTER' END [Timing]
FROM sysobjects sys1
JOIN sysobjects sys2 ON sys1.parent_obj = sys2.id
WHERE sys1.xtype = 'TR' AND sys2.name = ".q($R))as$K)$J[$K["name"]]=array($K["Timing"],$K["Event"]);return$J;}function
trigger_options(){return
array("Timing"=>array("AFTER","INSTEAD OF"),"Event"=>array("INSERT","UPDATE","DELETE"),"Type"=>array("AS"),);}function
schemas(){return
get_vals("SELECT name FROM sys.schemas");}function
get_schema(){if($_GET["ns"]!="")return$_GET["ns"];return
get_val("SELECT SCHEMA_NAME()");}function
set_schema($jh){$_GET["ns"]=$jh;return
true;}function
create_sql($R,$Ba,$Th){if(is_view(table_status1($R))){$lj=view($R);return"CREATE VIEW ".table($R)." AS $lj[select]";}$o=array();$G=false;foreach(fields($R)as$C=>$n){$X=process_field($n,$n);if($X[6])$G=true;$o[]=implode("",$X);}foreach(indexes($R)as$C=>$w){if(!$G||$w["type"]!="PRIMARY"){$e=array();foreach($w["columns"]as$y=>$X)$e[]=idf_escape($X).($w["descs"][$y]?" DESC":"");$C=idf_escape($C);$o[]=($w["type"]=="INDEX"?"INDEX $C":"CONSTRAINT $C ".($w["type"]=="UNIQUE"?"UNIQUE":"PRIMARY KEY"))." (".implode(", ",$e).")";}}foreach(driver()->checkConstraints($R)as$C=>$Xa)$o[]="CONSTRAINT ".idf_escape($C)." CHECK ($Xa)";return"CREATE TABLE ".table($R)." (\n\t".implode(",\n\t",$o)."\n)";}function
foreign_keys_sql($R){$o=array();foreach(foreign_keys($R)as$ed)$o[]=ltrim(format_foreign_key($ed));return($o?"ALTER TABLE ".table($R)." ADD\n\t".implode(",\n\t",$o).";\n\n":"");}function
truncate_sql($R){return"TRUNCATE TABLE ".table($R);}function
use_sql($Lb){return"USE ".idf_escape($Lb);}function
trigger_sql($R){$J="";foreach(triggers($R)as$C=>$Hi)$J
.=create_trigger(" ON ".table($R),trigger($C,$R)).";";return$J;}function
convert_field($n){}function
unconvert_field($n,$J){return$J;}function
support($Qc){return
preg_match('~^(check|comment|columns|database|drop_col|dump|indexes|descidx|scheme|sql|table|trigger|view|view_trigger)$~',$Qc);}}class
Adminer{static$de;var$error='';function
name(){return"<a href='https://www.adminer.org/'".target_blank()." id='h1'>Adminer</a>";}function
credentials(){return
array(SERVER,$_GET["username"],get_password());}function
connectSsl(){}function
permanentLogin($i=false){return
password_file($i);}function
bruteForceKey(){return$_SERVER["REMOTE_ADDR"];}function
serverName($N){return
h($N);}function
database(){return
DB;}function
databases($cd=true){return
get_databases($cd);}function
operators(){return
driver()->operators;}function
schemas(){return
schemas();}function
queryTimeout(){return
2;}function
headers(){}function
csp(array$Eb){return$Eb;}function
head($Ib=null){return
true;}function
css(){$J=array();foreach(array("","-dark")as$df){$p="adminer$df.css";if(file_exists($p))$J[]="$p?v=".crc32(file_get_contents($p));}return$J;}function
loginForm(){echo"<table class='layout'>\n",adminer()->loginFormField('driver','<tr><th>'.lang(32).'<td>',html_select("auth[driver]",SqlDriver::$cc,DRIVER,"loginDriver(this);")),adminer()->loginFormField('server','<tr><th>'.lang(33).'<td>','<input name="auth[server]" value="'.h(SERVER).'" title="hostname[:port]" placeholder="localhost" autocapitalize="off">'),adminer()->loginFormField('username','<tr><th>'.lang(34).'<td>','<input name="auth[username]" id="username" autofocus value="'.h($_GET["username"]).'" autocomplete="username" autocapitalize="off">'.script("const authDriver = qs('#username').form['auth[driver]']; authDriver && authDriver.onchange();")),adminer()->loginFormField('password','<tr><th>'.lang(35).'<td>','<input type="password" name="auth[password]" autocomplete="current-password">'),adminer()->loginFormField('db','<tr><th>'.lang(36).'<td>','<input name="auth[db]" value="'.h($_GET["db"]).'" autocapitalize="off">'),"</table>\n","<p><input type='submit' value='".lang(37)."'>\n",checkbox("auth[permanent]",1,$_COOKIE["adminer_permanent"],lang(38))."\n";}function
loginFormField($C,$Cd,$Y){return$Cd.$Y."\n";}function
login($Fe,$F){if($F=="")return
lang(39,target_blank());return
true;}function
tableName(array$Zh){return
h($Zh["Name"]);}function
fieldName(array$n,$Lf=0){$U=$n["full_type"];$ob=$n["comment"];return'<span title="'.h($U.($ob!=""?($U?": ":"").$ob:'')).'">'.h($n["field"]).'</span>';}function
selectLinks(array$Zh,$O=""){echo'<p class="links">';$De=array("select"=>lang(40));if(support("table")||support("indexes"))$De["table"]=lang(41);$le=false;if(support("table")){$le=is_view($Zh);if($le)$De["view"]=lang(42);else$De["create"]=lang(43);}if($O!==null)$De["edit"]=lang(44);$C=$Zh["Name"];foreach($De
as$y=>$X)echo" <a href='".h(ME)."$y=".urlencode($C).($y=="edit"?$O:"")."'".bold(isset($_GET[$y])).">$X</a>";echo
doc_link(array(JUSH=>driver()->tableHelp($C,$le)),"?"),"\n";}function
foreignKeys($R){return
foreign_keys($R);}function
backwardKeys($R,$Yh){return
array();}function
backwardKeysPrint(array$Fa,array$K){}function
selectQuery($H,$Ph,$Oc=false){$J="</p>\n";if(!$Oc&&($pj=driver()->warnings())){$u="warnings";$J=", <a href='#$u'>".lang(45)."</a>".script("qsl('a').onclick = partial(toggle, '$u');","")."$J<div id='$u' class='hidden'>\n$pj</div>\n";}return"<p><code class='jush-".JUSH."'>".h(str_replace("\n"," ",$H))."</code> <span class='time'>(".format_time($Ph).")</span>".(support("sql")?" <a href='".h(ME)."sql=".urlencode($H)."'>".lang(10)."</a>":"").$J;}function
sqlCommandQuery($H){return
shorten_utf8(trim($H),1000);}function
sqlPrintAfter(){}function
rowDescription($R){return"";}function
rowDescriptions(array$L,array$fd){return$L;}function
selectLink($X,array$n){}function
selectVal($X,$A,array$n,$Vf){$J=($X===null?"<i>NULL</i>":(preg_match("~char|binary|boolean~",$n["type"])&&!preg_match("~var~",$n["type"])?"<code>$X</code>":(preg_match('~json~',$n["type"])?"<code class='jush-js'>$X</code>":$X)));if(preg_match('~blob|bytea|raw|file~',$n["type"])&&!is_utf8($X))$J="<i>".lang(46,strlen($Vf))."</i>";return($A?"<a href='".h($A)."'".(is_url($A)?target_blank():"").">$J</a>":$J);}function
editVal($X,array$n){return$X;}function
tableStructurePrint(array$o,$Zh=null){echo"<div class='scrollable'>\n","<table class='nowrap odds'>\n","<thead><tr><th>".lang(47)."<td>".lang(48).(support("comment")?"<td>".lang(49):"")."</thead>\n";$Sh=driver()->structuredTypes();foreach($o
as$n){echo"<tr><th>".h($n["field"]);$U=h($n["full_type"]);$c=h($n["collation"]);echo"<td><span title='$c'>".(in_array($U,(array)$Sh[lang(31)])?"<a href='".h(ME.'type='.urlencode($U))."'>$U</a>":$U.($c&&isset($Zh["Collation"])&&$c!=$Zh["Collation"]?" $c":""))."</span>",($n["null"]?" <i>NULL</i>":""),($n["auto_increment"]?" <i>".lang(50)."</i>":"");$l=h($n["default"]);echo(isset($n["default"])?" <span title='".lang(51)."'>[<b>".($n["generated"]?"<code class='jush-".JUSH."'>$l</code>":$l)."</b>]</span>":""),(support("comment")?"<td>".h($n["comment"]):""),"\n";}echo"</table>\n","</div>\n";}function
tableIndexesPrint(array$x){echo"<table>\n";foreach($x
as$C=>$w){ksort($w["columns"]);$_g=array();foreach($w["columns"]as$y=>$X)$_g[]="<i>".h($X)."</i>".($w["lengths"][$y]?"(".$w["lengths"][$y].")":"").($w["descs"][$y]?" DESC":"");echo"<tr title='".h($C)."'><th>$w[type]<td>".implode(", ",$_g)."\n";}echo"</table>\n";}function
selectColumnsPrint(array$M,array$e){print_fieldset("select",lang(52),$M);$t=0;$M[""]=array();foreach($M
as$y=>$X){$X=idx($_GET["columns"],$y,array());$d=select_input(" name='columns[$t][col]'",$e,$X["col"],($y!==""?"selectFieldChange":"selectAddRow"));echo"<div>".(driver()->functions||driver()->grouping?html_select("columns[$t][fun]",array(-1=>"")+array_filter(array(lang(53)=>driver()->functions,lang(54)=>driver()->grouping)),$X["fun"]).on_help("event.target.value && event.target.value.replace(/ |\$/, '(') + ')'",1).script("qsl('select').onchange = function () { helpClose();".($y!==""?"":" qsl('select, input', this.parentNode).onchange();")." };","")."($d)":$d)."</div>\n";$t++;}echo"</div></fieldset>\n";}function
selectSearchPrint(array$Z,array$e,array$x){print_fieldset("search",lang(55),$Z);foreach($x
as$t=>$w){if($w["type"]=="FULLTEXT")echo"<div>(<i>".implode("</i>, <i>",array_map('Adminer\h',$w["columns"]))."</i>) AGAINST"," <input type='search' name='fulltext[$t]' value='".h($_GET["fulltext"][$t])."'>",script("qsl('input').oninput = selectFieldChange;",""),checkbox("boolean[$t]",1,isset($_GET["boolean"][$t]),"BOOL"),"</div>\n";}$Ua="this.parentNode.firstChild.onchange();";foreach(array_merge((array)$_GET["where"],array(array()))as$t=>$X){if(!$X||("$X[col]$X[val]"!=""&&in_array($X["op"],adminer()->operators())))echo"<div>".select_input(" name='where[$t][col]'",$e,$X["col"],($X?"selectFieldChange":"selectAddRow"),"(".lang(56).")"),html_select("where[$t][op]",adminer()->operators(),$X["op"],$Ua),"<input type='search' name='where[$t][val]' value='".h($X["val"])."'>",script("mixin(qsl('input'), {oninput: function () { $Ua }, onkeydown: selectSearchKeydown, onsearch: selectSearchSearch});",""),"</div>\n";}echo"</div></fieldset>\n";}function
selectOrderPrint(array$Lf,array$e,array$x){print_fieldset("sort",lang(57),$Lf);$t=0;foreach((array)$_GET["order"]as$y=>$X){if($X!=""){echo"<div>".select_input(" name='order[$t]'",$e,$X,"selectFieldChange"),checkbox("desc[$t]",1,isset($_GET["desc"][$y]),lang(58))."</div>\n";$t++;}}echo"<div>".select_input(" name='order[$t]'",$e,"","selectAddRow"),checkbox("desc[$t]",1,false,lang(58))."</div>\n","</div></fieldset>\n";}function
selectLimitPrint($_){echo"<fieldset><legend>".lang(59)."</legend><div>","<input type='number' name='limit' class='size' value='".intval($_)."'>",script("qsl('input').oninput = selectFieldChange;",""),"</div></fieldset>\n";}function
selectLengthPrint($pi){if($pi!==null)echo"<fieldset><legend>".lang(60)."</legend><div>","<input type='number' name='text_length' class='size' value='".h($pi)."'>","</div></fieldset>\n";}function
selectActionPrint(array$x){echo"<fieldset><legend>".lang(61)."</legend><div>","<input type='submit' value='".lang(52)."'>"," <span id='noindex' title='".lang(62)."'></span>","<script".nonce().">\n","const indexColumns = ";$e=array();foreach($x
as$w){$Hb=reset($w["columns"]);if($w["type"]!="FULLTEXT"&&$Hb)$e[$Hb]=1;}$e[""]=1;foreach($e
as$y=>$X)json_row($y);echo";\n","selectFieldChange.call(qs('#form')['select']);\n","</script>\n","</div></fieldset>\n";}function
selectCommandPrint(){return!information_schema(DB);}function
selectImportPrint(){return!information_schema(DB);}function
selectEmailPrint(array$qc,array$e){}function
selectColumnsProcess(array$e,array$x){$M=array();$rd=array();foreach((array)$_GET["columns"]as$y=>$X){if($X["fun"]=="count"||($X["col"]!=""&&(!$X["fun"]||in_array($X["fun"],driver()->functions)||in_array($X["fun"],driver()->grouping)))){$M[$y]=apply_sql_function($X["fun"],($X["col"]!=""?idf_escape($X["col"]):"*"));if(!in_array($X["fun"],driver()->grouping))$rd[]=$M[$y];}}return
array($M,$rd);}function
selectSearchProcess(array$o,array$x){$J=array();foreach($x
as$t=>$w){if($w["type"]=="FULLTEXT"&&$_GET["fulltext"][$t]!="")$J[]="MATCH (".implode(", ",array_map('Adminer\idf_escape',$w["columns"])).") AGAINST (".q($_GET["fulltext"][$t]).(isset($_GET["boolean"][$t])?" IN BOOLEAN MODE":"").")";}foreach((array)$_GET["where"]as$y=>$X){if("$X[col]$X[val]"!=""&&in_array($X["op"],adminer()->operators())){$xg="";$rb=" $X[op]";if(preg_match('~IN$~',$X["op"])){$Qd=process_length($X["val"]);$rb
.=" ".($Qd!=""?$Qd:"(NULL)");}elseif($X["op"]=="SQL")$rb=" $X[val]";elseif($X["op"]=="LIKE %%")$rb=" LIKE ".adminer()->processInput($o[$X["col"]],"%$X[val]%");elseif($X["op"]=="ILIKE %%")$rb=" ILIKE ".adminer()->processInput($o[$X["col"]],"%$X[val]%");elseif($X["op"]=="FIND_IN_SET"){$xg="$X[op](".q($X["val"]).", ";$rb=")";}elseif(!preg_match('~NULL$~',$X["op"]))$rb
.=" ".adminer()->processInput($o[$X["col"]],$X["val"]);if($X["col"]!="")$J[]=$xg.driver()->convertSearch(idf_escape($X["col"]),$X,$o[$X["col"]]).$rb;else{$kb=array();foreach($o
as$C=>$n){if(isset($n["privileges"]["where"])&&(preg_match('~^[-\d.'.(preg_match('~IN$~',$X["op"])?',':'').']+$~',$X["val"])||!preg_match('~'.number_type().'|bit~',$n["type"]))&&(!preg_match("~[\x80-\xFF]~",$X["val"])||preg_match('~char|text|enum|set~',$n["type"]))&&(!preg_match('~date|timestamp~',$n["type"])||preg_match('~^\d+-\d+-\d+~',$X["val"])))$kb[]=$xg.driver()->convertSearch(idf_escape($C),$X,$n).$rb;}$J[]=($kb?"(".implode(" OR ",$kb).")":"1 = 0");}}}return$J;}function
selectOrderProcess(array$o,array$x){$J=array();foreach((array)$_GET["order"]as$y=>$X){if($X!="")$J[]=(preg_match('~^((COUNT\(DISTINCT |[A-Z0-9_]+\()(`(?:[^`]|``)+`|"(?:[^"]|"")+")\)|COUNT\(\*\))$~',$X)?$X:idf_escape($X)).(isset($_GET["desc"][$y])?" DESC":"");}return$J;}function
selectLimitProcess(){return(isset($_GET["limit"])?intval($_GET["limit"]):50);}function
selectLengthProcess(){return(isset($_GET["text_length"])?"$_GET[text_length]":"100");}function
selectEmailProcess(array$Z,array$fd){return
false;}function
selectQueryBuild(array$M,array$Z,array$rd,array$Lf,$_,$E){return"";}function
messageQuery($H,$qi,$Oc=false){restart_session();$Ed=&get_session("queries");if(!idx($Ed,$_GET["db"]))$Ed[$_GET["db"]]=array();if(strlen($H)>1e6)$H=preg_replace('~[\x80-\xFF]+$~','',substr($H,0,1e6))."\n…";$Ed[$_GET["db"]][]=array($H,time(),$qi);$Lh="sql-".count($Ed[$_GET["db"]]);$J="<a href='#$Lh' class='toggle'>".lang(63)."</a>\n";if(!$Oc&&($pj=driver()->warnings())){$u="warnings-".count($Ed[$_GET["db"]]);$J="<a href='#$u' class='toggle'>".lang(45)."</a>, $J<div id='$u' class='hidden'>\n$pj</div>\n";}return" <span class='time'>".@date("H:i:s")."</span>"." $J<div id='$Lh' class='hidden'><pre><code class='jush-".JUSH."'>".shorten_utf8($H,1000)."</code></pre>".($qi?" <span class='time'>($qi)</span>":'').(support("sql")?'<p><a href="'.h(str_replace("db=".urlencode(DB),"db=".urlencode($_GET["db"]),ME).'sql=&history='.(count($Ed[$_GET["db"]])-1)).'">'.lang(10).'</a>':'').'</div>';}function
editRowPrint($R,array$o,$K,$Wi){}function
editFunctions(array$n){$J=($n["null"]?"NULL/":"");$Wi=isset($_GET["select"])||where($_GET);foreach(array(driver()->insertFunctions,driver()->editFunctions)as$y=>$md){if(!$y||(!isset($_GET["call"])&&$Wi)){foreach($md
as$mg=>$X){if(!$mg||preg_match("~$mg~",$n["type"]))$J
.="/$X";}}if($y&&$md&&!preg_match('~set|blob|bytea|raw|file|bool~',$n["type"]))$J
.="/SQL";}if($n["auto_increment"]&&!$Wi)$J=lang(50);return
explode("/",$J);}function
editInput($R,array$n,$_a,$Y){if($n["type"]=="enum")return(isset($_GET["select"])?"<label><input type='radio'$_a value='-1' checked><i>".lang(8)."</i></label> ":"").($n["null"]?"<label><input type='radio'$_a value=''".($Y!==null||isset($_GET["select"])?"":" checked")."><i>NULL</i></label> ":"").enum_input("radio",$_a,$n,$Y,$Y===0?0:null);return"";}function
editHint($R,array$n,$Y){return"";}function
processInput(array$n,$Y,$s=""){if($s=="SQL")return$Y;$C=$n["field"];$J=q($Y);if(preg_match('~^(now|getdate|uuid)$~',$s))$J="$s()";elseif(preg_match('~^current_(date|timestamp)$~',$s))$J=$s;elseif(preg_match('~^([+-]|\|\|)$~',$s))$J=idf_escape($C)." $s $J";elseif(preg_match('~^[+-] interval$~',$s))$J=idf_escape($C)." $s ".(preg_match("~^(\\d+|'[0-9.: -]') [A-Z_]+\$~i",$Y)?$Y:$J);elseif(preg_match('~^(addtime|subtime|concat)$~',$s))$J="$s(".idf_escape($C).", $J)";elseif(preg_match('~^(md5|sha1|password|encrypt)$~',$s))$J="$s($J)";return
unconvert_field($n,$J);}function
dumpOutput(){$J=array('text'=>lang(64),'file'=>lang(65));if(function_exists('gzencode'))$J['gz']='gzip';return$J;}function
dumpFormat(){return(support("dump")?array('sql'=>'SQL'):array())+array('csv'=>'CSV,','csv;'=>'CSV;','tsv'=>'TSV');}function
dumpDatabase($k){}function
dumpTable($R,$Th,$le=0){if($_POST["format"]!="sql"){echo"\xef\xbb\xbf";if($Th)dump_csv(array_keys(fields($R)));}else{if($le==2){$o=array();foreach(fields($R)as$C=>$n)$o[]=idf_escape($C)." $n[full_type]";$i="CREATE TABLE ".table($R)." (".implode(", ",$o).")";}else$i=create_sql($R,$_POST["auto_increment"],$Th);set_utf8mb4($i);if($Th&&$i){if($Th=="DROP+CREATE"||$le==1)echo"DROP ".($le==2?"VIEW":"TABLE")." IF EXISTS ".table($R).";\n";if($le==1)$i=remove_definer($i);echo"$i;\n\n";}}}function
dumpData($R,$Th,$H){if($Th){$Ne=(JUSH=="sqlite"?0:1048576);$o=array();$Nd=false;if($_POST["format"]=="sql"){if($Th=="TRUNCATE+INSERT")echo
truncate_sql($R).";\n";$o=fields($R);if(JUSH=="mssql"){foreach($o
as$n){if($n["auto_increment"]){echo"SET IDENTITY_INSERT ".table($R)." ON;\n";$Nd=true;break;}}}}$I=connection()->query($H,1);if($I){$be="";$Pa="";$qe=array();$nd=array();$Vh="";$Rc=($R!=''?'fetch_assoc':'fetch_row');while($K=$I->$Rc()){if(!$qe){$hj=array();foreach($K
as$X){$n=$I->fetch_field();if(idx($o[$n->name],'generated')){$nd[$n->name]=true;continue;}$qe[]=$n->name;$y=idf_escape($n->name);$hj[]="$y = VALUES($y)";}$Vh=($Th=="INSERT+UPDATE"?"\nON DUPLICATE KEY UPDATE ".implode(", ",$hj):"").";\n";}if($_POST["format"]!="sql"){if($Th=="table"){dump_csv($qe);$Th="INSERT";}dump_csv($K);}else{if(!$be)$be="INSERT INTO ".table($R)." (".implode(", ",array_map('Adminer\idf_escape',$qe)).") VALUES";foreach($K
as$y=>$X){if($nd[$y]){unset($K[$y]);continue;}$n=$o[$y];$K[$y]=($X!==null?unconvert_field($n,preg_match(number_type(),$n["type"])&&!preg_match('~\[~',$n["full_type"])&&is_numeric($X)?$X:q(($X===false?0:$X))):"NULL");}$hh=($Ne?"\n":" ")."(".implode(",\t",$K).")";if(!$Pa)$Pa=$be.$hh;elseif(strlen($Pa)+4+strlen($hh)+strlen($Vh)<$Ne)$Pa
.=",$hh";else{echo$Pa.$Vh;$Pa=$be.$hh;}}}if($Pa)echo$Pa.$Vh;}elseif($_POST["format"]=="sql")echo"-- ".str_replace("\n"," ",connection()->error)."\n";if($Nd)echo"SET IDENTITY_INSERT ".table($R)." OFF;\n";}}function
dumpFilename($Ld){return
friendly_url($Ld!=""?$Ld:(SERVER!=""?SERVER:"localhost"));}function
dumpHeaders($Ld,$ff=false){$Yf=$_POST["output"];$Jc=(preg_match('~sql~',$_POST["format"])?"sql":($ff?"tar":"csv"));header("Content-Type: ".($Yf=="gz"?"application/x-gzip":($Jc=="tar"?"application/x-tar":($Jc=="sql"||$Yf!="file"?"text/plain":"text/csv")."; charset=utf-8")));if($Yf=="gz"){ob_start(function($Q){return
gzencode($Q);},1e6);}return$Jc;}function
dumpFooter(){if($_POST["format"]=="sql")echo"-- ".gmdate("Y-m-d H:i:s e")."\n";}function
importServerPath(){return"adminer.sql";}function
homepage(){echo'<p class="links">'.($_GET["ns"]==""&&support("database")?'<a href="'.h(ME).'database=">'.lang(66)."</a>\n":""),(support("scheme")?"<a href='".h(ME)."scheme='>".($_GET["ns"]!=""?lang(67):lang(68))."</a>\n":""),($_GET["ns"]!==""?'<a href="'.h(ME).'schema=">'.lang(69)."</a>\n":""),(support("privileges")?"<a href='".h(ME)."privileges='>".lang(70)."</a>\n":"");return
true;}function
navigation($cf){echo"<h1>".adminer()->name()." <span class='version'>".VERSION;$nf=$_COOKIE["adminer_version"];echo" <a href='https://www.adminer.org/#download'".target_blank()." id='version'>".(version_compare(VERSION,$nf)<0?h($nf):"")."</a>","</span></h1>\n";switch_lang();if($cf=="auth"){$Yf="";foreach((array)$_SESSION["pwds"]as$jj=>$yh){foreach($yh
as$N=>$ej){$C=h(get_setting("vendor-$jj-$N")?:get_driver($jj));foreach($ej
as$V=>$F){if($F!==null){$Ob=$_SESSION["db"][$jj][$N][$V];foreach(($Ob?array_keys($Ob):array(""))as$k)$Yf
.="<li><a href='".h(auth_url($jj,$N,$V,$k))."'>($C) ".h($V.($N!=""?"@".adminer()->serverName($N):"").($k!=""?" - $k":""))."</a>\n";}}}}if($Yf)echo"<ul id='logins'>\n$Yf</ul>\n".script("mixin(qs('#logins'), {onmouseover: menuOver, onmouseout: menuOut});");}else{$T=array();if($_GET["ns"]!==""&&!$cf&&DB!=""){connection()->select_db(DB);$T=table_status('',true);}adminer()->syntaxHighlighting($T);adminer()->databasesPrint($cf);$ka=array();if(DB==""||!$cf){if(support("sql")){$ka[]="<a href='".h(ME)."sql='".bold(isset($_GET["sql"])&&!isset($_GET["import"])).">".lang(63)."</a>";$ka[]="<a href='".h(ME)."import='".bold(isset($_GET["import"])).">".lang(71)."</a>";}$ka[]="<a href='".h(ME)."dump=".urlencode(isset($_GET["table"])?$_GET["table"]:$_GET["select"])."' id='dump'".bold(isset($_GET["dump"])).">".lang(72)."</a>";}$Rd=$_GET["ns"]!==""&&!$cf&&DB!="";if($Rd)$ka[]='<a href="'.h(ME).'create="'.bold($_GET["create"]==="").">".lang(73)."</a>";echo($ka?"<p class='links'>\n".implode("\n",$ka)."\n":"");if($Rd){if($T)adminer()->tablesPrint($T);else
echo"<p class='message'>".lang(9)."</p>\n";}}}function
syntaxHighlighting(array$T){echo
script_src(preg_replace("~\\?.*~","",ME)."?file=jush.js&version=5.1.1");if(support("sql")){echo"<script".nonce().">\n";if($T){$De=array();foreach($T
as$R=>$U)$De[]=preg_quote($R,'/');echo"var jushLinks = { ".JUSH.": [ '".js_escape(ME).(support("table")?"table=":"select=")."\$&', /\\b(".implode("|",$De).")\\b/g ] };\n";foreach(array("bac","bra","sqlite_quo","mssql_bra")as$X)echo"jushLinks.$X = jushLinks.".JUSH.";\n";}echo"</script>\n";}echo
script("syntaxHighlighting('".preg_replace('~^(\d\.?\d).*~s','\1',connection()->server_info)."'".(connection()->flavor=='maria'?", 'maria'":(connection()->flavor=='cockroach'?", 'cockroach'":"")).");");}function
databasesPrint($cf){$j=adminer()->databases();if(DB&&$j&&!in_array(DB,$j))array_unshift($j,DB);echo"<form action=''>\n<p id='dbs'>\n";hidden_fields_get();$Mb=script("mixin(qsl('select'), {onmousedown: dbMouseDown, onchange: dbChange});");echo"<span title='".lang(36)."'>".lang(74).":</span> ".($j?html_select("db",array(""=>"")+$j,DB).$Mb:"<input name='db' value='".h(DB)."' autocapitalize='off' size='19'>\n"),"<input type='submit' value='".lang(20)."'".($j?" class='hidden'":"").">\n";if(support("scheme")){if($cf!="db"&&DB!=""&&connection()->select_db(DB)){echo"<br><span>".lang(75).":</span> ".html_select("ns",array(""=>"")+adminer()->schemas(),$_GET["ns"]).$Mb;if($_GET["ns"]!="")set_schema($_GET["ns"]);}}foreach(array("import","sql","schema","dump","privileges")as$X){if(isset($_GET[$X])){echo
input_hidden($X);break;}}echo"</p></form>\n";}function
tablesPrint(array$T){echo"<ul id='tables'>".script("mixin(qs('#tables'), {onmouseover: menuOver, onmouseout: menuOut});");foreach($T
as$R=>$P){$C=adminer()->tableName($P);if($C!="")echo'<li><a href="'.h(ME).'select='.urlencode($R).'"'.bold($_GET["select"]==$R||$_GET["edit"]==$R,"select")." title='".lang(40)."'>".lang(76)."</a> ",(support("table")||support("indexes")?'<a href="'.h(ME).'table='.urlencode($R).'"'.bold(in_array($R,array($_GET["table"],$_GET["create"],$_GET["indexes"],$_GET["foreign"],$_GET["trigger"])),(is_view($P)?"view":"structure"))." title='".lang(41)."'>$C</a>":"<span>$C</span>")."\n";}echo"</ul>\n";}}class
Plugins{private
static$va=array('dumpFormat'=>true,'dumpOutput'=>true,'editRowPrint'=>true,'editFunctions'=>true);var$plugins;var$error='';private$hooks=array();function
__construct($rg){if($rg===null){$rg=array();$Ja="adminer-plugins";if(is_dir($Ja)){foreach(glob("$Ja/*.php")as$p)$Sd=include_once"./$p";}$Dd=" href='https://www.adminer.org/plugins/#use'".target_blank();if(file_exists("$Ja.php")){$Sd=include_once"./$Ja.php";if(is_array($Sd)){foreach($Sd
as$qg)$rg[get_class($qg)]=$qg;}else$this->error
.=lang(77,"<b>$Ja.php</b>",$Dd)."<br>";}foreach(get_declared_classes()as$eb){if(!$rg[$eb]&&preg_match('~^Adminer\w~i',$eb)){$Rg=new
\ReflectionClass($eb);$wb=$Rg->getConstructor();if($wb&&$wb->getNumberOfRequiredParameters())$this->error
.=lang(78,$Dd,"<b>$eb</b>","<b>$Ja.php</b>")."<br>";else$rg[$eb]=new$eb;}}}$this->plugins=$rg;$na=new
Adminer;$rg[]=$na;$Rg=new
\ReflectionObject($na);foreach($Rg->getMethods()as$af){foreach($rg
as$qg){$C=$af->getName();if(method_exists($qg,$C))$this->hooks[$C][]=$qg;}}}function
__call($C,array$dg){$wa=array();foreach($dg
as$y=>$X)$wa[]=&$dg[$y];$J=null;foreach($this->hooks[$C]as$qg){$Y=call_user_func_array(array($qg,$C),$wa);if($Y!==null){if(!self::$va[$C])return$Y;$J=$Y+(array)$J;}}return$J;}}if(function_exists('adminer_object'))Adminer::$de=adminer_object();elseif(is_dir("adminer-plugins")||file_exists("adminer-plugins.php"))Adminer::$de=new
Plugins(null);else
Adminer::$de=new
Adminer;SqlDriver::$cc=array("server"=>"MySQL / MariaDB")+SqlDriver::$cc;if(!defined('Adminer\DRIVER')){define('Adminer\DRIVER',"server");if(extension_loaded("mysqli")&&$_GET["ext"]!="pdo"){class
Db
extends
\MySQLi{static$de;var$extension="MySQLi",$flavor='';function
__construct(){parent::init();}function
attach($N,$V,$F){mysqli_report(MYSQLI_REPORT_OFF);list($Hd,$sg)=explode(":",$N,2);$Oh=adminer()->connectSsl();if($Oh)$this->ssl_set($Oh['key'],$Oh['cert'],$Oh['ca'],'','');$J=@$this->real_connect(($N!=""?$Hd:ini_get("mysqli.default_host")),($N.$V!=""?$V:ini_get("mysqli.default_user")),($N.$V.$F!=""?$F:ini_get("mysqli.default_pw")),null,(is_numeric($sg)?intval($sg):ini_get("mysqli.default_port")),(is_numeric($sg)?$sg:null),($Oh?($Oh['verify']!==false?2048:64):0));$this->options(MYSQLI_OPT_LOCAL_INFILE,false);return($J?'':$this->error);}function
set_charset($Wa){if(parent::set_charset($Wa))return
true;parent::set_charset('utf8');return$this->query("SET NAMES $Wa");}function
next_result(){return
self::more_results()&&parent::next_result();}function
quote($Q){return"'".$this->escape_string($Q)."'";}}}elseif(extension_loaded("mysql")&&!((ini_bool("sql.safe_mode")||ini_bool("mysql.allow_local_infile"))&&extension_loaded("pdo_mysql"))){class
Db
extends
SqlDb{private$link;function
attach($N,$V,$F){if(ini_bool("mysql.allow_local_infile"))return
lang(79,"'mysql.allow_local_infile'","MySQLi","PDO_MySQL");$this->link=@mysql_connect(($N!=""?$N:ini_get("mysql.default_host")),("$N$V"!=""?$V:ini_get("mysql.default_user")),("$N$V$F"!=""?$F:ini_get("mysql.default_password")),true,131072);if(!$this->link)return
mysql_error();$this->server_info=mysql_get_server_info($this->link);return'';}function
set_charset($Wa){if(function_exists('mysql_set_charset')){if(mysql_set_charset($Wa,$this->link))return
true;mysql_set_charset('utf8',$this->link);}return$this->query("SET NAMES $Wa");}function
quote($Q){return"'".mysql_real_escape_string($Q,$this->link)."'";}function
select_db($Lb){return
mysql_select_db($Lb,$this->link);}function
query($H,$Oi=false){$I=@($Oi?mysql_unbuffered_query($H,$this->link):mysql_query($H,$this->link));$this->error="";if(!$I){$this->errno=mysql_errno($this->link);$this->error=mysql_error($this->link);return
false;}if($I===true){$this->affected_rows=mysql_affected_rows($this->link);$this->info=mysql_info($this->link);return
true;}return
new
Result($I);}}class
Result{var$num_rows;private$result;private$offset=0;function
__construct($I){$this->result=$I;$this->num_rows=mysql_num_rows($I);}function
fetch_assoc(){return
mysql_fetch_assoc($this->result);}function
fetch_row(){return
mysql_fetch_row($this->result);}function
fetch_field(){$J=mysql_fetch_field($this->result,$this->offset++);$J->orgtable=$J->table;$J->charsetnr=($J->blob?63:0);return$J;}function
__destruct(){mysql_free_result($this->result);}}}elseif(extension_loaded("pdo_mysql")){class
Db
extends
PdoDb{var$extension="PDO_MySQL";function
attach($N,$V,$F){$Jf=array(\PDO::MYSQL_ATTR_LOCAL_INFILE=>false);$Oh=adminer()->connectSsl();if($Oh){if($Oh['key'])$Jf[\PDO::MYSQL_ATTR_SSL_KEY]=$Oh['key'];if($Oh['cert'])$Jf[\PDO::MYSQL_ATTR_SSL_CERT]=$Oh['cert'];if($Oh['ca'])$Jf[\PDO::MYSQL_ATTR_SSL_CA]=$Oh['ca'];if(isset($Oh['verify']))$Jf[\PDO::MYSQL_ATTR_SSL_VERIFY_SERVER_CERT]=$Oh['verify'];}return$this->dsn("mysql:charset=utf8;host=".str_replace(":",";unix_socket=",preg_replace('~:(\d)~',';port=\1',$N)),$V,$F,$Jf);}function
set_charset($Wa){return$this->query("SET NAMES $Wa");}function
select_db($Lb){return$this->query("USE ".idf_escape($Lb));}function
query($H,$Oi=false){$this->pdo->setAttribute(\PDO::MYSQL_ATTR_USE_BUFFERED_QUERY,!$Oi);return
parent::query($H,$Oi);}}}class
Driver
extends
SqlDriver{static$Lc=array("MySQLi","MySQL","PDO_MySQL");static$ne="sql";var$unsigned=array("unsigned","zerofill","unsigned zerofill");var$operators=array("=","<",">","<=",">=","!=","LIKE","LIKE %%","REGEXP","IN","FIND_IN_SET","IS NULL","NOT LIKE","NOT REGEXP","NOT IN","IS NOT NULL","SQL");var$functions=array("char_length","date","from_unixtime","lower","round","floor","ceil","sec_to_time","time_to_sec","upper");var$grouping=array("avg","count","count distinct","group_concat","max","min","sum");static
function
connect($N,$V,$F){$g=parent::connect($N,$V,$F);if(is_string($g)){if(function_exists('iconv')&&!is_utf8($g)&&strlen($hh=iconv("windows-1250","utf-8",$g))>strlen($g))$g=$hh;return$g;}$g->set_charset(charset($g));$g->query("SET sql_quote_show_create = 1, autocommit = 1");$g->flavor=(preg_match('~MariaDB~',$g->server_info)?'maria':'mysql');add_driver(DRIVER,($g->flavor=='maria'?"MariaDB":"MySQL"));return$g;}function
__construct(Db$g){parent::__construct($g);$this->types=array(lang(25)=>array("tinyint"=>3,"smallint"=>5,"mediumint"=>8,"int"=>10,"bigint"=>20,"decimal"=>66,"float"=>12,"double"=>21),lang(26)=>array("date"=>10,"datetime"=>19,"timestamp"=>19,"time"=>10,"year"=>4),lang(27)=>array("char"=>255,"varchar"=>65535,"tinytext"=>255,"text"=>65535,"mediumtext"=>16777215,"longtext"=>4294967295),lang(80)=>array("enum"=>65535,"set"=>64),lang(28)=>array("bit"=>20,"binary"=>255,"varbinary"=>65535,"tinyblob"=>255,"blob"=>65535,"mediumblob"=>16777215,"longblob"=>4294967295),lang(30)=>array("geometry"=>0,"point"=>0,"linestring"=>0,"polygon"=>0,"multipoint"=>0,"multilinestring"=>0,"multipolygon"=>0,"geometrycollection"=>0),);$this->insertFunctions=array("char"=>"md5/sha1/password/encrypt/uuid","binary"=>"md5/sha1","date|time"=>"now",);$this->editFunctions=array(number_type()=>"+/-","date"=>"+ interval/- interval","time"=>"addtime/subtime","char|text"=>"concat",);if(min_version('5.7.8',10.2,$g))$this->types[lang(27)]["json"]=4294967295;if(min_version('',10.7,$g)){$this->types[lang(27)]["uuid"]=128;$this->insertFunctions['uuid']='uuid';}if(min_version(9,'',$g)){$this->types[lang(25)]["vector"]=16383;$this->insertFunctions['vector']='string_to_vector';}if(min_version(5.7,10.2,$g))$this->generated=array("STORED","VIRTUAL");}function
unconvertFunction(array$n){return(preg_match("~binary~",$n["type"])?"<code class='jush-sql'>UNHEX</code>":($n["type"]=="bit"?doc_link(array('sql'=>'bit-value-literals.html'),"<code>b''</code>"):(preg_match("~geometry|point|linestring|polygon~",$n["type"])?"<code class='jush-sql'>GeomFromText</code>":"")));}function
insert($R,array$O){return($O?parent::insert($R,$O):queries("INSERT INTO ".table($R)." ()\nVALUES ()"));}function
insertUpdate($R,array$L,array$G){$e=array_keys(reset($L));$xg="INSERT INTO ".table($R)." (".implode(", ",$e).") VALUES\n";$hj=array();foreach($e
as$y)$hj[$y]="$y = VALUES($y)";$Vh="\nON DUPLICATE KEY UPDATE ".implode(", ",$hj);$hj=array();$z=0;foreach($L
as$O){$Y="(".implode(", ",$O).")";if($hj&&(strlen($xg)+$z+strlen($Y)+strlen($Vh)>1e6)){if(!queries($xg.implode(",\n",$hj).$Vh))return
false;$hj=array();$z=0;}$hj[]=$Y;$z+=strlen($Y)+2;}return
queries($xg.implode(",\n",$hj).$Vh);}function
slowQuery($H,$ri){if(min_version('5.7.8','10.1.2')){if($this->conn->flavor=='maria')return"SET STATEMENT max_statement_time=$ri FOR $H";elseif(preg_match('~^(SELECT\b)(.+)~is',$H,$B))return"$B[1] /*+ MAX_EXECUTION_TIME(".($ri*1000).") */ $B[2]";}}function
convertSearch($v,array$X,array$n){return(preg_match('~char|text|enum|set~',$n["type"])&&!preg_match("~^utf8~",$n["collation"])&&preg_match('~[\x80-\xFF]~',$X['val'])?"CONVERT($v USING ".charset($this->conn).")":$v);}function
warnings(){$I=$this->conn->query("SHOW WARNINGS");if($I&&$I->num_rows){ob_start();print_select_result($I);return
ob_get_clean();}}function
tableHelp($C,$le=false){$He=($this->conn->flavor=='maria');if(information_schema(DB))return
strtolower("information-schema-".($He?"$C-table/":str_replace("_","-",$C)."-table.html"));if(DB=="mysql")return($He?"mysql$C-table/":"system-schema.html");}function
hasCStyleEscapes(){static$Ra;if($Ra===null){$Mh=get_val("SHOW VARIABLES LIKE 'sql_mode'",1,$this->conn);$Ra=(strpos($Mh,'NO_BACKSLASH_ESCAPES')===false);}return$Ra;}function
engines(){$J=array();foreach(get_rows("SHOW ENGINES")as$K){if(preg_match("~YES|DEFAULT~",$K["Support"]))$J[]=$K["Engine"];}return$J;}}function
idf_escape($v){return"`".str_replace("`","``",$v)."`";}function
table($v){return
idf_escape($v);}function
get_databases($cd){$J=get_session("dbs");if($J===null){$H="SELECT SCHEMA_NAME FROM information_schema.SCHEMATA ORDER BY SCHEMA_NAME";$J=($cd?slow_query($H):get_vals($H));restart_session();set_session("dbs",$J);stop_session();}return$J;}function
limit($H,$Z,$_,$D=0,$th=" "){return" $H$Z".($_?$th."LIMIT $_".($D?" OFFSET $D":""):"");}function
limit1($R,$H,$Z,$th="\n"){return
limit($H,$Z,1,0,$th);}function
db_collation($k,array$jb){$J=null;$i=get_val("SHOW CREATE DATABASE ".idf_escape($k),1);if(preg_match('~ COLLATE ([^ ]+)~',$i,$B))$J=$B[1];elseif(preg_match('~ CHARACTER SET ([^ ]+)~',$i,$B))$J=$jb[$B[1]][-1];return$J;}function
logged_user(){return
get_val("SELECT USER()");}function
tables_list(){return
get_key_vals("SELECT TABLE_NAME, TABLE_TYPE FROM information_schema.TABLES WHERE TABLE_SCHEMA = DATABASE() ORDER BY TABLE_NAME");}function
count_tables(array$j){$J=array();foreach($j
as$k)$J[$k]=count(get_vals("SHOW TABLES IN ".idf_escape($k)));return$J;}function
table_status($C="",$Pc=false){$J=array();foreach(get_rows($Pc?"SELECT TABLE_NAME AS Name, ENGINE AS Engine, TABLE_COMMENT AS Comment FROM information_schema.TABLES WHERE TABLE_SCHEMA = DATABASE() ".($C!=""?"AND TABLE_NAME = ".q($C):"ORDER BY Name"):"SHOW TABLE STATUS".($C!=""?" LIKE ".q(addcslashes($C,"%_\\")):""))as$K){if($K["Engine"]=="InnoDB")$K["Comment"]=preg_replace('~(?:(.+); )?InnoDB free: .*~','\1',$K["Comment"]);if(!isset($K["Engine"]))$K["Comment"]="";if($C!="")$K["Name"]=$C;$J[$K["Name"]]=$K;}return$J;}function
is_view(array$S){return$S["Engine"]===null;}function
fk_support(array$S){return
preg_match('~InnoDB|IBMDB2I'.(min_version(5.6)?'|NDB':'').'~i',$S["Engine"]);}function
fields($R){$He=(connection()->flavor=='maria');$J=array();foreach(get_rows("SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = ".q($R)." ORDER BY ORDINAL_POSITION")as$K){$n=$K["COLUMN_NAME"];$U=$K["COLUMN_TYPE"];$od=$K["GENERATION_EXPRESSION"];$Mc=$K["EXTRA"];preg_match('~^(VIRTUAL|PERSISTENT|STORED)~',$Mc,$nd);preg_match('~^([^( ]+)(?:\((.+)\))?( unsigned)?( zerofill)?$~',$U,$Ke);$l=$K["COLUMN_DEFAULT"];if($l!=""){$ke=preg_match('~text|json~',$Ke[1]);if(!$He&&$ke)$l=preg_replace("~^(_\w+)?('.*')$~",'\2',stripslashes($l));if($He||$ke){$l=($l=="NULL"?null:preg_replace_callback("~^'(.*)'$~",function($B){return
stripslashes(str_replace("''","'",$B[1]));},$l));}if(!$He&&preg_match('~binary~',$Ke[1])&&preg_match('~^0x(\w*)$~',$l,$B))$l=pack("H*",$B[1]);}$J[$n]=array("field"=>$n,"full_type"=>$U,"type"=>$Ke[1],"length"=>$Ke[2],"unsigned"=>ltrim($Ke[3].$Ke[4]),"default"=>($nd?($He?$od:stripslashes($od)):$l),"null"=>($K["IS_NULLABLE"]=="YES"),"auto_increment"=>($Mc=="auto_increment"),"on_update"=>(preg_match('~\bon update (\w+)~i',$Mc,$B)?$B[1]:""),"collation"=>$K["COLLATION_NAME"],"privileges"=>array_flip(explode(",","$K[PRIVILEGES],where,order")),"comment"=>$K["COLUMN_COMMENT"],"primary"=>($K["COLUMN_KEY"]=="PRI"),"generated"=>($nd[1]=="PERSISTENT"?"STORED":$nd[1]),);}return$J;}function
indexes($R,$h=null){$J=array();foreach(get_rows("SHOW INDEX FROM ".table($R),$h)as$K){$C=$K["Key_name"];$J[$C]["type"]=($C=="PRIMARY"?"PRIMARY":($K["Index_type"]=="FULLTEXT"?"FULLTEXT":($K["Non_unique"]?($K["Index_type"]=="SPATIAL"?"SPATIAL":"INDEX"):"UNIQUE")));$J[$C]["columns"][]=$K["Column_name"];$J[$C]["lengths"][]=($K["Index_type"]=="SPATIAL"?null:$K["Sub_part"]);$J[$C]["descs"][]=null;}return$J;}function
foreign_keys($R){static$mg='(?:`(?:[^`]|``)+`|"(?:[^"]|"")+")';$J=array();$Bb=get_val("SHOW CREATE TABLE ".table($R),1);if($Bb){preg_match_all("~CONSTRAINT ($mg) FOREIGN KEY ?\\(((?:$mg,? ?)+)\\) REFERENCES ($mg)(?:\\.($mg))? \\(((?:$mg,? ?)+)\\)(?: ON DELETE (driver()->onActions))?(?: ON UPDATE (driver()->onActions))?~",$Bb,$Le,PREG_SET_ORDER);foreach($Le
as$B){preg_match_all("~$mg~",$B[2],$Gh);preg_match_all("~$mg~",$B[5],$ji);$J[idf_unescape($B[1])]=array("db"=>idf_unescape($B[4]!=""?$B[3]:$B[4]),"table"=>idf_unescape($B[4]!=""?$B[4]:$B[3]),"source"=>array_map('Adminer\idf_unescape',$Gh[0]),"target"=>array_map('Adminer\idf_unescape',$ji[0]),"on_delete"=>($B[6]?:"RESTRICT"),"on_update"=>($B[7]?:"RESTRICT"),);}}return$J;}function
view($C){return
array("select"=>preg_replace('~^(?:[^`]|`[^`]*`)*\s+AS\s+~isU','',get_val("SHOW CREATE VIEW ".table($C),1)));}function
collations(){$J=array();foreach(get_rows("SHOW COLLATION")as$K){if($K["Default"])$J[$K["Charset"]][-1]=$K["Collation"];else$J[$K["Charset"]][]=$K["Collation"];}ksort($J);foreach($J
as$y=>$X)sort($J[$y]);return$J;}function
information_schema($k){return($k=="information_schema")||(min_version(5.5)&&$k=="performance_schema");}function
error(){return
h(preg_replace('~^You have an error.*syntax to use~U',"Syntax error",connection()->error));}function
create_database($k,$c){return
queries("CREATE DATABASE ".idf_escape($k).($c?" COLLATE ".q($c):""));}function
drop_databases(array$j){$J=apply_queries("DROP DATABASE",$j,'Adminer\idf_escape');restart_session();set_session("dbs",null);return$J;}function
rename_database($C,$c){$J=false;if(create_database($C,$c)){$T=array();$mj=array();foreach(tables_list()as$R=>$U){if($U=='VIEW')$mj[]=$R;else$T[]=$R;}$J=(!$T&&!$mj)||move_tables($T,$mj,$C);drop_databases($J?array(DB):array());}return$J;}function
auto_increment(){$Ca=" PRIMARY KEY";if($_GET["create"]!=""&&$_POST["auto_increment_col"]){foreach(indexes($_GET["create"])as$w){if(in_array($_POST["fields"][$_POST["auto_increment_col"]]["orig"],$w["columns"],true)){$Ca="";break;}if($w["type"]=="PRIMARY")$Ca=" UNIQUE";}}return" AUTO_INCREMENT$Ca";}function
alter_table($R,$C,array$o,array$ed,$ob,$tc,$c,$Ba,$ig){$b=array();foreach($o
as$n){if($n[1]){$l=$n[1][3];if(preg_match('~ GENERATED~',$l)){$n[1][3]=(connection()->flavor=='maria'?"":$n[1][2]);$n[1][2]=$l;}$b[]=($R!=""?($n[0]!=""?"CHANGE ".idf_escape($n[0]):"ADD"):" ")." ".implode($n[1]).($R!=""?$n[2]:"");}else$b[]="DROP ".idf_escape($n[0]);}$b=array_merge($b,$ed);$P=($ob!==null?" COMMENT=".q($ob):"").($tc?" ENGINE=".q($tc):"").($c?" COLLATE ".q($c):"").($Ba!=""?" AUTO_INCREMENT=$Ba":"");if($R=="")return
queries("CREATE TABLE ".table($C)." (\n".implode(",\n",$b)."\n)$P$ig");if($R!=$C)$b[]="RENAME TO ".table($C);if($P)$b[]=ltrim($P);return($b||$ig?queries("ALTER TABLE ".table($R)."\n".implode(",\n",$b).$ig):true);}function
alter_indexes($R,$b){$Va=array();foreach($b
as$X)$Va[]=($X[2]=="DROP"?"\nDROP INDEX ".idf_escape($X[1]):"\nADD $X[0] ".($X[0]=="PRIMARY"?"KEY ":"").($X[1]!=""?idf_escape($X[1])." ":"")."(".implode(", ",$X[2]).")");return
queries("ALTER TABLE ".table($R).implode(",",$Va));}function
truncate_tables(array$T){return
apply_queries("TRUNCATE TABLE",$T);}function
drop_views(array$mj){return
queries("DROP VIEW ".implode(", ",array_map('Adminer\table',$mj)));}function
drop_tables(array$T){return
queries("DROP TABLE ".implode(", ",array_map('Adminer\table',$T)));}function
move_tables(array$T,array$mj,$ji){$Vg=array();foreach($T
as$R)$Vg[]=table($R)." TO ".idf_escape($ji).".".table($R);if(!$Vg||queries("RENAME TABLE ".implode(", ",$Vg))){$Sb=array();foreach($mj
as$R)$Sb[table($R)]=view($R);connection()->select_db($ji);$k=idf_escape(DB);foreach($Sb
as$C=>$lj){if(!queries("CREATE VIEW $C AS ".str_replace(" $k."," ",$lj["select"]))||!queries("DROP VIEW $k.$C"))return
false;}return
true;}return
false;}function
copy_tables(array$T,array$mj,$ji){queries("SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO'");foreach($T
as$R){$C=($ji==DB?table("copy_$R"):idf_escape($ji).".".table($R));if(($_POST["overwrite"]&&!queries("\nDROP TABLE IF EXISTS $C"))||!queries("CREATE TABLE $C LIKE ".table($R))||!queries("INSERT INTO $C SELECT * FROM ".table($R)))return
false;foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($R,"%_\\")))as$K){$Hi=$K["Trigger"];if(!queries("CREATE TRIGGER ".($ji==DB?idf_escape("copy_$Hi"):idf_escape($ji).".".idf_escape($Hi))." $K[Timing] $K[Event] ON $C FOR EACH ROW\n$K[Statement];"))return
false;}}foreach($mj
as$R){$C=($ji==DB?table("copy_$R"):idf_escape($ji).".".table($R));$lj=view($R);if(($_POST["overwrite"]&&!queries("DROP VIEW IF EXISTS $C"))||!queries("CREATE VIEW $C AS $lj[select]"))return
false;}return
true;}function
trigger($C,$R){if($C=="")return
array();$L=get_rows("SHOW TRIGGERS WHERE `Trigger` = ".q($C));return
reset($L);}function
triggers($R){$J=array();foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($R,"%_\\")))as$K)$J[$K["Trigger"]]=array($K["Timing"],$K["Event"]);return$J;}function
trigger_options(){return
array("Timing"=>array("BEFORE","AFTER"),"Event"=>array("INSERT","UPDATE","DELETE"),"Type"=>array("FOR EACH ROW"),);}function
routine($C,$U){$ta=array("bool","boolean","integer","double precision","real","dec","numeric","fixed","national char","national varchar");$Hh="(?:\\s|/\\*[\s\S]*?\\*/|(?:#|-- )[^\n]*\n?|--\r?\n)";$vc=driver()->enumLength;$Mi="((".implode("|",array_merge(array_keys(driver()->types()),$ta)).")\\b(?:\\s*\\(((?:[^'\")]|$vc)++)\\))?"."\\s*(zerofill\\s*)?(unsigned(?:\\s+zerofill)?)?)(?:\\s*(?:CHARSET|CHARACTER\\s+SET)\\s*['\"]?([^'\"\\s,]+)['\"]?)?";$mg="$Hh*(".($U=="FUNCTION"?"":driver()->inout).")?\\s*(?:`((?:[^`]|``)*)`\\s*|\\b(\\S+)\\s+)$Mi";$i=get_val("SHOW CREATE $U ".idf_escape($C),2);preg_match("~\\(((?:$mg\\s*,?)*)\\)\\s*".($U=="FUNCTION"?"RETURNS\\s+$Mi\\s+":"")."(.*)~is",$i,$B);$o=array();preg_match_all("~$mg\\s*,?~is",$B[1],$Le,PREG_SET_ORDER);foreach($Le
as$cg)$o[]=array("field"=>str_replace("``","`",$cg[2]).$cg[3],"type"=>strtolower($cg[5]),"length"=>preg_replace_callback("~$vc~s",'Adminer\normalize_enum',$cg[6]),"unsigned"=>strtolower(preg_replace('~\s+~',' ',trim("$cg[8] $cg[7]"))),"null"=>true,"full_type"=>$cg[4],"inout"=>strtoupper($cg[1]),"collation"=>strtolower($cg[9]),);return
array("fields"=>$o,"comment"=>get_val("SELECT ROUTINE_COMMENT FROM information_schema.ROUTINES WHERE ROUTINE_SCHEMA = DATABASE() AND ROUTINE_NAME = ".q($C)),)+($U!="FUNCTION"?array("definition"=>$B[11]):array("returns"=>array("type"=>$B[12],"length"=>$B[13],"unsigned"=>$B[15],"collation"=>$B[16]),"definition"=>$B[17],"language"=>"SQL",));}function
routines(){return
get_rows("SELECT ROUTINE_NAME AS SPECIFIC_NAME, ROUTINE_NAME, ROUTINE_TYPE, DTD_IDENTIFIER FROM information_schema.ROUTINES WHERE ROUTINE_SCHEMA = DATABASE()");}function
routine_languages(){return
array();}function
routine_id($C,array$K){return
idf_escape($C);}function
last_id($I){return
get_val("SELECT LAST_INSERT_ID()");}function
explain(Db$g,$H){return$g->query("EXPLAIN ".(min_version(5.1)&&!min_version(5.7)?"PARTITIONS ":"").$H);}function
found_rows(array$S,array$Z){return($Z||$S["Engine"]!="InnoDB"?null:$S["Rows"]);}function
create_sql($R,$Ba,$Th){$J=get_val("SHOW CREATE TABLE ".table($R),1);if(!$Ba)$J=preg_replace('~ AUTO_INCREMENT=\d+~','',$J);return$J;}function
truncate_sql($R){return"TRUNCATE ".table($R);}function
use_sql($Lb){return"USE ".idf_escape($Lb);}function
trigger_sql($R){$J="";foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($R,"%_\\")),null,"-- ")as$K)$J
.="\nCREATE TRIGGER ".idf_escape($K["Trigger"])." $K[Timing] $K[Event] ON ".table($K["Table"])." FOR EACH ROW\n$K[Statement];;\n";return$J;}function
show_variables(){return
get_rows("SHOW VARIABLES");}function
show_status(){return
get_rows("SHOW STATUS");}function
process_list(){return
get_rows("SHOW FULL PROCESSLIST");}function
convert_field(array$n){if(preg_match("~binary~",$n["type"]))return"HEX(".idf_escape($n["field"]).")";if($n["type"]=="bit")return"BIN(".idf_escape($n["field"])." + 0)";if(preg_match("~geometry|point|linestring|polygon~",$n["type"]))return(min_version(8)?"ST_":"")."AsWKT(".idf_escape($n["field"]).")";}function
unconvert_field(array$n,$J){if(preg_match("~binary~",$n["type"]))$J="UNHEX($J)";if($n["type"]=="bit")$J="CONVERT(b$J, UNSIGNED)";if(preg_match("~geometry|point|linestring|polygon~",$n["type"])){$xg=(min_version(8)?"ST_":"");$J=$xg."GeomFromText($J, $xg"."SRID($n[field]))";}return$J;}function
support($Qc){return!preg_match("~scheme|sequence|type|view_trigger|materializedview".(min_version(8)?"":"|descidx".(min_version(5.1)?"":"|event|partitioning")).(min_version('8.0.16','10.2.1')?"":"|check")."~",$Qc);}function
kill_process($X){return
queries("KILL ".number($X));}function
connection_id(){return"SELECT CONNECTION_ID()";}function
max_connections(){return
get_val("SELECT @@max_connections");}function
types(){return
array();}function
type_values($u){return"";}function
schemas(){return
array();}function
get_schema(){return"";}function
set_schema($jh,$h=null){return
true;}}define('Adminer\JUSH',Driver::$ne);define('Adminer\SERVER',$_GET[DRIVER]);define('Adminer\DB',$_GET["db"]);define('Adminer\ME',preg_replace('~\?.*~','',relative_uri()).'?'.(sid()?SID.'&':'').(SERVER!==null?DRIVER."=".urlencode(SERVER).'&':'').($_GET["ext"]?"ext=".urlencode($_GET["ext"]).'&':'').(isset($_GET["username"])?"username=".urlencode($_GET["username"]).'&':'').(DB!=""?'db='.urlencode(DB).'&'.(isset($_GET["ns"])?"ns=".urlencode($_GET["ns"])."&":""):''));function
page_header($ti,$m="",$Oa=array(),$ui=""){page_headers();if(is_ajax()&&$m){page_messages($m);exit;}if(!ob_get_level())ob_start(null,4096);$vi=$ti.($ui!=""?": $ui":"");$wi=strip_tags($vi.(SERVER!=""&&SERVER!="localhost"?h(" - ".SERVER):"")." - ".adminer()->name());echo'<!DOCTYPE html>
<html lang="',LANG,'" dir="',lang(81),'">
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<meta name="robots" content="noindex">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>',$wi,'</title>
<link rel="stylesheet" href="',h(preg_replace("~\\?.*~","",ME)."?file=default.css&version=5.1.1"),'">
';$Fb=adminer()->css();$_d=false;$yd=false;foreach($Fb
as$p){if(strpos($p,"adminer.css")!==false)$_d=true;if(strpos($p,"adminer-dark.css")!==false)$yd=true;}$Ib=($_d?($yd?null:false):($yd?:null));$Te=" media='(prefers-color-scheme: dark)'";if($Ib!==false)echo"<link rel='stylesheet'".($Ib?"":$Te)." href='".h(preg_replace("~\\?.*~","",ME)."?file=dark.css&version=5.1.1")."'>\n";echo"<meta name='color-scheme' content='".($Ib===null?"light dark":($Ib?"dark":"light"))."'>\n",script_src(preg_replace("~\\?.*~","",ME)."?file=functions.js&version=5.1.1");if(adminer()->head($Ib))echo"<link rel='shortcut icon' type='image/x-icon' href='".h(preg_replace("~\\?.*~","",ME)."?file=favicon.ico&version=5.1.1")."'>\n","<link rel='apple-touch-icon' href='".h(preg_replace("~\\?.*~","",ME)."?file=favicon.ico&version=5.1.1")."'>\n";foreach($Fb
as$X)echo"<link rel='stylesheet'".(preg_match('~-dark~',$X)&&!$Ib?$Te:"")." href='".h($X)."'>\n";echo"\n<body class='".lang(81)." nojs'>\n";$p=get_temp_dir()."/adminer.version";if(!$_COOKIE["adminer_version"]&&function_exists('openssl_verify')&&file_exists($p)&&filemtime($p)+86400>time()){$kj=unserialize(file_get_contents($p));$Fg="-----BEGIN PUBLIC KEY-----
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwqWOVuF5uw7/+Z70djoK
RlHIZFZPO0uYRezq90+7Amk+FDNd7KkL5eDve+vHRJBLAszF/7XKXe11xwliIsFs
DFWQlsABVZB3oisKCBEuI71J4kPH8dKGEWR9jDHFw3cWmoH3PmqImX6FISWbG3B8
h7FIx3jEaw5ckVPVTeo5JRm/1DZzJxjyDenXvBQ/6o9DgZKeNDgxwKzH+sw9/YCO
jHnq1cFpOIISzARlrHMa/43YfeNRAm/tsBXjSxembBPo7aQZLAWHmaj5+K19H10B
nCpz9Y++cipkVEiKRGih4ZEvjoFysEOdRLj6WiD/uUNky4xGeA6LaJqh5XpkFkcQ
fQIDAQAB
-----END PUBLIC KEY-----
";if(openssl_verify($kj["version"],base64_decode($kj["signature"]),$Fg)==1)$_COOKIE["adminer_version"]=$kj["version"];}echo
script("mixin(document.body, {onkeydown: bodyKeydown, onclick: bodyClick".(isset($_COOKIE["adminer_version"])?"":", onload: partial(verifyVersion, '".VERSION."', '".js_escape(ME)."', '".get_token()."')")."});
document.body.classList.replace('nojs', 'js');
const offlineMessage = '".js_escape(lang(82))."';
const thousandsSeparator = '".js_escape(lang(4))."';"),"<div id='help' class='jush-".JUSH." jsonly hidden'></div>\n",script("mixin(qs('#help'), {onmouseover: () => { helpOpen = 1; }, onmouseout: helpMouseout});"),"<div id='content'>\n","<span id='menuopen' class='jsonly'>".icon("move","","menu","")."</span>".script("qs('#menuopen').onclick = event => { qs('#foot').classList.toggle('foot'); event.stopPropagation(); }");if($Oa!==null){$A=substr(preg_replace('~\b(username|db|ns)=[^&]*&~','',ME),0,-1);echo'<p id="breadcrumb"><a href="'.h($A?:".").'">'.get_driver(DRIVER).'</a> » ';$A=substr(preg_replace('~\b(db|ns)=[^&]*&~','',ME),0,-1);$N=adminer()->serverName(SERVER);$N=($N!=""?$N:lang(33));if($Oa===false)echo"$N\n";else{echo"<a href='".h($A)."' accesskey='1' title='Alt+Shift+1'>$N</a> » ";if($_GET["ns"]!=""||(DB!=""&&is_array($Oa)))echo'<a href="'.h($A."&db=".urlencode(DB).(support("scheme")?"&ns=":"")).'">'.h(DB).'</a> » ';if(is_array($Oa)){if($_GET["ns"]!="")echo'<a href="'.h(substr(ME,0,-1)).'">'.h($_GET["ns"]).'</a> » ';foreach($Oa
as$y=>$X){$Ub=(is_array($X)?$X[1]:h($X));if($Ub!="")echo"<a href='".h(ME."$y=").urlencode(is_array($X)?$X[0]:$X)."'>$Ub</a> » ";}}echo"$ti\n";}}echo"<h2>$vi</h2>\n","<div id='ajaxstatus' class='jsonly hidden'></div>\n";restart_session();page_messages($m);$j=&get_session("dbs");if(DB!=""&&$j&&!in_array(DB,$j,true))$j=null;stop_session();define('Adminer\PAGE_HEADER',1);}function
page_headers(){header("Content-Type: text/html; charset=utf-8");header("Cache-Control: no-cache");header("X-Frame-Options: deny");header("X-XSS-Protection: 0");header("X-Content-Type-Options: nosniff");header("Referrer-Policy: origin-when-cross-origin");foreach(adminer()->csp(csp())as$Eb){$Bd=array();foreach($Eb
as$y=>$X)$Bd[]="$y $X";header("Content-Security-Policy: ".implode("; ",$Bd));}adminer()->headers();}function
csp(){return
array(array("script-src"=>"'self' 'unsafe-inline' 'nonce-".get_nonce()."' 'strict-dynamic'","connect-src"=>"'self'","frame-src"=>"https://www.adminer.org","object-src"=>"'none'","base-uri"=>"'none'","form-action"=>"'self'",),);}function
get_nonce(){static$pf;if(!$pf)$pf=base64_encode(rand_string());return$pf;}function
page_messages($m){$Xi=preg_replace('~^[^?]*~','',$_SERVER["REQUEST_URI"]);$Ze=idx($_SESSION["messages"],$Xi);if($Ze){echo"<div class='message'>".implode("</div>\n<div class='message'>",$Ze)."</div>".script("messagesPrint();");unset($_SESSION["messages"][$Xi]);}if($m)echo"<div class='error'>$m</div>\n";if(adminer()->error)echo"<div class='error'>".adminer()->error."</div>\n";}function
page_footer($cf=""){echo"</div>\n\n<div id='foot' class='foot'>\n<div id='menu'>\n";adminer()->navigation($cf);echo"</div>\n";if($cf!="auth")echo'<form action="" method="post">
<p class="logout">
<span>',h($_GET["username"])."\n",'</span>
<input type="submit" name="logout" value="',lang(83),'" id="logout">
',input_token(),'</form>
';echo"</div>\n\n",script("setupSubmitHighlight(document);");}function
int32($hf){while($hf>=2147483648)$hf-=4294967296;while($hf<=-2147483649)$hf+=4294967296;return(int)$hf;}function
long2str(array$W,$oj){$hh='';foreach($W
as$X)$hh
.=pack('V',$X);if($oj)return
substr($hh,0,end($W));return$hh;}function
str2long($hh,$oj){$W=array_values(unpack('V*',str_pad($hh,4*ceil(strlen($hh)/4),"\0")));if($oj)$W[]=strlen($hh);return$W;}function
xxtea_mx($vj,$uj,$Wh,$oe){return
int32((($vj>>5&0x7FFFFFF)^$uj<<2)+(($uj>>3&0x1FFFFFFF)^$vj<<4))^int32(($Wh^$uj)+($oe^$vj));}function
encrypt_string($Rh,$y){if($Rh=="")return"";$y=array_values(unpack("V*",pack("H*",md5($y))));$W=str2long($Rh,true);$hf=count($W)-1;$vj=$W[$hf];$uj=$W[0];$Gg=floor(6+52/($hf+1));$Wh=0;while($Gg-->0){$Wh=int32($Wh+0x9E3779B9);$kc=$Wh>>2&3;for($ag=0;$ag<$hf;$ag++){$uj=$W[$ag+1];$gf=xxtea_mx($vj,$uj,$Wh,$y[$ag&3^$kc]);$vj=int32($W[$ag]+$gf);$W[$ag]=$vj;}$uj=$W[0];$gf=xxtea_mx($vj,$uj,$Wh,$y[$ag&3^$kc]);$vj=int32($W[$hf]+$gf);$W[$hf]=$vj;}return
long2str($W,false);}function
decrypt_string($Rh,$y){if($Rh=="")return"";if(!$y)return
false;$y=array_values(unpack("V*",pack("H*",md5($y))));$W=str2long($Rh,false);$hf=count($W)-1;$vj=$W[$hf];$uj=$W[0];$Gg=floor(6+52/($hf+1));$Wh=int32($Gg*0x9E3779B9);while($Wh){$kc=$Wh>>2&3;for($ag=$hf;$ag>0;$ag--){$vj=$W[$ag-1];$gf=xxtea_mx($vj,$uj,$Wh,$y[$ag&3^$kc]);$uj=int32($W[$ag]-$gf);$W[$ag]=$uj;}$vj=$W[$hf];$gf=xxtea_mx($vj,$uj,$Wh,$y[$ag&3^$kc]);$uj=int32($W[0]-$gf);$W[0]=$uj;$Wh=int32($Wh-0x9E3779B9);}return
long2str($W,true);}$og=array();if($_COOKIE["adminer_permanent"]){foreach(explode(" ",$_COOKIE["adminer_permanent"])as$X){list($y)=explode(":",$X);$og[$y]=$X;}}function
add_invalid_login(){$Ha=get_temp_dir()."/adminer.invalid";foreach(glob("$Ha*")?:array($Ha)as$p){$r=file_open_lock($p);if($r)break;}if(!$r)$r=file_open_lock("$Ha-".rand_string());if(!$r)return;$ge=unserialize(stream_get_contents($r));$qi=time();if($ge){foreach($ge
as$he=>$X){if($X[0]<$qi)unset($ge[$he]);}}$fe=&$ge[adminer()->bruteForceKey()];if(!$fe)$fe=array($qi+30*60,0);$fe[1]++;file_write_unlock($r,serialize($ge));}function
check_invalid_login(array&$og){$ge=array();foreach(glob(get_temp_dir()."/adminer.invalid*")as$p){$r=file_open_lock($p);if($r){$ge=unserialize(stream_get_contents($r));file_unlock($r);break;}}$fe=idx($ge,adminer()->bruteForceKey(),array());$of=($fe[1]>29?$fe[0]-time():0);if($of>0)auth_error(lang(84,ceil($of/60)),$og);}$Aa=$_POST["auth"];if($Aa){session_regenerate_id();$jj=$Aa["driver"];$N=$Aa["server"];$V=$Aa["username"];$F=(string)$Aa["password"];$k=$Aa["db"];set_password($jj,$N,$V,$F);$_SESSION["db"][$jj][$N][$V][$k]=true;if($Aa["permanent"]){$y=implode("-",array_map('base64_encode',array($jj,$N,$V,$k)));$Ag=adminer()->permanentLogin(true);$og[$y]="$y:".base64_encode($Ag?encrypt_string($F,$Ag):"");cookie("adminer_permanent",implode(" ",$og));}if(count($_POST)==1||DRIVER!=$jj||SERVER!=$N||$_GET["username"]!==$V||DB!=$k)redirect(auth_url($jj,$N,$V,$k));}elseif($_POST["logout"]&&(!$_SESSION["token"]||verify_token())){foreach(array("pwds","db","dbs","queries")as$y)set_session($y,null);unset_permanent($og);redirect(substr(preg_replace('~\b(username|db|ns)=[^&]*&~','',ME),0,-1),lang(85).' '.lang(86));}elseif($og&&!$_SESSION["pwds"]){session_regenerate_id();$Ag=adminer()->permanentLogin();foreach($og
as$y=>$X){list(,$db)=explode(":",$X);list($jj,$N,$V,$k)=array_map('base64_decode',explode("-",$y));set_password($jj,$N,$V,decrypt_string(base64_decode($db),$Ag));$_SESSION["db"][$jj][$N][$V][$k]=true;}}function
unset_permanent(array&$og){foreach($og
as$y=>$X){list($jj,$N,$V,$k)=array_map('base64_decode',explode("-",$y));if($jj==DRIVER&&$N==SERVER&&$V==$_GET["username"]&&$k==DB)unset($og[$y]);}cookie("adminer_permanent",implode(" ",$og));}function
auth_error($m,array&$og){$zh=session_name();if(isset($_GET["username"])){header("HTTP/1.1 403 Forbidden");if(($_COOKIE[$zh]||$_GET[$zh])&&!$_SESSION["token"])$m=lang(87);else{restart_session();add_invalid_login();$F=get_password();if($F!==null){if($F===false)$m
.=($m?'<br>':'').lang(88,target_blank(),'<code>permanentLogin()</code>');set_password(DRIVER,SERVER,$_GET["username"],null);}unset_permanent($og);}}if(!$_COOKIE[$zh]&&$_GET[$zh]&&ini_bool("session.use_only_cookies"))$m=lang(89);$dg=session_get_cookie_params();cookie("adminer_key",($_COOKIE["adminer_key"]?:rand_string()),$dg["lifetime"]);if(!$_SESSION["token"])$_SESSION["token"]=rand(1,1e6);page_header(lang(37),$m,null);echo"<form action='' method='post'>\n","<div>";if(hidden_fields($_POST,array("auth")))echo"<p class='message'>".lang(90)."\n";echo"</div>\n";adminer()->loginForm();echo"</form>\n";page_footer("auth");exit;}if(isset($_GET["username"])&&!class_exists('Adminer\Db')){unset($_SESSION["pwds"][DRIVER]);unset_permanent($og);page_header(lang(91),lang(92,implode(", ",Driver::$Lc)),false);page_footer("auth");exit;}$g='';if(isset($_GET["username"])&&is_string(get_password())){list($Hd,$sg)=explode(":",SERVER,2);if(preg_match('~^\s*([-+]?\d+)~',$sg,$B)&&($B[1]<1024||$B[1]>65535))auth_error(lang(93),$og);check_invalid_login($og);$Db=adminer()->credentials();$g=Driver::connect($Db[0],$Db[1],$Db[2]);if(is_object($g)){Db::$de=$g;Driver::$de=new
Driver($g);if($g->flavor)save_settings(array("vendor-".DRIVER."-".SERVER=>get_driver(DRIVER)));}}$Fe=null;if(!is_object($g)||($Fe=adminer()->login($_GET["username"],get_password()))!==true){$m=(is_string($g)?nl_br(h($g)):(is_string($Fe)?$Fe:lang(94))).(preg_match('~^ | $~',get_password())?'<br>'.lang(95):'');auth_error($m,$og);}if($_POST["logout"]&&$_SESSION["token"]&&!verify_token()){page_header(lang(83),lang(96));page_footer("db");exit;}if(!$_SESSION["token"])$_SESSION["token"]=rand(1,1e6);stop_session(true);if($Aa&&$_POST["token"])$_POST["token"]=get_token();$m='';if($_POST){if(!verify_token()){$Yd="max_input_vars";$Re=ini_get($Yd);if(extension_loaded("suhosin")){foreach(array("suhosin.request.max_vars","suhosin.post.max_vars")as$y){$X=ini_get($y);if($X&&(!$Re||$X<$Re)){$Yd=$y;$Re=$X;}}}$m=(!$_POST["token"]&&$Re?lang(97,"'$Yd'"):lang(96).' '.lang(98));}}elseif($_SERVER["REQUEST_METHOD"]=="POST"){$m=lang(99,"'post_max_size'");if(isset($_GET["sql"]))$m
.=' '.lang(100);}function
print_select_result($I,$h=null,array$Pf=array(),$_=0){$De=array();$x=array();$e=array();$Ma=array();$Ni=array();$J=array();for($t=0;(!$_||$t<$_)&&($K=$I->fetch_row());$t++){if(!$t){echo"<div class='scrollable'>\n","<table class='nowrap odds'>\n","<thead><tr>";for($me=0;$me<count($K);$me++){$n=$I->fetch_field();$C=$n->name;$Of=(isset($n->orgtable)?$n->orgtable:"");$Nf=(isset($n->orgname)?$n->orgname:$C);if($Pf&&JUSH=="sql")$De[$me]=($C=="table"?"table=":($C=="possible_keys"?"indexes=":null));elseif($Of!=""){if(isset($n->table))$J[$n->table]=$Of;if(!isset($x[$Of])){$x[$Of]=array();foreach(indexes($Of,$h)as$w){if($w["type"]=="PRIMARY"){$x[$Of]=array_flip($w["columns"]);break;}}$e[$Of]=$x[$Of];}if(isset($e[$Of][$Nf])){unset($e[$Of][$Nf]);$x[$Of][$Nf]=$me;$De[$me]=$Of;}}if($n->charsetnr==63)$Ma[$me]=true;$Ni[$me]=$n->type;echo"<th".($Of!=""||$n->name!=$Nf?" title='".h(($Of!=""?"$Of.":"").$Nf)."'":"").">".h($C).($Pf?doc_link(array('sql'=>"explain-output.html#explain_".strtolower($C),'mariadb'=>"explain/#the-columns-in-explain-select",)):"");}echo"</thead>\n";}echo"<tr>";foreach($K
as$y=>$X){$A="";if(isset($De[$y])&&!$e[$De[$y]]){if($Pf&&JUSH=="sql"){$R=$K[array_search("table=",$De)];$A=ME.$De[$y].urlencode($Pf[$R]!=""?$Pf[$R]:$R);}else{$A=ME."edit=".urlencode($De[$y]);foreach($x[$De[$y]]as$hb=>$me)$A
.="&where".urlencode("[".bracket_escape($hb)."]")."=".urlencode($K[$me]);}}elseif(is_url($X))$A=$X;if($X===null)$X="<i>NULL</i>";elseif($Ma[$y]&&!is_utf8($X))$X="<i>".lang(46,strlen($X))."</i>";else{$X=h($X);if($Ni[$y]==254)$X="<code>$X</code>";}if($A)$X="<a href='".h($A)."'".(is_url($A)?target_blank():'').">$X</a>";echo"<td".($Ni[$y]<=9||$Ni[$y]==246?" class='number'":"").">$X";}}echo($t?"</table>\n</div>":"<p class='message'>".lang(12))."\n";return$J;}function
referencable_primary($rh){$J=array();foreach(table_status('',true)as$bi=>$R){if($bi!=$rh&&fk_support($R)){foreach(fields($bi)as$n){if($n["primary"]){if($J[$bi]){unset($J[$bi]);break;}$J[$bi]=$n;}}}}return$J;}function
textarea($C,$Y,$L=10,$kb=80){echo"<textarea name='".h($C)."' rows='$L' cols='$kb' class='sqlarea jush-".JUSH."' spellcheck='false' wrap='off'>";if(is_array($Y)){foreach($Y
as$X)echo
h($X[0])."\n\n\n";}else
echo
h($Y);echo"</textarea>";}function
select_input($_a,array$Jf,$Y="",$Df="",$pg=""){$ii=($Jf?"select":"input");return"<$ii$_a".($Jf?"><option value=''>$pg".optionlist($Jf,$Y,true)."</select>":" size='10' value='".h($Y)."' placeholder='$pg'>").($Df?script("qsl('$ii').onchange = $Df;",""):"");}function
json_row($y,$X=null){static$Wc=true;if($Wc)echo"{";if($y!=""){echo($Wc?"":",")."\n\t\"".addcslashes($y,"\r\n\t\"\\/").'": '.($X!==null?'"'.addcslashes($X,"\r\n\"\\/").'"':'null');$Wc=false;}else{echo"\n}\n";$Wc=true;}}function
edit_type($y,array$n,array$jb,array$gd=array(),array$Nc=array()){$U=$n["type"];echo"<td><select name='".h($y)."[type]' class='type' aria-labelledby='label-type'>";if($U&&!array_key_exists($U,driver()->types())&&!isset($gd[$U])&&!in_array($U,$Nc))$Nc[]=$U;$Sh=driver()->structuredTypes();if($gd)$Sh[lang(101)]=$gd;echo
optionlist(array_merge($Nc,$Sh),$U),"</select><td>","<input name='".h($y)."[length]' value='".h($n["length"])."' size='3'".(!$n["length"]&&preg_match('~var(char|binary)$~',$U)?" class='required'":"")." aria-labelledby='label-length'>","<td class='options'>",($jb?"<input list='collations' name='".h($y)."[collation]'".(preg_match('~(char|text|enum|set)$~',$U)?"":" class='hidden'")." value='".h($n["collation"])."' placeholder='(".lang(102).")'>":''),(driver()->unsigned?"<select name='".h($y)."[unsigned]'".(!$U||preg_match(number_type(),$U)?"":" class='hidden'").'><option>'.optionlist(driver()->unsigned,$n["unsigned"]).'</select>':''),(isset($n['on_update'])?"<select name='".h($y)."[on_update]'".(preg_match('~timestamp|datetime~',$U)?"":" class='hidden'").'>'.optionlist(array(""=>"(".lang(103).")","CURRENT_TIMESTAMP"),(preg_match('~^CURRENT_TIMESTAMP~i',$n["on_update"])?"CURRENT_TIMESTAMP":$n["on_update"])).'</select>':''),($gd?"<select name='".h($y)."[on_delete]'".(preg_match("~`~",$U)?"":" class='hidden'")."><option value=''>(".lang(104).")".optionlist(explode("|",driver()->onActions),$n["on_delete"])."</select> ":" ");}function
get_partitions_info($R){$kd="FROM information_schema.PARTITIONS WHERE TABLE_SCHEMA = ".q(DB)." AND TABLE_NAME = ".q($R);$I=connection()->query("SELECT PARTITION_METHOD, PARTITION_EXPRESSION, PARTITION_ORDINAL_POSITION $kd ORDER BY PARTITION_ORDINAL_POSITION DESC LIMIT 1");$J=array();list($J["partition_by"],$J["partition"],$J["partitions"])=$I->fetch_row();$jg=get_key_vals("SELECT PARTITION_NAME, PARTITION_DESCRIPTION $kd AND PARTITION_NAME != '' ORDER BY PARTITION_ORDINAL_POSITION");$J["partition_names"]=array_keys($jg);$J["partition_values"]=array_values($jg);return$J;}function
process_length($z){$xc=driver()->enumLength;return(preg_match("~^\\s*\\(?\\s*$xc(?:\\s*,\\s*$xc)*+\\s*\\)?\\s*\$~",$z)&&preg_match_all("~$xc~",$z,$Le)?"(".implode(",",$Le[0]).")":preg_replace('~^[0-9].*~','(\0)',preg_replace('~[^-0-9,+()[\]]~','',$z)));}function
process_type(array$n,$ib="COLLATE"){return" $n[type]".process_length($n["length"]).(preg_match(number_type(),$n["type"])&&in_array($n["unsigned"],driver()->unsigned)?" $n[unsigned]":"").(preg_match('~char|text|enum|set~',$n["type"])&&$n["collation"]?" $ib ".(JUSH=="mssql"?$n["collation"]:q($n["collation"])):"");}function
process_field(array$n,array$Li){if($n["on_update"])$n["on_update"]=str_ireplace("current_timestamp()","CURRENT_TIMESTAMP",$n["on_update"]);return
array(idf_escape(trim($n["field"])),process_type($Li),($n["null"]?" NULL":" NOT NULL"),default_value($n),(preg_match('~timestamp|datetime~',$n["type"])&&$n["on_update"]?" ON UPDATE $n[on_update]":""),(support("comment")&&$n["comment"]!=""?" COMMENT ".q($n["comment"]):""),($n["auto_increment"]?auto_increment():null),);}function
default_value(array$n){$l=$n["default"];$nd=$n["generated"];return($l===null?"":(in_array($nd,driver()->generated)?(JUSH=="mssql"?" AS ($l)".($nd=="VIRTUAL"?"":" $nd")."":" GENERATED ALWAYS AS ($l) $nd"):" DEFAULT ".(!preg_match('~^GENERATED ~i',$l)&&(preg_match('~char|binary|text|json|enum|set~',$n["type"])||preg_match('~^(?![a-z])~i',$l))?(JUSH=="sql"&&preg_match('~text|json~',$n["type"])?"(".q($l).")":q($l)):str_ireplace("current_timestamp()","CURRENT_TIMESTAMP",(JUSH=="sqlite"?"($l)":$l)))));}function
type_class($U){foreach(array('char'=>'text','date'=>'time|year','binary'=>'blob','enum'=>'set',)as$y=>$X){if(preg_match("~$y|$X~",$U))return" class='$y'";}}function
edit_fields(array$o,array$jb,$U="TABLE",array$gd=array()){$o=array_values($o);$Qb=(($_POST?$_POST["defaults"]:get_setting("defaults"))?"":" class='hidden'");$pb=(($_POST?$_POST["comments"]:get_setting("comments"))?"":" class='hidden'");echo"<thead><tr>\n",($U=="PROCEDURE"?"<td>":""),"<th id='label-name'>".($U=="TABLE"?lang(105):lang(106)),"<td id='label-type'>".lang(48)."<textarea id='enum-edit' rows='4' cols='12' wrap='off' style='display: none;'></textarea>".script("qs('#enum-edit').onblur = editingLengthBlur;"),"<td id='label-length'>".lang(107),"<td>".lang(108);if($U=="TABLE")echo"<td id='label-null'>NULL\n","<td><input type='radio' name='auto_increment_col' value=''><abbr id='label-ai' title='".lang(50)."'>AI</abbr>",doc_link(array('sql'=>"example-auto-increment.html",'mariadb'=>"auto_increment/",'sqlite'=>"autoinc.html",'pgsql'=>"datatype-numeric.html#DATATYPE-SERIAL",'mssql'=>"t-sql/statements/create-table-transact-sql-identity-property",)),"<td id='label-default'$Qb>".lang(51),(support("comment")?"<td id='label-comment'$pb>".lang(49):"");echo"<td>".icon("plus","add[".(support("move_col")?0:count($o))."]","+",lang(109)),"</thead>\n<tbody>\n",script("mixin(qsl('tbody'), {onclick: editingClick, onkeydown: editingKeydown, oninput: editingInput});");foreach($o
as$t=>$n){$t++;$Qf=$n[($_POST?"orig":"field")];$Zb=(isset($_POST["add"][$t-1])||(isset($n["field"])&&!idx($_POST["drop_col"],$t)))&&(support("drop_col")||$Qf=="");echo"<tr".($Zb?"":" style='display: none;'").">\n",($U=="PROCEDURE"?"<td>".html_select("fields[$t][inout]",explode("|",driver()->inout),$n["inout"]):"")."<th>";if($Zb)echo"<input name='fields[$t][field]' value='".h($n["field"])."' data-maxlength='64' autocapitalize='off' aria-labelledby='label-name'>";echo
input_hidden("fields[$t][orig]",$Qf);edit_type("fields[$t]",$n,$jb,$gd);if($U=="TABLE")echo"<td>".checkbox("fields[$t][null]",1,$n["null"],"","","block","label-null"),"<td><label class='block'><input type='radio' name='auto_increment_col' value='$t'".($n["auto_increment"]?" checked":"")." aria-labelledby='label-ai'></label>","<td$Qb>".(driver()->generated?html_select("fields[$t][generated]",array_merge(array("","DEFAULT"),driver()->generated),$n["generated"])." ":checkbox("fields[$t][generated]",1,$n["generated"],"","","","label-default")),"<input name='fields[$t][default]' value='".h($n["default"])."' aria-labelledby='label-default'>",(support("comment")?"<td$pb><input name='fields[$t][comment]' value='".h($n["comment"])."' data-maxlength='".(min_version(5.5)?1024:255)."' aria-labelledby='label-comment'>":"");echo"<td>",(support("move_col")?icon("plus","add[$t]","+",lang(109))." ".icon("up","up[$t]","↑",lang(110))." ".icon("down","down[$t]","↓",lang(111))." ":""),($Qf==""||support("drop_col")?icon("cross","drop_col[$t]","x",lang(112)):"");}}function
process_fields(array&$o){$D=0;if($_POST["up"]){$we=0;foreach($o
as$y=>$n){if(key($_POST["up"])==$y){unset($o[$y]);array_splice($o,$we,0,array($n));break;}if(isset($n["field"]))$we=$D;$D++;}}elseif($_POST["down"]){$id=false;foreach($o
as$y=>$n){if(isset($n["field"])&&$id){unset($o[key($_POST["down"])]);array_splice($o,$D,0,array($id));break;}if(key($_POST["down"])==$y)$id=$n;$D++;}}elseif($_POST["add"]){$o=array_values($o);array_splice($o,key($_POST["add"]),0,array(array()));}elseif(!$_POST["drop_col"])return
false;return
true;}function
normalize_enum(array$B){$X=$B[0];return"'".str_replace("'","''",addcslashes(stripcslashes(str_replace($X[0].$X[0],$X[0],substr($X,1,-1))),'\\'))."'";}function
grant($pd,array$Cg,$e,$Af){if(!$Cg)return
true;if($Cg==array("ALL PRIVILEGES","GRANT OPTION"))return($pd=="GRANT"?queries("$pd ALL PRIVILEGES$Af WITH GRANT OPTION"):queries("$pd ALL PRIVILEGES$Af")&&queries("$pd GRANT OPTION$Af"));return
queries("$pd ".preg_replace('~(GRANT OPTION)\([^)]*\)~','\1',implode("$e, ",$Cg).$e).$Af);}function
drop_create($dc,$i,$fc,$mi,$hc,$Ee,$Ye,$We,$Xe,$yf,$lf){if($_POST["drop"])query_redirect($dc,$Ee,$Ye);elseif($yf=="")query_redirect($i,$Ee,$Xe);elseif($yf!=$lf){$Cb=queries($i);queries_redirect($Ee,$We,$Cb&&queries($dc));if($Cb)queries($fc);}else
queries_redirect($Ee,$We,queries($mi)&&queries($hc)&&queries($dc)&&queries($i));}function
create_trigger($Af,array$K){$si=" $K[Timing] $K[Event]".(preg_match('~ OF~',$K["Event"])?" $K[Of]":"");return"CREATE TRIGGER ".idf_escape($K["Trigger"]).(JUSH=="mssql"?$Af.$si:$si.$Af).rtrim(" $K[Type]\n$K[Statement]",";").";";}function
create_routine($dh,array$K){$O=array();$o=(array)$K["fields"];ksort($o);foreach($o
as$n){if($n["field"]!="")$O[]=(preg_match("~^(driver()->inout)\$~",$n["inout"])?"$n[inout] ":"").idf_escape($n["field"]).process_type($n,"CHARACTER SET");}$Rb=rtrim($K["definition"],";");return"CREATE $dh ".idf_escape(trim($K["name"]))." (".implode(", ",$O).")".($dh=="FUNCTION"?" RETURNS".process_type($K["returns"],"CHARACTER SET"):"").($K["language"]?" LANGUAGE $K[language]":"").(JUSH=="pgsql"?" AS ".q($Rb):"\n$Rb;");}function
remove_definer($H){return
preg_replace('~^([A-Z =]+) DEFINER=`'.preg_replace('~@(.*)~','`@`(%|\1)',logged_user()).'`~','\1',$H);}function
format_foreign_key(array$q){$k=$q["db"];$qf=$q["ns"];return" FOREIGN KEY (".implode(", ",array_map('Adminer\idf_escape',$q["source"])).") REFERENCES ".($k!=""&&$k!=$_GET["db"]?idf_escape($k).".":"").($qf!=""&&$qf!=$_GET["ns"]?idf_escape($qf).".":"").idf_escape($q["table"])." (".implode(", ",array_map('Adminer\idf_escape',$q["target"])).")".(preg_match("~^(driver()->onActions)\$~",$q["on_delete"])?" ON DELETE $q[on_delete]":"").(preg_match("~^(driver()->onActions)\$~",$q["on_update"])?" ON UPDATE $q[on_update]":"");}function
tar_file($p,$xi){$J=pack("a100a8a8a8a12a12",$p,644,0,0,decoct($xi->size),decoct(time()));$cb=8*32;for($t=0;$t<strlen($J);$t++)$cb+=ord($J[$t]);$J
.=sprintf("%06o",$cb)."\0 ";echo$J,str_repeat("\0",512-strlen($J));$xi->send();echo
str_repeat("\0",511-($xi->size+511)%512);}function
ini_bytes($Yd){$X=ini_get($Yd);switch(strtolower(substr($X,-1))){case'g':$X=(int)$X*1024;case'm':$X=(int)$X*1024;case'k':$X=(int)$X*1024;}return$X;}function
doc_link(array$lg,$ni="<sup>?</sup>"){$xh=connection()->server_info;$kj=preg_replace('~^(\d\.?\d).*~s','\1',$xh);$Zi=array('sql'=>"https://dev.mysql.com/doc/refman/$kj/en/",'sqlite'=>"https://www.sqlite.org/",'pgsql'=>"https://www.postgresql.org/docs/".(connection()->flavor=='cockroach'?"current":$kj)."/",'mssql'=>"https://learn.microsoft.com/en-us/sql/",'oracle'=>"https://www.oracle.com/pls/topic/lookup?ctx=db".preg_replace('~^.* (\d+)\.(\d+)\.\d+\.\d+\.\d+.*~s','\1\2',$xh)."&id=",);if(connection()->flavor=='maria'){$Zi['sql']="https://mariadb.com/kb/en/";$lg['sql']=(isset($lg['mariadb'])?$lg['mariadb']:str_replace(".html","/",$lg['sql']));}return($lg[JUSH]?"<a href='".h($Zi[JUSH].$lg[JUSH].(JUSH=='mssql'?"?view=sql-server-ver$kj":""))."'".target_blank().">$ni</a>":"");}function
db_size($k){if(!connection()->select_db($k))return"?";$J=0;foreach(table_status()as$S)$J+=$S["Data_length"]+$S["Index_length"];return
format_number($J);}function
set_utf8mb4($i){static$O=false;if(!$O&&preg_match('~\butf8mb4~i',$i)){$O=true;echo"SET NAMES ".charset(connection()).";\n\n";}}if(isset($_GET["status"]))$_GET["variables"]=$_GET["status"];if(isset($_GET["import"]))$_GET["sql"]=$_GET["import"];if(!(DB!=""?connection()->select_db(DB):isset($_GET["sql"])||isset($_GET["dump"])||isset($_GET["database"])||isset($_GET["processlist"])||isset($_GET["privileges"])||isset($_GET["user"])||isset($_GET["variables"])||$_GET["script"]=="connect"||$_GET["script"]=="kill")){if(DB!=""||$_GET["refresh"]){restart_session();set_session("dbs",null);}if(DB!=""){header("HTTP/1.1 404 Not Found");page_header(lang(36).": ".h(DB),lang(113),true);}else{if($_POST["db"]&&!$m)queries_redirect(substr(ME,0,-1),lang(114),drop_databases($_POST["db"]));page_header(lang(115),$m,false);echo"<p class='links'>\n";foreach(array('database'=>lang(116),'privileges'=>lang(70),'processlist'=>lang(117),'variables'=>lang(118),'status'=>lang(119),)as$y=>$X){if(support($y))echo"<a href='".h(ME)."$y='>$X</a>\n";}echo"<p>".lang(120,get_driver(DRIVER),"<b>".h(connection()->server_info)."</b>","<b>".connection()->extension."</b>")."\n","<p>".lang(121,"<b>".h(logged_user())."</b>")."\n";if(isset(adminer()->plugins)&&is_array(adminer()->plugins)){echo"<p>".lang(122).":\n<ul>\n";foreach(adminer()->plugins
as$qg){$Rg=new
\ReflectionObject($qg);echo"<li><b>".get_class($qg)."</b>".h(preg_match('~^/[\s*]+(.+)~',$Rg->getDocComment(),$B)?": $B[1]":"")."\n";}echo"</ul>\n";}$j=adminer()->databases();if($j){$lh=support("scheme");$jb=collations();echo"<form action='' method='post'>\n","<table class='checkable odds'>\n",script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});"),"<thead><tr>".(support("database")?"<td>":"")."<th>".lang(36).(get_session("dbs")!==null?" - <a href='".h(ME)."refresh=1'>".lang(123)."</a>":"")."<td>".lang(124)."<td>".lang(125)."<td>".lang(126)." - <a href='".h(ME)."dbsize=1'>".lang(127)."</a>".script("qsl('a').onclick = partial(ajaxSetHtml, '".js_escape(ME)."script=connect');","")."</thead>\n";$j=($_GET["dbsize"]?count_tables($j):array_flip($j));foreach($j
as$k=>$T){$ch=h(ME)."db=".urlencode($k);$u=h("Db-".$k);echo"<tr>".(support("database")?"<td>".checkbox("db[]",$k,in_array($k,(array)$_POST["db"]),"","","",$u):""),"<th><a href='$ch' id='$u'>".h($k)."</a>";$c=h(db_collation($k,$jb));echo"<td>".(support("database")?"<a href='$ch".($lh?"&amp;ns=":"")."&amp;database=' title='".lang(66)."'>$c</a>":$c),"<td align='right'><a href='$ch&amp;schema=' id='tables-".h($k)."' title='".lang(69)."'>".($_GET["dbsize"]?$T:"?")."</a>","<td align='right' id='size-".h($k)."'>".($_GET["dbsize"]?db_size($k):"?"),"\n";}echo"</table>\n",(support("database")?"<div class='footer'><div>\n"."<fieldset><legend>".lang(128)." <span id='selected'></span></legend><div>\n".input_hidden("all").script("qsl('input').onclick = function () { selectCount('selected', formChecked(this, /^db/)); };")."<input type='submit' name='drop' value='".lang(129)."'>".confirm()."\n"."</div></fieldset>\n"."</div></div>\n":""),input_token(),"</form>\n",script("tableCheck();");}}page_footer("db");exit;}if(support("scheme")){if(DB!=""&&$_GET["ns"]!==""){if(!isset($_GET["ns"]))redirect(preg_replace('~ns=[^&]*&~','',ME)."ns=".get_schema());if(!set_schema($_GET["ns"])){header("HTTP/1.1 404 Not Found");page_header(lang(75).": ".h($_GET["ns"]),lang(130),true);page_footer("ns");exit;}}}class
TmpFile{private$handler;var$size;function
__construct(){$this->handler=tmpfile();}function
write($yb){$this->size+=strlen($yb);fwrite($this->handler,$yb);}function
send(){fseek($this->handler,0);fpassthru($this->handler);fclose($this->handler);}}if(isset($_GET["select"])&&($_POST["edit"]||$_POST["clone"])&&!$_POST["save"])$_GET["edit"]=$_GET["select"];if(isset($_GET["callf"]))$_GET["call"]=$_GET["callf"];if(isset($_GET["function"]))$_GET["procedure"]=$_GET["function"];if(isset($_GET["download"])){$a=$_GET["download"];$o=fields($a);header("Content-Type: application/octet-stream");header("Content-Disposition: attachment; filename=".friendly_url("$a-".implode("_",$_GET["where"])).".".friendly_url($_GET["field"]));$M=array(idf_escape($_GET["field"]));$I=driver()->select($a,$M,array(where($_GET,$o)),$M);$K=($I?$I->fetch_row():array());echo
driver()->value($K[0],$o[$_GET["field"]]);exit;}elseif(isset($_GET["table"])){$a=$_GET["table"];$o=fields($a);if(!$o)$m=error()?:lang(9);$S=table_status1($a);$C=adminer()->tableName($S);page_header(($o&&is_view($S)?$S['Engine']=='materialized view'?lang(131):lang(132):lang(133)).": ".($C!=""?$C:h($a)),$m);$bh=array();foreach($o
as$y=>$n)$bh+=$n["privileges"];adminer()->selectLinks($S,(isset($bh["insert"])||!support("table")?"":null));$ob=$S["Comment"];if($ob!="")echo"<p class='nowrap'>".lang(49).": ".h($ob)."\n";if($o)adminer()->tableStructurePrint($o,$S);if(support("indexes")&&driver()->supportsIndex($S)){echo"<h3 id='indexes'>".lang(134)."</h3>\n";$x=indexes($a);if($x)adminer()->tableIndexesPrint($x);echo'<p class="links"><a href="'.h(ME).'indexes='.urlencode($a).'">'.lang(135)."</a>\n";}if(!is_view($S)){if(fk_support($S)){echo"<h3 id='foreign-keys'>".lang(101)."</h3>\n";$gd=foreign_keys($a);if($gd){echo"<table>\n","<thead><tr><th>".lang(136)."<td>".lang(137)."<td>".lang(104)."<td>".lang(103)."<td></thead>\n";foreach($gd
as$C=>$q){echo"<tr title='".h($C)."'>","<th><i>".implode("</i>, <i>",array_map('Adminer\h',$q["source"]))."</i>";$A=($q["db"]!=""?preg_replace('~db=[^&]*~',"db=".urlencode($q["db"]),ME):($q["ns"]!=""?preg_replace('~ns=[^&]*~',"ns=".urlencode($q["ns"]),ME):ME));echo"<td><a href='".h($A."table=".urlencode($q["table"]))."'>".($q["db"]!=""&&$q["db"]!=DB?"<b>".h($q["db"])."</b>.":"").($q["ns"]!=""&&$q["ns"]!=$_GET["ns"]?"<b>".h($q["ns"])."</b>.":"").h($q["table"])."</a>","(<i>".implode("</i>, <i>",array_map('Adminer\h',$q["target"]))."</i>)","<td>".h($q["on_delete"]),"<td>".h($q["on_update"]),'<td><a href="'.h(ME.'foreign='.urlencode($a).'&name='.urlencode($C)).'">'.lang(138).'</a>',"\n";}echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'foreign='.urlencode($a).'">'.lang(139)."</a>\n";}if(support("check")){echo"<h3 id='checks'>".lang(140)."</h3>\n";$Ya=driver()->checkConstraints($a);if($Ya){echo"<table>\n";foreach($Ya
as$y=>$X)echo"<tr title='".h($y)."'>","<td><code class='jush-".JUSH."'>".h($X),"<td><a href='".h(ME.'check='.urlencode($a).'&name='.urlencode($y))."'>".lang(138)."</a>","\n";echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'check='.urlencode($a).'">'.lang(141)."</a>\n";}}if(support(is_view($S)?"view_trigger":"trigger")){echo"<h3 id='triggers'>".lang(142)."</h3>\n";$Ki=triggers($a);if($Ki){echo"<table>\n";foreach($Ki
as$y=>$X)echo"<tr valign='top'><td>".h($X[0])."<td>".h($X[1])."<th>".h($y)."<td><a href='".h(ME.'trigger='.urlencode($a).'&name='.urlencode($y))."'>".lang(138)."</a>\n";echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'trigger='.urlencode($a).'">'.lang(143)."</a>\n";}}elseif(isset($_GET["schema"])){page_header(lang(69),"",array(),h(DB.($_GET["ns"]?".$_GET[ns]":"")));$di=array();$ei=array();$da=($_GET["schema"]?:$_COOKIE["adminer_schema-".str_replace(".","_",DB)]);preg_match_all('~([^:]+):([-0-9.]+)x([-0-9.]+)(_|$)~',$da,$Le,PREG_SET_ORDER);foreach($Le
as$t=>$B){$di[$B[1]]=array($B[2],$B[3]);$ei[]="\n\t'".js_escape($B[1])."': [ $B[2], $B[3] ]";}$_i=0;$Ia=-1;$jh=array();$Qg=array();$_e=array();$ua=driver()->allFields();foreach(table_status('',true)as$R=>$S){if(is_view($S))continue;$tg=0;$jh[$R]["fields"]=array();foreach($ua[$R]as$n){$tg+=1.25;$n["pos"]=$tg;$jh[$R]["fields"][$n["field"]]=$n;}$jh[$R]["pos"]=($di[$R]?:array($_i,0));foreach(adminer()->foreignKeys($R)as$X){if(!$X["db"]){$ye=$Ia;if(idx($di[$R],1)||idx($di[$X["table"]],1))$ye=min(idx($di[$R],1,0),idx($di[$X["table"]],1,0))-1;else$Ia-=.1;while($_e[(string)$ye])$ye-=.0001;$jh[$R]["references"][$X["table"]][(string)$ye]=array($X["source"],$X["target"]);$Qg[$X["table"]][$R][(string)$ye]=$X["target"];$_e[(string)$ye]=true;}}$_i=max($_i,$jh[$R]["pos"][0]+2.5+$tg);}echo'<div id="schema" style="height: ',$_i,'em;">
<script',nonce(),'>
qs(\'#schema\').onselectstart = () => false;
const tablePos = {',implode(",",$ei)."\n",'};
const em = qs(\'#schema\').offsetHeight / ',$_i,';
document.onmousemove = schemaMousemove;
document.onmouseup = partialArg(schemaMouseup, \'',js_escape(DB),'\');
</script>
';foreach($jh
as$C=>$R){echo"<div class='table' style='top: ".$R["pos"][0]."em; left: ".$R["pos"][1]."em;'>",'<a href="'.h(ME).'table='.urlencode($C).'"><b>'.h($C)."</b></a>",script("qsl('div').onmousedown = schemaMousedown;");foreach($R["fields"]as$n){$X='<span'.type_class($n["type"]).' title="'.h($n["type"].($n["length"]?"($n[length])":"").($n["null"]?" NULL":'')).'">'.h($n["field"]).'</span>';echo"<br>".($n["primary"]?"<i>$X</i>":$X);}foreach((array)$R["references"]as$ki=>$Sg){foreach($Sg
as$ye=>$Ng){$ze=$ye-idx($di[$C],1);$t=0;foreach($Ng[0]as$Gh)echo"\n<div class='references' title='".h($ki)."' id='refs$ye-".($t++)."' style='left: $ze"."em; top: ".$R["fields"][$Gh]["pos"]."em; padding-top: .5em;'>"."<div style='border-top: 1px solid gray; width: ".(-$ze)."em;'></div></div>";}}foreach((array)$Qg[$C]as$ki=>$Sg){foreach($Sg
as$ye=>$e){$ze=$ye-idx($di[$C],1);$t=0;foreach($e
as$ji)echo"\n<div class='references arrow' title='".h($ki)."' id='refd$ye-".($t++)."' style='left: $ze"."em; top: ".$R["fields"][$ji]["pos"]."em;'>"."<div style='height: .5em; border-bottom: 1px solid gray; width: ".(-$ze)."em;'></div>"."</div>";}}echo"\n</div>\n";}foreach($jh
as$C=>$R){foreach((array)$R["references"]as$ki=>$Sg){foreach($Sg
as$ye=>$Ng){$bf=$_i;$Pe=-10;foreach($Ng[0]as$y=>$Gh){$ug=$R["pos"][0]+$R["fields"][$Gh]["pos"];$vg=$jh[$ki]["pos"][0]+$jh[$ki]["fields"][$Ng[1][$y]]["pos"];$bf=min($bf,$ug,$vg);$Pe=max($Pe,$ug,$vg);}echo"<div class='references' id='refl$ye' style='left: $ye"."em; top: $bf"."em; padding: .5em 0;'><div style='border-right: 1px solid gray; margin-top: 1px; height: ".($Pe-$bf)."em;'></div></div>\n";}}}echo'</div>
<p class="links"><a href="',h(ME."schema=".urlencode($da)),'" id="schema-link">',lang(144),'</a>
';}elseif(isset($_GET["dump"])){$a=$_GET["dump"];if($_POST&&!$m){save_settings(array_intersect_key($_POST,array_flip(array("output","format","db_style","types","routines","events","table_style","auto_increment","triggers","data_style"))),"adminer_export");$T=array_flip((array)$_POST["tables"])+array_flip((array)$_POST["data"]);$Jc=dump_headers((count($T)==1?key($T):DB),(DB==""||count($T)>1));$je=preg_match('~sql~',$_POST["format"]);if($je){echo"-- Adminer ".VERSION." ".get_driver(DRIVER)." ".str_replace("\n"," ",connection()->server_info)." dump\n\n";if(JUSH=="sql"){echo"SET NAMES utf8;
SET time_zone = '+00:00';
SET foreign_key_checks = 0;
".($_POST["data_style"]?"SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO';
":"")."
";connection()->query("SET time_zone = '+00:00'");connection()->query("SET sql_mode = ''");}}$Th=$_POST["db_style"];$j=array(DB);if(DB==""){$j=$_POST["databases"];if(is_string($j))$j=explode("\n",rtrim(str_replace("\r","",$j),"\n"));}foreach((array)$j
as$k){adminer()->dumpDatabase($k);if(connection()->select_db($k)){if($je&&preg_match('~CREATE~',$Th)&&($i=get_val("SHOW CREATE DATABASE ".idf_escape($k),1))){set_utf8mb4($i);if($Th=="DROP+CREATE")echo"DROP DATABASE IF EXISTS ".idf_escape($k).";\n";echo"$i;\n";}if($je){if($Th)echo
use_sql($k).";\n\n";$Xf="";if($_POST["types"]){foreach(types()as$u=>$U){$yc=type_values($u);if($yc)$Xf
.=($Th!='DROP+CREATE'?"DROP TYPE IF EXISTS ".idf_escape($U).";;\n":"")."CREATE TYPE ".idf_escape($U)." AS ENUM ($yc);\n\n";else$Xf
.="-- Could not export type $U\n\n";}}if($_POST["routines"]){foreach(routines()as$K){$C=$K["ROUTINE_NAME"];$dh=$K["ROUTINE_TYPE"];$i=create_routine($dh,array("name"=>$C)+routine($K["SPECIFIC_NAME"],$dh));set_utf8mb4($i);$Xf
.=($Th!='DROP+CREATE'?"DROP $dh IF EXISTS ".idf_escape($C).";;\n":"")."$i;\n\n";}}if($_POST["events"]){foreach(get_rows("SHOW EVENTS",null,"-- ")as$K){$i=remove_definer(get_val("SHOW CREATE EVENT ".idf_escape($K["Name"]),3));set_utf8mb4($i);$Xf
.=($Th!='DROP+CREATE'?"DROP EVENT IF EXISTS ".idf_escape($K["Name"]).";;\n":"")."$i;;\n\n";}}echo($Xf&&JUSH=='sql'?"DELIMITER ;;\n\n$Xf"."DELIMITER ;\n\n":$Xf);}if($_POST["table_style"]||$_POST["data_style"]){$mj=array();foreach(table_status('',true)as$C=>$S){$R=(DB==""||in_array($C,(array)$_POST["tables"]));$Jb=(DB==""||in_array($C,(array)$_POST["data"]));if($R||$Jb){$xi=null;if($Jc=="tar"){$xi=new
TmpFile;ob_start(array($xi,'write'),1e5);}adminer()->dumpTable($C,($R?$_POST["table_style"]:""),(is_view($S)?2:0));if(is_view($S))$mj[]=$C;elseif($Jb){$o=fields($C);adminer()->dumpData($C,$_POST["data_style"],"SELECT *".convert_fields($o,$o)." FROM ".table($C));}if($je&&$_POST["triggers"]&&$R&&($Ki=trigger_sql($C)))echo"\nDELIMITER ;;\n$Ki\nDELIMITER ;\n";if($Jc=="tar"){ob_end_flush();tar_file((DB!=""?"":"$k/")."$C.csv",$xi);}elseif($je)echo"\n";}}if(function_exists('Adminer\foreign_keys_sql')){foreach(table_status('',true)as$C=>$S){$R=(DB==""||in_array($C,(array)$_POST["tables"]));if($R&&!is_view($S))echo
foreign_keys_sql($C);}}foreach($mj
as$lj)adminer()->dumpTable($lj,$_POST["table_style"],1);if($Jc=="tar")echo
pack("x512");}}}adminer()->dumpFooter();exit;}page_header(lang(72),$m,($_GET["export"]!=""?array("table"=>$_GET["export"]):array()),h(DB));echo'
<form action="" method="post">
<table class="layout">
';$Nb=array('','USE','DROP+CREATE','CREATE');$fi=array('','DROP+CREATE','CREATE');$Kb=array('','TRUNCATE+INSERT','INSERT');if(JUSH=="sql")$Kb[]='INSERT+UPDATE';$K=get_settings("adminer_export");if(!$K)$K=array("output"=>"text","format"=>"sql","db_style"=>(DB!=""?"":"CREATE"),"table_style"=>"DROP+CREATE","data_style"=>"INSERT");if(!isset($K["events"])){$K["routines"]=$K["events"]=($_GET["dump"]=="");$K["triggers"]=$K["table_style"];}echo"<tr><th>".lang(145)."<td>".html_radios("output",adminer()->dumpOutput(),$K["output"])."\n","<tr><th>".lang(146)."<td>".html_radios("format",adminer()->dumpFormat(),$K["format"])."\n",(JUSH=="sqlite"?"":"<tr><th>".lang(36)."<td>".html_select('db_style',$Nb,$K["db_style"]).(support("type")?checkbox("types",1,$K["types"],lang(31)):"").(support("routine")?checkbox("routines",1,$K["routines"],lang(147)):"").(support("event")?checkbox("events",1,$K["events"],lang(148)):"")),"<tr><th>".lang(125)."<td>".html_select('table_style',$fi,$K["table_style"]).checkbox("auto_increment",1,$K["auto_increment"],lang(50)).(support("trigger")?checkbox("triggers",1,$K["triggers"],lang(142)):""),"<tr><th>".lang(149)."<td>".html_select('data_style',$Kb,$K["data_style"]),'</table>
<p><input type="submit" value="',lang(72),'">
',input_token(),'
<table>
',script("qsl('table').onclick = dumpClick;");$yg=array();if(DB!=""){$ab=($a!=""?"":" checked");echo"<thead><tr>","<th style='text-align: left;'><label class='block'><input type='checkbox' id='check-tables'$ab>".lang(125)."</label>".script("qs('#check-tables').onclick = partial(formCheck, /^tables\\[/);",""),"<th style='text-align: right;'><label class='block'>".lang(149)."<input type='checkbox' id='check-data'$ab></label>".script("qs('#check-data').onclick = partial(formCheck, /^data\\[/);",""),"</thead>\n";$mj="";$gi=tables_list();foreach($gi
as$C=>$U){$xg=preg_replace('~_.*~','',$C);$ab=($a==""||$a==(substr($a,-1)=="%"?"$xg%":$C));$_g="<tr><td>".checkbox("tables[]",$C,$ab,$C,"","block");if($U!==null&&!preg_match('~table~i',$U))$mj
.="$_g\n";else
echo"$_g<td align='right'><label class='block'><span id='Rows-".h($C)."'></span>".checkbox("data[]",$C,$ab)."</label>\n";$yg[$xg]++;}echo$mj;if($gi)echo
script("ajaxSetHtml('".js_escape(ME)."script=db');");}else{echo"<thead><tr><th style='text-align: left;'>","<label class='block'><input type='checkbox' id='check-databases'".($a==""?" checked":"").">".lang(36)."</label>",script("qs('#check-databases').onclick = partial(formCheck, /^databases\\[/);",""),"</thead>\n";$j=adminer()->databases();if($j){foreach($j
as$k){if(!information_schema($k)){$xg=preg_replace('~_.*~','',$k);echo"<tr><td>".checkbox("databases[]",$k,$a==""||$a=="$xg%",$k,"","block")."\n";$yg[$xg]++;}}}else
echo"<tr><td><textarea name='databases' rows='10' cols='20'></textarea>";}echo'</table>
</form>
';$Wc=true;foreach($yg
as$y=>$X){if($y!=""&&$X>1){echo($Wc?"<p>":" ")."<a href='".h(ME)."dump=".urlencode("$y%")."'>".h($y)."</a>";$Wc=false;}}}elseif(isset($_GET["privileges"])){page_header(lang(70));echo'<p class="links"><a href="'.h(ME).'user=">'.lang(150)."</a>";$I=connection()->query("SELECT User, Host FROM mysql.".(DB==""?"user":"db WHERE ".q(DB)." LIKE Db")." ORDER BY Host, User");$pd=$I;if(!$I)$I=connection()->query("SELECT SUBSTRING_INDEX(CURRENT_USER, '@', 1) AS User, SUBSTRING_INDEX(CURRENT_USER, '@', -1) AS Host");echo"<form action=''><p>\n";hidden_fields_get();echo
input_hidden("db",DB),($pd?"":input_hidden("grant")),"<table class='odds'>\n","<thead><tr><th>".lang(34)."<th>".lang(33)."<th></thead>\n";while($K=$I->fetch_assoc())echo'<tr><td>'.h($K["User"])."<td>".h($K["Host"]).'<td><a href="'.h(ME.'user='.urlencode($K["User"]).'&host='.urlencode($K["Host"])).'">'.lang(10)."</a>\n";if(!$pd||DB!="")echo"<tr><td><input name='user' autocapitalize='off'><td><input name='host' value='localhost' autocapitalize='off'><td><input type='submit' value='".lang(10)."'>\n";echo"</table>\n","</form>\n";}elseif(isset($_GET["sql"])){if(!$m&&$_POST["export"]){save_settings(array("output"=>$_POST["output"],"format"=>$_POST["format"]),"adminer_import");dump_headers("sql");adminer()->dumpTable("","");adminer()->dumpData("","table",$_POST["query"]);adminer()->dumpFooter();exit;}restart_session();$Fd=&get_session("queries");$Ed=&$Fd[DB];if(!$m&&$_POST["clear"]){$Ed=array();redirect(remove_from_uri("history"));}stop_session();page_header((isset($_GET["import"])?lang(71):lang(63)),$m);if(!$m&&$_POST){$r=false;if(!isset($_GET["import"]))$H=$_POST["query"];elseif($_POST["webfile"]){$Kh=adminer()->importServerPath();$r=@fopen((file_exists($Kh)?$Kh:"compress.zlib://$Kh.gz"),"rb");$H=($r?fread($r,1e6):false);}else$H=get_file("sql_file",true,";");if(is_string($H)){if(function_exists('memory_get_usage')&&($Ue=ini_bytes("memory_limit"))!="-1")@ini_set("memory_limit",max($Ue,strval(2*strlen($H)+memory_get_usage()+8e6)));if($H!=""&&strlen($H)<1e6){$Gg=$H.(preg_match("~;[ \t\r\n]*\$~",$H)?"":";");if(!$Ed||first(end($Ed))!=$Gg){restart_session();$Ed[]=array($Gg,time());set_session("queries",$Fd);stop_session();}}$Hh="(?:\\s|/\\*[\s\S]*?\\*/|(?:#|-- )[^\n]*\n?|--\r?\n)";$Tb=";";$D=0;$sc=true;$h=connect(adminer()->credentials());if($h&&DB!=""){$h->select_db(DB);if($_GET["ns"]!="")set_schema($_GET["ns"],$h);}$nb=0;$_c=array();$eg='[\'"'.(JUSH=="sql"?'`#':(JUSH=="sqlite"?'`[':(JUSH=="mssql"?'[':''))).']|/\*|-- |$'.(JUSH=="pgsql"?'|\$[^$]*\$':'');$Ai=microtime(true);$oa=get_settings("adminer_import");$jc=adminer()->dumpFormat();unset($jc["sql"]);while($H!=""){if(!$D&&preg_match("~^$Hh*+DELIMITER\\s+(\\S+)~i",$H,$B)){$Tb=$B[1];$H=substr($H,strlen($B[0]));}else{preg_match('('.preg_quote($Tb)."\\s*|$eg)",$H,$B,PREG_OFFSET_CAPTURE,$D);list($id,$tg)=$B[0];if(!$id&&$r&&!feof($r))$H
.=fread($r,1e5);else{if(!$id&&rtrim($H)=="")break;$D=$tg+strlen($id);if($id&&rtrim($id)!=$Tb){$Sa=driver()->hasCStyleEscapes()||(JUSH=="pgsql"&&($tg>0&&strtolower($H[$tg-1])=="e"));$mg=($id=='/*'?'\*/':($id=='['?']':(preg_match('~^-- |^#~',$id)?"\n":preg_quote($id).($Sa?"|\\\\.":""))));while(preg_match("($mg|\$)s",$H,$B,PREG_OFFSET_CAPTURE,$D)){$hh=$B[0][0];if(!$hh&&$r&&!feof($r))$H
.=fread($r,1e5);else{$D=$B[0][1]+strlen($hh);if(!$hh||$hh[0]!="\\")break;}}}else{$sc=false;$Gg=substr($H,0,$tg);$nb++;$_g="<pre id='sql-$nb'><code class='jush-".JUSH."'>".adminer()->sqlCommandQuery($Gg)."</code></pre>\n";if(JUSH=="sqlite"&&preg_match("~^$Hh*+ATTACH\\b~i",$Gg,$B)){echo$_g,"<p class='error'>".lang(151)."\n";$_c[]=" <a href='#sql-$nb'>$nb</a>";if($_POST["error_stops"])break;}else{if(!$_POST["only_errors"]){echo$_g;ob_flush();flush();}$Ph=microtime(true);if(connection()->multi_query($Gg)&&$h&&preg_match("~^$Hh*+USE\\b~i",$Gg))$h->query($Gg);do{$I=connection()->store_result();if(connection()->error){echo($_POST["only_errors"]?$_g:""),"<p class='error'>".lang(152).(connection()->errno?" (".connection()->errno.")":"").": ".error()."\n";$_c[]=" <a href='#sql-$nb'>$nb</a>";if($_POST["error_stops"])break
2;}else{$qi=" <span class='time'>(".format_time($Ph).")</span>".(strlen($Gg)<1000?" <a href='".h(ME)."sql=".urlencode(trim($Gg))."'>".lang(10)."</a>":"");$qa=connection()->affected_rows;$pj=($_POST["only_errors"]?"":driver()->warnings());$qj="warnings-$nb";if($pj)$qi
.=", <a href='#$qj'>".lang(45)."</a>".script("qsl('a').onclick = partial(toggle, '$qj');","");$Hc=null;$Pf=null;$Ic="explain-$nb";if(is_object($I)){$_=$_POST["limit"];$Pf=print_select_result($I,$h,array(),$_);if(!$_POST["only_errors"]){echo"<form action='' method='post'>\n";$rf=$I->num_rows;echo"<p class='sql-footer'>".($rf?($_&&$rf>$_?lang(153,$_):"").lang(154,$rf):""),$qi;if($h&&preg_match("~^($Hh|\\()*+SELECT\\b~i",$Gg)&&($Hc=explain($h,$Gg)))echo", <a href='#$Ic'>Explain</a>".script("qsl('a').onclick = partial(toggle, '$Ic');","");$u="export-$nb";echo", <a href='#$u'>".lang(72)."</a>".script("qsl('a').onclick = partial(toggle, '$u');","")."<span id='$u' class='hidden'>: ".html_select("output",adminer()->dumpOutput(),$oa["output"])." ".html_select("format",$jc,$oa["format"]).input_hidden("query",$Gg)."<input type='submit' name='export' value='".lang(72)."'>".input_token()."</span>\n"."</form>\n";}}else{if(preg_match("~^$Hh*+(CREATE|DROP|ALTER)$Hh++(DATABASE|SCHEMA)\\b~i",$Gg)){restart_session();set_session("dbs",null);stop_session();}if(!$_POST["only_errors"])echo"<p class='message' title='".h(connection()->info)."'>".lang(155,$qa)."$qi\n";}echo($pj?"<div id='$qj' class='hidden'>\n$pj</div>\n":"");if($Hc){echo"<div id='$Ic' class='hidden explain'>\n";print_select_result($Hc,$h,$Pf);echo"</div>\n";}}$Ph=microtime(true);}while(connection()->next_result());}$H=substr($H,$D);$D=0;}}}}if($sc)echo"<p class='message'>".lang(156)."\n";elseif($_POST["only_errors"])echo"<p class='message'>".lang(157,$nb-count($_c))," <span class='time'>(".format_time($Ai).")</span>\n";elseif($_c&&$nb>1)echo"<p class='error'>".lang(152).": ".implode("",$_c)."\n";}else
echo"<p class='error'>".upload_error($H)."\n";}echo'
<form action="" method="post" enctype="multipart/form-data" id="form">
';$Fc="<input type='submit' value='".lang(158)."' title='Ctrl+Enter'>";if(!isset($_GET["import"])){$Gg=$_GET["sql"];if($_POST)$Gg=$_POST["query"];elseif($_GET["history"]=="all")$Gg=$Ed;elseif($_GET["history"]!="")$Gg=idx($Ed[$_GET["history"]],0);echo"<p>";textarea("query",$Gg,20);echo
script(($_POST?"":"qs('textarea').focus();\n")."qs('#form').onsubmit = partial(sqlSubmit, qs('#form'), '".js_escape(remove_from_uri("sql|limit|error_stops|only_errors|history"))."');"),"<p>";adminer()->sqlPrintAfter();echo"$Fc\n",lang(159).": <input type='number' name='limit' class='size' value='".h($_POST?$_POST["limit"]:$_GET["limit"])."'>\n";}else{echo"<fieldset><legend>".lang(160)."</legend><div>";$vd=(extension_loaded("zlib")?"[.gz]":"");echo(ini_bool("file_uploads")?"SQL$vd (&lt; ".ini_get("upload_max_filesize")."B): <input type='file' name='sql_file[]' multiple>\n$Fc":lang(161)),"</div></fieldset>\n";$Pd=adminer()->importServerPath();if($Pd)echo"<fieldset><legend>".lang(162)."</legend><div>",lang(163,"<code>".h($Pd)."$vd</code>"),' <input type="submit" name="webfile" value="'.lang(164).'">',"</div></fieldset>\n";echo"<p>";}echo
checkbox("error_stops",1,($_POST?$_POST["error_stops"]:isset($_GET["import"])||$_GET["error_stops"]),lang(165))."\n",checkbox("only_errors",1,($_POST?$_POST["only_errors"]:isset($_GET["import"])||$_GET["only_errors"]),lang(166))."\n",input_token();if(!isset($_GET["import"])&&$Ed){print_fieldset("history",lang(167),$_GET["history"]!="");for($X=end($Ed);$X;$X=prev($Ed)){$y=key($Ed);list($Gg,$qi,$nc)=$X;echo'<a href="'.h(ME."sql=&history=$y").'">'.lang(10)."</a>"." <span class='time' title='".@date('Y-m-d',$qi)."'>".@date("H:i:s",$qi)."</span>"." <code class='jush-".JUSH."'>".shorten_utf8(ltrim(str_replace("\n"," ",str_replace("\r","",preg_replace('~^(#|-- ).*~m','',$Gg)))),80,"</code>").($nc?" <span class='time'>($nc)</span>":"")."<br>\n";}echo"<input type='submit' name='clear' value='".lang(168)."'>\n","<a href='".h(ME."sql=&history=all")."'>".lang(169)."</a>\n","</div></fieldset>\n";}echo'</form>
';}elseif(isset($_GET["edit"])){$a=$_GET["edit"];$o=fields($a);$Z=(isset($_GET["select"])?($_POST["check"]&&count($_POST["check"])==1?where_check($_POST["check"][0],$o):""):where($_GET,$o));$Wi=(isset($_GET["select"])?$_POST["edit"]:$Z);foreach($o
as$C=>$n){if(!isset($n["privileges"][$Wi?"update":"insert"])||adminer()->fieldName($n)==""||$n["generated"])unset($o[$C]);}if($_POST&&!$m&&!isset($_GET["select"])){$Ee=$_POST["referer"];if($_POST["insert"])$Ee=($Wi?null:$_SERVER["REQUEST_URI"]);elseif(!preg_match('~^.+&select=.+$~',$Ee))$Ee=ME."select=".urlencode($a);$x=indexes($a);$Ri=unique_array($_GET["where"],$x);$Jg="\nWHERE $Z";if(isset($_POST["delete"]))queries_redirect($Ee,lang(170),driver()->delete($a,$Jg,$Ri?0:1));else{$O=array();foreach($o
as$C=>$n){$X=process_input($n);if($X!==false&&$X!==null)$O[idf_escape($C)]=$X;}if($Wi){if(!$O)redirect($Ee);queries_redirect($Ee,lang(171),driver()->update($a,$O,$Jg,$Ri?0:1));if(is_ajax()){page_headers();page_messages($m);exit;}}else{$I=driver()->insert($a,$O);$xe=($I?last_id($I):0);queries_redirect($Ee,lang(172,($xe?" $xe":"")),$I);}}}$K=null;if($_POST["save"])$K=(array)$_POST["fields"];elseif($Z){$M=array();foreach($o
as$C=>$n){if(isset($n["privileges"]["select"])){$ya=($_POST["clone"]&&$n["auto_increment"]?"''":convert_field($n));$M[]=($ya?"$ya AS ":"").idf_escape($C);}}$K=array();if(!support("table"))$M=array("*");if($M){$I=driver()->select($a,$M,array($Z),$M,array(),(isset($_GET["select"])?2:1));if(!$I)$m=error();else{$K=$I->fetch_assoc();if(!$K)$K=false;}if(isset($_GET["select"])&&(!$K||$I->fetch_assoc()))$K=null;}}if(!support("table")&&!$o){if(!$Z){$I=driver()->select($a,array("*"),array(),array("*"));$K=($I?$I->fetch_assoc():false);if(!$K)$K=array(driver()->primary=>"");}if($K){foreach($K
as$y=>$X){if(!$Z)$K[$y]=null;$o[$y]=array("field"=>$y,"null"=>($y!=driver()->primary),"auto_increment"=>($y==driver()->primary));}}}edit_form($a,$o,$K,$Wi,$m);}elseif(isset($_GET["create"])){$a=$_GET["create"];$gg=array();foreach(array('HASH','LINEAR HASH','KEY','LINEAR KEY','RANGE','LIST')as$y)$gg[$y]=$y;$Pg=referencable_primary($a);$gd=array();foreach($Pg
as$bi=>$n)$gd[str_replace("`","``",$bi)."`".str_replace("`","``",$n["field"])]=$bi;$Sf=array();$S=array();if($a!=""){$Sf=fields($a);$S=table_status1($a);if(count($S)<2)$m=lang(9);}$K=$_POST;$K["fields"]=(array)$K["fields"];if($K["auto_increment_col"])$K["fields"][$K["auto_increment_col"]]["auto_increment"]=true;if($_POST)save_settings(array("comments"=>$_POST["comments"],"defaults"=>$_POST["defaults"]));if($_POST&&!process_fields($K["fields"])&&!$m){if($_POST["drop"])queries_redirect(substr(ME,0,-1),lang(173),drop_tables(array($a)));else{$o=array();$ua=array();$aj=false;$ed=array();$Rf=reset($Sf);$sa=" FIRST";foreach($K["fields"]as$y=>$n){$q=$gd[$n["type"]];$Li=($q!==null?$Pg[$q]:$n);if($n["field"]!=""){if(!$n["generated"])$n["default"]=null;$Eg=process_field($n,$Li);$ua[]=array($n["orig"],$Eg,$sa);if(!$Rf||$Eg!==process_field($Rf,$Rf)){$o[]=array($n["orig"],$Eg,$sa);if($n["orig"]!=""||$sa)$aj=true;}if($q!==null)$ed[idf_escape($n["field"])]=($a!=""&&JUSH!="sqlite"?"ADD":" ").format_foreign_key(array('table'=>$gd[$n["type"]],'source'=>array($n["field"]),'target'=>array($Li["field"]),'on_delete'=>$n["on_delete"],));$sa=" AFTER ".idf_escape($n["field"]);}elseif($n["orig"]!=""){$aj=true;$o[]=array($n["orig"]);}if($n["orig"]!=""){$Rf=next($Sf);if(!$Rf)$sa="";}}$ig="";if(support("partitioning")){if(isset($gg[$K["partition_by"]])){$dg=array();foreach($K
as$y=>$X){if(preg_match('~^partition~',$y))$dg[$y]=$X;}foreach($dg["partition_names"]as$y=>$C){if($C==""){unset($dg["partition_names"][$y]);unset($dg["partition_values"][$y]);}}if($dg!=get_partitions_info($a)){$jg=array();if($dg["partition_by"]=='RANGE'||$dg["partition_by"]=='LIST'){foreach($dg["partition_names"]as$y=>$C){$Y=$dg["partition_values"][$y];$jg[]="\n  PARTITION ".idf_escape($C)." VALUES ".($dg["partition_by"]=='RANGE'?"LESS THAN":"IN").($Y!=""?" ($Y)":" MAXVALUE");}}$ig
.="\nPARTITION BY $dg[partition_by]($dg[partition])";if($jg)$ig
.=" (".implode(",",$jg)."\n)";elseif($dg["partitions"])$ig
.=" PARTITIONS ".(+$dg["partitions"]);}}elseif(preg_match("~partitioned~",$S["Create_options"]))$ig
.="\nREMOVE PARTITIONING";}$Ve=lang(174);if($a==""){cookie("adminer_engine",$K["Engine"]);$Ve=lang(175);}$C=trim($K["name"]);queries_redirect(ME.(support("table")?"table=":"select=").urlencode($C),$Ve,alter_table($a,$C,(JUSH=="sqlite"&&($aj||$ed)?$ua:$o),$ed,($K["Comment"]!=$S["Comment"]?$K["Comment"]:null),($K["Engine"]&&$K["Engine"]!=$S["Engine"]?$K["Engine"]:""),($K["Collation"]&&$K["Collation"]!=$S["Collation"]?$K["Collation"]:""),($K["Auto_increment"]!=""?number($K["Auto_increment"]):""),$ig));}}page_header(($a!=""?lang(43):lang(73)),$m,array("table"=>$a),h($a));if(!$_POST){$Ni=driver()->types();$K=array("Engine"=>$_COOKIE["adminer_engine"],"fields"=>array(array("field"=>"","type"=>(isset($Ni["int"])?"int":(isset($Ni["integer"])?"integer":"")),"on_update"=>"")),"partition_names"=>array(""),);if($a!=""){$K=$S;$K["name"]=$a;$K["fields"]=array();if(!$_GET["auto_increment"])$K["Auto_increment"]="";foreach($Sf
as$n){$n["generated"]=$n["generated"]?:(isset($n["default"])?"DEFAULT":"");$K["fields"][]=$n;}if(support("partitioning")){$K+=get_partitions_info($a);$K["partition_names"][]="";$K["partition_values"][]="";}}}$jb=collations();if(is_array(reset($jb)))$jb=call_user_func_array('array_merge',array_values($jb));$uc=driver()->engines();foreach($uc
as$tc){if(!strcasecmp($tc,$K["Engine"])){$K["Engine"]=$tc;break;}}echo'
<form action="" method="post" id="form">
<p>
';if(support("columns")||$a==""){echo
lang(176).": <input name='name'".($a==""&&!$_POST?" autofocus":"")." data-maxlength='64' value='".h($K["name"])."' autocapitalize='off'>\n",($uc?html_select("Engine",array(""=>"(".lang(177).")")+$uc,$K["Engine"]).on_help("event.target.value",1).script("qsl('select').onchange = helpClose;")."\n":"");if($jb)echo"<datalist id='collations'>".optionlist($jb)."</datalist>\n",(preg_match("~sqlite|mssql~",JUSH)?"":"<input list='collations' name='Collation' value='".h($K["Collation"])."' placeholder='(".lang(102).")'>");echo"<input type='submit' value='".lang(14)."'>\n";}if(support("columns")){echo"<div class='scrollable'>\n","<table id='edit-fields' class='nowrap'>\n";edit_fields($K["fields"],$jb,"TABLE",$gd);echo"</table>\n",script("editFields();"),"</div>\n<p>\n",lang(50).": <input type='number' name='Auto_increment' class='size' value='".h($K["Auto_increment"])."'>\n",checkbox("defaults",1,($_POST?$_POST["defaults"]:get_setting("defaults")),lang(178),"columnShow(this.checked, 5)","jsonly");$qb=($_POST?$_POST["comments"]:get_setting("comments"));echo(support("comment")?checkbox("comments",1,$qb,lang(49),"editingCommentsClick(this, true);","jsonly").' '.(preg_match('~\n~',$K["Comment"])?"<textarea name='Comment' rows='2' cols='20'".($qb?"":" class='hidden'").">".h($K["Comment"])."</textarea>":'<input name="Comment" value="'.h($K["Comment"]).'" data-maxlength="'.(min_version(5.5)?2048:60).'"'.($qb?"":" class='hidden'").'>'):''),'<p>
<input type="submit" value="',lang(14),'">
';}echo'
';if($a!="")echo'<input type="submit" name="drop" value="',lang(129),'">',confirm(lang(179,$a));if(support("partitioning")){$hg=preg_match('~RANGE|LIST~',$K["partition_by"]);print_fieldset("partition",lang(180),$K["partition_by"]);echo"<p>".html_select("partition_by",array(""=>"")+$gg,$K["partition_by"]).on_help("event.target.value.replace(/./, 'PARTITION BY \$&')",1).script("qsl('select').onchange = partitionByChange;"),"(<input name='partition' value='".h($K["partition"])."'>)\n",lang(181).": <input type='number' name='partitions' class='size".($hg||!$K["partition_by"]?" hidden":"")."' value='".h($K["partitions"])."'>\n","<table id='partition-table'".($hg?"":" class='hidden'").">\n","<thead><tr><th>".lang(182)."<th>".lang(183)."</thead>\n";foreach($K["partition_names"]as$y=>$X)echo'<tr>','<td><input name="partition_names[]" value="'.h($X).'" autocapitalize="off">',($y==count($K["partition_names"])-1?script("qsl('input').oninput = partitionNameChange;"):''),'<td><input name="partition_values[]" value="'.h(idx($K["partition_values"],$y)).'">';echo"</table>\n</div></fieldset>\n";}echo
input_token(),'</form>
';}elseif(isset($_GET["indexes"])){$a=$_GET["indexes"];$Ud=array("PRIMARY","UNIQUE","INDEX");$S=table_status1($a,true);if(preg_match('~MyISAM|M?aria'.(min_version(5.6,'10.0.5')?'|InnoDB':'').'~i',$S["Engine"]))$Ud[]="FULLTEXT";if(preg_match('~MyISAM|M?aria'.(min_version(5.7,'10.2.2')?'|InnoDB':'').'~i',$S["Engine"]))$Ud[]="SPATIAL";$x=indexes($a);$G=array();if(JUSH=="mongo"){$G=$x["_id_"];unset($Ud[0]);unset($x["_id_"]);}$K=$_POST;if($K)save_settings(array("index_options"=>$K["options"]));if($_POST&&!$m&&!$_POST["add"]&&!$_POST["drop_col"]){$b=array();foreach($K["indexes"]as$w){$C=$w["name"];if(in_array($w["type"],$Ud)){$e=array();$Be=array();$Vb=array();$O=array();ksort($w["columns"]);foreach($w["columns"]as$y=>$d){if($d!=""){$z=idx($w["lengths"],$y);$Ub=idx($w["descs"],$y);$O[]=idf_escape($d).($z?"(".(+$z).")":"").($Ub?" DESC":"");$e[]=$d;$Be[]=($z?:null);$Vb[]=$Ub;}}$Gc=$x[$C];if($Gc){ksort($Gc["columns"]);ksort($Gc["lengths"]);ksort($Gc["descs"]);if($w["type"]==$Gc["type"]&&array_values($Gc["columns"])===$e&&(!$Gc["lengths"]||array_values($Gc["lengths"])===$Be)&&array_values($Gc["descs"])===$Vb){unset($x[$C]);continue;}}if($e)$b[]=array($w["type"],$C,$O);}}foreach($x
as$C=>$Gc)$b[]=array($Gc["type"],$C,"DROP");if(!$b)redirect(ME."table=".urlencode($a));queries_redirect(ME."table=".urlencode($a),lang(184),alter_indexes($a,$b));}page_header(lang(134),$m,array("table"=>$a),h($a));$o=array_keys(fields($a));if($_POST["add"]){foreach($K["indexes"]as$y=>$w){if($w["columns"][count($w["columns"])]!="")$K["indexes"][$y]["columns"][]="";}$w=end($K["indexes"]);if($w["type"]||array_filter($w["columns"],'strlen'))$K["indexes"][]=array("columns"=>array(1=>""));}if(!$K){foreach($x
as$y=>$w){$x[$y]["name"]=$y;$x[$y]["columns"][]="";}$x[]=array("columns"=>array(1=>""));$K["indexes"]=$x;}$Be=(JUSH=="sql"||JUSH=="mssql");$Bh=($_POST?$_POST["options"]:get_setting("index_options"));echo'
<form action="" method="post">
<div class="scrollable">
<table class="nowrap">
<thead><tr>
<th id="label-type">',lang(185),'<th><input type="submit" class="wayoff">',lang(47).($Be?"<span class='idxopts".($Bh?"":" hidden")."'> (".lang(186).")</span>":"");if($Be||support("descidx"))echo
checkbox("options",1,$Bh,lang(108),"indexOptionsShow(this.checked)","jsonly")."\n";echo'<th id="label-name">',lang(187),'<th><noscript>',icon("plus","add[0]","+",lang(109)),'</noscript>
</thead>
';if($G){echo"<tr><td>PRIMARY<td>";foreach($G["columns"]as$y=>$d)echo
select_input(" disabled",$o,$d),"<label><input disabled type='checkbox'>".lang(58)."</label> ";echo"<td><td>\n";}$me=1;foreach($K["indexes"]as$w){if(!$_POST["drop_col"]||$me!=key($_POST["drop_col"])){echo"<tr><td>".html_select("indexes[$me][type]",array(-1=>"")+$Ud,$w["type"],($me==count($K["indexes"])?"indexesAddRow.call(this);":""),"label-type"),"<td>";ksort($w["columns"]);$t=1;foreach($w["columns"]as$y=>$d){echo"<span>".select_input(" name='indexes[$me][columns][$t]' title='".lang(47)."'",($o?array_combine($o,$o):$o),$d,"partial(".($t==count($w["columns"])?"indexesAddColumn":"indexesChangeColumn").", '".js_escape(JUSH=="sql"?"":$_GET["indexes"]."_")."')"),"<span class='idxopts".($Bh?"":" hidden")."'>",($Be?"<input type='number' name='indexes[$me][lengths][$t]' class='size' value='".h(idx($w["lengths"],$y))."' title='".lang(107)."'>":""),(support("descidx")?checkbox("indexes[$me][descs][$t]",1,idx($w["descs"],$y),lang(58)):""),"</span> </span>";$t++;}echo"<td><input name='indexes[$me][name]' value='".h($w["name"])."' autocapitalize='off' aria-labelledby='label-name'>\n","<td>".icon("cross","drop_col[$me]","x",lang(112)).script("qsl('button').onclick = partial(editingRemoveRow, 'indexes\$1[type]');");}$me++;}echo'</table>
</div>
<p>
<input type="submit" value="',lang(14),'">
',input_token(),'</form>
';}elseif(isset($_GET["database"])){$K=$_POST;if($_POST&&!$m&&!$_POST["add"]){$C=trim($K["name"]);if($_POST["drop"]){$_GET["db"]="";queries_redirect(remove_from_uri("db|database"),lang(188),drop_databases(array(DB)));}elseif(DB!==$C){if(DB!=""){$_GET["db"]=$C;queries_redirect(preg_replace('~\bdb=[^&]*&~','',ME)."db=".urlencode($C),lang(189),rename_database($C,$K["collation"]));}else{$j=explode("\n",str_replace("\r","",$C));$Uh=true;$we="";foreach($j
as$k){if(count($j)==1||$k!=""){if(!create_database($k,$K["collation"]))$Uh=false;$we=$k;}}restart_session();set_session("dbs",null);queries_redirect(ME."db=".urlencode($we),lang(190),$Uh);}}else{if(!$K["collation"])redirect(substr(ME,0,-1));query_redirect("ALTER DATABASE ".idf_escape($C).(preg_match('~^[a-z0-9_]+$~i',$K["collation"])?" COLLATE $K[collation]":""),substr(ME,0,-1),lang(191));}}page_header(DB!=""?lang(66):lang(116),$m,array(),h(DB));$jb=collations();$C=DB;if($_POST)$C=$K["name"];elseif(DB!="")$K["collation"]=db_collation(DB,$jb);elseif(JUSH=="sql"){foreach(get_vals("SHOW GRANTS")as$pd){if(preg_match('~ ON (`(([^\\\\`]|``|\\\\.)*)%`\.\*)?~',$pd,$B)&&$B[1]){$C=stripcslashes(idf_unescape("`$B[2]`"));break;}}}echo'
<form action="" method="post">
<p>
',($_POST["add"]||strpos($C,"\n")?'<textarea autofocus name="name" rows="10" cols="40">'.h($C).'</textarea><br>':'<input name="name" autofocus value="'.h($C).'" data-maxlength="64" autocapitalize="off">')."\n".($jb?html_select("collation",array(""=>"(".lang(102).")")+$jb,$K["collation"]).doc_link(array('sql'=>"charset-charsets.html",'mariadb'=>"supported-character-sets-and-collations/",'mssql'=>"relational-databases/system-functions/sys-fn-helpcollations-transact-sql",)):""),'<input type="submit" value="',lang(14),'">
';if(DB!="")echo"<input type='submit' name='drop' value='".lang(129)."'>".confirm(lang(179,DB))."\n";elseif(!$_POST["add"]&&$_GET["db"]=="")echo
icon("plus","add[0]","+",lang(109))."\n";echo
input_token(),'</form>
';}elseif(isset($_GET["scheme"])){$K=$_POST;if($_POST&&!$m){$A=preg_replace('~ns=[^&]*&~','',ME)."ns=";if($_POST["drop"])query_redirect("DROP SCHEMA ".idf_escape($_GET["ns"]),$A,lang(192));else{$C=trim($K["name"]);$A
.=urlencode($C);if($_GET["ns"]=="")query_redirect("CREATE SCHEMA ".idf_escape($C),$A,lang(193));elseif($_GET["ns"]!=$C)query_redirect("ALTER SCHEMA ".idf_escape($_GET["ns"])." RENAME TO ".idf_escape($C),$A,lang(194));else
redirect($A);}}page_header($_GET["ns"]!=""?lang(67):lang(68),$m);if(!$K)$K["name"]=$_GET["ns"];echo'
<form action="" method="post">
<p><input name="name" autofocus value="',h($K["name"]),'" autocapitalize="off">
<input type="submit" value="',lang(14),'">
';if($_GET["ns"]!="")echo"<input type='submit' name='drop' value='".lang(129)."'>".confirm(lang(179,$_GET["ns"]))."\n";echo
input_token(),'</form>
';}elseif(isset($_GET["call"])){$ca=($_GET["name"]?:$_GET["call"]);page_header(lang(195).": ".h($ca),$m);$dh=routine($_GET["call"],(isset($_GET["callf"])?"FUNCTION":"PROCEDURE"));$Qd=array();$Xf=array();foreach($dh["fields"]as$t=>$n){if(substr($n["inout"],-3)=="OUT")$Xf[$t]="@".idf_escape($n["field"])." AS ".idf_escape($n["field"]);if(!$n["inout"]||substr($n["inout"],0,2)=="IN")$Qd[]=$t;}if(!$m&&$_POST){$Ta=array();foreach($dh["fields"]as$y=>$n){$X="";if(in_array($y,$Qd)){$X=process_input($n);if($X===false)$X="''";if(isset($Xf[$y]))connection()->query("SET @".idf_escape($n["field"])." = $X");}$Ta[]=(isset($Xf[$y])?"@".idf_escape($n["field"]):$X);}$H=(isset($_GET["callf"])?"SELECT":"CALL")." ".table($ca)."(".implode(", ",$Ta).")";$Ph=microtime(true);$I=connection()->multi_query($H);$qa=connection()->affected_rows;echo
adminer()->selectQuery($H,$Ph,!$I);if(!$I)echo"<p class='error'>".error()."\n";else{$h=connect(adminer()->credentials());if($h)$h->select_db(DB);do{$I=connection()->store_result();if(is_object($I))print_select_result($I,$h);else
echo"<p class='message'>".lang(196,$qa)." <span class='time'>".@date("H:i:s")."</span>\n";}while(connection()->next_result());if($Xf)print_select_result(connection()->query("SELECT ".implode(", ",$Xf)));}}echo'
<form action="" method="post">
';if($Qd){echo"<table class='layout'>\n";foreach($Qd
as$y){$n=$dh["fields"][$y];$C=$n["field"];echo"<tr><th>".adminer()->fieldName($n);$Y=idx($_POST["fields"],$C);if($Y!=""){if($n["type"]=="set")$Y=implode(",",$Y);}input($n,$Y,idx($_POST["function"],$C,""));echo"\n";}echo"</table>\n";}echo'<p>
<input type="submit" value="',lang(195),'">
',input_token(),'</form>

<pre>
';function
pre_tr($hh){return
preg_replace('~^~m','<tr>',preg_replace('~\|~','<td>',preg_replace('~\|$~m',"",rtrim($hh))));}$R='(\+--[-+]+\+\n)';$K='(\| .* \|\n)';echo
preg_replace_callback("~^$R?$K$R?($K*)$R?~m",function($B){$Xc=pre_tr($B[2]);return"<table>\n".($B[1]?"<thead>$Xc</thead>\n":$Xc).pre_tr($B[4])."\n</table>";},preg_replace('~(\n(    -|mysql)&gt; )(.+)~',"\\1<code class='jush-sql'>\\3</code>",preg_replace('~(.+)\n---+\n~',"<b>\\1</b>\n",h($dh['comment']))));echo'</pre>
';}elseif(isset($_GET["foreign"])){$a=$_GET["foreign"];$C=$_GET["name"];$K=$_POST;if($_POST&&!$m&&!$_POST["add"]&&!$_POST["change"]&&!$_POST["change-js"]){if(!$_POST["drop"]){$K["source"]=array_filter($K["source"],'strlen');ksort($K["source"]);$ji=array();foreach($K["source"]as$y=>$X)$ji[$y]=$K["target"][$y];$K["target"]=$ji;}if(JUSH=="sqlite")$I=recreate_table($a,$a,array(),array(),array(" $C"=>($K["drop"]?"":" ".format_foreign_key($K))));else{$b="ALTER TABLE ".table($a);$I=($C==""||queries("$b DROP ".(JUSH=="sql"?"FOREIGN KEY ":"CONSTRAINT ").idf_escape($C)));if(!$K["drop"])$I=queries("$b ADD".format_foreign_key($K));}queries_redirect(ME."table=".urlencode($a),($K["drop"]?lang(197):($C!=""?lang(198):lang(199))),$I);if(!$K["drop"])$m="$m<br>".lang(200);}page_header(lang(201),$m,array("table"=>$a),h($a));if($_POST){ksort($K["source"]);if($_POST["add"])$K["source"][]="";elseif($_POST["change"]||$_POST["change-js"])$K["target"]=array();}elseif($C!=""){$gd=foreign_keys($a);$K=$gd[$C];$K["source"][]="";}else{$K["table"]=$a;$K["source"]=array("");}echo'
<form action="" method="post">
';$Gh=array_keys(fields($a));if($K["db"]!="")connection()->select_db($K["db"]);if($K["ns"]!=""){$Tf=get_schema();set_schema($K["ns"]);}$Og=array_keys(array_filter(table_status('',true),'Adminer\fk_support'));$ji=array_keys(fields(in_array($K["table"],$Og)?$K["table"]:reset($Og)));$Df="this.form['change-js'].value = '1'; this.form.submit();";echo"<p>".lang(202).": ".html_select("table",$Og,$K["table"],$Df)."\n";if(support("scheme")){$kh=array_filter(adminer()->schemas(),function($jh){return!preg_match('~^information_schema$~i',$jh);});echo
lang(75).": ".html_select("ns",$kh,$K["ns"]!=""?$K["ns"]:$_GET["ns"],$Df);if($K["ns"]!="")set_schema($Tf);}elseif(JUSH!="sqlite"){$Ob=array();foreach(adminer()->databases()as$k){if(!information_schema($k))$Ob[]=$k;}echo
lang(74).": ".html_select("db",$Ob,$K["db"]!=""?$K["db"]:$_GET["db"],$Df);}echo
input_hidden("change-js"),'<noscript><p><input type="submit" name="change" value="',lang(203),'"></noscript>
<table>
<thead><tr><th id="label-source">',lang(136),'<th id="label-target">',lang(137),'</thead>
';$me=0;foreach($K["source"]as$y=>$X){echo"<tr>","<td>".html_select("source[".(+$y)."]",array(-1=>"")+$Gh,$X,($me==count($K["source"])-1?"foreignAddRow.call(this);":""),"label-source"),"<td>".html_select("target[".(+$y)."]",$ji,idx($K["target"],$y),"","label-target");$me++;}echo'</table>
<p>
',lang(104),': ',html_select("on_delete",array(-1=>"")+explode("|",driver()->onActions),$K["on_delete"]),' ',lang(103),': ',html_select("on_update",array(-1=>"")+explode("|",driver()->onActions),$K["on_update"]),doc_link(array('sql'=>"innodb-foreign-key-constraints.html",'mariadb'=>"foreign-keys/",'pgsql'=>"sql-createtable.html#SQL-CREATETABLE-REFERENCES",'mssql'=>"t-sql/statements/create-table-transact-sql",'oracle'=>"SQLRF01111",)),'<p>
<input type="submit" value="',lang(14),'">
<noscript><p><input type="submit" name="add" value="',lang(204),'"></noscript>
';if($C!="")echo'<input type="submit" name="drop" value="',lang(129),'">',confirm(lang(179,$C));echo
input_token(),'</form>
';}elseif(isset($_GET["view"])){$a=$_GET["view"];$K=$_POST;$Uf="VIEW";if(JUSH=="pgsql"&&$a!=""){$P=table_status1($a);$Uf=strtoupper($P["Engine"]);}if($_POST&&!$m){$C=trim($K["name"]);$ya=" AS\n$K[select]";$Ee=ME."table=".urlencode($C);$Ve=lang(205);$U=($_POST["materialized"]?"MATERIALIZED VIEW":"VIEW");if(!$_POST["drop"]&&$a==$C&&JUSH!="sqlite"&&$U=="VIEW"&&$Uf=="VIEW")query_redirect((JUSH=="mssql"?"ALTER":"CREATE OR REPLACE")." VIEW ".table($C).$ya,$Ee,$Ve);else{$li=$C."_adminer_".uniqid();drop_create("DROP $Uf ".table($a),"CREATE $U ".table($C).$ya,"DROP $U ".table($C),"CREATE $U ".table($li).$ya,"DROP $U ".table($li),($_POST["drop"]?substr(ME,0,-1):$Ee),lang(206),$Ve,lang(207),$a,$C);}}if(!$_POST&&$a!=""){$K=view($a);$K["name"]=$a;$K["materialized"]=($Uf!="VIEW");if(!$m)$m=error();}page_header(($a!=""?lang(42):lang(208)),$m,array("table"=>$a),h($a));echo'
<form action="" method="post">
<p>',lang(187),': <input name="name" value="',h($K["name"]),'" data-maxlength="64" autocapitalize="off">
',(support("materializedview")?" ".checkbox("materialized",1,$K["materialized"],lang(131)):""),'<p>';textarea("select",$K["select"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($a!="")echo'<input type="submit" name="drop" value="',lang(129),'">',confirm(lang(179,$a));echo
input_token(),'</form>
';}elseif(isset($_GET["event"])){$aa=$_GET["event"];$ee=array("YEAR","QUARTER","MONTH","DAY","HOUR","MINUTE","WEEK","SECOND","YEAR_MONTH","DAY_HOUR","DAY_MINUTE","DAY_SECOND","HOUR_MINUTE","HOUR_SECOND","MINUTE_SECOND");$Qh=array("ENABLED"=>"ENABLE","DISABLED"=>"DISABLE","SLAVESIDE_DISABLED"=>"DISABLE ON SLAVE");$K=$_POST;if($_POST&&!$m){if($_POST["drop"])query_redirect("DROP EVENT ".idf_escape($aa),substr(ME,0,-1),lang(209));elseif(in_array($K["INTERVAL_FIELD"],$ee)&&isset($Qh[$K["STATUS"]])){$ih="\nON SCHEDULE ".($K["INTERVAL_VALUE"]?"EVERY ".q($K["INTERVAL_VALUE"])." $K[INTERVAL_FIELD]".($K["STARTS"]?" STARTS ".q($K["STARTS"]):"").($K["ENDS"]?" ENDS ".q($K["ENDS"]):""):"AT ".q($K["STARTS"]))." ON COMPLETION".($K["ON_COMPLETION"]?"":" NOT")." PRESERVE";queries_redirect(substr(ME,0,-1),($aa!=""?lang(210):lang(211)),queries(($aa!=""?"ALTER EVENT ".idf_escape($aa).$ih.($aa!=$K["EVENT_NAME"]?"\nRENAME TO ".idf_escape($K["EVENT_NAME"]):""):"CREATE EVENT ".idf_escape($K["EVENT_NAME"]).$ih)."\n".$Qh[$K["STATUS"]]." COMMENT ".q($K["EVENT_COMMENT"]).rtrim(" DO\n$K[EVENT_DEFINITION]",";").";"));}}page_header(($aa!=""?lang(212).": ".h($aa):lang(213)),$m);if(!$K&&$aa!=""){$L=get_rows("SELECT * FROM information_schema.EVENTS WHERE EVENT_SCHEMA = ".q(DB)." AND EVENT_NAME = ".q($aa));$K=reset($L);}echo'
<form action="" method="post">
<table class="layout">
<tr><th>',lang(187),'<td><input name="EVENT_NAME" value="',h($K["EVENT_NAME"]),'" data-maxlength="64" autocapitalize="off">
<tr><th title="datetime">',lang(214),'<td><input name="STARTS" value="',h("$K[EXECUTE_AT]$K[STARTS]"),'">
<tr><th title="datetime">',lang(215),'<td><input name="ENDS" value="',h($K["ENDS"]),'">
<tr><th>',lang(216),'<td><input type="number" name="INTERVAL_VALUE" value="',h($K["INTERVAL_VALUE"]),'" class="size"> ',html_select("INTERVAL_FIELD",$ee,$K["INTERVAL_FIELD"]),'<tr><th>',lang(119),'<td>',html_select("STATUS",$Qh,$K["STATUS"]),'<tr><th>',lang(49),'<td><input name="EVENT_COMMENT" value="',h($K["EVENT_COMMENT"]),'" data-maxlength="64">
<tr><th><td>',checkbox("ON_COMPLETION","PRESERVE",$K["ON_COMPLETION"]=="PRESERVE",lang(217)),'</table>
<p>';textarea("EVENT_DEFINITION",$K["EVENT_DEFINITION"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($aa!="")echo'<input type="submit" name="drop" value="',lang(129),'">',confirm(lang(179,$aa));echo
input_token(),'</form>
';}elseif(isset($_GET["procedure"])){$ca=($_GET["name"]?:$_GET["procedure"]);$dh=(isset($_GET["function"])?"FUNCTION":"PROCEDURE");$K=$_POST;$K["fields"]=(array)$K["fields"];if($_POST&&!process_fields($K["fields"])&&!$m){$Qf=routine($_GET["procedure"],$dh);$li="$K[name]_adminer_".uniqid();foreach($K["fields"]as$y=>$n){if($n["field"]=="")unset($K["fields"][$y]);}drop_create("DROP $dh ".routine_id($ca,$Qf),create_routine($dh,$K),"DROP $dh ".routine_id($K["name"],$K),create_routine($dh,array("name"=>$li)+$K),"DROP $dh ".routine_id($li,$K),substr(ME,0,-1),lang(218),lang(219),lang(220),$ca,$K["name"]);}page_header(($ca!=""?(isset($_GET["function"])?lang(221):lang(222)).": ".h($ca):(isset($_GET["function"])?lang(223):lang(224))),$m);if(!$_POST){if($ca=="")$K["language"]="sql";else{$K=routine($_GET["procedure"],$dh);$K["name"]=$ca;}}$jb=get_vals("SHOW CHARACTER SET");sort($jb);$eh=routine_languages();echo($jb?"<datalist id='collations'>".optionlist($jb)."</datalist>":""),'
<form action="" method="post" id="form">
<p>',lang(187),': <input name="name" value="',h($K["name"]),'" data-maxlength="64" autocapitalize="off">
',($eh?lang(19).": ".html_select("language",$eh,$K["language"])."\n":""),'<input type="submit" value="',lang(14),'">
<div class="scrollable">
<table class="nowrap">
';edit_fields($K["fields"],$jb,$dh);if(isset($_GET["function"])){echo"<tr><td>".lang(225);edit_type("returns",$K["returns"],$jb,array(),(JUSH=="pgsql"?array("void","trigger"):array()));}echo'</table>
',script("editFields();"),'</div>
<p>';textarea("definition",$K["definition"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($ca!="")echo'<input type="submit" name="drop" value="',lang(129),'">',confirm(lang(179,$ca));echo
input_token(),'</form>
';}elseif(isset($_GET["sequence"])){$ea=$_GET["sequence"];$K=$_POST;if($_POST&&!$m){$A=substr(ME,0,-1);$C=trim($K["name"]);if($_POST["drop"])query_redirect("DROP SEQUENCE ".idf_escape($ea),$A,lang(226));elseif($ea=="")query_redirect("CREATE SEQUENCE ".idf_escape($C),$A,lang(227));elseif($ea!=$C)query_redirect("ALTER SEQUENCE ".idf_escape($ea)." RENAME TO ".idf_escape($C),$A,lang(228));else
redirect($A);}page_header($ea!=""?lang(229).": ".h($ea):lang(230),$m);if(!$K)$K["name"]=$ea;echo'
<form action="" method="post">
<p><input name="name" value="',h($K["name"]),'" autocapitalize="off">
<input type="submit" value="',lang(14),'">
';if($ea!="")echo"<input type='submit' name='drop' value='".lang(129)."'>".confirm(lang(179,$ea))."\n";echo
input_token(),'</form>
';}elseif(isset($_GET["type"])){$fa=$_GET["type"];$K=$_POST;if($_POST&&!$m){$A=substr(ME,0,-1);if($_POST["drop"])query_redirect("DROP TYPE ".idf_escape($fa),$A,lang(231));else
query_redirect("CREATE TYPE ".idf_escape(trim($K["name"]))." $K[as]",$A,lang(232));}page_header($fa!=""?lang(233).": ".h($fa):lang(234),$m);if(!$K)$K["as"]="AS ";echo'
<form action="" method="post">
<p>
';if($fa!=""){$Ni=driver()->types();$yc=type_values($Ni[$fa]);if($yc)echo"<code class='jush-".JUSH."'>ENUM (".h($yc).")</code>\n<p>";echo"<input type='submit' name='drop' value='".lang(129)."'>".confirm(lang(179,$fa))."\n";}else{echo
lang(187).": <input name='name' value='".h($K['name'])."' autocapitalize='off'>\n",doc_link(array('pgsql'=>"datatype-enum.html",),"?");textarea("as",$K["as"]);echo"<p><input type='submit' value='".lang(14)."'>\n";}echo
input_token(),'</form>
';}elseif(isset($_GET["check"])){$a=$_GET["check"];$C=$_GET["name"];$K=$_POST;if($K&&!$m){if(JUSH=="sqlite")$I=recreate_table($a,$a,array(),array(),array(),"",array(),"$C",($K["drop"]?"":$K["clause"]));else{$I=($C==""||queries("ALTER TABLE ".table($a)." DROP CONSTRAINT ".idf_escape($C)));if(!$K["drop"])$I=queries("ALTER TABLE ".table($a)." ADD".($K["name"]!=""?" CONSTRAINT ".idf_escape($K["name"]):"")." CHECK ($K[clause])");}queries_redirect(ME."table=".urlencode($a),($K["drop"]?lang(235):($C!=""?lang(236):lang(237))),$I);}page_header(($C!=""?lang(238).": ".h($C):lang(141)),$m,array("table"=>$a));if(!$K){$bb=driver()->checkConstraints($a);$K=array("name"=>$C,"clause"=>$bb[$C]);}echo'
<form action="" method="post">
<p>';if(JUSH!="sqlite")echo
lang(187).': <input name="name" value="'.h($K["name"]).'" data-maxlength="64" autocapitalize="off"> ';echo
doc_link(array('sql'=>"create-table-check-constraints.html",'mariadb'=>"constraint/",'pgsql'=>"ddl-constraints.html#DDL-CONSTRAINTS-CHECK-CONSTRAINTS",'mssql'=>"relational-databases/tables/create-check-constraints",'sqlite'=>"lang_createtable.html#check_constraints",),"?"),'<p>';textarea("clause",$K["clause"]);echo'<p><input type="submit" value="',lang(14),'">
';if($C!="")echo'<input type="submit" name="drop" value="',lang(129),'">',confirm(lang(179,$C));echo
input_token(),'</form>
';}elseif(isset($_GET["trigger"])){$a=$_GET["trigger"];$C="$_GET[name]";$Ji=trigger_options();$K=(array)trigger($C,$a)+array("Trigger"=>$a."_bi");if($_POST){if(!$m&&in_array($_POST["Timing"],$Ji["Timing"])&&in_array($_POST["Event"],$Ji["Event"])&&in_array($_POST["Type"],$Ji["Type"])){$Af=" ON ".table($a);$dc="DROP TRIGGER ".idf_escape($C).(JUSH=="pgsql"?$Af:"");$Ee=ME."table=".urlencode($a);if($_POST["drop"])query_redirect($dc,$Ee,lang(239));else{if($C!="")queries($dc);queries_redirect($Ee,($C!=""?lang(240):lang(241)),queries(create_trigger($Af,$_POST)));if($C!="")queries(create_trigger($Af,$K+array("Type"=>reset($Ji["Type"]))));}}$K=$_POST;}page_header(($C!=""?lang(242).": ".h($C):lang(243)),$m,array("table"=>$a));echo'
<form action="" method="post" id="form">
<table class="layout">
<tr><th>',lang(244),'<td>',html_select("Timing",$Ji["Timing"],$K["Timing"],"triggerChange(/^".preg_quote($a,"/")."_[ba][iud]$/, '".js_escape($a)."', this.form);"),'<tr><th>',lang(245),'<td>',html_select("Event",$Ji["Event"],$K["Event"],"this.form['Timing'].onchange();"),(in_array("UPDATE OF",$Ji["Event"])?" <input name='Of' value='".h($K["Of"])."' class='hidden'>":""),'<tr><th>',lang(48),'<td>',html_select("Type",$Ji["Type"],$K["Type"]),'</table>
<p>',lang(187),': <input name="Trigger" value="',h($K["Trigger"]),'" data-maxlength="64" autocapitalize="off">
',script("qs('#form')['Timing'].onchange();"),'<p>';textarea("Statement",$K["Statement"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($C!="")echo'<input type="submit" name="drop" value="',lang(129),'">',confirm(lang(179,$C));echo
input_token(),'</form>
';}elseif(isset($_GET["user"])){$ga=$_GET["user"];$Cg=array(""=>array("All privileges"=>""));foreach(get_rows("SHOW PRIVILEGES")as$K){foreach(explode(",",($K["Privilege"]=="Grant option"?"":$K["Context"]))as$zb)$Cg[$zb][$K["Privilege"]]=$K["Comment"];}$Cg["Server Admin"]+=$Cg["File access on server"];$Cg["Databases"]["Create routine"]=$Cg["Procedures"]["Create routine"];unset($Cg["Procedures"]["Create routine"]);$Cg["Columns"]=array();foreach(array("Select","Insert","Update","References")as$X)$Cg["Columns"][$X]=$Cg["Tables"][$X];unset($Cg["Server Admin"]["Usage"]);foreach($Cg["Tables"]as$y=>$X)unset($Cg["Databases"][$y]);$kf=array();if($_POST){foreach($_POST["objects"]as$y=>$X)$kf[$X]=(array)$kf[$X]+idx($_POST["grants"],$y,array());}$qd=array();$zf="";if(isset($_GET["host"])&&($I=connection()->query("SHOW GRANTS FOR ".q($ga)."@".q($_GET["host"])))){while($K=$I->fetch_row()){if(preg_match('~GRANT (.*) ON (.*) TO ~',$K[0],$B)&&preg_match_all('~ *([^(,]*[^ ,(])( *\([^)]+\))?~',$B[1],$Le,PREG_SET_ORDER)){foreach($Le
as$X){if($X[1]!="USAGE")$qd["$B[2]$X[2]"][$X[1]]=true;if(preg_match('~ WITH GRANT OPTION~',$K[0]))$qd["$B[2]$X[2]"]["GRANT OPTION"]=true;}}if(preg_match("~ IDENTIFIED BY PASSWORD '([^']+)~",$K[0],$B))$zf=$B[1];}}if($_POST&&!$m){$_f=(isset($_GET["host"])?q($ga)."@".q($_GET["host"]):"''");if($_POST["drop"])query_redirect("DROP USER $_f",ME."privileges=",lang(246));else{$mf=q($_POST["user"])."@".q($_POST["host"]);$kg=$_POST["pass"];if($kg!=''&&!$_POST["hashed"]&&!min_version(8)){$kg=get_val("SELECT PASSWORD(".q($kg).")");$m=!$kg;}$Cb=false;if(!$m){if($_f!=$mf){$Cb=queries((min_version(5)?"CREATE USER":"GRANT USAGE ON *.* TO")." $mf IDENTIFIED BY ".(min_version(8)?"":"PASSWORD ").q($kg));$m=!$Cb;}elseif($kg!=$zf)queries("SET PASSWORD FOR $mf = ".q($kg));}if(!$m){$ah=array();foreach($kf
as$tf=>$pd){if(isset($_GET["grant"]))$pd=array_filter($pd);$pd=array_keys($pd);if(isset($_GET["grant"]))$ah=array_diff(array_keys(array_filter($kf[$tf],'strlen')),$pd);elseif($_f==$mf){$xf=array_keys((array)$qd[$tf]);$ah=array_diff($xf,$pd);$pd=array_diff($pd,$xf);unset($qd[$tf]);}if(preg_match('~^(.+)\s*(\(.*\))?$~U',$tf,$B)&&(!grant("REVOKE",$ah,$B[2]," ON $B[1] FROM $mf")||!grant("GRANT",$pd,$B[2]," ON $B[1] TO $mf"))){$m=true;break;}}}if(!$m&&isset($_GET["host"])){if($_f!=$mf)queries("DROP USER $_f");elseif(!isset($_GET["grant"])){foreach($qd
as$tf=>$ah){if(preg_match('~^(.+)(\(.*\))?$~U',$tf,$B))grant("REVOKE",array_keys($ah),$B[2]," ON $B[1] FROM $mf");}}}queries_redirect(ME."privileges=",(isset($_GET["host"])?lang(247):lang(248)),!$m);if($Cb)connection()->query("DROP USER $mf");}}page_header((isset($_GET["host"])?lang(34).": ".h("$ga@$_GET[host]"):lang(150)),$m,array("privileges"=>array('',lang(70))));$K=$_POST;if($K)$qd=$kf;else{$K=$_GET+array("host"=>get_val("SELECT SUBSTRING_INDEX(CURRENT_USER, '@', -1)"));$K["pass"]=$zf;if($zf!="")$K["hashed"]=true;$qd[(DB==""||$qd?"":idf_escape(addcslashes(DB,"%_\\"))).".*"]=array();}echo'<form action="" method="post">
<table class="layout">
<tr><th>',lang(33),'<td><input name="host" data-maxlength="60" value="',h($K["host"]),'" autocapitalize="off">
<tr><th>',lang(34),'<td><input name="user" data-maxlength="80" value="',h($K["user"]),'" autocapitalize="off">
<tr><th>',lang(35),'<td><input name="pass" id="pass" value="',h($K["pass"]),'" autocomplete="new-password">
',($K["hashed"]?"":script("typePassword(qs('#pass'));")),(min_version(8)?"":checkbox("hashed",1,$K["hashed"],lang(249),"typePassword(this.form['pass'], this.checked);")),'</table>

',"<table class='odds'>\n","<thead><tr><th colspan='2'>".lang(70).doc_link(array('sql'=>"grant.html#priv_level"));$t=0;foreach($qd
as$tf=>$pd){echo'<th>'.($tf!="*.*"?"<input name='objects[$t]' value='".h($tf)."' size='10' autocapitalize='off'>":input_hidden("objects[$t]","*.*")."*.*");$t++;}echo"</thead>\n";foreach(array(""=>"","Server Admin"=>lang(33),"Databases"=>lang(36),"Tables"=>lang(133),"Columns"=>lang(47),"Procedures"=>lang(250),)as$zb=>$Ub){foreach((array)$Cg[$zb]as$Bg=>$ob){echo"<tr><td".($Ub?">$Ub<td":" colspan='2'").' lang="en" title="'.h($ob).'">'.h($Bg);$t=0;foreach($qd
as$tf=>$pd){$C="'grants[$t][".h(strtoupper($Bg))."]'";$Y=$pd[strtoupper($Bg)];if($zb=="Server Admin"&&$tf!=(isset($qd["*.*"])?"*.*":".*"))echo"<td>";elseif(isset($_GET["grant"]))echo"<td><select name=$C><option><option value='1'".($Y?" selected":"").">".lang(251)."<option value='0'".($Y=="0"?" selected":"").">".lang(252)."</select>";else
echo"<td align='center'><label class='block'>","<input type='checkbox' name=$C value='1'".($Y?" checked":"").($Bg=="All privileges"?" id='grants-$t-all'>":">".($Bg=="Grant option"?"":script("qsl('input').onclick = function () { if (this.checked) formUncheck('grants-$t-all'); };"))),"</label>";$t++;}}}echo"</table>\n",'<p>
<input type="submit" value="',lang(14),'">
';if(isset($_GET["host"]))echo'<input type="submit" name="drop" value="',lang(129),'">',confirm(lang(179,"$ga@$_GET[host]"));echo
input_token(),'</form>
';}elseif(isset($_GET["processlist"])){if(support("kill")){if($_POST&&!$m){$se=0;foreach((array)$_POST["kill"]as$X){if(kill_process($X))$se++;}queries_redirect(ME."processlist=",lang(253,$se),$se||!$_POST["kill"]);}}page_header(lang(117),$m);echo'
<form action="" method="post">
<div class="scrollable">
<table class="nowrap checkable odds">
',script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});");$t=-1;foreach(process_list()as$t=>$K){if(!$t){echo"<thead><tr lang='en'>".(support("kill")?"<th>":"");foreach($K
as$y=>$X)echo"<th>$y".doc_link(array('sql'=>"show-processlist.html#processlist_".strtolower($y),'pgsql'=>"monitoring-stats.html#PG-STAT-ACTIVITY-VIEW",'oracle'=>"REFRN30223",));echo"</thead>\n";}echo"<tr>".(support("kill")?"<td>".checkbox("kill[]",$K[JUSH=="sql"?"Id":"pid"],0):"");foreach($K
as$y=>$X)echo"<td>".((JUSH=="sql"&&$y=="Info"&&preg_match("~Query|Killed~",$K["Command"])&&$X!="")||(JUSH=="pgsql"&&$y=="current_query"&&$X!="<IDLE>")||(JUSH=="oracle"&&$y=="sql_text"&&$X!="")?"<code class='jush-".JUSH."'>".shorten_utf8($X,100,"</code>").' <a href="'.h(ME.($K["db"]!=""?"db=".urlencode($K["db"])."&":"")."sql=".urlencode($X)).'">'.lang(254).'</a>':h($X));echo"\n";}echo'</table>
</div>
<p>
';if(support("kill"))echo($t+1)."/".lang(255,max_connections()),"<p><input type='submit' value='".lang(256)."'>\n";echo
input_token(),'</form>
',script("tableCheck();");}elseif(isset($_GET["select"])){$a=$_GET["select"];$S=table_status1($a);$x=indexes($a);$o=fields($a);$gd=column_foreign_keys($a);$vf=$S["Oid"];$pa=get_settings("adminer_import");$bh=array();$e=array();$nh=array();$Mf=array();$pi="";foreach($o
as$y=>$n){$C=adminer()->fieldName($n);$if=html_entity_decode(strip_tags($C),ENT_QUOTES);if(isset($n["privileges"]["select"])&&$C!=""){$e[$y]=$if;if(is_shortable($n))$pi=adminer()->selectLengthProcess();}if(isset($n["privileges"]["where"])&&$C!="")$nh[$y]=$if;if(isset($n["privileges"]["order"])&&$C!="")$Mf[$y]=$if;$bh+=$n["privileges"];}list($M,$rd)=adminer()->selectColumnsProcess($e,$x);$M=array_unique($M);$rd=array_unique($rd);$ie=count($rd)<count($M);$Z=adminer()->selectSearchProcess($o,$x);$Lf=adminer()->selectOrderProcess($o,$x);$_=adminer()->selectLimitProcess();if($_GET["val"]&&is_ajax()){header("Content-Type: text/plain; charset=utf-8");foreach($_GET["val"]as$Si=>$K){$ya=convert_field($o[key($K)]);$M=array($ya?:idf_escape(key($K)));$Z[]=where_check($Si,$o);$J=driver()->select($a,$M,$Z,$M);if($J)echo
first($J->fetch_row());}exit;}$G=$Ui=null;foreach($x
as$w){if($w["type"]=="PRIMARY"){$G=array_flip($w["columns"]);$Ui=($M?$G:array());foreach($Ui
as$y=>$X){if(in_array(idf_escape($y),$M))unset($Ui[$y]);}break;}}if($vf&&!$G){$G=$Ui=array($vf=>0);$x[]=array("type"=>"PRIMARY","columns"=>array($vf));}if($_POST&&!$m){$sj=$Z;if(!$_POST["all"]&&is_array($_POST["check"])){$bb=array();foreach($_POST["check"]as$Xa)$bb[]=where_check($Xa,$o);$sj[]="((".implode(") OR (",$bb)."))";}$sj=($sj?"\nWHERE ".implode(" AND ",$sj):"");if($_POST["export"]){save_settings(array("output"=>$_POST["output"],"format"=>$_POST["format"]),"adminer_import");dump_headers($a);adminer()->dumpTable($a,"");$kd=($M?implode(", ",$M):"*").convert_fields($e,$o,$M)."\nFROM ".table($a);$td=($rd&&$ie?"\nGROUP BY ".implode(", ",$rd):"").($Lf?"\nORDER BY ".implode(", ",$Lf):"");$H="SELECT $kd$sj$td";if(is_array($_POST["check"])&&!$G){$Qi=array();foreach($_POST["check"]as$X)$Qi[]="(SELECT".limit($kd,"\nWHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($X,$o).$td,1).")";$H=implode(" UNION ALL ",$Qi);}adminer()->dumpData($a,"table",$H);adminer()->dumpFooter();exit;}if(!adminer()->selectEmailProcess($Z,$gd)){if($_POST["save"]||$_POST["delete"]){$I=true;$qa=0;$O=array();if(!$_POST["delete"]){foreach($_POST["fields"]as$C=>$X){$X=process_input($o[$C]);if($X!==null&&($_POST["clone"]||$X!==false))$O[idf_escape($C)]=($X!==false?$X:idf_escape($C));}}if($_POST["delete"]||$O){$H=($_POST["clone"]?"INTO ".table($a)." (".implode(", ",array_keys($O)).")\nSELECT ".implode(", ",$O)."\nFROM ".table($a):"");if($_POST["all"]||($G&&is_array($_POST["check"]))||$ie){$I=($_POST["delete"]?driver()->delete($a,$sj):($_POST["clone"]?queries("INSERT $H$sj".driver()->insertReturning($a)):driver()->update($a,$O,$sj)));$qa=connection()->affected_rows;if(is_object($I))$qa+=$I->num_rows;}else{foreach((array)$_POST["check"]as$X){$rj="\nWHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($X,$o);$I=($_POST["delete"]?driver()->delete($a,$rj,1):($_POST["clone"]?queries("INSERT".limit1($a,$H,$rj)):driver()->update($a,$O,$rj,1)));if(!$I)break;$qa+=connection()->affected_rows;}}}$Ve=lang(257,$qa);if($_POST["clone"]&&$I&&$qa==1){$xe=last_id($I);if($xe)$Ve=lang(172," $xe");}queries_redirect(remove_from_uri($_POST["all"]&&$_POST["delete"]?"page":""),$Ve,$I);if(!$_POST["delete"]){$wg=(array)$_POST["fields"];edit_form($a,array_intersect_key($o,$wg),$wg,!$_POST["clone"],$m);page_footer();exit;}}elseif(!$_POST["import"]){if(!$_POST["val"])$m=lang(258);else{$I=true;$qa=0;foreach($_POST["val"]as$Si=>$K){$O=array();foreach($K
as$y=>$X){$y=bracket_escape($y,true);$O[idf_escape($y)]=(preg_match('~char|text~',$o[$y]["type"])||$X!=""?adminer()->processInput($o[$y],$X):"NULL");}$I=driver()->update($a,$O," WHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($Si,$o),($ie||$G?0:1)," ");if(!$I)break;$qa+=connection()->affected_rows;}queries_redirect(remove_from_uri(),lang(257,$qa),$I);}}elseif(!is_string($Uc=get_file("csv_file",true)))$m=upload_error($Uc);elseif(!preg_match('~~u',$Uc))$m=lang(259);else{save_settings(array("output"=>$pa["output"],"format"=>$_POST["separator"]),"adminer_import");$I=true;$kb=array_keys($o);preg_match_all('~(?>"[^"]*"|[^"\r\n]+)+~',$Uc,$Le);$qa=count($Le[0]);driver()->begin();$th=($_POST["separator"]=="csv"?",":($_POST["separator"]=="tsv"?"\t":";"));$L=array();foreach($Le[0]as$y=>$X){preg_match_all("~((?>\"[^\"]*\")+|[^$th]*)$th~",$X.$th,$Me);if(!$y&&!array_diff($Me[1],$kb)){$kb=$Me[1];$qa--;}else{$O=array();foreach($Me[1]as$t=>$hb)$O[idf_escape($kb[$t])]=($hb==""&&$o[$kb[$t]]["null"]?"NULL":q(preg_match('~^".*"$~s',$hb)?str_replace('""','"',substr($hb,1,-1)):$hb));$L[]=$O;}}$I=(!$L||driver()->insertUpdate($a,$L,$G));if($I)driver()->commit();queries_redirect(remove_from_uri("page"),lang(260,$qa),$I);driver()->rollback();}}}$bi=adminer()->tableName($S);if(is_ajax()){page_headers();ob_start();}else
page_header(lang(52).": $bi",$m);$O=null;if(isset($bh["insert"])||!support("table")){$dg=array();foreach((array)$_GET["where"]as$X){if(isset($gd[$X["col"]])&&count($gd[$X["col"]])==1&&($X["op"]=="="||(!$X["op"]&&(is_array($X["val"])||!preg_match('~[_%]~',$X["val"])))))$dg["set"."[".bracket_escape($X["col"])."]"]=$X["val"];}$O=$dg?"&".http_build_query($dg):"";}adminer()->selectLinks($S,$O);if(!$e&&support("table"))echo"<p class='error'>".lang(261).($o?".":": ".error())."\n";else{echo"<form action='' id='form'>\n","<div style='display: none;'>";hidden_fields_get();echo(DB!=""?input_hidden("db",DB).(isset($_GET["ns"])?input_hidden("ns",$_GET["ns"]):""):""),input_hidden("select",$a),"</div>\n";adminer()->selectColumnsPrint($M,$e);adminer()->selectSearchPrint($Z,$nh,$x);adminer()->selectOrderPrint($Lf,$Mf,$x);adminer()->selectLimitPrint($_);adminer()->selectLengthPrint($pi);adminer()->selectActionPrint($x);echo"</form>\n";$E=$_GET["page"];if($E=="last"){$jd=get_val(count_rows($a,$Z,$ie,$rd));$E=floor(max(0,intval($jd)-1)/$_);}$oh=$M;$sd=$rd;if(!$oh){$oh[]="*";$_b=convert_fields($e,$o,$M);if($_b)$oh[]=substr($_b,2);}foreach($M
as$y=>$X){$n=$o[idf_unescape($X)];if($n&&($ya=convert_field($n)))$oh[$y]="$ya AS $X";}if(!$ie&&$Ui){foreach($Ui
as$y=>$X){$oh[]=idf_escape($y);if($sd)$sd[]=idf_escape($y);}}$I=driver()->select($a,$oh,$Z,$sd,$Lf,$_,$E,true);if(!$I)echo"<p class='error'>".error()."\n";else{if(JUSH=="mssql"&&$E)$I->seek($_*$E);$rc=array();echo"<form action='' method='post' enctype='multipart/form-data'>\n";$L=array();while($K=$I->fetch_assoc()){if($E&&JUSH=="oracle")unset($K["RNUM"]);$L[]=$K;}if($_GET["page"]!="last"&&$_&&$rd&&$ie&&JUSH=="sql")$jd=get_val(" SELECT FOUND_ROWS()");if(!$L)echo"<p class='message'>".lang(12)."\n";else{$Ga=adminer()->backwardKeys($a,$bi);echo"<div class='scrollable'>","<table id='table' class='nowrap checkable odds'>",script("mixin(qs('#table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true), onkeydown: editingKeydown});"),"<thead><tr>".(!$rd&&$M?"":"<td><input type='checkbox' id='all-page' class='jsonly'>".script("qs('#all-page').onclick = partial(formCheck, /check/);","")." <a href='".h($_GET["modify"]?remove_from_uri("modify"):$_SERVER["REQUEST_URI"]."&modify=1")."'>".lang(262)."</a>");$jf=array();$md=array();reset($M);$Lg=1;foreach($L[0]as$y=>$X){if(!isset($Ui[$y])){$X=idx($_GET["columns"],key($M))?:array();$n=$o[$M?($X?$X["col"]:current($M)):$y];$C=($n?adminer()->fieldName($n,$Lg):($X["fun"]?"*":h($y)));if($C!=""){$Lg++;$jf[$y]=$C;$d=idf_escape($y);$Id=remove_from_uri('(order|desc)[^=]*|page').'&order%5B0%5D='.urlencode($y);$Ub="&desc%5B0%5D=1";echo"<th id='th[".h(bracket_escape($y))."]'>".script("mixin(qsl('th'), {onmouseover: partial(columnMouse), onmouseout: partial(columnMouse, ' hidden')});","");$ld=apply_sql_function($X["fun"],$C);$Fh=isset($n["privileges"]["order"])||$ld;echo($Fh?'<a href="'.h($Id.($Lf[0]==$d||$Lf[0]==$y||(!$Lf&&$ie&&$rd[0]==$d)?$Ub:'')).'">'."$ld</a>":$ld),"<span class='column hidden'>";if($Fh)echo"<a href='".h($Id.$Ub)."' title='".lang(58)."' class='text'> ↓</a>";if(!$X["fun"]&&isset($n["privileges"]["where"]))echo'<a href="#fieldset-search" title="'.lang(55).'" class="text jsonly"> =</a>',script("qsl('a').onclick = partial(selectSearch, '".js_escape($y)."');");echo"</span>";}$md[$y]=$X["fun"];next($M);}}$Be=array();if($_GET["modify"]){foreach($L
as$K){foreach($K
as$y=>$X)$Be[$y]=max($Be[$y],min(40,strlen(utf8_decode($X))));}}echo($Ga?"<th>".lang(263):"")."</thead>\n";if(is_ajax())ob_end_clean();foreach(adminer()->rowDescriptions($L,$gd)as$hf=>$K){$Ri=unique_array($L[$hf],$x);if(!$Ri){$Ri=array();foreach($L[$hf]as$y=>$X){if(!preg_match('~^(COUNT\((\*|(DISTINCT )?`(?:[^`]|``)+`)\)|(AVG|GROUP_CONCAT|MAX|MIN|SUM)\(`(?:[^`]|``)+`\))$~',$y))$Ri[$y]=$X;}}$Si="";foreach($Ri
as$y=>$X){$n=(array)$o[$y];if((JUSH=="sql"||JUSH=="pgsql")&&preg_match('~char|text|enum|set~',$n["type"])&&strlen($X)>64){$y=(strpos($y,'(')?$y:idf_escape($y));$y="MD5(".(JUSH!='sql'||preg_match("~^utf8~",$n["collation"])?$y:"CONVERT($y USING ".charset(connection()).")").")";$X=md5($X);}$Si
.="&".($X!==null?urlencode("where[".bracket_escape($y)."]")."=".urlencode($X===false?"f":$X):"null%5B%5D=".urlencode($y));}echo"<tr>".(!$rd&&$M?"":"<td>".checkbox("check[]",substr($Si,1),in_array(substr($Si,1),(array)$_POST["check"])).($ie||information_schema(DB)?"":" <a href='".h(ME."edit=".urlencode($a).$Si)."' class='edit'>".lang(264)."</a>"));foreach($K
as$y=>$X){if(isset($jf[$y])){$n=(array)$o[$y];$X=driver()->value($X,$n);if($X!=""&&(!isset($rc[$y])||$rc[$y]!=""))$rc[$y]=(is_mail($X)?$jf[$y]:"");$A="";if(preg_match('~blob|bytea|raw|file~',$n["type"])&&$X!="")$A=ME.'download='.urlencode($a).'&field='.urlencode($y).$Si;if(!$A&&$X!==null){foreach((array)$gd[$y]as$q){if(count($gd[$y])==1||end($q["source"])==$y){$A="";foreach($q["source"]as$t=>$Gh)$A
.=where_link($t,$q["target"][$t],$L[$hf][$Gh]);$A=($q["db"]!=""?preg_replace('~([?&]db=)[^&]+~','\1'.urlencode($q["db"]),ME):ME).'select='.urlencode($q["table"]).$A;if($q["ns"])$A=preg_replace('~([?&]ns=)[^&]+~','\1'.urlencode($q["ns"]),$A);if(count($q["source"])==1)break;}}}if($y=="COUNT(*)"){$A=ME."select=".urlencode($a);$t=0;foreach((array)$_GET["where"]as$W){if(!array_key_exists($W["col"],$Ri))$A
.=where_link($t++,$W["col"],$W["val"],$W["op"]);}foreach($Ri
as$oe=>$W)$A
.=where_link($t++,$oe,$W);}$X=select_value($X,$A,$n,$pi);$u=h("val[$Si][".bracket_escape($y)."]");$Y=idx(idx($_POST["val"],$Si),bracket_escape($y));$mc=!is_array($K[$y])&&is_utf8($X)&&$L[$hf][$y]==$K[$y]&&!$md[$y]&&!$n["generated"];$ni=preg_match('~text|json|lob~',$n["type"]);echo"<td id='$u'".(preg_match(number_type(),$n["type"])&&($X=='<i>NULL</i>'||is_numeric(strip_tags($X)))?" class='number'":"");if(($_GET["modify"]&&$mc)||$Y!==null){$wd=h($Y!==null?$Y:$K[$y]);echo">".($ni?"<textarea name='$u' cols='30' rows='".(substr_count($K[$y],"\n")+1)."'>$wd</textarea>":"<input name='$u' value='$wd' size='$Be[$y]'>");}else{$Ge=strpos($X,"<i>…</i>");echo" data-text='".($Ge?2:($ni?1:0))."'".($mc?"":" data-warning='".h(lang(265))."'").">$X";}}}if($Ga)echo"<td>";adminer()->backwardKeysPrint($Ga,$L[$hf]);echo"</tr>\n";}if(is_ajax())exit;echo"</table>\n","</div>\n";}if(!is_ajax()){if($L||$E){$Ec=true;$jd=null;if($_GET["page"]!="last"){if(!$_||(count($L)<$_&&($L||!$E)))$jd=($E?$E*$_:0)+count($L);elseif(JUSH!="sql"||!$ie){$jd=($ie?false:found_rows($S,$Z));if(intval($jd)<max(1e4,2*($E+1)*$_))$jd=first(slow_query(count_rows($a,$Z,$ie,$rd)));else$Ec=false;}}$bg=($_&&($jd===false||$jd>$_||$E));if($bg)echo(($jd===false?count($L)+1:$jd-$E*$_)>$_?'<p><a href="'.h(remove_from_uri("page")."&page=".($E+1)).'" class="loadmore">'.lang(266).'</a>'.script("qsl('a').onclick = partial(selectLoadMore, $_, '".lang(267)."…');",""):''),"\n";echo"<div class='footer'><div>\n";if($bg){$Oe=($jd===false?$E+(count($L)>=$_?2:1):floor(($jd-1)/$_));echo"<fieldset>";if(JUSH!="simpledb"){echo"<legend><a href='".h(remove_from_uri("page"))."'>".lang(268)."</a></legend>",script("qsl('a').onclick = function () { pageClick(this.href, +prompt('".lang(268)."', '".($E+1)."')); return false; };"),pagination(0,$E).($E>5?" …":"");for($t=max(1,$E-4);$t<min($Oe,$E+5);$t++)echo
pagination($t,$E);if($Oe>0)echo($E+5<$Oe?" …":""),($Ec&&$jd!==false?pagination($Oe,$E):" <a href='".h(remove_from_uri("page")."&page=last")."' title='~$Oe'>".lang(269)."</a>");}else
echo"<legend>".lang(268)."</legend>",pagination(0,$E).($E>1?" …":""),($E?pagination($E,$E):""),($Oe>$E?pagination($E+1,$E).($Oe>$E+1?" …":""):"");echo"</fieldset>\n";}echo"<fieldset>","<legend>".lang(270)."</legend>";$ac=($Ec?"":"~ ").$jd;$Ef="const checked = formChecked(this, /check/); selectCount('selected', this.checked ? '$ac' : checked); selectCount('selected2', this.checked || !checked ? '$ac' : checked);";echo
checkbox("all",1,0,($jd!==false?($Ec?"":"~ ").lang(154,$jd):""),$Ef)."\n","</fieldset>\n";if(adminer()->selectCommandPrint())echo'<fieldset',($_GET["modify"]?'':' class="jsonly"'),'><legend>',lang(262),'</legend><div>
<input type="submit" value="',lang(14),'"',($_GET["modify"]?'':' title="'.lang(258).'"'),'>
</div></fieldset>
<fieldset><legend>',lang(128),' <span id="selected"></span></legend><div>
<input type="submit" name="edit" value="',lang(10),'">
<input type="submit" name="clone" value="',lang(254),'">
<input type="submit" name="delete" value="',lang(18),'">',confirm(),'</div></fieldset>
';$hd=adminer()->dumpFormat();foreach((array)$_GET["columns"]as$d){if($d["fun"]){unset($hd['sql']);break;}}if($hd){print_fieldset("export",lang(72)." <span id='selected2'></span>");$Yf=adminer()->dumpOutput();echo($Yf?html_select("output",$Yf,$pa["output"])." ":""),html_select("format",$hd,$pa["format"])," <input type='submit' name='export' value='".lang(72)."'>\n","</div></fieldset>\n";}adminer()->selectEmailPrint(array_filter($rc,'strlen'),$e);echo"</div></div>\n";}if(adminer()->selectImportPrint())echo"<div>","<a href='#import'>".lang(71)."</a>",script("qsl('a').onclick = partial(toggle, 'import');",""),"<span id='import'".($_POST["import"]?"":" class='hidden'").">: ","<input type='file' name='csv_file'> ",html_select("separator",array("csv"=>"CSV,","csv;"=>"CSV;","tsv"=>"TSV"),$pa["format"])," <input type='submit' name='import' value='".lang(71)."'>","</span>","</div>";echo
input_token(),"</form>\n",(!$rd&&$M?"":script("tableCheck();"));}}}if(is_ajax()){ob_end_clean();exit;}}elseif(isset($_GET["variables"])){$P=isset($_GET["status"]);page_header($P?lang(119):lang(118));$ij=($P?show_status():show_variables());if(!$ij)echo"<p class='message'>".lang(12)."\n";else{echo"<table>\n";foreach($ij
as$K){echo"<tr>";$y=array_shift($K);echo"<th><code class='jush-".JUSH.($P?"status":"set")."'>".h($y)."</code>";foreach($K
as$X)echo"<td>".nl_br(h($X));}echo"</table>\n";}}elseif(isset($_GET["script"])){header("Content-Type: text/javascript; charset=utf-8");if($_GET["script"]=="db"){$Xh=array("Data_length"=>0,"Index_length"=>0,"Data_free"=>0);foreach(table_status()as$C=>$S){json_row("Comment-$C",h($S["Comment"]));if(!is_view($S)){foreach(array("Engine","Collation")as$y)json_row("$y-$C",h($S[$y]));foreach($Xh+array("Auto_increment"=>0,"Rows"=>0)as$y=>$X){if($S[$y]!=""){$X=format_number($S[$y]);if($X>=0)json_row("$y-$C",($y=="Rows"&&$X&&$S["Engine"]==(JUSH=="pgsql"?"table":"InnoDB")?"~ $X":$X));if(isset($Xh[$y]))$Xh[$y]+=($S["Engine"]!="InnoDB"||$y!="Data_free"?$S[$y]:0);}elseif(array_key_exists($y,$S))json_row("$y-$C","?");}}}foreach($Xh
as$y=>$X)json_row("sum-$y",format_number($X));json_row("");}elseif($_GET["script"]=="kill")connection()->query("KILL ".number($_POST["kill"]));else{foreach(count_tables(adminer()->databases())as$k=>$X){json_row("tables-$k",$X);json_row("size-$k",db_size($k));}json_row("");}exit;}else{$hi=array_merge((array)$_POST["tables"],(array)$_POST["views"]);if($hi&&!$m&&!$_POST["search"]){$I=true;$Ve="";if(JUSH=="sql"&&$_POST["tables"]&&count($_POST["tables"])>1&&($_POST["drop"]||$_POST["truncate"]||$_POST["copy"]))queries("SET foreign_key_checks = 0");if($_POST["truncate"]){if($_POST["tables"])$I=truncate_tables($_POST["tables"]);$Ve=lang(271);}elseif($_POST["move"]){$I=move_tables((array)$_POST["tables"],(array)$_POST["views"],$_POST["target"]);$Ve=lang(272);}elseif($_POST["copy"]){$I=copy_tables((array)$_POST["tables"],(array)$_POST["views"],$_POST["target"]);$Ve=lang(273);}elseif($_POST["drop"]){if($_POST["views"])$I=drop_views($_POST["views"]);if($I&&$_POST["tables"])$I=drop_tables($_POST["tables"]);$Ve=lang(274);}elseif(JUSH=="sqlite"&&$_POST["check"]){foreach((array)$_POST["tables"]as$R){foreach(get_rows("PRAGMA integrity_check(".q($R).")")as$K)$Ve
.="<b>".h($R)."</b>: ".h($K["integrity_check"])."<br>";}}elseif(JUSH!="sql"){$I=(JUSH=="sqlite"?queries("VACUUM"):apply_queries("VACUUM".($_POST["optimize"]?"":" ANALYZE"),$_POST["tables"]));$Ve=lang(275);}elseif(!$_POST["tables"])$Ve=lang(9);elseif($I=queries(($_POST["optimize"]?"OPTIMIZE":($_POST["check"]?"CHECK":($_POST["repair"]?"REPAIR":"ANALYZE")))." TABLE ".implode(", ",array_map('Adminer\idf_escape',$_POST["tables"])))){while($K=$I->fetch_assoc())$Ve
.="<b>".h($K["Table"])."</b>: ".h($K["Msg_text"])."<br>";}queries_redirect(substr(ME,0,-1),$Ve,$I);}page_header(($_GET["ns"]==""?lang(36).": ".h(DB):lang(75).": ".h($_GET["ns"])),$m,true);if(adminer()->homepage()){if($_GET["ns"]!==""){echo"<h3 id='tables-views'>".lang(276)."</h3>\n";$gi=tables_list();if(!$gi)echo"<p class='message'>".lang(9)."\n";else{echo"<form action='' method='post'>\n";if(support("table")){echo"<fieldset><legend>".lang(277)." <span id='selected2'></span></legend><div>","<input type='search' name='query' value='".h($_POST["query"])."'>",script("qsl('input').onkeydown = partialArg(bodyKeydown, 'search');","")," <input type='submit' name='search' value='".lang(55)."'>\n","</div></fieldset>\n";if($_POST["search"]&&$_POST["query"]!=""){$_GET["where"][0]["op"]=driver()->convertOperator("LIKE %%");search_tables();}}echo"<div class='scrollable'>\n","<table class='nowrap checkable odds'>\n",script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});"),'<thead><tr class="wrap">','<td><input id="check-all" type="checkbox" class="jsonly">'.script("qs('#check-all').onclick = partial(formCheck, /^(tables|views)\[/);",""),'<th>'.lang(133),'<td>'.lang(278).doc_link(array('sql'=>'storage-engines.html')),'<td>'.lang(124).doc_link(array('sql'=>'charset-charsets.html','mariadb'=>'supported-character-sets-and-collations/')),'<td>'.lang(279).doc_link(array('sql'=>'show-table-status.html','pgsql'=>'functions-admin.html#FUNCTIONS-ADMIN-DBOBJECT','oracle'=>'REFRN20286')),'<td>'.lang(280).doc_link(array('sql'=>'show-table-status.html','pgsql'=>'functions-admin.html#FUNCTIONS-ADMIN-DBOBJECT')),'<td>'.lang(281).doc_link(array('sql'=>'show-table-status.html')),'<td>'.lang(50).doc_link(array('sql'=>'example-auto-increment.html','mariadb'=>'auto_increment/')),'<td>'.lang(282).doc_link(array('sql'=>'show-table-status.html','pgsql'=>'catalog-pg-class.html#CATALOG-PG-CLASS','oracle'=>'REFRN20286')),(support("comment")?'<td>'.lang(49).doc_link(array('sql'=>'show-table-status.html','pgsql'=>'functions-info.html#FUNCTIONS-INFO-COMMENT-TABLE')):''),"</thead>\n";$T=0;foreach($gi
as$C=>$U){$lj=($U!==null&&!preg_match('~table|sequence~i',$U));$u=h("Table-".$C);echo'<tr><td>'.checkbox(($lj?"views[]":"tables[]"),$C,in_array("$C",$hi,true),"","","",$u),'<th>'.(support("table")||support("indexes")?"<a href='".h(ME)."table=".urlencode($C)."' title='".lang(41)."' id='$u'>".h($C).'</a>':h($C));if($lj)echo'<td colspan="6"><a href="'.h(ME)."view=".urlencode($C).'" title="'.lang(42).'">'.(preg_match('~materialized~i',$U)?lang(131):lang(132)).'</a>','<td align="right"><a href="'.h(ME)."select=".urlencode($C).'" title="'.lang(40).'">?</a>';else{foreach(array("Engine"=>array(),"Collation"=>array(),"Data_length"=>array("create",lang(43)),"Index_length"=>array("indexes",lang(135)),"Data_free"=>array("edit",lang(44)),"Auto_increment"=>array("auto_increment=1&create",lang(43)),"Rows"=>array("select",lang(40)),)as$y=>$A){$u=" id='$y-".h($C)."'";echo($A?"<td align='right'>".(support("table")||$y=="Rows"||(support("indexes")&&$y!="Data_length")?"<a href='".h(ME."$A[0]=").urlencode($C)."'$u title='$A[1]'>?</a>":"<span$u>?</span>"):"<td id='$y-".h($C)."'>");}$T++;}echo(support("comment")?"<td id='Comment-".h($C)."'>":""),"\n";}echo"<tr><td><th>".lang(255,count($gi)),"<td>".h(JUSH=="sql"?get_val("SELECT @@default_storage_engine"):""),"<td>".h(db_collation(DB,collations()));foreach(array("Data_length","Index_length","Data_free")as$y)echo"<td align='right' id='sum-$y'>";echo"\n","</table>\n","</div>\n";if(!information_schema(DB)){echo"<div class='footer'><div>\n";$fj="<input type='submit' value='".lang(283)."'> ".on_help("'VACUUM'");$Hf="<input type='submit' name='optimize' value='".lang(284)."'> ".on_help(JUSH=="sql"?"'OPTIMIZE TABLE'":"'VACUUM OPTIMIZE'");echo"<fieldset><legend>".lang(128)." <span id='selected'></span></legend><div>".(JUSH=="sqlite"?$fj."<input type='submit' name='check' value='".lang(285)."'> ".on_help("'PRAGMA integrity_check'"):(JUSH=="pgsql"?$fj.$Hf:(JUSH=="sql"?"<input type='submit' value='".lang(286)."'> ".on_help("'ANALYZE TABLE'").$Hf."<input type='submit' name='check' value='".lang(285)."'> ".on_help("'CHECK TABLE'")."<input type='submit' name='repair' value='".lang(287)."'> ".on_help("'REPAIR TABLE'"):"")))."<input type='submit' name='truncate' value='".lang(288)."'> ".on_help(JUSH=="sqlite"?"'DELETE'":"'TRUNCATE".(JUSH=="pgsql"?"'":" TABLE'")).confirm()."<input type='submit' name='drop' value='".lang(129)."'>".on_help("'DROP TABLE'").confirm()."\n";$j=(support("scheme")?adminer()->schemas():adminer()->databases());if(count($j)!=1&&JUSH!="sqlite"){$k=(isset($_POST["target"])?$_POST["target"]:(support("scheme")?$_GET["ns"]:DB));echo"<p>".lang(289).": ",($j?html_select("target",$j,$k):'<input name="target" value="'.h($k).'" autocapitalize="off">')," <input type='submit' name='move' value='".lang(290)."'>",(support("copy")?" <input type='submit' name='copy' value='".lang(291)."'> ".checkbox("overwrite",1,$_POST["overwrite"],lang(292)):""),"\n";}echo"<input type='hidden' name='all' value=''>",script("qsl('input').onclick = function () { selectCount('selected', formChecked(this, /^(tables|views)\[/));".(support("table")?" selectCount('selected2', formChecked(this, /^tables\[/) || $T);":"")." }"),input_token(),"</div></fieldset>\n","</div></div>\n";}echo"</form>\n",script("tableCheck();");}echo"<p class='links'><a href='".h(ME)."create='>".lang(73)."</a>\n",(support("view")?"<a href='".h(ME)."view='>".lang(208)."</a>\n":"");if(support("routine")){echo"<h3 id='routines'>".lang(147)."</h3>\n";$fh=routines();if($fh){echo"<table class='odds'>\n",'<thead><tr><th>'.lang(187).'<td>'.lang(48).'<td>'.lang(225)."<td></thead>\n";foreach($fh
as$K){$C=($K["SPECIFIC_NAME"]==$K["ROUTINE_NAME"]?"":"&name=".urlencode($K["ROUTINE_NAME"]));echo'<tr>','<th><a href="'.h(ME.($K["ROUTINE_TYPE"]!="PROCEDURE"?'callf=':'call=').urlencode($K["SPECIFIC_NAME"]).$C).'">'.h($K["ROUTINE_NAME"]).'</a>','<td>'.h($K["ROUTINE_TYPE"]),'<td>'.h($K["DTD_IDENTIFIER"]),'<td><a href="'.h(ME.($K["ROUTINE_TYPE"]!="PROCEDURE"?'function=':'procedure=').urlencode($K["SPECIFIC_NAME"]).$C).'">'.lang(138)."</a>";}echo"</table>\n";}echo'<p class="links">'.(support("procedure")?'<a href="'.h(ME).'procedure=">'.lang(224).'</a>':'').'<a href="'.h(ME).'function=">'.lang(223)."</a>\n";}if(support("sequence")){echo"<h3 id='sequences'>".lang(293)."</h3>\n";$wh=get_vals("SELECT sequence_name FROM information_schema.sequences WHERE sequence_schema = current_schema() ORDER BY sequence_name");if($wh){echo"<table class='odds'>\n","<thead><tr><th>".lang(187)."</thead>\n";foreach($wh
as$X)echo"<tr><th><a href='".h(ME)."sequence=".urlencode($X)."'>".h($X)."</a>\n";echo"</table>\n";}echo"<p class='links'><a href='".h(ME)."sequence='>".lang(230)."</a>\n";}if(support("type")){echo"<h3 id='user-types'>".lang(31)."</h3>\n";$dj=types();if($dj){echo"<table class='odds'>\n","<thead><tr><th>".lang(187)."</thead>\n";foreach($dj
as$X)echo"<tr><th><a href='".h(ME)."type=".urlencode($X)."'>".h($X)."</a>\n";echo"</table>\n";}echo"<p class='links'><a href='".h(ME)."type='>".lang(234)."</a>\n";}if(support("event")){echo"<h3 id='events'>".lang(148)."</h3>\n";$L=get_rows("SHOW EVENTS");if($L){echo"<table>\n","<thead><tr><th>".lang(187)."<td>".lang(294)."<td>".lang(214)."<td>".lang(215)."<td></thead>\n";foreach($L
as$K)echo"<tr>","<th>".h($K["Name"]),"<td>".($K["Execute at"]?lang(295)."<td>".$K["Execute at"]:lang(216)." ".$K["Interval value"]." ".$K["Interval field"]."<td>$K[Starts]"),"<td>$K[Ends]",'<td><a href="'.h(ME).'event='.urlencode($K["Name"]).'">'.lang(138).'</a>';echo"</table>\n";$Cc=get_val("SELECT @@event_scheduler");if($Cc&&$Cc!="ON")echo"<p class='error'><code class='jush-sqlset'>event_scheduler</code>: ".h($Cc)."\n";}echo'<p class="links"><a href="'.h(ME).'event=">'.lang(213)."</a>\n";}if($gi)echo
script("ajaxSetHtml('".js_escape(ME)."script=db');");}}}page_footer();